<!-- received="Wed Sep  8 17:48:15 1999 EET DST" -->
<!-- sent="Wed, 8 Sep 1999 16:41:51 +0200" -->
<!-- name="Vitezslav Samel" -->
<!-- email="vsamel@seznam.cz" -->
<!-- subject="[PATCH] off-by-one bug in do_process_times() in kernel/sched.c" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] off-by-one bug in do_process_times() in kernel/sched.c</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] off-by-one bug in do_process_times() in kernel/sched.c</h1>
<b>Vitezslav Samel</b> (<a href="mailto:vsamel@seznam.cz"><i>vsamel@seznam.cz</i></a>)<br>
<i>Wed, 8 Sep 1999 16:41:51 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#529">[ date ]</a><a href="index.html#529">[ thread ]</a><a href="subject.html#529">[ subject ]</a><a href="author.html#529">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0530.html">Jose Miguel Pereira Tavares: "Re: accurate timing"</a>
<li> <b>Previous message:</b> <a href="0528.html">Carlos Costa Portela: "Re: for a help"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
	Hi!<br>
<p>
  When using 'ulimit -t 10' for a long-running process, it was killed right<br>
after 11 secs.<br>
<p>
  Here's a two-line patch:<br>
<p>
diff -urN clean-2.3.16/kernel/sched.c linux/kernel/sched.c<br>
--- clean-2.3.16/kernel/sched.c	Thu Aug 26 19:43:59 1999<br>
+++ linux/kernel/sched.c	Tue Sep  7 21:50:44 1999<br>
@@ -1185,12 +1185,12 @@<br>
 <br>
 	psecs = (p-&gt;times.tms_utime += user);<br>
 	psecs += (p-&gt;times.tms_stime += system);<br>
-	if (psecs / HZ &gt; p-&gt;rlim[RLIMIT_CPU].rlim_cur) {<br>
+	if (psecs / HZ &gt;= p-&gt;rlim[RLIMIT_CPU].rlim_cur) {<br>
 		/* Send SIGXCPU every second.. */<br>
 		if (!(psecs % HZ))<br>
 			send_sig(SIGXCPU, p, 1);<br>
 		/* and SIGKILL when we go over max.. */<br>
-		if (psecs / HZ &gt; p-&gt;rlim[RLIMIT_CPU].rlim_max)<br>
+		if (psecs / HZ &gt;= p-&gt;rlim[RLIMIT_CPU].rlim_max)<br>
 			send_sig(SIGKILL, p, 1);<br>
 	}<br>
 }<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0530.html">Jose Miguel Pereira Tavares: "Re: accurate timing"</a>
<li> <b>Previous message:</b> <a href="0528.html">Carlos Costa Portela: "Re: for a help"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
