<!-- received="Wed Sep  8 22:26:02 1999 EET DST" -->
<!-- sent="Wed, 8 Sep 1999 19:27:30 +0000 (GMT)" -->
<!-- name="Thomas Habets" -->
<!-- email="thomas@habets.pp.se" -->
<!-- subject="Immutable file bug" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: Immutable file bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Immutable file bug</h1>
<b>Thomas Habets</b> (<a href="mailto:thomas@habets.pp.se"><i>thomas@habets.pp.se</i></a>)<br>
<i>Wed, 8 Sep 1999 19:27:30 +0000 (GMT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#568">[ date ]</a><a href="index.html#568">[ thread ]</a><a href="subject.html#568">[ subject ]</a><a href="author.html#568">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0569.html">David Weinehall: "Re: I vote for updated RAID and KNFSD"</a>
<li> <b>Previous message:</b> <a href="0567.html">Mikael Pettersson: "[Announce] x86 performance-monitoring counters with Athlon support"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I was looking into how security levels are implemented in linux and I<br>
stumbled on what I think is a bug.<br>
<p>
An immutable file can still be touched to change its date. I'm not really<br>
sure if immutable should prohibit that but I think so (since you can't<br>
change permissions on an immutable file) and I think it should.<br>
<p>
I traced it to sys_utime() and sys_utimes() in fs/open.c and patched it<br>
there. But after seing directories turning into files (spooky) i tried<br>
again and patched inode_change_ok() in fs/attr.c.<br>
<p>
Oh, and a question: does linux even *have* security levels? I assumed it<br>
did since it has immutable files but people say it doesn't have it.<br>
<p>
IMPORTANT NOTE:<br>
This patch works for me but am sure Linus will beat me silly for patching<br>
absolutely wrong.<br>
<p>
--- linux-2.2.12/fs/attr.c	Fri Nov 13 19:07:26 1998<br>
+++ marvin-2.2.12/fs/attr.c	Wed Sep  8 20:57:39 1999<br>
@@ -17,6 +17,10 @@<br>
 	int retval = -EPERM;<br>
 	unsigned int ia_valid = attr-&gt;ia_valid;<br>
<p>
+	/* don't touch if immutable */<br>
+	if (IS_IMMUTABLE(inode)) {<br>
+		goto error;<br>
+	}<br>
+	<br>
 	/* If force is set do it anyway. */<br>
 	if (ia_valid &amp; ATTR_FORCE)<br>
 		goto fine;<br>
<p>
<p>
---------<br>
typedef struct me_s {<br>
  char name[]    = { "Thomas Habets" };<br>
  char email[]   = { "thomas@habets.pp.se" };<br>
  char os[]      = { "Linux 2.2" };<br>
  char *pgpKey[] = { "finger -m <a href="mailto:thompa@nss.nu">thompa@nss.nu</a>" };<br>
} me_t;<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0569.html">David Weinehall: "Re: I vote for updated RAID and KNFSD"</a>
<li> <b>Previous message:</b> <a href="0567.html">Mikael Pettersson: "[Announce] x86 performance-monitoring counters with Athlon support"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
