<!-- received="Thu Sep  9 01:51:19 1999 EET DST" -->
<!-- sent="Wed, 8 Sep 1999 16:41:22 -0600" -->
<!-- name="George Sexton" -->
<!-- email="gsexton@mhsoftware.com" -->
<!-- subject="RE: Immutable file bug" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.05.9909081911180.468-100000@marvin.junknet" -->
<title>Linux-kernel mailing list archive 1999-36,: RE: Immutable file bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>RE: Immutable file bug</h1>
<b>George Sexton</b> (<a href="mailto:gsexton@mhsoftware.com"><i>gsexton@mhsoftware.com</i></a>)<br>
<i>Wed, 8 Sep 1999 16:41:22 -0600</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#611">[ date ]</a><a href="index.html#611">[ thread ]</a><a href="subject.html#611">[ subject ]</a><a href="author.html#611">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0612.html">Garst R. Reese: "2.3.17 PCMCIA HOWTO?"</a>
<li> <b>Previous message:</b> <a href="0610.html">David Weinehall: "Clean up of the config-options"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Here is my feeble input to this.<br>
<p>
2.0.xx had a SecureLevel. It was implemented in the /proc file system. Once<br>
it was set to non-zero, you could not change the immutable flag. It also<br>
looked like you could not load modules once the securelevel was set to<br>
non-zero. The original implementation set the flags for it to 444. Just for<br>
grins, I changed this to 644 and wrote to it. This worked. Unfortunately,<br>
the code for securelevel strategy is kind of broken because I could set it<br>
back to 0 after it had been elevated. At this point I quit looking at it.<br>
<p>
I went through the 2.2.x code looking at this. It now uses the CAPABILITY<br>
which I don't understand at all. The only reference I could find to<br>
capabilities was in reference to ELF file headers.<br>
<p>
I would be interested in whatever you find out.<br>
<p>
<p>
<p>
George Sexton<br>
MH Software, Inc.<br>
Voice: 303 438 9585<br>
Fax: 303 469 9679<br>
URL: <a href="http://www.mhsoftware.com">http://www.mhsoftware.com</a><br>
<p>
-----Original Message-----<br>
From: <a href="mailto:owner-linux-kernel@vger.rutgers.edu">owner-linux-kernel@vger.rutgers.edu</a><br>
[<a href="mailto:owner-linux-kernel@vger.rutgers.edu">mailto:owner-linux-kernel@vger.rutgers.edu</a>]On Behalf Of Thomas Habets<br>
Sent: Wednesday, September 08, 1999 1:28 PM<br>
To: <a href="mailto:linux-kernel@vger.rutgers.edu">linux-kernel@vger.rutgers.edu</a><br>
Subject: Immutable file bug<br>
<p>
<p>
<p>
I was looking into how security levels are implemented in linux and I<br>
stumbled on what I think is a bug.<br>
<p>
An immutable file can still be touched to change its date. I'm not really<br>
sure if immutable should prohibit that but I think so (since you can't<br>
change permissions on an immutable file) and I think it should.<br>
<p>
I traced it to sys_utime() and sys_utimes() in fs/open.c and patched it<br>
there. But after seing directories turning into files (spooky) i tried<br>
again and patched inode_change_ok() in fs/attr.c.<br>
<p>
Oh, and a question: does linux even *have* security levels? I assumed it<br>
did since it has immutable files but people say it doesn't have it.<br>
<p>
IMPORTANT NOTE:<br>
This patch works for me but am sure Linus will beat me silly for patching<br>
absolutely wrong.<br>
<p>
--- linux-2.2.12/fs/attr.c	Fri Nov 13 19:07:26 1998<br>
+++ marvin-2.2.12/fs/attr.c	Wed Sep  8 20:57:39 1999<br>
@@ -17,6 +17,10 @@<br>
 	int retval = -EPERM;<br>
 	unsigned int ia_valid = attr-&gt;ia_valid;<br>
<p>
+	/* don't touch if immutable */<br>
+	if (IS_IMMUTABLE(inode)) {<br>
+		goto error;<br>
+	}<br>
+<br>
 	/* If force is set do it anyway. */<br>
 	if (ia_valid &amp; ATTR_FORCE)<br>
 		goto fine;<br>
<p>
<p>
---------<br>
typedef struct me_s {<br>
  char name[]    = { "Thomas Habets" };<br>
  char email[]   = { "thomas@habets.pp.se" };<br>
  char os[]      = { "Linux 2.2" };<br>
  char *pgpKey[] = { "finger -m <a href="mailto:thompa@nss.nu">thompa@nss.nu</a>" };<br>
} me_t;<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0612.html">Garst R. Reese: "2.3.17 PCMCIA HOWTO?"</a>
<li> <b>Previous message:</b> <a href="0610.html">David Weinehall: "Clean up of the config-options"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
