<!-- received="Thu Sep  9 05:16:01 1999 EET DST" -->
<!-- sent="Thu, 9 Sep 1999 04:12:40 +0200 (MET DST)" -->
<!-- name="Andries.Brouwer@cwi.nl" -->
<!-- email="Andries.Brouwer@cwi.nl" -->
<!-- subject="[PATCH] qnx4 causes memory corruption in 2.2.12" -->
<!-- id="UTC199909090212.EAA23719.aeb@papegaai.cwi.nl" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] qnx4 causes memory corruption in 2.2.12</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] qnx4 causes memory corruption in 2.2.12</h1>
<a href="mailto:Andries.Brouwer@cwi.nl"><i>Andries.Brouwer@cwi.nl</i></a><br>
<i>Thu, 9 Sep 1999 04:12:40 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#629">[ date ]</a><a href="index.html#629">[ thread ]</a><a href="subject.html#629">[ subject ]</a><a href="author.html#629">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0630.html">=?iso-8859-1?Q?Peter_Sj=F6berg?=: "2.3.17 and alpha fails with too few arguments `ioremap'"</a>
<li> <b>Previous message:</b> <a href="0628.html">Brian Macy: "BusLogic + SMP == broke"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
When mounting something without the -t option,<br>
the program mount will try all known filesystems.<br>
The unfortunate soul that has qnx4 compiled into<br>
her kernel will experience memory corruption.<br>
<p>
What happens? First, the test that the fs starts with QNX4FS<br>
is ifdef'ed out, so that we don't notice right away that<br>
something is wrong. Then, the<br>
	d_alloc_root(iget(s, QNX4_ROOT_INO * QNX4_INODES_PER_BLOCK), NULL);<br>
will allocate dentries and put inodes in the hash table.<br>
Further down in qnx4_read_super() a qnx4_checkroot() is done<br>
and we decide that this after all is not a valid qnx4 filesystem.<br>
The mount fails, and bogus data remains in the inode hash table.<br>
<p>
There are other things in the qnx4 code that look extremely suspect.<br>
Here a patch that moves the qnx4_checkroot() to before the iget().<br>
It fixes a reproducible memory corruption.<br>
For extra safety I removed the #if 0 .. #endif from the signature check.<br>
<p>
Andries<br>
<p>
---------------------------------------------------------------<br>
diff -u --recursive --new-file ../linux-2.2.12/linux/fs/qnx4/inode.c ./linux/fs/qnx4/inode.c<br>
--- ../linux-2.2.12/linux/fs/qnx4/inode.c	Sun Sep  6 02:01:45 1998<br>
+++ ./linux/fs/qnx4/inode.c	Thu Sep  9 03:39:47 1999<br>
@@ -26,7 +26,6 @@<br>
 <br>
 #define QNX4_VERSION  4<br>
 #define QNX4_BMNAME   ".bitmap"<br>
-#define CHECK_BOOT_SIGNATURE 0<br>
 <br>
 static struct super_operations qnx4_sops;<br>
 <br>
@@ -256,9 +255,6 @@<br>
 	int i, j;<br>
 	int found = 0;<br>
 <br>
-	if (s == NULL) {<br>
-		return "no qnx4 filesystem (null superblock).";<br>
-	}<br>
 	if (*(s-&gt;u.qnx4_sb.sb-&gt;RootDir.di_fname) != '/') {<br>
 		return "no qnx4 filesystem (no root dir).";<br>
 	} else {<br>
@@ -281,6 +277,8 @@<br>
 					}<br>
 				}<br>
 			}<br>
+			/* WAIT! s-&gt;u.qnx4_sb.BitMap points into bh-&gt;b_data<br>
+			   and now we release bh?? */<br>
 			brelse(bh);<br>
 			if (found != 0) {<br>
 				break;<br>
@@ -298,9 +296,8 @@<br>
 {<br>
 	struct buffer_head *bh;<br>
 	kdev_t dev = s-&gt;s_dev;<br>
-#if CHECK_BOOT_SIGNATURE<br>
+	struct inode *root;<br>
 	char *tmpc;<br>
-#endif<br>
 	const char *errmsg;<br>
 <br>
 	MOD_INC_USE_COUNT;<br>
@@ -310,7 +307,9 @@<br>
 	s-&gt;s_blocksize_bits = 9;<br>
 	s-&gt;s_dev = dev;<br>
 <br>
-#if CHECK_BOOT_SIGNATURE<br>
+	/* Check the boot signature. Since the qnx4 code is<br>
+	   dangerous, we should leave as quickly as possible<br>
+	   if we don't belong here... */<br>
 	bh = bread(dev, 0, QNX4_BLOCK_SIZE);<br>
 	if (!bh) {<br>
 		printk("qnx4: unable to read the boot sector\n");<br>
@@ -319,11 +318,12 @@<br>
 	tmpc = (char *) bh-&gt;b_data;<br>
 	if (tmpc[4] != 'Q' || tmpc[5] != 'N' || tmpc[6] != 'X' ||<br>
 	    tmpc[7] != '4' || tmpc[8] != 'F' || tmpc[9] != 'S') {<br>
-		printk("qnx4: wrong fsid in boot sector.\n");<br>
+		if (!silent)<br>
+			printk("qnx4: wrong fsid in boot sector.\n");<br>
 		goto out;<br>
 	}<br>
 	brelse(bh);<br>
-#endif<br>
+<br>
 	bh = bread(dev, 1, QNX4_BLOCK_SIZE);<br>
 	if (!bh) {<br>
 		printk("qnx4: unable to read the superblock\n");<br>
@@ -336,23 +336,34 @@<br>
 #endif<br>
 	s-&gt;u.qnx4_sb.sb_buf = bh;<br>
 	s-&gt;u.qnx4_sb.sb = (struct qnx4_super_block *) bh-&gt;b_data;<br>
-	s-&gt;s_root =<br>
-	    d_alloc_root(iget(s, QNX4_ROOT_INO * QNX4_INODES_PER_BLOCK), NULL);<br>
-	if (s-&gt;s_root == NULL) {<br>
-		printk("qnx4: get inode failed\n");<br>
-		goto out;<br>
-	}<br>
+<br>
+	/* check before allocating dentries, inodes, .. */<br>
 	errmsg = qnx4_checkroot(s);<br>
 	if (errmsg != NULL) {<br>
-		printk("qnx4: %s\n", errmsg);<br>
+		if (!silent)<br>
+			printk("qnx4: %s\n", errmsg);<br>
 		goto out;<br>
 	}<br>
+<br>
+	/* does root not have inode number QNX4_ROOT_INO ?? */<br>
+	root = iget(s, QNX4_ROOT_INO * QNX4_INODES_PER_BLOCK);<br>
+	if (!root) {<br>
+		printk("qnx4: get inode failed\n");<br>
+		goto out;<br>
+	}<br>
+<br>
+	s-&gt;s_root = d_alloc_root(root, NULL);<br>
+	if (s-&gt;s_root == NULL)<br>
+		goto outi;<br>
+<br>
 	brelse(bh);<br>
 	unlock_super(s);<br>
 	s-&gt;s_dirt = 1;<br>
 <br>
 	return s;<br>
 <br>
+      outi:<br>
+	iput(root);<br>
       out:<br>
 	brelse(bh);<br>
       outnobh:<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0630.html">=?iso-8859-1?Q?Peter_Sj=F6berg?=: "2.3.17 and alpha fails with too few arguments `ioremap'"</a>
<li> <b>Previous message:</b> <a href="0628.html">Brian Macy: "BusLogic + SMP == broke"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
