<!-- received="Thu Sep  9 10:24:05 1999 EET DST" -->
<!-- sent="Thu, 9 Sep 1999 00:06:01 -0700" -->
<!-- name="david parsons" -->
<!-- email="orc@pell.portland.or.us" -->
<!-- subject="A memory patch to the 2.3.17 memory detection stuff..." -->
<!-- id="199909090706.AAA25358@pell.portland.or.us" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: A memory patch to the 2.3.17 memory detection stuff...</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>A memory patch to the 2.3.17 memory detection stuff...</h1>
<b>david parsons</b> (<a href="mailto:orc@pell.portland.or.us"><i>orc@pell.portland.or.us</i></a>)<br>
<i>Thu, 9 Sep 1999 00:06:01 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#646">[ date ]</a><a href="index.html#646">[ thread ]</a><a href="subject.html#646">[ subject ]</a><a href="author.html#646">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0647.html">(no name): "Re: I vote for updated RAID and KNFSD"</a>
<li> <b>Previous message:</b> <a href="0645.html">dstein@phoenixcontact.com: "Kernel oops on SMP machine"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0684.html">Simon Richter: "Re: A memory patch to the 2.3.17 memory detection stuff..."</a>
<li> <b>Reply:</b> <a href="0684.html">Simon Richter: "Re: A memory patch to the 2.3.17 memory detection stuff..."</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
... synthesised from a bunch of input.<br>
<p>
It has a tweak in it to not accept e820 input when the map contains only<br>
one entry.<br>
<p>
It has the memory types replaced with symbolic constants, and the debugging<br>
printk's put back in.<br>
<p>
And it has the addr/end scheme that Linus suggested.<br>
<p>
It's been tested on a grand total of two machines here (and it works for<br>
the both of them;  2 scales to 10 million without any trouble, right?)<br>
but I'd be pleased to have it tested and/or placed into 2.3.18.<br>
<p>
-david parsons  "Now I guess I can try to figure out why libc 5'ed binaries<br>
                                         Just Don't Do It on my machine :-("<br>
<p>
--- linux-2.3.17-orig/include/asm-i386/e820.h	Mon Aug 30 10:47:02 1999<br>
+++ linux-2.3.17/include/asm-i386/e820.h	Wed Sep  8 20:26:06 1999<br>
@@ -16,6 +16,11 @@<br>
 #define E820MAX	32		/* number of entries in E820MAP */<br>
 #define E820NR	0x1e8		/* # entries in E820MAP */<br>
 <br>
+/* for e820map.map[].type */<br>
+#define E820_RAM	1<br>
+#define E820_RESERVED	2<br>
+#define E820_ACPI	3<br>
+<br>
 #define HIGH_MEMORY	(1024*1024)<br>
 <br>
 #ifndef __ASSEMBLY__<br>
--- linux-2.3.17-orig/arch/i386/mm/init.c	Wed Sep  8 20:19:51 1999<br>
+++ linux-2.3.17/arch/i386/mm/init.c	Wed Sep  8 20:50:59 1999<br>
@@ -414,25 +414,23 @@<br>
 	for (avail = i = 0; i &lt; e820.nr_map; i++) {<br>
 		unsigned long addr, end, size;<br>
 <br>
-		if (e820.map[i].type != 1)	/* not usable memory */<br>
+		if (e820.map[i].type != E820_RAM)	/* not usable memory */<br>
 			continue;<br>
 		addr = e820.map[i].addr;<br>
 		size = e820.map[i].size;<br>
 <br>
-		/* Overflow large memory reasonably gracefully */<br>
+		/* Silently ignore memory regions starting above 4gb */<br>
 		if (addr != e820.map[i].addr)<br>
 			continue;<br>
 <br>
 		printk("memory region: %luk @ %08lx\n", size &gt;&gt; 10, addr );<br>
 <br>
 		/* Make sure we don't get fractional pages */<br>
-		end = (addr + size) &amp; PAGE_MASK;<br>
-		addr = PAGE_ALIGN(addr);<br>
-		if (end &lt;= addr)<br>
-			continue;<br>
+		end = PAGE_OFFSET + ((addr + size) &amp; PAGE_MASK);<br>
+		addr= PAGE_OFFSET + PAGE_ALIGN(addr);<br>
+<br>
+		for ( ; addr &lt; end; addr += PAGE_SIZE) {<br>
 <br>
-		size = end - addr;<br>
-		for (addr = addr + PAGE_OFFSET ; size ; addr += PAGE_SIZE, size -= PAGE_SIZE) {<br>
 			/* this little bit of grossness is for dealing<br>
 			 * with memory borrowing for system bookkeeping<br>
 			 * (smp stacks, zero page, kernel code, etc)<br>
@@ -446,14 +444,11 @@<br>
 			 * in any case, we don't want to hack mem_map<br>
 			 * entries above end_mem.<br>
 			 */<br>
-			if ( addr &lt; start_low_mem )<br>
-				continue;<br>
-			if ( addr &gt; end_mem )<br>
-				continue;<br>
-			if ( addr &gt;= HIGH_MEMORY &amp;&amp; addr &lt;= start_mem )<br>
+			if ( (addr &lt; start_low_mem)<br>
+			  || (addr &gt;= HIGH_MEMORY &amp;&amp; addr &lt;= start_mem)<br>
+			  || (addr &gt; end_mem) )<br>
 				continue;<br>
 <br>
-			avail++;<br>
 			clear_bit(PG_reserved, &amp;mem_map[MAP_NR(addr)].flags);<br>
 		}<br>
 	}<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0647.html">(no name): "Re: I vote for updated RAID and KNFSD"</a>
<li> <b>Previous message:</b> <a href="0645.html">dstein@phoenixcontact.com: "Kernel oops on SMP machine"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0684.html">Simon Richter: "Re: A memory patch to the 2.3.17 memory detection stuff..."</a>
<li> <b>Reply:</b> <a href="0684.html">Simon Richter: "Re: A memory patch to the 2.3.17 memory detection stuff..."</a>
<!-- reply="end" -->
</ul>
</font></body>
