<!-- received="Thu Sep  9 11:48:37 1999 EET DST" -->
<!-- sent="Wed, 8 Sep 1999 23:36:19 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Integration of pcnet_cs into drivers/pcmcia" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: Integration of pcnet_cs into drivers/pcmcia</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Integration of pcnet_cs into drivers/pcmcia</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Wed, 8 Sep 1999 23:36:19 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#656">[ date ]</a><a href="index.html#656">[ thread ]</a><a href="subject.html#656">[ subject ]</a><a href="author.html#656">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0657.html">Paul Ashton: "Re: Strange kbd problems with 2.3.17 on toshiba satellite 4030cdt"</a>
<li> <b>Previous message:</b> <a href="0655.html">Pavel Machek: "ESS maestro"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
hi!<br>
<p>
So my wish for 2.4 came true: pcmcia is integrated in kernel. Here is<br>
my help: integrating pcnet_cs (and fixing minor bugs I noticed at the<br>
point). It works for me and I think it is the right thing.<br>
<p>
								Pavel<br>
<p>
diff -u clean//drivers/pcmcia/Config.in linux/drivers/pcmcia/Config.in<br>
--- clean//drivers/pcmcia/Config.in	Wed Sep  8 20:41:56 1999<br>
+++ linux/drivers/pcmcia/Config.in	Wed Sep  8 22:10:25 1999<br>
@@ -8,5 +8,6 @@<br>
 if [ "$CONFIG_PCMCIA" != "n" ]; then<br>
   bool '  CardBus support' CONFIG_CARDBUS<br>
 fi<br>
+tristate 'PCMCIA ethernet cards (NE2000 compatibles: DE-650, ...)' CONFIG_PCMCIA_PCNET<br>
 <br>
 endmenu<br>
diff -u clean//drivers/pcmcia/Makefile linux/drivers/pcmcia/Makefile<br>
--- clean//drivers/pcmcia/Makefile	Wed Sep  8 20:41:56 1999<br>
+++ linux/drivers/pcmcia/Makefile	Wed Sep  8 22:12:28 1999<br>
@@ -25,4 +25,12 @@<br>
   endif<br>
 endif<br>
 <br>
+ifeq ($(CONFIG_PCMCIA_PCNET),y)<br>
+  O_OBJS += pcnet_cs.o<br>
+else<br>
+  ifeq ($(CONFIG_PCMCIA_PCNET),m)<br>
+    MX_OBJS += pcnet_cs.o<br>
+  endif<br>
+endif<br>
+<br>
 include $(TOPDIR)/Rules.make<br>
diff -u clean//drivers/Makefile linux/drivers/Makefile<br>
--- clean//drivers/Makefile	Wed Sep  8 20:41:53 1999<br>
+++ linux/drivers/Makefile	Wed Sep  8 22:41:01 1999<br>
@@ -24,6 +24,7 @@<br>
 <br>
 ifdef CONFIG_PCMCIA<br>
 SUB_DIRS += pcmcia<br>
+MOD_SUB_DIRS += pcmcia<br>
 endif<br>
 <br>
 ifdef CONFIG_SBUS<br>
--- clean//init/main.c	Wed Sep  8 20:42:02 1999<br>
+++ linux/init/main.c	Wed Sep  8 23:25:15 1999<br>
@@ -117,6 +119,7 @@<br>
 <br>
 int root_mountflags = MS_RDONLY;<br>
 char *execute_command = NULL;<br>
+char *execute_chroot = NULL;<br>
 <br>
 static char * argv_init[MAX_INIT_ARGS+2] = { "init", NULL, };<br>
 static char * envp_init[MAX_INIT_ENVS+2] = { "HOME=/", "TERM=linux", NULL, };<br>
@@ -658,8 +695,11 @@<br>
 #ifdef CONFIG_IRDA<br>
 	irda_device_init(); /* Must be done after protocol initialization */<br>
 #endif<br>
 #ifdef CONFIG_PCMCIA<br>
 	pcmcia_init();		/* Do this last */<br>
+#ifdef CONFIG_PCMCIA_PCNET<br>
+	init_pcnet_cs();<br>
+#endif<br>
 #endif<br>
 	/* Mount the root filesystem.. */<br>
 	mount_root();<br>
--- /dev/null	Sun Jun 27 13:16:23 1999<br>
+++ linux/drivers/pcmcia/pcnet_cs.c	Wed Sep  8 23:18:14 1999<br>
@@ -0,0 +1,1359 @@<br>
+/*======================================================================<br>
+<br>
+    A PCMCIA ethernet driver for NS8390-based cards<br>
+<br>
+    This driver supports the D-Link DE-650 and Linksys EthernetCard<br>
+    cards, the newer D-Link and Linksys combo cards, Accton EN2212<br>
+    cards, the RPTI EP400, and the PreMax PE-200 in non-shared-memory<br>
+    mode, and the IBM Credit Card Adapter, the NE4100, the Thomas<br>
+    Conrad ethernet card, and the Kingston KNE-PCM/x in shared-memory<br>
+    mode.  It will also handle the Socket EA card in either mode.<br>
+<br>
+    Copyright (C) 1998 David A. Hinds -- <a href="mailto:dhinds@hyper.stanford.edu">dhinds@hyper.stanford.edu</a><br>
+<br>
+    pcnet_cs.c 1.94 1999/07/29 06:04:49<br>
+    <br>
+    The network driver code is based on Donald Becker's NE2000 code:<br>
+<br>
+    Written 1992,1993 by Donald Becker.<br>
+    Copyright 1993 United States Government as represented by the<br>
+    Director, National Security Agency.  This software may be used and<br>
+    distributed according to the terms of the GNU Public License,<br>
+    incorporated herein by reference.<br>
+    Donald Becker may be reached at <a href="mailto:becker@cesdis1.gsfc.nasa.gov">becker@cesdis1.gsfc.nasa.gov</a><br>
+<br>
+    Based also on Keith Moore's changes to Don Becker's code, for IBM<br>
+    CCAE support.  Drivers merged back together, and shared-memory<br>
+    Socket EA support added, by Ken Raeburn, September 1995.<br>
+<br>
+======================================================================*/<br>
+<br>
+#include &lt;linux/module.h&gt;<br>
+#include &lt;linux/kernel.h&gt;<br>
+#include &lt;linux/sched.h&gt;<br>
+#include &lt;linux/ptrace.h&gt;<br>
+#include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/string.h&gt;<br>
+#include &lt;linux/timer.h&gt;<br>
+#include &lt;linux/delay.h&gt;<br>
+#include &lt;asm/io.h&gt;<br>
+#include &lt;asm/system.h&gt;<br>
+<br>
+#include &lt;linux/netdevice.h&gt;<br>
+#include "../../drivers/net/8390.h"<br>
+<br>
+#include &lt;pcmcia/version.h&gt;<br>
+#include &lt;pcmcia/cs_types.h&gt;<br>
+#include &lt;pcmcia/cs.h&gt;<br>
+#include &lt;pcmcia/cistpl.h&gt;<br>
+#include &lt;pcmcia/ciscode.h&gt;<br>
+#include &lt;pcmcia/ds.h&gt;<br>
+#include &lt;pcmcia/cisreg.h&gt;<br>
+<br>
+#define PCNET_CMD	0x00<br>
+#define PCNET_DATAPORT	0x10	/* NatSemi-defined port window offset. */<br>
+#define PCNET_RESET	0x1f	/* Issue a read to reset, a write to clear. */<br>
+#define PCNET_MISC	0x18	/* For IBM CCAE and Socket EA cards */<br>
+<br>
+#define PCNET_START_PG	0x40	/* First page of TX buffer */<br>
+#define PCNET_STOP_PG	0x80	/* Last page +1 of RX ring */<br>
+<br>
+/* Socket EA cards have a larger packet buffer */<br>
+#define SOCKET_START_PG	0x01<br>
+#define SOCKET_STOP_PG	0xff<br>
+<br>
+#define PCNET_RDC_TIMEOUT 0x02	/* Max wait in jiffies for Tx RDC */<br>
+<br>
+static char *if_names[] = { "auto", "10baseT", "10base2"};<br>
+<br>
+#define PCMCIA_DEBUG 6<br>
+#ifdef PCMCIA_DEBUG<br>
+static int pc_debug = PCMCIA_DEBUG;<br>
+MODULE_PARM(pc_debug, "i");<br>
+#define DEBUG(n, args...) if (pc_debug&gt;(n)) printk(KERN_DEBUG args)<br>
+static char *version =<br>
+"pcnet_cs.c 1.94 1999/07/29 06:04:49 (David Hinds)";<br>
+#else<br>
+#define DEBUG(n, args...)<br>
+#endif<br>
+<br>
+/*====================================================================*/<br>
+<br>
+/* Parameters that can be set with 'insmod' */<br>
+<br>
+/* Bit map of interrupts to choose from */<br>
+static u_int irq_mask = 0xdeb8;<br>
+static int irq_list[4] = { -1 };<br>
+<br>
+/* Transceiver type, for Socket EA and IBM CC cards. */<br>
+static int if_port = 1;<br>
+<br>
+/* Use 64K packet buffer, for Socket EA cards. */<br>
+static int use_big_buf = 1;<br>
+<br>
+/* Shared memory speed, in ns */<br>
+static int mem_speed = 0;<br>
+<br>
+/* Insert a pause in block_output after sending a packet */<br>
+static int delay_output = 0;<br>
+<br>
+/* Length of delay, in microseconds */<br>
+static int delay_time = 4;<br>
+<br>
+/* Use shared memory, if available? */<br>
+static int use_shmem = -1;<br>
+<br>
+/* Ugh!  Let the user hardwire the hardware address for queer cards */<br>
+static int hw_addr[6] = { 0, /* ... */ };<br>
+<br>
+MODULE_PARM(irq_mask, "i");<br>
+MODULE_PARM(irq_list, "1-4i");<br>
+MODULE_PARM(if_port, "i");<br>
+MODULE_PARM(use_big_buf, "i");<br>
+MODULE_PARM(mem_speed, "i");<br>
+MODULE_PARM(delay_output, "i");<br>
+MODULE_PARM(delay_time, "i");<br>
+MODULE_PARM(use_shmem, "i");<br>
+MODULE_PARM(hw_addr, "6i");<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void pcnet_config(dev_link_t *link);<br>
+static void pcnet_release(u_long arg);<br>
+static int pcnet_event(event_t event, int priority,<br>
+		       event_callback_args_t *args);<br>
+<br>
+static int pcnet_open(struct net_device *dev);<br>
+static int pcnet_close(struct net_device *dev);<br>
+<br>
+static void pcnet_reset_8390(struct net_device *dev);<br>
+<br>
+static int set_config(struct net_device *dev, struct ifmap *map);<br>
+<br>
+static int setup_shmem_window(dev_link_t *link, int start_pg,<br>
+			      int stop_pg, int cm_offset);<br>
+static int setup_dma_config(dev_link_t *link, int start_pg,<br>
+			    int stop_pg);<br>
+<br>
+static dev_info_t dev_info = "pcnet_cs";<br>
+<br>
+static dev_link_t *pcnet_attach(void);<br>
+static void pcnet_detach(dev_link_t *);<br>
+<br>
+static dev_link_t *dev_list;<br>
+<br>
+/*====================================================================*/<br>
+<br>
+typedef struct hw_info_t {<br>
+    u_long	offset;<br>
+    u_char	a0, a1, a2;<br>
+    u_long	flags;<br>
+} hw_info_t;<br>
+<br>
+#define DELAY_OUTPUT	0x01<br>
+#define HAS_MISC_REG	0x02<br>
+#define USE_BIG_BUF	0x04<br>
+#define HAS_IBM_MISC	0x08<br>
+#define IS_DL10019A	0x10<br>
+#define USE_SHMEM	0x80	/* autodetected */<br>
+<br>
+static hw_info_t hw_info[] = {<br>
+    { /* Accton EN2212 */ 0x0ff0, 0x00, 0x00, 0xe8, DELAY_OUTPUT }, <br>
+    { /* Allied Telesis LA-PCM */ 0x0ff0, 0x00, 0x00, 0xf4, 0 },<br>
+    { /* APEX MultiCard */ 0x03f4, 0x00, 0x20, 0xe5, 0 },<br>
+    { /* ASANTE FriendlyNet */ 0x4910, 0x00, 0x00, 0x94,<br>
+      DELAY_OUTPUT | HAS_IBM_MISC },<br>
+    { /* Danpex EN-6200P2 */ 0x0110, 0x00, 0x40, 0xc7, 0 },<br>
+    { /* DataTrek NetCard */ 0x0ff0, 0x00, 0x20, 0xe8, 0 },<br>
+    { /* Dayna CommuniCard E */ 0x0110, 0x00, 0x80, 0x19, 0 },<br>
+    { /* D-Link DE-650 */ 0x0040, 0x00, 0x80, 0xc8, 0 },<br>
+    { /* EP-210 Ethernet */ 0x0110, 0x00, 0x40, 0x33, 0 },<br>
+    { /* EP4000 Ethernet */ 0x01c0, 0x00, 0x00, 0xb4, 0 },<br>
+    { /* Epson EEN10B */ 0x0ff0, 0x00, 0x00, 0x48,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* ELECOM Laneed LD-CDWA */ 0xb8, 0x08, 0x00, 0x42, 0 },<br>
+    { /* Hypertec Ethernet */ 0x01c0, 0x00, 0x40, 0x4c, 0 },<br>
+    { /* IBM CCAE */ 0x0ff0, 0x08, 0x00, 0x5a,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* IBM CCAE */ 0x0ff0, 0x00, 0x04, 0xac,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* IBM CCAE */ 0x0ff0, 0x00, 0x06, 0x29,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* IBM FME */ 0x0374, 0x08, 0x00, 0x5a,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* IBM FME */ 0x0374, 0x00, 0x04, 0xac,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* Kansai KLA-PCM/T */ 0x0ff0, 0x00, 0x60, 0x87,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* NSC DP83903 */ 0x0374, 0x00, 0xc0, 0xa8,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* NSC DP83903 */ 0x0374, 0x00, 0xa0, 0xb0,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* NSC DP83903 */ 0x0198, 0x00, 0x20, 0xe0,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* I-O DATA PCLA/T */ 0x0ff0, 0x00, 0xa0, 0xb0, 0 },<br>
+    { /* Katron PE-520 */ 0x0110, 0x00, 0x40, 0xf6, 0 },<br>
+    { /* Kingston KNE-PCM/x */ 0x0ff0, 0x00, 0xc0, 0xf0,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* Kingston KNE-PCM/x */ 0x0ff0, 0xe2, 0x0c, 0x0f,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* Kingston KNE-PC2 */ 0x0180, 0x00, 0xc0, 0xf0, 0 },<br>
+    { /* Maxtech PCN2000 */ 0x5000, 0x00, 0x00, 0xe8, 0 },<br>
+    { /* NDC Instant-Link */ 0x003a, 0x00, 0x80, 0xc6, 0 },<br>
+    { /* NE2000 Compatible */ 0x0ff0, 0x00, 0xa0, 0x0c, 0 },<br>
+    { /* Network General Sniffer */ 0x0ff0, 0x00, 0x00, 0x65,<br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* Panasonic VEL211 */ 0x0ff0, 0x00, 0x80, 0x45, <br>
+      HAS_MISC_REG | HAS_IBM_MISC },<br>
+    { /* PreMax PE-200 */ 0x07f0, 0x00, 0x20, 0xe0, 0 },<br>
+    { /* RPTI EP400 */ 0x0110, 0x00, 0x40, 0x95, 0 },<br>
+    { /* SCM Ethernet */ 0x0ff0, 0x00, 0x20, 0xcb, 0 },<br>
+    { /* Socket EA */ 0x4000, 0x00, 0xc0, 0x1b,<br>
+      DELAY_OUTPUT | HAS_MISC_REG | USE_BIG_BUF },<br>
+    { /* SuperSocket RE450T */ 0x0110, 0x00, 0xe0, 0x98, 0 },<br>
+    { /* Volktek NPL-402CT */ 0x0060, 0x00, 0x40, 0x05, 0 }<br>
+};<br>
+<br>
+#define NR_INFO		(sizeof(hw_info)/sizeof(hw_info_t))<br>
+<br>
+static hw_info_t default_info =<br>
+{ /* Unknown NE2000 Clone */ 0x00, 0x00, 0x00, 0x00, 0 };<br>
+static hw_info_t dl_fast_info =<br>
+{ /* D-Link EtherFast */ 0x00, 0x00, 0x00, 0x00, IS_DL10019A };<br>
+<br>
+typedef struct pcnet_dev_t {<br>
+    struct net_device	dev;<br>
+    dev_node_t		node;<br>
+    u_long		flags;<br>
+    caddr_t		base;<br>
+} pcnet_dev_t;<br>
+<br>
+/*======================================================================<br>
+<br>
+    This bit of code is used to avoid unregistering network devices<br>
+    at inappropriate times.  2.2 and later kernels are fairly picky<br>
+    about when this can happen.<br>
+    <br>
+======================================================================*/<br>
+<br>
+static void flush_stale_links(void)<br>
+{<br>
+    dev_link_t *link, *next;<br>
+    for (link = dev_list; link; link = next) {<br>
+	next = link-&gt;next;<br>
+	if (link-&gt;state &amp; DEV_STALE_LINK)<br>
+	    pcnet_detach(link);<br>
+    }<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void cs_error(client_handle_t handle, int func, int ret)<br>
+{<br>
+    error_info_t err = { func, ret };<br>
+    CardServices(ReportError, handle, &amp;err);<br>
+}<br>
+<br>
+/*======================================================================<br>
+<br>
+    We never need to do anything when a pcnet device is "initialized"<br>
+    by the net software, because we only register already-found cards.<br>
+<br>
+======================================================================*/<br>
+<br>
+static int pcnet_init(struct net_device *dev)<br>
+{<br>
+    return 0;<br>
+}<br>
+<br>
+/*======================================================================<br>
+<br>
+    pcnet_attach() creates an "instance" of the driver, allocating<br>
+    local data structures for one device.  The device is registered<br>
+    with Card Services.<br>
+<br>
+======================================================================*/<br>
+<br>
+static dev_link_t *pcnet_attach(void)<br>
+{<br>
+    client_reg_t client_reg;<br>
+    dev_link_t *link;<br>
+    pcnet_dev_t *info;<br>
+    struct net_device *dev;<br>
+    int i, ret;<br>
+<br>
+    DEBUG(0, "pcnet_attach()\n");<br>
+    flush_stale_links();<br>
+<br>
+    /* Create new ethernet device */<br>
+    link = kmalloc(sizeof(struct dev_link_t), GFP_KERNEL);<br>
+    memset(link, 0, sizeof(struct dev_link_t));<br>
+    link-&gt;release.function = &amp;pcnet_release;<br>
+    link-&gt;release.data = (u_long)link;<br>
+    link-&gt;irq.Attributes = IRQ_TYPE_EXCLUSIVE;<br>
+    link-&gt;irq.IRQInfo1 = IRQ_INFO2_VALID|IRQ_LEVEL_ID;<br>
+    if (irq_list[0] == -1)<br>
+	link-&gt;irq.IRQInfo2 = irq_mask;<br>
+    else<br>
+	for (i = 0; i &lt; 4; i++)<br>
+	    link-&gt;irq.IRQInfo2 |= 1 &lt;&lt; irq_list[i];<br>
+    link-&gt;conf.Attributes = CONF_ENABLE_IRQ;<br>
+    link-&gt;conf.Vcc = 50;<br>
+    link-&gt;conf.IntType = INT_MEMORY_AND_IO;<br>
+<br>
+    info = kmalloc(sizeof(struct pcnet_dev_t), GFP_KERNEL);<br>
+    memset(info, 0, sizeof(struct pcnet_dev_t));<br>
+    dev = &amp;info-&gt;dev;<br>
+    ethdev_init(dev);<br>
+    dev-&gt;name = info-&gt;node.dev_name;<br>
+    dev-&gt;init = &amp;pcnet_init;<br>
+    dev-&gt;open = &amp;pcnet_open;<br>
+    dev-&gt;stop = &amp;pcnet_close;<br>
+    dev-&gt;set_config = &amp;set_config;<br>
+    dev-&gt;tbusy = 1;<br>
+    link-&gt;priv = info;<br>
+<br>
+    /* Register with Card Services */<br>
+    link-&gt;next = dev_list;<br>
+    dev_list = link;<br>
+    client_reg.dev_info = &amp;dev_info;<br>
+    client_reg.Attributes = INFO_IO_CLIENT | INFO_CARD_SHARE;<br>
+    client_reg.EventMask =<br>
+	CS_EVENT_CARD_INSERTION | CS_EVENT_CARD_REMOVAL |<br>
+	CS_EVENT_RESET_PHYSICAL | CS_EVENT_CARD_RESET |<br>
+	CS_EVENT_PM_SUSPEND | CS_EVENT_PM_RESUME;<br>
+    client_reg.event_handler = &amp;pcnet_event;<br>
+    client_reg.Version = 0x0210;<br>
+    client_reg.event_callback_args.client_data = link;<br>
+    ret = CardServices(RegisterClient, &amp;link-&gt;handle, &amp;client_reg);<br>
+    if (ret != CS_SUCCESS) {<br>
+	cs_error(link-&gt;handle, RegisterClient, ret);<br>
+	pcnet_detach(link);<br>
+	return NULL;<br>
+    }<br>
+<br>
+    return link;<br>
+} /* pcnet_attach */<br>
+<br>
+/*======================================================================<br>
+<br>
+    This deletes a driver "instance".  The device is de-registered<br>
+    with Card Services.  If it has been released, all local data<br>
+    structures are freed.  Otherwise, the structures will be freed<br>
+    when the device is released.<br>
+<br>
+======================================================================*/<br>
+<br>
+static void pcnet_detach(dev_link_t *link)<br>
+{<br>
+    dev_link_t **linkp;<br>
+    long flags;<br>
+<br>
+    DEBUG(0, "pcnet_detach(0x%p)\n", link);<br>
+<br>
+    /* Locate device structure */<br>
+    for (linkp = &amp;dev_list; *linkp; linkp = &amp;(*linkp)-&gt;next)<br>
+	if (*linkp == link) break;<br>
+    if (*linkp == NULL)<br>
+	return;<br>
+<br>
+    save_flags(flags);<br>
+    cli();<br>
+    if (link-&gt;state &amp; DEV_RELEASE_PENDING) {<br>
+	del_timer(&amp;link-&gt;release);<br>
+	link-&gt;state &amp;= ~DEV_RELEASE_PENDING;<br>
+    }<br>
+    restore_flags(flags);<br>
+<br>
+    if (link-&gt;state &amp; DEV_CONFIG) {<br>
+	pcnet_release((u_long)link);<br>
+	if (link-&gt;state &amp; DEV_STALE_CONFIG) {<br>
+	    link-&gt;state |= DEV_STALE_LINK;<br>
+	    return;<br>
+	}<br>
+    }<br>
+<br>
+    if (link-&gt;handle)<br>
+	CardServices(DeregisterClient, link-&gt;handle);<br>
+<br>
+    /* Unlink device structure, free bits */<br>
+    *linkp = link-&gt;next;<br>
+    if (link-&gt;priv) {<br>
+	struct net_device *dev = link-&gt;priv;<br>
+	if (link-&gt;dev != NULL)<br>
+	    unregister_netdev(dev);<br>
+	if (dev-&gt;priv)<br>
+	    kfree_s(dev-&gt;priv, sizeof(struct ei_device));<br>
+	kfree_s(dev, sizeof(struct pcnet_dev_t));<br>
+    }<br>
+    kfree_s(link, sizeof(struct dev_link_t));<br>
+<br>
+} /* pcnet_detach */<br>
+<br>
+/*======================================================================<br>
+<br>
+    For the Linksys EtherFast 10/100 card<br>
+<br>
+======================================================================*/<br>
+<br>
+static hw_info_t *get_dl_fast(dev_link_t *link)<br>
+{<br>
+    struct net_device *dev = link-&gt;priv;<br>
+    int i;<br>
+    u_char sum;<br>
+<br>
+    for (sum = 0, i = 0x14; i &lt; 0x1c; i++)<br>
+	sum += inb_p(dev-&gt;base_addr + i);<br>
+    if (sum != 0xff)<br>
+	return NULL;<br>
+    for (i = 0; i &lt; 6; i++)<br>
+	dev-&gt;dev_addr[i] = inb_p(dev-&gt;base_addr + 0x14 + i);<br>
+    return &amp;dl_fast_info;<br>
+}<br>
+<br>
+/*======================================================================<br>
+<br>
+    This probes for a card's hardware address, for card types that<br>
+    encode this information in their CIS.<br>
+<br>
+======================================================================*/<br>
+<br>
+static hw_info_t *get_hwinfo(dev_link_t *link)<br>
+{<br>
+    struct net_device *dev = link-&gt;priv;<br>
+    win_req_t req;<br>
+    memreq_t mem;<br>
+    u_char *base, *virt;<br>
+    int i, j;<br>
+<br>
+    /* Allocate a small memory window */<br>
+    req.Attributes = WIN_DATA_WIDTH_8|WIN_MEMORY_TYPE_AM|WIN_ENABLE;<br>
+    req.Base = 0; req.Size = 0;<br>
+    req.AccessSpeed = 0;<br>
+    link-&gt;win = (window_handle_t)link-&gt;handle;<br>
+    i = CardServices(RequestWindow, &amp;link-&gt;win, &amp;req);<br>
+    if (i != CS_SUCCESS) {<br>
+	cs_error(link-&gt;handle, RequestWindow, i);<br>
+	return NULL;<br>
+    }<br>
+<br>
+    virt = ioremap(req.Base, req.Size);<br>
+    mem.Page = 0;<br>
+    for (i = 0; i &lt; NR_INFO; i++) {<br>
+	mem.CardOffset = hw_info[i].offset &amp; ~(req.Size-1);<br>
+	CardServices(MapMemPage, link-&gt;win, &amp;mem);<br>
+	base = &amp;virt[hw_info[i].offset &amp; (req.Size-1)];<br>
+	if ((readb(base+0) == hw_info[i].a0) &amp;&amp;<br>
+	    (readb(base+2) == hw_info[i].a1) &amp;&amp;<br>
+	    (readb(base+4) == hw_info[i].a2))<br>
+	    break;<br>
+    }<br>
+    if (i &lt; NR_INFO) {<br>
+	for (j = 0; j &lt; 6; j++)<br>
+	    dev-&gt;dev_addr[j] = readb(base + (j&lt;&lt;1));<br>
+    }<br>
+    <br>
+    iounmap(virt);<br>
+    j = CardServices(ReleaseWindow, link-&gt;win);<br>
+    if (j != CS_SUCCESS)<br>
+	cs_error(link-&gt;handle, ReleaseWindow, j);<br>
+    return (i &lt; NR_INFO) ? hw_info+i : NULL;<br>
+} /* get_hwinfo */<br>
+<br>
+/*======================================================================<br>
+<br>
+    This probes for a card's hardware address by reading the PROM.<br>
+    It checks the address against a list of known types, then falls<br>
+    back to a simple NE2000 clone signature check.<br>
+<br>
+======================================================================*/<br>
+<br>
+static hw_info_t *get_prom(dev_link_t *link)<br>
+{<br>
+    struct net_device *dev = link-&gt;priv;<br>
+    unsigned char prom[32];<br>
+    int i, j, ioaddr;<br>
+<br>
+    /* This is lifted straight from drivers/net/ne.c */<br>
+    struct {<br>
+	unsigned char value, offset;<br>
+    } program_seq[] = {<br>
+	{E8390_NODMA+E8390_PAGE0+E8390_STOP, E8390_CMD}, /* Select page 0*/<br>
+	{0x48,	EN0_DCFG},	/* Set byte-wide (0x48) access. */<br>
+	{0x00,	EN0_RCNTLO},	/* Clear the count regs. */<br>
+	{0x00,	EN0_RCNTHI},<br>
+	{0x00,	EN0_IMR},	/* Mask completion irq. */<br>
+	{0xFF,	EN0_ISR},<br>
+	{E8390_RXOFF, EN0_RXCR},	/* 0x20  Set to monitor */<br>
+	{E8390_TXOFF, EN0_TXCR},	/* 0x02  and loopback mode. */<br>
+	{32,	EN0_RCNTLO},<br>
+	{0x00,	EN0_RCNTHI},<br>
+	{0x00,	EN0_RSARLO},	/* DMA starting at 0x0000. */<br>
+	{0x00,	EN0_RSARHI},<br>
+	{E8390_RREAD+E8390_START, E8390_CMD},<br>
+    };<br>
+<br>
+    ioaddr = dev-&gt;base_addr;<br>
+<br>
+    pcnet_reset_8390(dev);<br>
+    udelay(10000);<br>
+<br>
+    for (i = 0; i &lt; sizeof(program_seq)/sizeof(program_seq[0]); i++)<br>
+	outb_p(program_seq[i].value, ioaddr + program_seq[i].offset);<br>
+<br>
+    for (i = 0; i &lt; 32; i++)<br>
+	prom[i] = inb(ioaddr + PCNET_DATAPORT);<br>
+    for (i = 0; i &lt; NR_INFO; i++) {<br>
+	if ((prom[0] == hw_info[i].a0) &amp;&amp;<br>
+	    (prom[2] == hw_info[i].a1) &amp;&amp;<br>
+	    (prom[4] == hw_info[i].a2))<br>
+	    break;<br>
+    }<br>
+    if ((i &lt; NR_INFO) || ((prom[28] == 0x57) &amp;&amp; (prom[30] == 0x57))) {<br>
+	for (j = 0; j &lt; 6; j++)<br>
+	    dev-&gt;dev_addr[j] = prom[j&lt;&lt;1];<br>
+	return (i &lt; NR_INFO) ? hw_info+i : &amp;default_info;<br>
+    }<br>
+    return NULL;<br>
+} /* get_prom */<br>
+<br>
+/*======================================================================<br>
+<br>
+    This should be totally unnecessary... but when we can't figure<br>
+    out the hardware address any other way, we'll let the user hard<br>
+    wire it when the module is initialized.<br>
+<br>
+======================================================================*/<br>
+<br>
+static hw_info_t *get_hwired(dev_link_t *link)<br>
+{<br>
+    struct net_device *dev = link-&gt;priv;<br>
+    int i;<br>
+<br>
+    for (i = 0; i &lt; 6; i++)<br>
+	if (hw_addr[i] != 0) break;<br>
+    if (i == 6)<br>
+	return NULL;<br>
+<br>
+    for (i = 0; i &lt; 6; i++)<br>
+	dev-&gt;dev_addr[i] = hw_addr[i];<br>
+<br>
+    return &amp;default_info;<br>
+} /* get_hwired */<br>
+<br>
+/*======================================================================<br>
+<br>
+    pcnet_config() is scheduled to run after a CARD_INSERTION event<br>
+    is received, to configure the PCMCIA socket, and to make the<br>
+    ethernet device available to the system.<br>
+<br>
+======================================================================*/<br>
+<br>
+#define CS_CHECK(fn, args...) \<br>
+while ((last_ret=CardServices(last_fn=(fn), args))!=0) goto cs_failed<br>
+<br>
+#define CFG_CHECK(fn, args...) \<br>
+if (CardServices(fn, args) != 0) goto next_entry<br>
+<br>
+static int try_io_port(dev_link_t *link)<br>
+{<br>
+    int j, ret;<br>
+    if (link-&gt;io.NumPorts1 == 32) {<br>
+	link-&gt;io.Attributes1 = IO_DATA_PATH_WIDTH_AUTO;<br>
+	if (link-&gt;io.NumPorts2 &gt; 0) {<br>
+	    /* for master/slave multifunction cards */<br>
+	    link-&gt;io.Attributes2 = IO_DATA_PATH_WIDTH_8;<br>
+	    link-&gt;irq.Attributes = <br>
+		IRQ_TYPE_DYNAMIC_SHARING|IRQ_FIRST_SHARED;<br>
+	}<br>
+    } else {<br>
+	/* This should be two 16-port windows */<br>
+	link-&gt;io.Attributes1 = IO_DATA_PATH_WIDTH_8;<br>
+	link-&gt;io.Attributes2 = IO_DATA_PATH_WIDTH_16;<br>
+    }<br>
+    if (link-&gt;io.BasePort1 == 0) {<br>
+	for (j = 0; j &lt; 0x400; j += 0x20) {<br>
+	    link-&gt;io.BasePort1 = j ^ 0x300;<br>
+	    link-&gt;io.BasePort2 = (j ^ 0x300) + 0x10;<br>
+	    ret = CardServices(RequestIO, link-&gt;handle, &amp;link-&gt;io);<br>
+	    if (ret == CS_SUCCESS) return ret;<br>
+	}<br>
+	return ret;<br>
+    } else {<br>
+	return CardServices(RequestIO, link-&gt;handle, &amp;link-&gt;io);<br>
+    }<br>
+}<br>
+<br>
+static void pcnet_config(dev_link_t *link)<br>
+{<br>
+    client_handle_t handle;<br>
+    tuple_t tuple;<br>
+    cisparse_t parse;<br>
+    pcnet_dev_t *info;<br>
+    struct net_device *dev;<br>
+    int i, last_ret, last_fn, start_pg, stop_pg, cm_offset;<br>
+    int manfid = 0, prodid = 0, has_shmem = 0;<br>
+    u_short buf[64];<br>
+    hw_info_t *hw_info;<br>
+<br>
+    handle = link-&gt;handle;<br>
+    info = link-&gt;priv;<br>
+    dev = &amp;info-&gt;dev;<br>
+<br>
+    DEBUG(0, "pcnet_config(0x%p)\n", link);<br>
+<br>
+    tuple.Attributes = 0;<br>
+    tuple.TupleData = (cisdata_t *)buf;<br>
+    tuple.TupleDataMax = sizeof(buf);<br>
+    tuple.TupleOffset = 0;<br>
+    tuple.DesiredTuple = CISTPL_CONFIG;<br>
+    CS_CHECK(GetFirstTuple, handle, &amp;tuple);<br>
+    CS_CHECK(GetTupleData, handle, &amp;tuple);<br>
+    CS_CHECK(ParseTuple, handle, &amp;tuple, &amp;parse);<br>
+    link-&gt;conf.ConfigBase = parse.config.base;<br>
+    link-&gt;conf.Present = parse.config.rmask[0];<br>
+<br>
+    /* Configure card */<br>
+    link-&gt;state |= DEV_CONFIG;<br>
+<br>
+    tuple.DesiredTuple = CISTPL_MANFID;<br>
+    tuple.Attributes = TUPLE_RETURN_COMMON;<br>
+    if ((CardServices(GetFirstTuple, handle, &amp;tuple) == CS_SUCCESS) &amp;&amp;<br>
+ 	(CardServices(GetTupleData, handle, &amp;tuple) == CS_SUCCESS)) {<br>
+	manfid = le16_to_cpu(buf[0]);<br>
+	prodid = le16_to_cpu(buf[1]);<br>
+    }<br>
+    <br>
+    tuple.DesiredTuple = CISTPL_CFTABLE_ENTRY;<br>
+    tuple.Attributes = 0;<br>
+    CS_CHECK(GetFirstTuple, handle, &amp;tuple);<br>
+    while (last_ret == CS_SUCCESS) {<br>
+	cistpl_cftable_entry_t *cfg = &amp;(parse.cftable_entry);<br>
+	cistpl_io_t *io = &amp;(parse.cftable_entry.io);<br>
+	<br>
+	CFG_CHECK(GetTupleData, handle, &amp;tuple);<br>
+	CFG_CHECK(ParseTuple, handle, &amp;tuple, &amp;parse);<br>
+	if ((cfg-&gt;index == 0) || (cfg-&gt;io.nwin == 0))<br>
+	    goto next_entry;<br>
+	<br>
+	link-&gt;conf.ConfigIndex = cfg-&gt;index;<br>
+	/* For multifunction cards, by convention, we configure the<br>
+	   network function with window 0, and serial with window 1 */<br>
+	if (io-&gt;nwin &gt; 1) {<br>
+	    i = (io-&gt;win[1].len &gt; io-&gt;win[0].len);<br>
+	    link-&gt;io.BasePort2 = io-&gt;win[1-i].base;<br>
+	    link-&gt;io.NumPorts2 = io-&gt;win[1-i].len;<br>
+	} else {<br>
+	    i = link-&gt;io.NumPorts2 = 0;<br>
+	}<br>
+	has_shmem = ((cfg-&gt;mem.nwin == 1) &amp;&amp;<br>
+		     (cfg-&gt;mem.win[0].len &gt;= 0x4000));<br>
+	link-&gt;io.BasePort1 = io-&gt;win[i].base;<br>
+	link-&gt;io.NumPorts1 = io-&gt;win[i].len;<br>
+	if (link-&gt;io.NumPorts1 + link-&gt;io.NumPorts2 &gt;= 32) {<br>
+	    last_ret = try_io_port(link);<br>
+	    if (last_ret == CS_SUCCESS) break;<br>
+	}<br>
+    next_entry:<br>
+	last_ret = CardServices(GetNextTuple, handle, &amp;tuple);<br>
+    }<br>
+    if (last_ret != CS_SUCCESS) {<br>
+	cs_error(handle, RequestIO, last_ret);<br>
+	goto failed;<br>
+    }<br>
+<br>
+    CS_CHECK(RequestIRQ, handle, &amp;link-&gt;irq);<br>
+    <br>
+    if (link-&gt;io.NumPorts2 == 8) {<br>
+	link-&gt;conf.Attributes |= CONF_ENABLE_SPKR;<br>
+	link-&gt;conf.Status = CCSR_AUDIO_ENA;<br>
+    }<br>
+    if ((manfid == MANFID_IBM) &amp;&amp;<br>
+	(prodid == PRODID_IBM_HOME_AND_AWAY))<br>
+	link-&gt;conf.ConfigIndex |= 0x10;<br>
+    <br>
+    CS_CHECK(RequestConfiguration, handle, &amp;link-&gt;conf);<br>
+    dev-&gt;irq = link-&gt;irq.AssignedIRQ;<br>
+    dev-&gt;base_addr = link-&gt;io.BasePort1;<br>
+    if ((if_port == 1) || (if_port == 2))<br>
+	dev-&gt;if_port = if_port;<br>
+    else<br>
+	printk(KERN_NOTICE "pcnet_cs: invalid if_port requested\n");<br>
+    dev-&gt;tbusy = 0;<br>
+    if (register_netdev(dev) != 0) {<br>
+	printk(KERN_NOTICE "pcnet_cs: register_netdev() failed\n");<br>
+	goto failed;<br>
+    }<br>
+<br>
+    hw_info = get_hwinfo(link);<br>
+    if (hw_info == NULL)<br>
+	hw_info = get_prom(link);<br>
+    if (hw_info == NULL)<br>
+	hw_info = get_dl_fast(link);<br>
+    if (hw_info == NULL)<br>
+	hw_info = get_hwired(link);<br>
+    <br>
+    if (hw_info == NULL) {<br>
+	printk(KERN_NOTICE "pcnet_cs: unable to read hardware net address\n");<br>
+	goto config_undo;<br>
+    }<br>
+<br>
+    info-&gt;flags = hw_info-&gt;flags;<br>
+    /* Check for user overrides */<br>
+    info-&gt;flags |= (delay_output) ? DELAY_OUTPUT : 0;<br>
+    if ((manfid == MANFID_SOCKET) &amp;&amp; (prodid == PRODID_SOCKET_LPE))<br>
+	info-&gt;flags &amp;= ~USE_BIG_BUF;<br>
+    if (!use_big_buf)<br>
+	info-&gt;flags &amp;= ~USE_BIG_BUF;<br>
+    <br>
+    if (info-&gt;flags &amp; USE_BIG_BUF) {<br>
+	start_pg = SOCKET_START_PG;<br>
+	stop_pg = SOCKET_STOP_PG;<br>
+	cm_offset = 0x10000;<br>
+    } else {<br>
+	start_pg = PCNET_START_PG;<br>
+	stop_pg = PCNET_STOP_PG;<br>
+	cm_offset = 0;<br>
+    }<br>
+<br>
+    /* has_shmem is ignored if use_shmem != -1 */<br>
+    if ((use_shmem == 0) || (!has_shmem &amp;&amp; (use_shmem == -1)) ||<br>
+	(setup_shmem_window(link, start_pg, stop_pg, cm_offset) != 0))<br>
+	setup_dma_config(link, start_pg, stop_pg);<br>
+<br>
+    ei_status.name = "NE2000";<br>
+    ei_status.word16 = 1;<br>
+    ei_status.reset_8390 = &amp;pcnet_reset_8390;<br>
+<br>
+    link-&gt;dev = &amp;info-&gt;node;<br>
+    link-&gt;state &amp;= ~DEV_CONFIG_PENDING;<br>
+<br>
+    printk(KERN_INFO "%s: NE2000 Compatible: io %#3lx, irq %d,",<br>
+	   dev-&gt;name, dev-&gt;base_addr, dev-&gt;irq);<br>
+    if (info-&gt;flags &amp; USE_SHMEM)<br>
+	printk (" mem %#5lx,", dev-&gt;mem_start);<br>
+    if (info-&gt;flags &amp; HAS_MISC_REG)<br>
+	printk(" %s xcvr,", if_names[dev-&gt;if_port]);<br>
+    printk(" hw_addr ");<br>
+    for (i = 0; i &lt; 6; i++)<br>
+	printk("%02X%s", dev-&gt;dev_addr[i], ((i&lt;5) ? ":" : "\n"));<br>
+    return;<br>
+<br>
+config_undo:<br>
+    unregister_netdev(dev);<br>
+    goto failed;<br>
+cs_failed:<br>
+    cs_error(link-&gt;handle, last_fn, last_ret);<br>
+failed:<br>
+    pcnet_release((u_long)link);<br>
+    return;<br>
+} /* pcnet_config */<br>
+<br>
+/*======================================================================<br>
+<br>
+    After a card is removed, pcnet_release() will unregister the net<br>
+    device, and release the PCMCIA configuration.  If the device is<br>
+    still open, this will be postponed until it is closed.<br>
+<br>
+======================================================================*/<br>
+<br>
+static void pcnet_release(u_long arg)<br>
+{<br>
+    dev_link_t *link = (dev_link_t *)arg;<br>
+    pcnet_dev_t *info = link-&gt;priv;<br>
+<br>
+    DEBUG(0, "pcnet_release(0x%p)\n", link);<br>
+<br>
+    if (link-&gt;open) {<br>
+	DEBUG(1, "pcnet_cs: release postponed, '%s' still open\n",<br>
+	      info-&gt;node.dev_name);<br>
+	link-&gt;state |= DEV_STALE_CONFIG;<br>
+	return;<br>
+    }<br>
+<br>
+    if (info-&gt;flags &amp; USE_SHMEM) {<br>
+	iounmap(info-&gt;base);<br>
+	CardServices(ReleaseWindow, link-&gt;win);<br>
+    }<br>
+    CardServices(ReleaseConfiguration, link-&gt;handle);<br>
+    CardServices(ReleaseIO, link-&gt;handle, &amp;link-&gt;io);<br>
+    CardServices(ReleaseIRQ, link-&gt;handle, &amp;link-&gt;irq);<br>
+<br>
+    link-&gt;state &amp;= ~(DEV_CONFIG | DEV_RELEASE_PENDING);<br>
+<br>
+} /* pcnet_release */<br>
+<br>
+/*======================================================================<br>
+<br>
+    The card status event handler.  Mostly, this schedules other<br>
+    stuff to run after an event is received.  A CARD_REMOVAL event<br>
+    also sets some flags to discourage the net drivers from trying<br>
+    to talk to the card any more.<br>
+<br>
+======================================================================*/<br>
+<br>
+static int pcnet_event(event_t event, int priority,<br>
+		       event_callback_args_t *args)<br>
+{<br>
+    dev_link_t *link = args-&gt;client_data;<br>
+    pcnet_dev_t *info = link-&gt;priv;<br>
+<br>
+    DEBUG(2, "pcnet_event(0x%06x)\n", event);<br>
+<br>
+    switch (event) {<br>
+    case CS_EVENT_CARD_REMOVAL:<br>
+	link-&gt;state &amp;= ~DEV_PRESENT;<br>
+	if (link-&gt;state &amp; DEV_CONFIG) {<br>
+	    info-&gt;dev.tbusy = 1; info-&gt;dev.start = 0;<br>
+	    link-&gt;release.expires = jiffies + HZ/20;<br>
+	    link-&gt;state |= DEV_RELEASE_PENDING;<br>
+	    add_timer(&amp;link-&gt;release);<br>
+	}<br>
+	break;<br>
+    case CS_EVENT_CARD_INSERTION:<br>
+	link-&gt;state |= DEV_PRESENT;<br>
+	pcnet_config(link);<br>
+	break;<br>
+    case CS_EVENT_PM_SUSPEND:<br>
+	link-&gt;state |= DEV_SUSPEND;<br>
+	/* Fall through... */<br>
+    case CS_EVENT_RESET_PHYSICAL:<br>
+	if (link-&gt;state &amp; DEV_CONFIG) {<br>
+	    if (link-&gt;open) {<br>
+		info-&gt;dev.tbusy = 1; info-&gt;dev.start = 0;<br>
+	    }<br>
+	    CardServices(ReleaseConfiguration, link-&gt;handle);<br>
+	}<br>
+	break;<br>
+    case CS_EVENT_PM_RESUME:<br>
+	link-&gt;state &amp;= ~DEV_SUSPEND;<br>
+	/* Fall through... */<br>
+    case CS_EVENT_CARD_RESET:<br>
+	if (link-&gt;state &amp; DEV_CONFIG) {<br>
+	    CardServices(RequestConfiguration, link-&gt;handle, &amp;link-&gt;conf);<br>
+	    if (link-&gt;open) {<br>
+		pcnet_reset_8390(&amp;info-&gt;dev);<br>
+		NS8390_init(&amp;info-&gt;dev, 1);<br>
+		info-&gt;dev.tbusy = 0; info-&gt;dev.start = 1;<br>
+	    }<br>
+	}<br>
+	break;<br>
+    }<br>
+    return 0;<br>
+} /* pcnet_event */<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void set_misc_reg(struct net_device *dev)<br>
+{<br>
+    int nic_base = dev-&gt;base_addr;<br>
+    pcnet_dev_t *info = (pcnet_dev_t *)dev;<br>
+    u_char tmp;<br>
+    <br>
+    if (info-&gt;flags &amp; HAS_MISC_REG) {<br>
+	tmp = inb_p(nic_base + PCNET_MISC) &amp; ~3;<br>
+	if (dev-&gt;if_port == 2)<br>
+	    tmp |= 1;<br>
+	if (info-&gt;flags &amp; USE_BIG_BUF)<br>
+	    tmp |= 2;<br>
+	if (info-&gt;flags &amp; HAS_IBM_MISC)<br>
+	    tmp |= 8;<br>
+	outb_p(tmp, nic_base + PCNET_MISC);<br>
+    }<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static int pcnet_open(struct net_device *dev)<br>
+{<br>
+    pcnet_dev_t *info = (pcnet_dev_t *)dev;<br>
+    dev_link_t *link;<br>
+    <br>
+    DEBUG(2, "pcnet_open('%s')\n", dev-&gt;name);<br>
+<br>
+    for (link = dev_list; link; link = link-&gt;next)<br>
+	if (link-&gt;priv == dev) break;<br>
+    if (!DEV_OK(link))<br>
+	return -ENODEV;<br>
+<br>
+    link-&gt;open++;<br>
+    MOD_INC_USE_COUNT;<br>
+<br>
+    /* For D-Link EtherFast, wait for something(?) to happen */<br>
+    if (info-&gt;flags &amp; IS_DL10019A) {<br>
+	int i;<br>
+	for (i = 0; i &lt; 20; i++) {<br>
+	    if ((inb(dev-&gt;base_addr+0x1c) &amp; 0x01) == 0) break;<br>
+	    current-&gt;state = TASK_INTERRUPTIBLE;<br>
+	    schedule_timeout(HZ/10);<br>
+	}<br>
+    }<br>
+    <br>
+    set_misc_reg(dev);<br>
+    request_irq(dev-&gt;irq, ei_interrupt, SA_SHIRQ, dev_info, dev);<br>
+    return ei_open(dev);<br>
+} /* pcnet_open */<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static int pcnet_close(struct net_device *dev)<br>
+{<br>
+    dev_link_t *link;<br>
+<br>
+    DEBUG(2, "pcnet_close('%s')\n", dev-&gt;name);<br>
+<br>
+    for (link = dev_list; link; link = link-&gt;next)<br>
+	if (link-&gt;priv == dev) break;<br>
+    if (link == NULL)<br>
+	return -ENODEV;<br>
+    free_irq(dev-&gt;irq, dev);<br>
+    <br>
+    link-&gt;open--; dev-&gt;start = 0;<br>
+    if (link-&gt;state &amp; DEV_STALE_CONFIG) {<br>
+	link-&gt;release.expires = jiffies+HZ/20;<br>
+	link-&gt;state |= DEV_RELEASE_PENDING;<br>
+	add_timer(&amp;link-&gt;release);<br>
+    }<br>
+<br>
+    MOD_DEC_USE_COUNT;<br>
+<br>
+    return 0;<br>
+} /* pcnet_close */<br>
+<br>
+/*======================================================================<br>
+<br>
+    Hard reset the card.  This used to pause for the same period that<br>
+    a 8390 reset command required, but that shouldn't be necessary.<br>
+<br>
+======================================================================*/<br>
+<br>
+static void pcnet_reset_8390(struct net_device *dev)<br>
+{<br>
+    int nic_base = dev-&gt;base_addr;<br>
+    int i;<br>
+<br>
+    ei_status.txing = ei_status.dmaing = 0;<br>
+<br>
+    outb(inb(nic_base + PCNET_RESET), nic_base + PCNET_RESET);<br>
+<br>
+    for (i = 0; i &lt; 100; i++) {<br>
+	if ((inb_p(nic_base+EN0_ISR) &amp; ENISR_RESET) != 0)<br>
+	    break;<br>
+	udelay(100L);<br>
+    }<br>
+    outb_p(ENISR_RESET, nic_base + EN0_ISR); /* Ack intr. */<br>
+    <br>
+    if (i == 100)<br>
+	printk(KERN_ERR "%s: pcnet_reset_8390() did not complete.\n",<br>
+	       dev-&gt;name);<br>
+    set_misc_reg(dev);<br>
+    <br>
+} /* pcnet_reset_8390 */<br>
+<br>
+/* ======================================================================= */<br>
+<br>
+static int set_config(struct net_device *dev, struct ifmap *map)<br>
+{<br>
+    pcnet_dev_t *info = (pcnet_dev_t *)dev;<br>
+    if ((map-&gt;port != (u_char)(-1)) &amp;&amp; (map-&gt;port != dev-&gt;if_port)) {<br>
+	if ((map-&gt;port != 0) &amp;&amp; !(info-&gt;flags &amp; HAS_MISC_REG)) {<br>
+	    printk(KERN_NOTICE "%s: transceiver selection not "<br>
+		   "implemented\n", dev-&gt;name);<br>
+	    return -EINVAL;<br>
+	}<br>
+	if ((map-&gt;port == 1) || (map-&gt;port == 2)) {<br>
+	    dev-&gt;if_port = map-&gt;port;<br>
+	    printk(KERN_INFO "%s: switched to %s port\n",<br>
+		   dev-&gt;name, if_names[dev-&gt;if_port]);<br>
+	} else<br>
+	    return -EINVAL;<br>
+    }<br>
+    return 0;<br>
+}<br>
+<br>
+/* ======================================================================= */<br>
+<br>
+static void dma_get_8390_hdr(struct net_device *dev,<br>
+			     struct e8390_pkt_hdr *hdr,<br>
+			     int ring_page)<br>
+{<br>
+    int nic_base = dev-&gt;base_addr;<br>
+<br>
+    if (ei_status.dmaing) {<br>
+	printk(KERN_NOTICE "%s: DMAing conflict in dma_block_input."<br>
+	       "[DMAstat:%1x][irqlock:%1x][intr:%ld]\n",<br>
+	       dev-&gt;name, ei_status.dmaing, ei_status.irqlock,<br>
+	       (long)dev-&gt;interrupt);<br>
+	return;<br>
+    }<br>
+    <br>
+    ei_status.dmaing |= 0x01;<br>
+    outb_p(E8390_NODMA+E8390_PAGE0+E8390_START, nic_base + PCNET_CMD);<br>
+    outb_p(sizeof(struct e8390_pkt_hdr), nic_base + EN0_RCNTLO);<br>
+    outb_p(0, nic_base + EN0_RCNTHI);<br>
+    outb_p(0, nic_base + EN0_RSARLO);		/* On page boundary */<br>
+    outb_p(ring_page, nic_base + EN0_RSARHI);<br>
+    outb_p(E8390_RREAD+E8390_START, nic_base + PCNET_CMD);<br>
+<br>
+    insw(nic_base + PCNET_DATAPORT, hdr,<br>
+	    sizeof(struct e8390_pkt_hdr)&gt;&gt;1);<br>
+    /* Fix for big endian systems */<br>
+    hdr-&gt;count = le16_to_cpu(hdr-&gt;count);<br>
+<br>
+    outb_p(ENISR_RDC, nic_base + EN0_ISR);	/* Ack intr. */<br>
+    ei_status.dmaing &amp;= ~0x01;<br>
+}<br>
+<br>
+/* ======================================================================= */<br>
+<br>
+static void dma_block_input(struct net_device *dev, int count,<br>
+			    struct sk_buff *skb, int ring_offset)<br>
+{<br>
+    int nic_base = dev-&gt;base_addr;<br>
+    int xfer_count = count;<br>
+    char *buf = skb-&gt;data;<br>
+<br>
+#ifdef PCMCIA_DEBUG<br>
+    if ((ei_debug &gt; 4) &amp;&amp; (count != 4))<br>
+	printk(KERN_DEBUG "%s: [bi=%d]\n", dev-&gt;name, count+4);<br>
+#endif<br>
+    if (ei_status.dmaing) {<br>
+	printk(KERN_NOTICE "%s: DMAing conflict in dma_block_input."<br>
+	       "[DMAstat:%1x][irqlock:%1x][intr:%ld]\n",<br>
+	       dev-&gt;name, ei_status.dmaing, ei_status.irqlock,<br>
+	       (long)dev-&gt;interrupt);<br>
+	return;<br>
+    }<br>
+    ei_status.dmaing |= 0x01;<br>
+    outb_p(E8390_NODMA+E8390_PAGE0+E8390_START, nic_base + PCNET_CMD);<br>
+    outb_p(count &amp; 0xff, nic_base + EN0_RCNTLO);<br>
+    outb_p(count &gt;&gt; 8, nic_base + EN0_RCNTHI);<br>
+    outb_p(ring_offset &amp; 0xff, nic_base + EN0_RSARLO);<br>
+    outb_p(ring_offset &gt;&gt; 8, nic_base + EN0_RSARHI);<br>
+    outb_p(E8390_RREAD+E8390_START, nic_base + PCNET_CMD);<br>
+<br>
+    insw(nic_base + PCNET_DATAPORT,buf,count&gt;&gt;1);<br>
+    if (count &amp; 0x01)<br>
+	buf[count-1] = inb(nic_base + PCNET_DATAPORT), xfer_count++;<br>
+<br>
+    /* This was for the ALPHA version only, but enough people have<br>
+       encountering problems that it is still here. */<br>
+#ifdef PCMCIA_DEBUG<br>
+    if (ei_debug &gt; 4) {		/* DMA termination address check... */<br>
+	int addr, tries = 20;<br>
+	do {<br>
+	    /* DON'T check for 'inb_p(EN0_ISR) &amp; ENISR_RDC' here<br>
+	       -- it's broken for Rx on some cards! */<br>
+	    int high = inb_p(nic_base + EN0_RSARHI);<br>
+	    int low = inb_p(nic_base + EN0_RSARLO);<br>
+	    addr = (high &lt;&lt; 8) + low;<br>
+	    if (((ring_offset + xfer_count) &amp; 0xff) == (addr &amp; 0xff))<br>
+		break;<br>
+	} while (--tries &gt; 0);<br>
+	if (tries &lt;= 0)<br>
+	    printk(KERN_NOTICE "%s: RX transfer address mismatch,"<br>
+		   "%#4.4x (expected) vs. %#4.4x (actual).\n",<br>
+		   dev-&gt;name, ring_offset + xfer_count, addr);<br>
+    }<br>
+#endif<br>
+    outb_p(ENISR_RDC, nic_base + EN0_ISR);	/* Ack intr. */<br>
+    ei_status.dmaing &amp;= ~0x01;<br>
+} /* dma_block_input */<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void dma_block_output(struct net_device *dev, int count,<br>
+			     const unsigned char *buf,<br>
+			     const int start_page)<br>
+{<br>
+    int nic_base = dev-&gt;base_addr;<br>
+    pcnet_dev_t *info = (pcnet_dev_t *)dev;<br>
+#ifdef PCMCIA_DEBUG<br>
+    int retries = 0;<br>
+#endif<br>
+    u_long dma_start;<br>
+<br>
+#ifdef PCMCIA_DEBUG<br>
+    if (ei_debug &gt; 4)<br>
+	printk(KERN_DEBUG "%s: [bo=%d]\n", dev-&gt;name, count);<br>
+#endif<br>
+<br>
+    /* Round the count up for word writes.  Do we need to do this?<br>
+       What effect will an odd byte count have on the 8390?<br>
+       I should check someday. */<br>
+    if (count &amp; 0x01)<br>
+	count++;<br>
+    if (ei_status.dmaing) {<br>
+	printk(KERN_NOTICE "%s: DMAing conflict in dma_block_output."<br>
+	       "[DMAstat:%1x][irqlock:%1x][intr:%ld]\n",<br>
+	       dev-&gt;name, ei_status.dmaing, ei_status.irqlock,<br>
+	       (long)dev-&gt;interrupt);<br>
+	return;<br>
+    }<br>
+    ei_status.dmaing |= 0x01;<br>
+    /* We should already be in page 0, but to be safe... */<br>
+    outb_p(E8390_PAGE0+E8390_START+E8390_NODMA, nic_base+PCNET_CMD);<br>
+<br>
+#ifdef PCMCIA_DEBUG<br>
+  retry:<br>
+#endif<br>
+<br>
+    outb_p(ENISR_RDC, nic_base + EN0_ISR);<br>
+<br>
+    /* Now the normal output. */<br>
+    outb_p(count &amp; 0xff, nic_base + EN0_RCNTLO);<br>
+    outb_p(count &gt;&gt; 8,   nic_base + EN0_RCNTHI);<br>
+    outb_p(0x00, nic_base + EN0_RSARLO);<br>
+    outb_p(start_page, nic_base + EN0_RSARHI);<br>
+<br>
+    outb_p(E8390_RWRITE+E8390_START, nic_base + PCNET_CMD);<br>
+    outsw(nic_base + PCNET_DATAPORT, buf, count&gt;&gt;1);<br>
+<br>
+    dma_start = jiffies;<br>
+<br>
+#ifdef PCMCIA_DEBUG<br>
+    /* This was for the ALPHA version only, but enough people have<br>
+       encountering problems that it is still here. */<br>
+    if (ei_debug &gt; 4) {	/* DMA termination address check... */<br>
+	int addr, tries = 20;<br>
+	do {<br>
+	    int high = inb_p(nic_base + EN0_RSARHI);<br>
+	    int low = inb_p(nic_base + EN0_RSARLO);<br>
+	    addr = (high &lt;&lt; 8) + low;<br>
+	    if ((start_page &lt;&lt; 8) + count == addr)<br>
+		break;<br>
+	} while (--tries &gt; 0);<br>
+	if (tries &lt;= 0) {<br>
+	    printk(KERN_NOTICE "%s: Tx packet transfer address mismatch,"<br>
+		   "%#4.4x (expected) vs. %#4.4x (actual).\n",<br>
+		   dev-&gt;name, (start_page &lt;&lt; 8) + count, addr);<br>
+	    if (retries++ == 0)<br>
+		goto retry;<br>
+	}<br>
+    }<br>
+#endif<br>
+<br>
+    while ((inb_p(nic_base + EN0_ISR) &amp; ENISR_RDC) == 0)<br>
+	if (jiffies - dma_start &gt; PCNET_RDC_TIMEOUT) {<br>
+	    printk(KERN_NOTICE "%s: timeout waiting for Tx RDC.\n",<br>
+		   dev-&gt;name);<br>
+	    pcnet_reset_8390(dev);<br>
+	    NS8390_init(dev, 1);<br>
+	    break;<br>
+	}<br>
+<br>
+    outb_p(ENISR_RDC, nic_base + EN0_ISR);	/* Ack intr. */<br>
+    if (info-&gt;flags &amp; DELAY_OUTPUT)<br>
+	udelay((long)delay_time);<br>
+    ei_status.dmaing &amp;= ~0x01;<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static int setup_dma_config(dev_link_t *link, int start_pg,<br>
+			    int stop_pg)<br>
+{<br>
+    struct net_device *dev = link-&gt;priv;<br>
+<br>
+    ei_status.tx_start_page = start_pg;<br>
+    ei_status.rx_start_page = start_pg + TX_PAGES;<br>
+    ei_status.stop_page = stop_pg;<br>
+<br>
+    /* set up block i/o functions */<br>
+    ei_status.get_8390_hdr = &amp;dma_get_8390_hdr;<br>
+    ei_status.block_input = &amp;dma_block_input;<br>
+    ei_status.block_output = &amp;dma_block_output;<br>
+<br>
+    return 0;<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void copyin(unsigned char *dest, unsigned char *src, int c)<br>
+{<br>
+    unsigned short *d = (unsigned short *) dest;<br>
+    unsigned short *s = (unsigned short *) src;<br>
+    int odd;<br>
+<br>
+    if (c &lt;= 0)<br>
+	return;<br>
+    odd = (c &amp; 01); c &gt;&gt;= 1;<br>
+<br>
+    if (c) {<br>
+	do { *d++ = readw(s++); } while (--c);<br>
+    }<br>
+    /* get last byte by fetching a word and masking */<br>
+    if (odd)<br>
+	*((unsigned char *)d) = readw(s) &amp; 0xff;<br>
+}<br>
+<br>
+static void copyout(unsigned char *dest, const unsigned char *src, int c)<br>
+{<br>
+    volatile unsigned short *d = (unsigned short *) dest;<br>
+    unsigned short *s = (unsigned short *) src;<br>
+    int odd;<br>
+<br>
+    if (c &lt;= 0)<br>
+	return;<br>
+    odd = (c &amp; 01); c &gt;&gt;= 1;<br>
+<br>
+    if (c) {<br>
+	do { writew(*s++, d++); } while (--c);<br>
+    }<br>
+    /* copy last byte doing a read-modify-write */<br>
+    if (odd)<br>
+	writew((readw(d) &amp; 0xff00) | *(u_char *)s, d);<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void shmem_get_8390_hdr(struct net_device *dev,<br>
+			       struct e8390_pkt_hdr *hdr,<br>
+			       int ring_page)<br>
+{<br>
+    void *xfer_start = (void *)(dev-&gt;rmem_start + (ring_page &lt;&lt; 8)<br>
+				- (ei_status.rx_start_page &lt;&lt; 8));<br>
+    <br>
+    copyin((void *)hdr, xfer_start, sizeof(struct e8390_pkt_hdr));<br>
+    /* Fix for big endian systems */<br>
+    hdr-&gt;count = le16_to_cpu(hdr-&gt;count);<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void shmem_block_input(struct net_device *dev, int count,<br>
+			      struct sk_buff *skb, int ring_offset)<br>
+{<br>
+    void *xfer_start = (void *)(dev-&gt;rmem_start + ring_offset<br>
+				- (ei_status.rx_start_page &lt;&lt; 8));<br>
+    char *buf = skb-&gt;data;<br>
+    <br>
+    if (xfer_start + count &gt; (void *)dev-&gt;rmem_end) {<br>
+	/* We must wrap the input move. */<br>
+	int semi_count = (void*)dev-&gt;rmem_end - xfer_start;<br>
+	copyin(buf, xfer_start, semi_count);<br>
+	buf += semi_count;<br>
+	ring_offset = ei_status.rx_start_page &lt;&lt; 8;<br>
+	xfer_start = (void *)dev-&gt;rmem_start;<br>
+	count -= semi_count;<br>
+    }<br>
+    copyin(buf, xfer_start, count);<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static void shmem_block_output(struct net_device *dev, int count,<br>
+			       const unsigned char *buf,<br>
+			       const int start_page)<br>
+{<br>
+    void *shmem = (void *)dev-&gt;mem_start + (start_page &lt;&lt; 8);<br>
+    shmem -= ei_status.tx_start_page &lt;&lt; 8;<br>
+<br>
+    if (ei_debug &gt; 4)<br>
+	printk(KERN_DEBUG "[bo=%d @ %x]\n", count, start_page);<br>
+<br>
+    copyout(shmem, buf, count);<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+static int setup_shmem_window(dev_link_t *link, int start_pg,<br>
+			      int stop_pg, int cm_offset)<br>
+{<br>
+    struct net_device *dev = link-&gt;priv;<br>
+    pcnet_dev_t *info = link-&gt;priv;<br>
+    win_req_t req;<br>
+    memreq_t mem;<br>
+    int i, window_size, offset, last_ret, last_fn;<br>
+<br>
+    window_size = (stop_pg - start_pg) &lt;&lt; 8;<br>
+    if (window_size &gt; 32 * 1024)<br>
+	window_size = 32 * 1024;<br>
+<br>
+    /* Make sure it's a power of two.  */<br>
+    while ((window_size &amp; (window_size - 1)) != 0)<br>
+	window_size += window_size &amp; ~(window_size - 1);<br>
+<br>
+    /* Allocate a memory window */<br>
+    req.Attributes = WIN_DATA_WIDTH_16|WIN_MEMORY_TYPE_CM|WIN_ENABLE;<br>
+    req.Attributes |= WIN_USE_WAIT;<br>
+    req.Base = 0; req.Size = window_size;<br>
+    req.AccessSpeed = mem_speed;<br>
+    link-&gt;win = (window_handle_t)link-&gt;handle;<br>
+    CS_CHECK(RequestWindow, &amp;link-&gt;win, &amp;req);<br>
+<br>
+    mem.CardOffset = (start_pg &lt;&lt; 8) + cm_offset;<br>
+    offset = mem.CardOffset % window_size;<br>
+    mem.CardOffset -= offset;<br>
+    mem.Page = 0;<br>
+    CS_CHECK(MapMemPage, link-&gt;win, &amp;mem);<br>
+<br>
+    /* Try scribbling on the buffer */<br>
+    info-&gt;base = ioremap(req.Base, window_size);<br>
+    for (i = 0; i &lt; (TX_PAGES&lt;&lt;8); i += 2)<br>
+	writew((i&gt;&gt;1), info-&gt;base+offset+i);<br>
+    udelay(100);<br>
+    for (i = 0; i &lt; (TX_PAGES&lt;&lt;8); i += 2)<br>
+	if (readw(info-&gt;base+offset+i) != (i&gt;&gt;1)) break;<br>
+    pcnet_reset_8390(dev);<br>
+    if (i != (TX_PAGES&lt;&lt;8)) {<br>
+	iounmap(info-&gt;base);<br>
+	CardServices(ReleaseWindow, link-&gt;win);<br>
+	info-&gt;base = NULL; link-&gt;win = NULL;<br>
+	goto failed;<br>
+    }<br>
+    <br>
+    dev-&gt;mem_start = (u_long)info-&gt;base + offset;<br>
+    dev-&gt;rmem_start = dev-&gt;mem_start + (TX_PAGES&lt;&lt;8);<br>
+    dev-&gt;mem_end = dev-&gt;rmem_end = (u_long)info-&gt;base + req.Size;<br>
+<br>
+    ei_status.tx_start_page = start_pg;<br>
+    ei_status.rx_start_page = start_pg + TX_PAGES;<br>
+    ei_status.stop_page = start_pg + ((req.Size - offset) &gt;&gt; 8);<br>
+<br>
+    /* set up block i/o functions */<br>
+    ei_status.get_8390_hdr = &amp;shmem_get_8390_hdr;<br>
+    ei_status.block_input = &amp;shmem_block_input;<br>
+    ei_status.block_output = &amp;shmem_block_output;<br>
+<br>
+    info-&gt;flags |= USE_SHMEM;<br>
+    return 0;<br>
+<br>
+cs_failed:<br>
+    cs_error(link-&gt;handle, last_fn, last_ret);<br>
+failed:<br>
+    return 1;<br>
+}<br>
+<br>
+/*====================================================================*/<br>
+<br>
+#ifdef MODULE<br>
+int init_module(void)<br>
+#else<br>
+int init_pcnet_cs(void)<br>
+#endif<br>
+{<br>
+    servinfo_t serv;<br>
+    DEBUG(0, "%s\n", version);<br>
+    CardServices(GetCardServicesInfo, &amp;serv);<br>
+    if (serv.Revision != CS_RELEASE_CODE) {<br>
+	printk(KERN_NOTICE "pcnet_cs: Card Services release "<br>
+	       "does not match!\n");<br>
+	return -1;<br>
+    }<br>
+    register_pcmcia_driver(&amp;dev_info, &amp;pcnet_attach, &amp;pcnet_detach);<br>
+    DEBUG(0, "pcnet driver registered\n" );<br>
+    return 0;<br>
+}<br>
+<br>
+//__initcall(init_pcnet_cs);<br>
+<br>
+#ifdef MODULE<br>
+void cleanup_module(void)<br>
+{<br>
+    DEBUG(0, "pcnet_cs: unloading\n");<br>
+    unregister_pcmcia_driver(&amp;dev_info);<br>
+    while (dev_list != NULL)<br>
+	pcnet_detach(dev_list);<br>
+}<br>
+#endif<br>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. Look at <a href="http://195.113.31.123/~pavel">http://195.113.31.123/~pavel</a>.  Pavel
Hi! I'm a .signature virus! Copy me into your ~/.signature, please!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0657.html">Paul Ashton: "Re: Strange kbd problems with 2.3.17 on toshiba satellite 4030cdt"</a>
<li> <b>Previous message:</b> <a href="0655.html">Pavel Machek: "ESS maestro"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
