<!-- received="Thu Sep  9 15:59:39 1999 EET DST" -->
<!-- sent="Thu, 9 Sep 1999 14:56:25 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] touch_buffer in getblk" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [patch] touch_buffer in getblk</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] touch_buffer in getblk</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Thu, 9 Sep 1999 14:56:25 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#687">[ date ]</a><a href="index.html#687">[ thread ]</a><a href="subject.html#687">[ subject ]</a><a href="author.html#687">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0688.html">roel@grobbebol.xs4all.nl: "Re: BusLogic + SMP == broke"</a>
<li> <b>Previous message:</b> <a href="0686.html">Marco Colombo: "Re: Compile problem [2.3.16]: include/linux/serialP.h"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Currently we do touch_buffer in brelse instead of in getblk. It make sense<br>
to mark the page referenced in getblk so we'll less probably enter the<br>
try_to_free_buffers path. Also it's possible to cleanup the fast-path of<br>
getblk.<br>
<p>
This patch against 2.3.17 will do that:<br>
<p>
--- 2.3.17-pre1/fs/buffer.c	Wed Sep  8 00:26:01 1999<br>
+++ buffer.c	Wed Sep  8 00:30:58 1999<br>
@@ -787,30 +787,29 @@<br>
 		atomic_set(&amp;bh-&gt;b_count, 1);<br>
 	}<br>
 	spin_unlock(&amp;free_list[isize].lock);<br>
-	if (!bh)<br>
-		goto refill;<br>
-<br>
-	/* OK, FINALLY we know that this buffer is the only one of its kind,<br>
-	 * we hold a reference (b_count&gt;0), it is unlocked, and it is clean.<br>
-	 */<br>
-	init_buffer(bh, end_buffer_io_sync, NULL);<br>
-	bh-&gt;b_dev = dev;<br>
-	bh-&gt;b_blocknr = block;<br>
-	bh-&gt;b_state = 1 &lt;&lt; BH_Mapped;<br>
-<br>
-	/* Insert the buffer into the regular lists */<br>
-	insert_into_queues(bh);<br>
-	goto out;<br>
+	if (bh)<br>
+	{<br>
+		/* OK, FINALLY we know that this buffer is the only one of<br>
+		   its kind, we hold a reference (b_count&gt;0), it is unlocked,<br>
+		   and it is clean. */<br>
+		init_buffer(bh, end_buffer_io_sync, NULL);<br>
+		bh-&gt;b_dev = dev;<br>
+		bh-&gt;b_blocknr = block;<br>
+		bh-&gt;b_state = 1 &lt;&lt; BH_Mapped;<br>
+<br>
+		/* Insert the buffer into the regular lists */<br>
+		insert_into_queues(bh);<br>
+	out:<br>
+		touch_buffer(bh);<br>
+		return bh;<br>
+	}<br>
 <br>
 	/*<br>
 	 * If we block while refilling the free list, somebody may<br>
 	 * create the buffer first ... search the hashes again.<br>
 	 */<br>
-refill:<br>
 	refill_freelist(size);<br>
 	goto repeat;<br>
-out:<br>
-	return bh;<br>
 }<br>
 <br>
 /*<br>
@@ -881,8 +880,6 @@<br>
  */<br>
 void __brelse(struct buffer_head * buf)<br>
 {<br>
-	touch_buffer(buf);<br>
-<br>
 	if (atomic_read(&amp;buf-&gt;b_count)) {<br>
 		atomic_dec(&amp;buf-&gt;b_count);<br>
 		return;<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0688.html">roel@grobbebol.xs4all.nl: "Re: BusLogic + SMP == broke"</a>
<li> <b>Previous message:</b> <a href="0686.html">Marco Colombo: "Re: Compile problem [2.3.16]: include/linux/serialP.h"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
