<!-- received="Thu Sep  9 22:32:30 1999 EET DST" -->
<!-- sent="Thu, 9 Sep 1999 21:29:28 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] longstanding chksum patch" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [patch] longstanding chksum patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] longstanding chksum patch</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Thu, 9 Sep 1999 21:29:28 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#729">[ date ]</a><a href="index.html#729">[ thread ]</a><a href="subject.html#729">[ subject ]</a><a href="author.html#729">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0730.html">Arjan van de Ven: "Re: &gt; 15,000 Simultaneous Connections"</a>
<li> <b>Previous message:</b> <a href="0728.html">Alan Cox: "Patch 2.2.13pre5"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0752.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0752.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0762.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0768.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0783.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0790.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0825.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Some month ago I pointed out that the checksum 686 can buffer overflow if<br>
the start of the buf&amp;1 is != 0.<br>
<p>
My old longstanding patch is still valid also against 2.3.17 and IMHO it's<br>
better to have a solid chksum routine than to save some CPU cycle. I don't<br>
like optimizations done at the expense of robuteness.<br>
<p>
Enlarging the unrolled-loop in the copy_and_chksym call is still a good<br>
idea IMO since the jmp will save instruction-cachelines for small buffers.<br>
<p>
--- linux/arch/i386/lib/checksum.S	1999/05/18 20:17:13	1.1.1.3<br>
+++ linux/arch/i386/lib/checksum.S	1999/05/24 01:40:00<br>
@@ -18,6 +18,8 @@<br>
  *			     handling.<br>
  *		Andi Kleen,  add zeroing on error<br>
  *                   converted to pure assembler<br>
+ *		Andrea Arcangeli, fixed a potential buffer overflow in the<br>
+ *		686 csum_partial, and some improvement in the 686 code.<br>
  *<br>
  *		This program is free software; you can redistribute it and/or<br>
  *		modify it under the terms of the GNU General Public License<br>
@@ -123,9 +125,6 @@<br>
 	movl 16(%esp),%ecx	# Function arg: int len<br>
 	movl 12(%esp),%esi	# Function arg:	const unsigned char *buf<br>
 <br>
-	testl $2, %esi         <br>
-	jnz 30f                 <br>
-10:<br>
 	movl %ecx, %edx<br>
 	movl %ecx, %ebx<br>
 	andl $0x7c, %ebx<br>
@@ -134,27 +133,9 @@<br>
 	shrl $2, %ebx  <br>
 	negl %ebx<br>
 	lea 45f(%ebx,%ebx,2), %ebx<br>
-	testl %esi, %esi<br>
+	clc<br>
 	jmp *%ebx<br>
 <br>
-	# Handle 2-byte-aligned regions<br>
-20:	addw (%esi), %ax<br>
-	lea 2(%esi), %esi<br>
-	adcl $0, %eax<br>
-	jmp 10b<br>
-<br>
-30:	subl $2, %ecx          <br>
-	ja 20b                 <br>
-	je 32f<br>
-	movzbl (%esi),%ebx	# csumming 1 byte, 2-aligned<br>
-	addl %ebx, %eax<br>
-	adcl $0, %eax<br>
-	jmp 80f<br>
-32:<br>
-	addw (%esi), %ax	# csumming 2 bytes, 2-aligned<br>
-	adcl $0, %eax<br>
-	jmp 80f<br>
-<br>
 40: <br>
 	addl -128(%esi), %eax<br>
 	adcl -124(%esi), %eax<br>
@@ -193,18 +174,20 @@<br>
 	adcl $0, %eax<br>
 	dec %ecx<br>
 	jge 40b<br>
-	movl %edx, %ecx<br>
-50:	andl $3, %ecx<br>
+50:<br>
+	testl $3, %edx<br>
 	jz 80f<br>
-<br>
-	# Handle the last 1-3 bytes without jumping<br>
-	notl %ecx		# 1-&gt;2, 2-&gt;1, 3-&gt;0, higher bits are masked<br>
-	movl $0xffffff,%ebx	# by the shll and shrl instructions<br>
-	shll $3,%ecx<br>
-	shrl %cl,%ebx<br>
-	andl -128(%esi),%ebx	# esi is 4-aligned so should be ok<br>
-	addl %ebx,%eax<br>
+	testl $2, %edx<br>
+	jz 70f<br>
+	addw -128(%esi), %ax<br>
+	lea 2(%esi), %esi<br>
 	adcl $0,%eax<br>
+70:<br>
+	testl $1, %edx<br>
+	jz 80f<br>
+	movzbl -128(%esi), %ebx<br>
+	addl %ebx, %eax<br>
+	adcl $0, %eax<br>
 80: <br>
 	popl %ebx<br>
 	popl %esi<br>
@@ -393,36 +376,44 @@<br>
 	movl ARGBASE+16(%esp),%eax	#sum<br>
 	movl %ecx, %edx  <br>
 	movl %ecx, %ebx  <br>
-	shrl $6, %ecx     <br>
-	andl $0x3c, %ebx  <br>
+	andl $0x7c, %ebx<br>
+	shrl $7, %ecx<br>
+	addl %ebx,%esi<br>
+	addl %ebx,%edi<br>
+	shrl $2, %ebx<br>
 	negl %ebx<br>
-	subl %ebx, %esi  <br>
-	subl %ebx, %edi  <br>
-	lea 3f(%ebx,%ebx), %ebx<br>
-	testl %esi, %esi <br>
+	shll $3, %ebx<br>
+	leal 3f(%ebx), %ebx<br>
+	clc<br>
 	jmp *%ebx         <br>
-1:	addl $64,%esi<br>
-	addl $64,%edi <br>
-	ROUND1(-64) ROUND(-60) ROUND(-56) ROUND(-52)	<br>
+1:<br>
+	ROUND1(-128) ROUND(-124) ROUND(-120) ROUND(-116)<br>
+	ROUND (-112) ROUND(-108) ROUND(-104) ROUND(-100)<br>
+	ROUND (-96) ROUND(-92) ROUND(-88) ROUND(-84)<br>
+	ROUND (-80) ROUND(-76) ROUND(-72)  ROUND(-68)<br>
+	ROUND (-64) ROUND(-60) ROUND(-56) ROUND(-52)	<br>
 	ROUND (-48) ROUND(-44) ROUND(-40) ROUND(-36)	<br>
 	ROUND (-32) ROUND(-28) ROUND(-24) ROUND(-20)	<br>
 	ROUND (-16) ROUND(-12) ROUND(-8)  ROUND(-4)	<br>
-3:	adcl $0,%eax<br>
+3:<br>
+	leal 128(%esi), %esi<br>
+	adcl $0,%eax<br>
+	leal 128(%edi), %edi<br>
 	dec %ecx<br>
 	jge 1b<br>
 4:      andl $3, %edx<br>
 	jz 7f<br>
 	cmpl $2, %edx<br>
 	jb 5f<br>
-SRC(	movw (%esi), %dx         )<br>
+SRC(	movw -128(%esi), %dx        )<br>
 	leal 2(%esi), %esi<br>
-DST(	movw %dx, (%edi)         )<br>
+DST(	movw %dx, -128(%edi)        )<br>
 	leal 2(%edi), %edi<br>
 	je 6f<br>
 	shll $16,%edx<br>
 5:<br>
-SRC(	movb (%esi), %dl         )<br>
-DST(	movb %dl, (%edi)         )<br>
+SRC(	movb -128(%esi), %dl        )<br>
+DST(	movb %dl, -128(%edi)         )<br>
 6:	addl %edx, %eax<br>
 	adcl $0, %eax<br>
 7:<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0730.html">Arjan van de Ven: "Re: &gt; 15,000 Simultaneous Connections"</a>
<li> <b>Previous message:</b> <a href="0728.html">Alan Cox: "Patch 2.2.13pre5"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0752.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0752.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0762.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0768.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0783.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0790.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<li> <b>Reply:</b> <a href="0825.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<!-- reply="end" -->
</ul>
</font></body>
