<!-- received="Thu Sep  9 23:24:49 1999 EET DST" -->
<!-- sent="9 Sep 1999 13:20:01 -0700" -->
<!-- name="david parsons" -->
<!-- email="o.r.c@p.e.l.l.p.o.r.t.l.a.n.d.o.r.u.s" -->
<!-- subject="Re: The other half of the patch to the fancy memory patch" -->
<!-- id="" -->
<!-- inreplyto="The other half of the patch to the fancy memory patch" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: The other half of the patch to the fancy memory patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: The other half of the patch to the fancy memory patch</h1>
<b>david parsons</b> (<a href="mailto:o.r.c@p.e.l.l.p.o.r.t.l.a.n.d.o.r.u.s"><i>o.r.c@p.e.l.l.p.o.r.t.l.a.n.d.o.r.u.s</i></a>)<br>
<i>9 Sep 1999 13:20:01 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#736">[ date ]</a><a href="index.html#736">[ thread ]</a><a href="subject.html#736">[ subject ]</a><a href="author.html#736">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0737.html">Chuck Lever: "Re: &gt; 15,000 Simultaneous Connections"</a>
<li> <b>Previous message:</b> <a href="0735.html">Oystein Viggen: "pgcc"</a>
<li> <b>Maybe in reply to:</b> <a href="0726.html">david parsons: "The other half of the patch to the fancy memory patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
In article &lt;<a href="mailto:linux.kernel.199909091740.KAA06160@pell.portland.or.us">linux.kernel.199909091740.KAA06160@pell.portland.or.us</a>&gt;,<br>
david parsons  &lt;<a href="mailto:orc@pell.portland.or.us">orc@pell.portland.or.us</a>&gt; wrote:<br>
<i>&gt;</i><br>
<i>&gt;I didn't include the differences against arch/i386/kernel/setup.c in</i><br>
<i>&gt;the patch I mailed last night.   This means that Pavel's tweak for</i><br>
<i>&gt;not applying the e820 memory map unless we read it correctly (and</i><br>
<i>&gt;the verbosity explaining what the full memory map is like) wouldn't</i><br>
<i>&gt;actually work with that patch.</i><br>
<p>
   And, for those of you who might want to actually USE this patch,<br>
   here it is again in patch(1)able format.<br>
<p>
                 ____<br>
   david parsons \bi/ I blame my general flakiness on C++<br>
                  \/<br>
<p>
<p>
<p>
<p>
--- linux-2.3.17-orig/arch/i386/kernel/setup.c	Wed Sep  8 20:19:51 1999<br>
+++ linux-2.3.17/arch/i386/kernel/setup.c	Thu Sep  9 08:16:09 1999<br>
@@ -401,18 +401,49 @@<br>
 <br>
 void __init setup_memory_region(void)<br>
 {<br>
+#define E820_DEBUG	1<br>
+#ifdef E820_DEBUG<br>
+	int i;<br>
+#endif<br>
+<br>
 	/*<br>
 	 * If we're lucky and live on a modern system, the setup code<br>
 	 * will have given us a memory map that we can use to properly<br>
 	 * set up memory.  If we aren't, we'll fake a memory map.<br>
+	 *<br>
+	 * We check to see that the memory map contains at least 2 elements<br>
+	 * before we'll use it, because the detection code in setup.S may<br>
+	 * not be perfect and most every PC known to man has two memory<br>
+	 * regions: one from 0 to 640k, and one from 1mb up.  (The IBM<br>
+	 * thinkpad 560x, for example, does not cooperate with the memory<br>
+	 * detection code.)<br>
 	 */<br>
-	if (E820_MAP_NR) {<br>
+	if (E820_MAP_NR &gt; 1) {<br>
 		/* got a memory map; copy it into a safe place.<br>
 		 */<br>
 		e820.nr_map = E820_MAP_NR;<br>
 		if (e820.nr_map &gt; E820MAX)<br>
 			e820.nr_map = E820MAX;<br>
 		memcpy(e820.map, E820_MAP, e820.nr_map * sizeof e820.map[0]);<br>
+#ifdef E820_DEBUG<br>
+		for (i=0; i &lt; e820.nr_map; i++) {<br>
+			printk("e820: %ld @ %08lx ",<br>
+				(unsigned long)(e820.map[i].size),<br>
+				(unsigned long)(e820.map[i].addr));<br>
+			switch (e820.map[i].type) {<br>
+			case E820_RAM:	printk("(usable)\n");<br>
+					break;<br>
+			case E820_RESERVED:<br>
+					printk("(reserved)\n");<br>
+					break;<br>
+			case E820_ACPI:<br>
+					printk("(ACPI data)\n");<br>
+					break;<br>
+			default:	printk("type %lu\n", e820.map[i].type);<br>
+					break;<br>
+			}<br>
+		}<br>
+#endif<br>
 	}<br>
 	else {<br>
 		/* otherwise fake a memory map; one section from 0k-&gt;640k,<br>
@@ -422,8 +453,8 @@<br>
 <br>
 		mem_size = (ALT_MEM_K &lt; EXT_MEM_K) ? EXT_MEM_K : ALT_MEM_K;<br>
 <br>
-		add_memory_region(0, LOWMEMSIZE(), 1);<br>
-		add_memory_region(HIGH_MEMORY, mem_size &lt;&lt; 10, 1);<br>
+		add_memory_region(0, LOWMEMSIZE(), E820_RAM);<br>
+		add_memory_region(HIGH_MEMORY, mem_size &lt;&lt; 10, E820_RAM);<br>
   	}<br>
 } /* setup_memory_region */<br>
 <br>
@@ -503,7 +534,7 @@<br>
 					 */<br>
 					e820.nr_map = 0;<br>
 					usermem = 1;<br>
-					add_memory_region(0, LOWMEMSIZE(), 1);<br>
+					add_memory_region(0, LOWMEMSIZE(), E820_RAM);<br>
 				}<br>
 				mem_size = memparse(from+4, &amp;from);<br>
 				if (*from == '@')<br>
@@ -512,7 +543,7 @@<br>
 					start_at = HIGH_MEMORY;<br>
 					mem_size -= HIGH_MEMORY;<br>
 				}<br>
-				add_memory_region(start_at, mem_size, 1);<br>
+				add_memory_region(start_at, mem_size, E820_RAM);<br>
 			}<br>
 		}<br>
 		c = *(from++);<br>
@@ -531,7 +562,7 @@<br>
 	memory_end = 0;<br>
 	for (i=0; i &lt; e820.nr_map; i++) {<br>
 		/* RAM? */<br>
-		if (e820.map[i].type == 1) {<br>
+		if (e820.map[i].type == E820_RAM) {<br>
 			unsigned long end = e820.map[i].addr + e820.map[i].size;<br>
 <br>
 			if (end &gt; memory_end)<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0737.html">Chuck Lever: "Re: &gt; 15,000 Simultaneous Connections"</a>
<li> <b>Previous message:</b> <a href="0735.html">Oystein Viggen: "pgcc"</a>
<li> <b>Maybe in reply to:</b> <a href="0726.html">david parsons: "The other half of the patch to the fancy memory patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
