<!-- received="Fri Sep 10 02:09:22 1999 EET DST" -->
<!-- sent="Thu,  9 Sep 1999 16:50:05 -0600 (MDT)" -->
<!-- name="Vincent Stemen" -->
<!-- email="vstemen@crel.com" -->
<!-- subject="PS/2 mouse detection patch" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: PS/2 mouse detection patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PS/2 mouse detection patch</h1>
<b>Vincent Stemen</b> (<a href="mailto:vstemen@crel.com"><i>vstemen@crel.com</i></a>)<br>
<i>Thu,  9 Sep 1999 16:50:05 -0600 (MDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#763">[ date ]</a><a href="index.html#763">[ thread ]</a><a href="subject.html#763">[ subject ]</a><a href="author.html#763">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0764.html">Andrea Arcangeli: "Re: [Problem] predictable IP ID"</a>
<li> <b>Previous message:</b> <a href="0762.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--abVV5Burlk<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Hi.<br>
<p>
I discovered that the new kernels now always load the psaux driver<br>
whether there is a mouse present or not when psaux is turned on.  This<br>
caused the auto mouse configuration boot scripts I had written to<br>
break when I upgraded from the 2.0.36 kernel.  Also, when the device<br>
gets accessed and there is no PS/2 mouse present, the keyboard locks<br>
up.<br>
<p>
I saw some comments in the kernel mailing list archives that this was<br>
apparently done because some people wanted to be able to hot plug a<br>
PS/2 mouse in without rebooting.  The problem is, now there is no way<br>
to auto configure the mouse from boot up init scripts.<br>
<p>
Attatched below is a patch I created that allows one to choose in the<br>
kernel configuration whether to require the PS/2 mouse to be present<br>
to load the psaux driver.  I am in hopes this will be put in the<br>
official kernels.  The patch was done against version 2.2.12.<br>
<p>
Thanks.<br>
Vincent<br>
<p>
<p>
--abVV5Burlk<br>
Content-Type: text/plain<br>
Content-Description: psaux patch<br>
Content-Disposition: inline;<br>
	filename="linux.psaux.patch"<br>
Content-Transfer-Encoding: 7bit<br>
<p>
diff -urN linux.orig/Documentation/Configure.help linux/Documentation/Configure.help<br>
--- linux.orig/Documentation/Configure.help	Wed Aug 25 18:29:45 1999<br>
+++ linux/Documentation/Configure.help	Thu Sep  9 14:36:27 1999<br>
@@ -8426,6 +8426,15 @@<br>
   <a href="ftp://metalab.unc.edu/pub/Linux/system/Daemons">ftp://metalab.unc.edu/pub/Linux/system/Daemons</a>) solves this<br>
   problem, or you can get the "mconv" utility also from metalab.<br>
 <br>
+Initialize the psaux driver even if a PS/2 mouse is not connected<br>
+CONFIG_ALWAYS_INITIALIZE_PSAUX<br>
+  If set to yes, the PS/2 auxiliary device driver will be loaded if<br>
+  there is a PS/2 Mouse Port on your computer whether there is a mouse<br>
+  connected to it or not.  Normally this is set to no.  This way boot up<br>
+  init scripts can attempt to auto-configure the mouse, assuming there<br>
+  is no PS/2 mouse if there is no psaux device.  If set to no the PS/2<br>
+  mouse must be plugged in at boot time to enable it.<br>
+  <br>
 C&amp;T 82C710 mouse port support (as on TI Travelmate)<br>
 CONFIG_82C710_MOUSE<br>
   This is a certain kind of PS/2 mouse used on the TI Travelmate. If<br>
diff -urN linux.orig/drivers/char/Config.in linux/drivers/char/Config.in<br>
--- linux.orig/drivers/char/Config.in	Wed Aug 25 18:29:46 1999<br>
+++ linux/drivers/char/Config.in	Wed Sep  8 21:42:13 1999<br>
@@ -69,6 +69,9 @@<br>
 	tristate 'Logitech busmouse support' CONFIG_BUSMOUSE<br>
 	tristate 'Microsoft busmouse support' CONFIG_MS_BUSMOUSE<br>
 	bool 'PS/2 mouse (aka "auxiliary device") support' CONFIG_PSMOUSE<br>
+	if [ "$CONFIG_PSMOUSE" = "y" ]; then<br>
+	  bool 'Initialize the psaux driver even if a PS/2 mouse is not connected' CONFIG_ALWAYS_INITIALIZE_PSAUX<br>
+	fi<br>
 	tristate 'C&amp;T 82C710 mouse port support (as on TI Travelmate)' CONFIG_82C710_MOUSE<br>
 	tristate 'PC110 digitizer pad support' CONFIG_PC110_PAD<br>
 	endmenu<br>
diff -urN linux.orig/drivers/char/pc_keyb.c linux/drivers/char/pc_keyb.c<br>
--- linux.orig/drivers/char/pc_keyb.c	Mon Aug  9 13:04:39 1999<br>
+++ linux/drivers/char/pc_keyb.c	Thu Sep  9 15:26:45 1999<br>
@@ -13,6 +13,10 @@<br>
  * Code fixes to handle mouse ACKs properly.<br>
  * C. Scott Ananian &lt;<a href="mailto:cananian@alumni.princeton.edu">cananian@alumni.princeton.edu</a>&gt; 1999-01-29.<br>
  *<br>
+ * Added #ifndef CONFIG_ALWAYS_INITIALIZE_PSAUX code to optionally load<br>
+ * the psaux driver if a PS/2 mouse is not connected.<br>
+ * 1999-09-09  Vincent Stemen  &lt;<a href="mailto:vstemen@crel.com">vstemen@crel.com</a>&gt;<br>
+ *<br>
  */<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
@@ -968,6 +972,13 @@<br>
 {<br>
 	if (!detect_auxiliary_port())<br>
 		return -EIO;<br>
+<br>
+#ifndef CONFIG_ALWAYS_INITIALIZE_PSAUX<br>
+	if (aux_device_present != 0xaa) <br>
+                return -EIO;<br>
+        else<br>
+                printk(KERN_INFO "PS/2 auxiliary pointing device detected -- driver installed.\n");<br>
+#endif<br>
 <br>
 	misc_register(&amp;psaux_mouse);<br>
 	queue = (struct aux_queue *) kmalloc(sizeof(*queue), GFP_KERNEL);<br>
<p>
--abVV5Burlk--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0764.html">Andrea Arcangeli: "Re: [Problem] predictable IP ID"</a>
<li> <b>Previous message:</b> <a href="0762.html">Artur Skawina: "Re: [patch] longstanding chksum patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
