<!-- received="Fri Sep 10 20:49:00 1999 EET DST" -->
<!-- sent="Fri, 10 Sep 1999 13:39:33 -0400" -->
<!-- name="Thomas Gschwendtner" -->
<!-- email="tgs@bu.edu" -->
<!-- subject="bug in linux 2.2.10 and 2.2.12 ip or network layer" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: bug in linux 2.2.10 and 2.2.12 ip or network layer</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>bug in linux 2.2.10 and 2.2.12 ip or network layer</h1>
<b>Thomas Gschwendtner</b> (<a href="mailto:tgs@bu.edu"><i>tgs@bu.edu</i></a>)<br>
<i>Fri, 10 Sep 1999 13:39:33 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#892">[ date ]</a><a href="index.html#892">[ thread ]</a><a href="subject.html#892">[ subject ]</a><a href="author.html#892">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0893.html">: "Do newer kernels conflict with cdrecord?"</a>
<li> <b>Previous message:</b> <a href="0891.html">nathan.zook@amd.com: "RE: version mismatch in modules--Permanent solution?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0906.html">Richard Maier: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0906.html">Richard Maier: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0907.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0915.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0920.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0921.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------3C6B958F2A2076FEC872E02E<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Hi all,<br>
<p>
I discovered a bug in the linux network subsystem. Either the IP layer<br>
or (more probably) the network layer drops packets occasionally. I<br>
traced the packets using tcpdump and there are occasionally gaps in the<br>
TCP sequence numbers, i.e. packets are missing. This is not a problem of<br>
the BPF, because:<br>
1. I run tcpdump also at the remote host and there are the same packets<br>
missing and<br>
2. the remote host returns duplicated acks.<br>
I traced the packets which are passed fromm the TCP to the IP layer in<br>
tcp_transmit_skb. No packet was missing there. The bug does not occur<br>
when I use the loopback interface. (That's why I assume that the bug is<br>
in the network layer and not in the IP.)<br>
<p>
My setup is as follows:<br>
<p>
I have two PPro 200 connected by a 100 Mbit ethernet and DECchip<br>
ethernet cards (CONFIG_DEC_ELCP). I have a simple server which sends<br>
data to a simple client. I attached the source code. Usage:<br>
<p>
server &lt;port&gt; &lt;number of bytes to send to client&gt;<br>
client &lt;host name&gt; &lt;port&gt; &lt;number of clients&gt; &lt;log file name&gt;<br>
<p>
The client actually forks &lt;number of clients&gt; clients, i.e. you will<br>
have &lt;number of clients&gt; simultaneously connections. The log file is for<br>
internal use only, so don't ask, just give some file name.<br>
I did not see the bug with 1, 2 or 3 clients, but it occurred always,<br>
when I had 5 clients, i.e. 5 simultaneously TCP flows. So it seems to be<br>
a race between flows. I tested 2.2.10 and 2.2.12. The bug occurrs in<br>
both versions.<br>
<p>
Can anyone comment on this? Has anyone else seen this bug?<br>
<p>
Thank you.<br>
<p>
tgs<br>
<p>
PS:<br>
Here is the output of ver_linux<br>
-- Versions installed: (if some fields are empty or looks<br>
-- unusual then possibly you have very old versions)<br>
Linux RIVERWAY.BU.EDU 2.2.12 #5 Fri Sep 10 12:52:52 EDT 1999 i686<br>
unknown<br>
Kernel modules         2.1.121<br>
Gnu C                  egcs-2.91.66<br>
Binutils               2.9.1.0.23<br>
Linux C Library        2.1.1<br>
Dynamic linker         ldd (GNU libc) 2.1.1<br>
Procps                 2.0.2<br>
Mount                  2.9o<br>
Net-tools              1.51<br>
Console-tools          1999.03.02<br>
Sh-utils               1.16<br>
--------------3C6B958F2A2076FEC872E02E<br>
Content-Type: text/plain; charset=us-ascii;<br>
 name="client.c"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline;<br>
 filename="client.c"<br>
<p>
#include &lt;stdio.h&gt; <br>
#include &lt;stdlib.h&gt;<br>
#include &lt;string.h&gt; <br>
#include &lt;netdb.h&gt; <br>
#include &lt;sys/time.h&gt; <br>
#include &lt;sys/types.h&gt; <br>
#include &lt;sys/socket.h&gt; <br>
#include &lt;netinet/in.h&gt; <br>
#include &lt;unistd.h&gt;<br>
#include &lt;sys/wait.h&gt;<br>
<p>
#define RECBUFSIZE 1024      /* Reception buffer size             */ <br>
#define TIMEBUFSIZE 20<br>
<p>
int main(int argc, char *argv[]) <br>
{ <br>
  long  sizetransf;           /* How many bytes to receive        */ <br>
  char sizechar[80] = {0};         /* How many bytes in a string       */ <br>
  char sizeofsize; <br>
  int  sock;                 /* Server connection socket         */ <br>
  struct sockaddr_in serv;   /* Server connection socket address */ <br>
  struct hostent *as;        /* Server IP address structure      */ <br>
<p>
  char recbuf[RECBUFSIZE];   /* Reception buffer                 */ <br>
  int  reccount, i;             /* Amount of data received          */ <br>
  double startclock, endclock; /* Transmission time variables      */ <br>
  struct timeval tv; <br>
  struct timezone tz; <br>
	FILE *fd;<br>
	char timebuf[TIMEBUFSIZE];<br>
  int pid, clients;<br>
	<br>
  if (argc &lt; 5) <br>
  { <br>
    fprintf(stderr, "%s &lt;machine&gt; &lt;port&gt; &lt;number of clients&gt; &lt;log_file_name&gt;\n", argv[0]); <br>
    exit(1); <br>
  } <br>
<p>
  if (!(as = gethostbyname(argv[1]))) /* Server IP address      */ <br>
  { <br>
    herror("gethostbyname() error"); <br>
    exit(1); <br>
  } <br>
<p>
	if ((fd = fopen(argv[4], "w+")) == NULL )<br>
	{ <br>
		perror("Cannot open log file");<br>
		exit(1);<br>
	}<br>
	<br>
	if ((clients = atoi(argv[3])) == 0)<br>
	{<br>
		fprintf(stderr, "Number of clients can not be zero.\n");<br>
		exit(1);<br>
	}<br>
	<br>
  /* Build server address structure                             */ <br>
  serv.sin_family = AF_INET; <br>
  serv.sin_port   = htons(atoi(argv[2])); <br>
  memcpy((char *) &amp;serv.sin_addr, as-&gt;h_addr_list[0], as-&gt;h_length); <br>
<p>
	for (i = 0; i &lt; clients; i++)<br>
	{<br>
		pid = fork();<br>
		<br>
		if (pid == 0)<br>
			break;<br>
	}<br>
	<br>
	if (pid != 0)<br>
	{<br>
		fclose(fd);<br>
		<br>
		for (i = 0; i &lt; clients; i++)<br>
			wait(NULL);<br>
		<br>
		endclock = 0;<br>
		<br>
		if ((fd = fopen(argv[4], "r")) == NULL )<br>
		{ <br>
			perror("Cannot open log file");<br>
			exit(1);<br>
		}<br>
	<br>
		while (fgets(timebuf, TIMEBUFSIZE, fd))<br>
		  endclock += atof(timebuf);<br>
		endclock /= clients;<br>
		<br>
		printf("Transfer time: %f\n", endclock);<br>
		fclose(fd);<br>
		exit(0);<br>
	}<br>
	<br>
  fflush(NULL); <br>
<p>
  gettimeofday(&amp;tv, &amp;tz); /* Computes time to 1/100th second \/ */ <br>
  startclock = (double)tv.tv_sec + (double)tv.tv_usec / 1000000; <br>
<p>
  reccount = 0; <br>
<p>
  /* Open socket */ <br>
  if ((sock = socket(AF_INET, SOCK_STREAM, 0)) &lt; 0) <br>
  { <br>
    perror("Cannot open a socket"); <br>
    exit(1); <br>
  } <br>
<p>
  /* Connect to server */ <br>
  if (connect(sock, (struct sockaddr *) &amp;serv, sizeof(serv)) == -1) <br>
  { <br>
    perror("Cannot connect to the server"); <br>
    exit(1); <br>
  } <br>
<p>
  /* Gets the amount of bytes to receive.  Protocol: the amount as a */ <br>
  /* string that follows the size of that string (for portability). */ <br>
  recv(sock, (char *) &amp;sizeofsize, sizeof(sizeofsize), 0); <br>
  printf("Size of transfere size received: %u\n", (int)sizeofsize);<br>
  recv(sock, sizechar, sizeofsize, 0); <br>
  sizetransf = atoi(sizechar); <br>
<p>
  printf("Transfere size received: %lu\n", sizetransf);<br>
  <br>
  if (sizetransf &gt; 0) <br>
  { <br>
    while ( reccount &lt; sizetransf )<br>
      reccount += recv(sock, recbuf, RECBUFSIZE, 0); <br>
  } <br>
  else <br>
  { <br>
    fprintf(stderr, "Invalid data length"); <br>
    exit(1); <br>
  } <br>
<p>
  close(sock); /* Closes the connection */ <br>
<p>
  gettimeofday(&amp;tv, &amp;tz); /* Computes time in milli seconds */ <br>
  endclock =  (double)tv.tv_sec + (double)tv.tv_usec / 1000000; <br>
<p>
  printf(" %u bytes received\n", reccount);<br>
  printf(" Starttime: %.3f\n", startclock);<br>
  printf(" Endtime:   %.3f\n", endclock); <br>
	<br>
	endclock -= startclock;<br>
	fprintf(fd, "%f\n", endclock);<br>
	fclose(fd);<br>
	<br>
	exit(0);<br>
}<br>
<p>
<p>
--------------3C6B958F2A2076FEC872E02E<br>
Content-Type: text/plain; charset=us-ascii;<br>
 name="server.c"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline;<br>
 filename="server.c"<br>
<p>
<p>
#include &lt;stdio.h&gt; <br>
#include &lt;stdlib.h&gt; <br>
#include &lt;unistd.h&gt; <br>
#include &lt;signal.h&gt; <br>
#include &lt;netdb.h&gt; <br>
#include &lt;time.h&gt; <br>
#include &lt;sys/types.h&gt; <br>
#include &lt;sys/time.h&gt; <br>
#include &lt;linux/socket.h&gt; <br>
#include &lt;sys/wait.h&gt; <br>
#include &lt;sys/resource.h&gt; <br>
#include &lt;netinet/in.h&gt; <br>
<p>
#define EMBUFSIZE   20000     /* Emission buffer size              */ <br>
<p>
void EndChild(int sig); <br>
void Service(int sock, int nof); <br>
<p>
char embuf[EMBUFSIZE];       /* Emission buffer                   */ <br>
long sizetransf;             /* How many bytes to send to clients */ <br>
char sizetransfchar[20]; <br>
int main(int argc, char *argv[]) <br>
{ <br>
  int  sock, a_sock;       /* Listening socket; service socket  */ <br>
  struct sockaddr_in serv; /* Socket address                    */ <br>
  int  lg;                 /* Socket address size               */ <br>
  char nom[80];            /* Local host name                   */ <br>
  int  pid, i, port; <br>
<p>
  if (argc != 3) <br>
  { <br>
    fprintf(stderr, "%s &lt;server port&gt; &lt;sizetransf&gt;\n", argv[0]); <br>
    exit(1); <br>
  } <br>
<p>
  port = atoi(argv[1]);<br>
  <br>
  sizetransf = atoi(argv[2]); <br>
  if (sizetransf &lt;= 0) <br>
  { <br>
    fprintf(stderr, "Invalid transfer size: %s\n", argv[2]); <br>
    exit(1); <br>
  } <br>
  else <br>
    strcpy(sizetransfchar, argv[2]); <br>
  <br>
  /* Initializes the pseudo-random number generator             */ <br>
  srand((unsigned int)time(NULL) / getpid()); <br>
<p>
  /* Fill in the emission buffer with some random sequence      */ <br>
  for (i=0; i &lt; EMBUFSIZE; i++) <br>
    embuf[i] = rand() % 256; <br>
<p>
  /* Open listening socket                                      */ <br>
  if ((sock = socket(AF_INET, SOCK_STREAM, 0)) &lt; 0) <br>
  { <br>
    perror("Cannot open a socket"); <br>
    exit(1); <br>
  }<br>
  <br>
  /* Build listening socket address structure                             */ <br>
  serv.sin_family      = AF_INET;           /* IP domain                  */ <br>
  serv.sin_addr.s_addr = htonl(INADDR_ANY); /* Multiples addresses        */ <br>
  serv.sin_port        = htons(port);     /* fixed port number          */ <br>
<p>
  /* Bind listening socket                                                */ <br>
  if (bind(sock, (struct sockaddr *) &amp;serv, sizeof(serv)) == -1) <br>
  { <br>
    perror("Cannot bind the socket"); <br>
    exit(1); <br>
  } <br>
  gethostname(nom, 80); <br>
<p>
  /* Launch SIGCHLD handler                                               */ <br>
  signal(SIGCHLD, (void (*)())EndChild); <br>
<p>
  /* Launch connection queue                                              */ <br>
  listen(sock, 100);         /* 100 clients max                      */ <br>
<p>
  while (1)                  /* Server loop                                */ <br>
  { <br>
    lg = sizeof(serv); <br>
    <br>
    do <br>
      a_sock = accept(sock, (struct sockaddr *) &amp;serv, &amp;lg); <br>
    while (a_sock == -1); <br>
<p>
    pid = fork(); <br>
    if (pid == 0) <br>
    {                     /* Child process                              */ <br>
      if (close(sock) &lt; 0)      /* Close the listening socket                 */ <br>
      {<br>
        perror("Error closing listening socket");<br>
        exit(1);<br>
      }<br>
<p>
      Service(a_sock, i);  /* Start the service                          */ <br>
    } <br>
    else <br>
    {                     /* Parent process                             */ <br>
      if (close(a_sock) &lt; 0)    /* Close the service socket                   */ <br>
      {<br>
        perror("Error closing service socket");<br>
        exit(1);<br>
      }<br>
    } <br>
  }<br>
} <br>
<p>
/* ------------------------------------------------------------------------ */ <br>
/*  Detects and processes a child process actual termination.               */ <br>
/* ------------------------------------------------------------------------ */ <br>
void EndChild(int sig) <br>
{ <br>
  while (wait3(NULL, WNOHANG, NULL) &gt; 0);     /* We don't want zombies    */ <br>
  signal(SIGCHLD, (void (*)())EndChild);      /* Relaunch SIGCHLD handler */ <br>
} <br>
<p>
/* ------------------------------------------------------------------------ */ <br>
/*  Service function                                                        */ <br>
/*  The server just sends &lt;sizetransf&gt; bytes and closes the connection.     */ <br>
/* ------------------------------------------------------------------------ */ <br>
void Service(int sock, int nof) <br>
{ <br>
  char sizeofsize;           /* Size of that string         */ <br>
  long  sendcount = 0, length = EMBUFSIZE; <br>
  int j; <br>
<p>
  /* Send transfer size.  Protocol: the size as a string that follows */ <br>
  /* the size of that string (for portability). */ <br>
  sizeofsize = strlen(sizetransfchar); <br>
  if (send(sock, (char *) &amp;sizeofsize, sizeof(sizeofsize), 0) == -1)<br>
  {<br>
    perror("send size of transfer size");<br>
    exit(1);<br>
  } <br>
  if (send(sock, sizetransfchar, sizeofsize, 0) == -1) <br>
  {<br>
    perror("send transfer size");<br>
    exit(1);<br>
  } <br>
  <br>
  srand(nof);<br>
<p>
  /* Send data in length chunks */ <br>
  while(sendcount &lt; sizetransf ) <br>
  {<br>
    length = 1 + (int)((float)EMBUFSIZE * rand() / (RAND_MAX + 1.0));<br>
    if (sizetransf - sendcount &lt; length)<br>
      length = sizetransf - sendcount;<br>
    <br>
    j = send(sock, embuf, length, 0); <br>
    if (j == -1)<br>
    {<br>
      perror("send data");<br>
      exit(1);<br>
    } <br>
    <br>
    sendcount += j;<br>
  }<br>
<p>
  if (close(sock) &lt; 0)      /* Close the server socket                 */ <br>
  {<br>
    perror("Error closing server socket");<br>
    exit(1);<br>
  }<br>
  exit(0); <br>
}<br>
<p>
--------------3C6B958F2A2076FEC872E02E--<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0893.html">: "Do newer kernels conflict with cdrecord?"</a>
<li> <b>Previous message:</b> <a href="0891.html">nathan.zook@amd.com: "RE: version mismatch in modules--Permanent solution?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0906.html">Richard Maier: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0906.html">Richard Maier: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0907.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0915.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0920.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<li> <b>Reply:</b> <a href="0921.html">Thomas Gschwendtner: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<!-- reply="end" -->
</ul>
</font></body>
