<!-- received="Sat Sep 11 01:32:36 1999 EET DST" -->
<!-- sent="Fri, 10 Sep 1999 18:29:33 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@pobox.com" -->
<!-- subject="[patch] pci probing" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [patch] pci probing</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] pci probing</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@pobox.com"><i>jgarzik@pobox.com</i></a>)<br>
<i>Fri, 10 Sep 1999 18:29:33 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#938">[ date ]</a><a href="index.html#938">[ thread ]</a><a href="subject.html#938">[ subject ]</a><a href="author.html#938">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0939.html">David Hinds: "Re: Integration of pcnet_cs into drivers/pcmcia"</a>
<li> <b>Previous message:</b> <a href="0937.html">Richard B. Johnson: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0948.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0948.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0961.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0963.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0975.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------BE8D44F8C9555BB8F8EA530E<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Linus?<br>
<p>
Have you left the office yet?  ;-)<br>
<p>
PCI probing in drivers really sucks.  The attached patch against 2.3.18<br>
is small, self-contained, and should be incredibly valuable to PCI<br>
driver writers.  I myself have duplicated this code in no less than<br>
_four_ drivers.<br>
<p>
My patch adds a PCI probing function which takes an array of PCI ids<br>
(typically __initdata tables in a driver), and probes for each in turn. <br>
It calls a callback function to do the actual registration work.  The<br>
architecture is very flexible, and should be useful to most people<br>
supporting drivers with more than one chipset, or more than one board.<br>
<p>
Can we sneak this small, totally-zero-impact, easy-to-review, tested<br>
patch in?  ;-)<br>
<p>
Regards,<br>
<p>
	Jeff<br>
<p>
<p>
<p>
<p>
<pre>
-- 
Custom driver development	|    Never worry about theory as long
Open source programming		|    as the machinery does what it's
				|    supposed to do.  -- R. A. Heinlein
--------------BE8D44F8C9555BB8F8EA530E
Content-Type: text/plain; charset=us-ascii;
 name="patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch"
<p>
--- include/linux/pci.h.orig	Fri Sep 10 18:04:27 1999
+++ include/linux/pci.h	Fri Sep 10 18:23:33 1999
@@ -1598,5 +1598,24 @@
 
 void pci_fixup_device(int pass, struct pci_dev *dev);
 
+
+/*
+ * semi-automated pci probing for drivers
+ *
+ * callback should return &gt;= 0 on success (continue probing), or
+ * negative value on error (stop probing)
+ */
+struct pci_probe_entry {
+	void *drvr_data;
+	unsigned short vendor;
+	unsigned short device;
+};
+typedef int (*pci_probe_callback) (struct pci_dev *dev, int match_num,
+				   void *drvr_data);
+int pci_driver_probe (struct pci_probe_entry *list, size_t list_len,
+		      int one_match_only, pci_probe_callback cb,
+		      void *drvr_data);
+
+
 #endif /* __KERNEL__ */
 #endif /* LINUX_PCI_H */
--- drivers/pci/pci.c.orig	Fri Sep 10 18:04:40 1999
+++ drivers/pci/pci.c	Fri Sep 10 18:22:34 1999
@@ -114,6 +114,51 @@
 
 
 /*
+ * pci_driver_probe
+ *
+ * Probe for a list of PCI ids, calling a callback function for
+ * each successful match.
+ *
+ * Returns number of matches (&gt;= 0), or negative on error.
+ */
+
+int pci_driver_probe (struct pci_probe_entry *list, size_t list_len,
+                      int one_match_only, pci_probe_callback cb,
+                      void *drvr_data)
+{
+	size_t i, matches = 0;
+	int rc;
+	struct pci_dev *dev;
+	struct pci_probe_entry *ent;
+
+	if (!list || !cb)
+		return -1;
+
+	ent = list;
+	for (i = 0; i &lt; list_len; i++) {
+		dev = pci_find_device (ent-&gt;vendor, ent-&gt;device, NULL);
+		while (dev) {
+			rc = (* cb) (dev, matches, drvr_data);
+			if (rc &lt; 0)
+				return rc;
+
+			if (one_match_only &amp;&amp; matches)
+				return matches;
+
+			matches++;
+			dev = pci_find_device (ent-&gt;vendor, ent-&gt;device, dev);
+		}
+
+		ent++;
+	}
+
+	return matches;
+}
+
+
+
+
+/*
  *  For given resource region of given device, return the resource
  *  region of parent bus the given region is contained in or where
  *  it should be allocated from.
<p>
--------------BE8D44F8C9555BB8F8EA530E--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0939.html">David Hinds: "Re: Integration of pcnet_cs into drivers/pcmcia"</a>
<li> <b>Previous message:</b> <a href="0937.html">Richard B. Johnson: "Re: bug in linux 2.2.10 and 2.2.12 ip or network layer"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0948.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0948.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0961.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0963.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<li> <b>Reply:</b> <a href="0975.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<!-- reply="end" -->
</ul>
</font></body>
