<!-- received="Sat Sep 11 04:21:47 1999 EET DST" -->
<!-- sent="Fri, 10 Sep 1999 21:14:00 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@pobox.com" -->
<!-- subject="Re: [patch] pci probing" -->
<!-- id="" -->
<!-- inreplyto="[patch] pci probing" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: [patch] pci probing</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [patch] pci probing</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@pobox.com"><i>jgarzik@pobox.com</i></a>)<br>
<i>Fri, 10 Sep 1999 21:14:00 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#961">[ date ]</a><a href="index.html#961">[ thread ]</a><a href="subject.html#961">[ subject ]</a><a href="author.html#961">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0962.html">Alan Cox: "Re: [patch] pci probing"</a>
<li> <b>Previous message:</b> <a href="0960.html">Christopher Horn: "Re: SNA"</a>
<li> <b>Maybe in reply to:</b> <a href="0938.html">Jeff Garzik: "[patch] pci probing"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0963.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------8208F7F3385CD006A625B8DD<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Alan Cox wrote:<br>
<i>&gt; </i><br>
<i>&gt; &gt; Can you elaborate on what my patch lacks?  My patch seems much more</i><br>
<i>&gt; &gt; flexible than Don's method used in tulip.c and 3c59x.c at least.  In</i><br>
<i>&gt; &gt; fact if you rip out all the net-driver-specific stuff from struct</i><br>
<i>&gt; &gt; pci_id_info, his method looks a lot like mine (without a couple</i><br>
<i>&gt; &gt; features).</i><br>
<i>&gt; </i><br>
<i>&gt; Have a look on cesdis.gsfc.nasa.gov:/pub/linux/drivers/v2.3/</i><br>
<i>&gt; </i><br>
<i>&gt; The pci scan code in that does pci scans but also handles stuff like checking</i><br>
<i>&gt; latency and correcting it when needed</i><br>
<p>
Thanks.<br>
<p>
Besides the obvious net-centric code, his code was only more flexible<br>
such that there was a per-entry callback.  My flexibility came from<br>
being able to specify probe order, per-entry and per-probe data pointers<br>
(dev_data, drvr_data), and matching a limited number of devices.<br>
<p>
What do you think of this merge of Donald's code, attached?  Most of the<br>
PCI_COMMAND stuff is net-driver-specific and absent in my patch, as it<br>
is not applicable to general use.<br>
<p>
Regards,<br>
<p>
	Jeff<br>
<p>
<p>
<p>
<p>
<pre>
-- 
Custom driver development	|    Never worry about theory as long
Open source programming		|    as the machinery does what it's
				|    supposed to do.  -- R. A. Heinlein
--------------8208F7F3385CD006A625B8DD
Content-Type: text/plain; charset=us-ascii;
 name="patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch"
<p>
--- include/linux/pci.h.orig	Fri Sep 10 18:04:27 1999
+++ include/linux/pci.h	Fri Sep 10 20:55:46 1999
@@ -1598,5 +1598,45 @@
 
 void pci_fixup_device(int pass, struct pci_dev *dev);
 
+
+/*
+ * pci probing for drivers
+ *
+ * callback should return &gt;= 0 on success (continue probing), or
+ * negative value on error (stop probing)
+ */
+
+enum {
+	PCI_PR_NO_ACPI_WAKE	= (1 &lt;&lt; 0), /* disable ACPI wakeup */
+	PCI_PR_SET_MASTER	= (1 &lt;&lt; 1), /* set bus mastering */
+};
+
+struct pci_probe_entry;
+typedef int (*pci_probe_callback) (struct pci_dev *dev,
+				   const struct pci_probe_entry *ent,
+				   int match_num,
+				   void *drvr_data);
+
+struct pci_probe_entry {
+	unsigned short vendor;	/* vendor id, PCI_ANY_ID, or 0 for last entry */
+	unsigned short device;	/* device id, PCI_ANY_ID, or 0 for last entry */
+
+	pci_probe_callback cb;
+	void *dev_data;		/* driver-private, entry-specific data */
+
+	u32 flags;		/* PCI_PR_xxx flags, above */
+	u32 check_region_mask;	/* set bit(x) for check_region(resource[x]) */
+
+	unsigned short subsys_vendor, subsys_vendor_mask; /* =0,0 to ignore */
+	unsigned short subsys_device, subsys_device_mask; /* =0,0 to ignore */
+	unsigned char revision, revision_mask; /* =0,0 to ignore */
+
+	u8 min_pci_latency;	/* =0 to not check/set minimum PCI latency */
+};
+
+int pci_driver_probe (struct pci_probe_entry *list, size_t match_limit,
+		      void *drvr_data);
+
+
 #endif /* __KERNEL__ */
 #endif /* LINUX_PCI_H */
--- drivers/pci/pci.c.orig	Fri Sep 10 18:04:40 1999
+++ drivers/pci/pci.c	Fri Sep 10 21:06:22 1999
@@ -113,6 +113,9 @@
 }
 
 
+
+
+
 /*
  *  For given resource region of given device, return the resource
  *  region of parent bus the given region is contained in or where
@@ -148,6 +151,137 @@
 }
 
 
+/* returns 1 if matched, 0 if not */
+static inline int pci_probe_device_matched (u8 rev, const struct pci_dev *dev,
+				            const struct pci_probe_entry *ent)
+{
+	if ((rev &amp; ent-&gt;revision_mask) != ent-&gt;revision) goto not_matched;
+
+	if ((dev-&gt;subsystem_vendor &amp; ent-&gt;subsys_vendor_mask) !=
+	    ent-&gt;subsys_vendor) goto not_matched;
+
+	if ((dev-&gt;subsystem_device &amp; ent-&gt;subsys_device_mask) !=
+	    ent-&gt;subsys_device) goto not_matched;
+
+	return 1;
+
+not_matched:
+	return 0;
+}
+
+
+
+/* returns negative on error */
+static int pci_probe_do_match (size_t match_num, struct pci_dev *dev,
+			       const struct pci_probe_entry *ent,
+			       void *drvr_data)
+{
+	int rc = 0;
+
+	printk (KERN_DEBUG "Matched PCI device %s\n", dev-&gt;name);
+
+#if 0
+	if (! (ent-&gt;flags &amp; PCI_PR_NO_ACPI_WAKE))
+		acpi_wake (dev);
+#endif
+
+	if (ent-&gt;flags &amp; PCI_PR_SET_MASTER)
+		pci_set_master (dev);
+
+	if (ent-&gt;min_pci_latency &gt; 0) {
+		u8 pci_latency;
+
+		pci_read_config_byte(dev, PCI_LATENCY_TIMER, &amp;pci_latency);
+		if (pci_latency &lt; ent-&gt;min_pci_latency) {
+			printk(KERN_INFO "  PCI latency timer (CFLT) is "
+			       "unreasonably low at %d.  Setting to %d.\n",
+			       pci_latency, ent-&gt;min_pci_latency);
+			pci_write_config_byte(dev, PCI_LATENCY_TIMER,
+					      ent-&gt;min_pci_latency);
+		}
+	}
+
+	if (ent-&gt;check_region_mask) {
+		int i, rc;
+		unsigned long n;
+		struct resource *res;
+
+		for (i = 0; i &lt; DEVICE_COUNT_RESOURCE; i++) {
+			if (! (ent-&gt;check_region_mask &amp; (1 &lt;&lt; i)))
+				continue;
+
+			n = dev-&gt;resource[i].end - dev-&gt;resource[i].start + 1;
+
+			if (dev-&gt;resource[i].flags &amp; IORESOURCE_IO) {
+				res = &amp;ioport_resource;
+			} else {
+				res = &amp;iomem_resource;
+			}
+
+			rc = __check_region (res, dev-&gt;resource[i].start, n);
+			if (rc)
+				return rc;
+		}
+	}
+
+	if (ent-&gt;cb)
+		rc = (* ent-&gt;cb) (dev, ent, match_num, drvr_data);
+
+	return rc;
+}
+
+
+
+/*
+ * pci_driver_probe
+ *
+ * Probe for a list of PCI ids, calling a callback function for
+ * each successful match.
+ *
+ * Returns number of matches (&gt;= 0), or negative on error.
+ */
+
+int pci_driver_probe (struct pci_probe_entry *list, size_t match_limit,
+		      void *drvr_data)
+{
+	struct pci_dev *dev;
+	struct pci_probe_entry *ent;
+	size_t matches = 0;
+	int rc;
+	u8 rev;
+
+	if (!list)
+		return -ENODEV;
+
+	ent = list;
+	while (ent-&gt;vendor &amp;&amp; ent-&gt;device) {
+		dev = pci_find_device (ent-&gt;vendor, ent-&gt;device, NULL);
+		while (dev) {
+			pci_read_config_byte (dev, PCI_REVISION_ID, &amp;rev);
+
+			if (pci_probe_device_matched (rev, dev, ent)) {
+				rc = pci_probe_do_match (matches, dev,
+							 ent, drvr_data);
+				if (rc &lt; 0)
+					return rc;
+
+				matches++;
+
+				if (match_limit &amp;&amp; match_limit == matches)
+					return matches;
+			}
+
+			dev = pci_find_device (ent-&gt;vendor, ent-&gt;device, dev);
+		}
+
+		ent++;
+	}
+
+	return matches;
+}
+
+
+
 /*
  * This interrupt-safe spinlock protects all accesses to PCI
  * configuration space.
@@ -203,6 +337,8 @@
 		pci_write_config_byte(dev, PCI_LATENCY_TIMER, 64);
 	}
 }
+
+
 
 /*
  * Assign new address to PCI resource.  We hope our resource information
<p>
--------------8208F7F3385CD006A625B8DD--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0962.html">Alan Cox: "Re: [patch] pci probing"</a>
<li> <b>Previous message:</b> <a href="0960.html">Christopher Horn: "Re: SNA"</a>
<li> <b>Maybe in reply to:</b> <a href="0938.html">Jeff Garzik: "[patch] pci probing"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0963.html">Jeff Garzik: "Re: [patch] pci probing"</a>
<!-- reply="end" -->
</ul>
</font></body>
