<!-- received="Sat Sep 11 12:36:54 1999 EET DST" -->
<!-- sent="Sat, 11 Sep 1999 11:24:00 +0200 (METDST)" -->
<!-- name="Richard Guenther" -->
<!-- email="zxmpm11@student.uni-tuebingen.de" -->
<!-- subject="[PATCH] support for ISAPnP code with ne2000 network driver" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] support for ISAPnP code with ne2000 network driver</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] support for ISAPnP code with ne2000 network driver</h1>
<b>Richard Guenther</b> (<a href="mailto:zxmpm11@student.uni-tuebingen.de"><i>zxmpm11@student.uni-tuebingen.de</i></a>)<br>
<i>Sat, 11 Sep 1999 11:24:00 +0200 (METDST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#996">[ date ]</a><a href="index.html#996">[ thread ]</a><a href="subject.html#996">[ subject ]</a><a href="author.html#996">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0997.html">Manfred Spraul: "2.3.18-ac1: double_lock() moved into &lt;include/linux/dcache.h&gt;"</a>
<li> <b>Previous message:</b> <a href="0995.html">Dietmar Stein: "Kernel oops (2)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
Attached is a patch to support initializing a ISAPnP ne2k clone<br>
with the ne.c driver. Unfortunately, deactivating the card at<br>
module unload seems to be impossible (or at least hard) due to<br>
a lack of a private field in struct net_dev. At least it works<br>
for me, but probably other ID's have to be added to the isapnp<br>
card list.<br>
<p>
Richard.<br>
<p>
<pre>
--
Richard Guenther &lt;<a href="mailto:richard.guenther@student.uni-tuebingen.de">richard.guenther@student.uni-tuebingen.de</a>&gt;
PGP: 2E829319 - 2F 83 FC 93 E9 E4 19 E2 93 7A 32 42 45 37 23 57
WWW: <a href="http://www.anatom.uni-tuebingen.de/~richi/">http://www.anatom.uni-tuebingen.de/~richi/</a>
<p>
<p>
--- linux-2.3.16/drivers/net/ne.c.original	Fri Sep 10 21:27:46 1999
+++ linux-2.3.16/drivers/net/ne.c	Fri Sep 10 23:04:23 1999
@@ -28,7 +28,8 @@
     <a href="mailto:rjohnson@analogic.com">rjohnson@analogic.com</a> : Changed init order so an interrupt will only
     occur after memory is allocated for dev-&gt;priv. Deallocated memory
     last in cleanup_modue()
-
+    Richard Guenther    : Added support for ISAPnP cards
+    
 */
 
 /* Routines for the NatSemi-based designs (NE[12]000). */
@@ -43,6 +44,7 @@
 #include &lt;linux/sched.h&gt;
 #include &lt;linux/errno.h&gt;
 #include &lt;linux/pci.h&gt;
+#include &lt;linux/isapnp.h&gt;
 #include &lt;linux/init.h&gt;
 #include &lt;linux/delay.h&gt;
 #include &lt;asm/system.h&gt;
@@ -90,6 +92,13 @@
 static int probe_pci = 1;
 #endif
 
+static struct { unsigned short vendor, function; char *name; }
+isapnp_clone_list[] __initdata = {
+	{ISAPNP_VENDOR('E','D','I'), ISAPNP_FUNCTION(0x0216),		"NN NE2000" },
+	{ISAPNP_VENDOR('P','N','P'), ISAPNP_FUNCTION(0x80d6),		"Generic PNP" },
+	{0,}
+};
+
 #ifdef SUPPORT_NE_BAD_CLONES
 /* A list of bad clones that we none-the-less recognize. */
 static struct { const char *name8, *name16; unsigned char SAprefix[4];}
@@ -128,6 +137,7 @@
 
 int ne_probe(struct net_device *dev);
 static int ne_probe1(struct net_device *dev, int ioaddr);
+static int ne_probe_isapnp(struct net_device *dev);
 #ifdef CONFIG_PCI
 static int ne_probe_pci(struct net_device *dev);
 #endif
@@ -193,6 +203,10 @@
 		return 0;
 #endif
 
+	/* Then look for any installed ISAPnP clones */
+	if (isapnp_present() &amp;&amp; (ne_probe_isapnp(dev) == 0))
+		return 0;
+
 #ifndef MODULE
 	/* Last resort. The semi-risky ISA auto-probe. */
 	for (base_addr = 0; netcard_portlist[base_addr] != 0; base_addr++) {
@@ -242,6 +256,45 @@
 	return -ENODEV;
 }
 #endif  /* CONFIG_PCI */
+
+static int __init ne_probe_isapnp(struct net_device *dev)
+{
+	int i;
+	
+	for (i = 0; isapnp_clone_list[i].vendor != 0; i++) {
+		struct pci_dev *idev = NULL;
+
+		while ((idev = isapnp_find_dev(NULL,
+					       isapnp_clone_list[i].vendor,
+					       isapnp_clone_list[i].function,
+					       idev))) {
+			/* Avoid already found cards from previous calls */
+			if (idev-&gt;prepare(idev))
+				continue;
+			if (idev-&gt;activate(idev))
+				continue;
+			pci_irq_line = idev-&gt;irq_resource[0].start;
+			/* if no irq, search for next */
+			if (!pci_irq_line)
+				continue;
+			/* found it */
+			if (ne_probe1(dev, idev-&gt;resource[0].start) != 0) {	/* Shouldn't happen. */
+				printk(KERN_ERR "ne.c: Probe of ISAPnP card at %#lx failed.\n",
+				       idev-&gt;resource[0].start);
+				return -ENXIO;
+			}
+			break;
+		}
+		if (!idev)
+			continue;
+		printk(KERN_INFO "ne.c: ISAPnP reports %s at i/o %#lx, irq %d.\n",
+				isapnp_clone_list[i].name,
+				dev-&gt;base_addr, dev-&gt;irq);
+		return 0;
+	}
+
+	return -ENODEV;
+}
 
 static int __init ne_probe1(struct net_device *dev, int ioaddr)
 {
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0997.html">Manfred Spraul: "2.3.18-ac1: double_lock() moved into &lt;include/linux/dcache.h&gt;"</a>
<li> <b>Previous message:</b> <a href="0995.html">Dietmar Stein: "Kernel oops (2)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
