<!-- received="Sat Sep 11 17:49:28 1999 EET DST" -->
<!-- sent="Sat, 11 Sep 1999 16:46:23 +0200 (METDST)" -->
<!-- name="Richard Guenther" -->
<!-- email="zxmpm11@student.uni-tuebingen.de" -->
<!-- subject="[PATCH][RFC] support for MODULE_PARAM as kernel commandline" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH][RFC] support for MODULE_PARAM as kernel commandline</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH][RFC] support for MODULE_PARAM as kernel commandline</h1>
<b>Richard Guenther</b> (<a href="mailto:zxmpm11@student.uni-tuebingen.de"><i>zxmpm11@student.uni-tuebingen.de</i></a>)<br>
<i>Sat, 11 Sep 1999 16:46:23 +0200 (METDST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1030">[ date ]</a><a href="index.html#1030">[ thread ]</a><a href="subject.html#1030">[ subject ]</a><a href="author.html#1030">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1031.html">Jens Axboe: "Re: 2.2.13-pre6"</a>
<li> <b>Previous message:</b> <a href="1029.html">Khimenko Victor: "Re: 64 bit OS [Q]"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
The following patch transforms MODULE_PARAM declarations<br>
to appropriate __setup() functions that are called for<br>
the build-in drivers to get their parameters set up from<br>
the kernel command line.<br>
I'm using this for isapnp to make it not steal my soundcard<br>
irq.<br>
<p>
Any comments (apart from misformatted code :) and of course<br>
missing 's' handling,... )<br>
<p>
Richard.<br>
<p>
<pre>
--
Richard Guenther &lt;<a href="mailto:richard.guenther@student.uni-tuebingen.de">richard.guenther@student.uni-tuebingen.de</a>&gt;
PGP: 2E829319 - 2F 83 FC 93 E9 E4 19 E2 93 7A 32 42 45 37 23 57
WWW: <a href="http://www.anatom.uni-tuebingen.de/~richi/">http://www.anatom.uni-tuebingen.de/~richi/</a>
<p>
--- linux-2.3.16/lib/Makefile.original	Sat Sep 11 15:45:57 1999
+++ linux-2.3.16/lib/Makefile	Sat Sep 11 16:29:13 1999
@@ -7,6 +7,6 @@
 #
 
 L_TARGET := lib.a
-L_OBJS   := errno.o ctype.o string.o vsprintf.o
+L_OBJS   := errno.o ctype.o string.o vsprintf.o parse.o
 
 include $(TOPDIR)/Rules.make
--- linux-2.3.16/lib/parse.c.original	Sat Sep 11 16:28:05 1999
+++ linux-2.3.16/lib/parse.c	Sat Sep 11 16:14:50 1999
@@ -0,0 +1,65 @@
+/* parameter parse routine for transparent MODULE_PARAM -&gt; kernel command
+ * line conversion.
+ * dumb first version
+ * 
+ * (c) Richard Guenther &lt;<a href="mailto:richard.guenther@student.uni-tuebingen.de">richard.guenther@student.uni-tuebingen.de</a>&gt;
+ */
+#include &lt;linux/kernel.h&gt;
+#include &lt;linux/ctype.h&gt;
+
+/* parse module parameters like insmod */
+int parse_parameters(void *var, char *type, char *str)
+{
+  char *p, t;
+  long min, max, val, cnt;
+
+  p = type;
+  if (isdigit(*p)) {
+    min = simple_strtoul(p, &amp;p, 0);
+    if (*p == '-')
+      max = simple_strtoul(p+1, &amp;p, 0);
+    else
+      max = min;
+  } else
+    min = max = 1;
+  t = *p;
+
+  p = str;
+  cnt = 0;
+  do {
+    if (*p == ',') {
+      p++;
+      cnt++;
+      continue;
+    }
+    switch (t) {
+    case 'b':
+      val = simple_strtol(p, &amp;p, 0);
+      ((char *)var)[cnt] = (char)val;
+      break;
+    case 'h':
+      val = simple_strtol(p, &amp;p, 0);
+      ((short *)var)[cnt] = (short)val;
+      break;
+    case 'i':
+      val = simple_strtol(p, &amp;p, 0);
+      ((int *)var)[cnt] = (int)val;
+      break;
+    case 'l':
+      val = simple_strtol(p, &amp;p, 0);
+      ((long *)var)[cnt] = (long)val;
+      break;
+    case 's':
+      printk(KERN_INFO "umm, s type parameter not implemented\n");
+      break;
+    default:
+      printk(KERN_INFO "error in parsing arguments \"%s\" using format %s\n", str, type);
+      return 0;
+    }
+    if (*p == ',')
+      p++;
+    cnt++;
+  } while (*p &amp;&amp; cnt &lt; max);
+
+  return 1;
+}
--- linux-2.3.16/include/linux/module.h.original	Sat Sep 11 15:04:03 1999
+++ linux-2.3.16/include/linux/module.h	Sat Sep 11 16:08:09 1999
@@ -8,6 +8,7 @@
 #define _LINUX_MODULE_H
 
 #include &lt;linux/config.h&gt;
+#include &lt;linux/init.h&gt;
 
 #ifdef __GENKSYMS__
 #  define _set_ver(sym) sym
@@ -207,11 +208,17 @@
 #endif
 
 #else /* MODULE */
-
+extern int parse_parameters(void *var, char *type, char *str);
 #define MODULE_AUTHOR(name)
 #define MODULE_DESCRIPTION(desc)
 #define MODULE_SUPPORTED_DEVICE(name)
-#define MODULE_PARM(var,type)
+#define MODULE_PARM(var,type) \
+static char *modparm##var##_setup_type __initdata = type;\
+static int __init modparm##var##_setup(char *str)\
+{\
+  return parse_parameters(var, modparm##var##_setup_type, str);\
+}\
+__setup(#var "=", modparm##var##_setup);
 #define MODULE_PARM_DESC(var,desc)
 
 #ifndef __GENKSYMS__
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1031.html">Jens Axboe: "Re: 2.2.13-pre6"</a>
<li> <b>Previous message:</b> <a href="1029.html">Khimenko Victor: "Re: 64 bit OS [Q]"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
