<!-- received="Sat Sep 11 19:09:53 1999 EET DST" -->
<!-- sent="Sat, 11 Sep 1999 17:44:46 +0200" -->
<!-- name="Robert H. de Vries" -->
<!-- email="rhdv@rhdv.cistron.nl" -->
<!-- subject="[PATCH] 2.3.18ac1 APM as module" -->
<!-- id="99091118004800.00753@calvin" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] 2.3.18ac1 APM as module</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.3.18ac1 APM as module</h1>
<b>Robert H. de Vries</b> (<a href="mailto:rhdv@rhdv.cistron.nl"><i>rhdv@rhdv.cistron.nl</i></a>)<br>
<i>Sat, 11 Sep 1999 17:44:46 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1043">[ date ]</a><a href="index.html#1043">[ thread ]</a><a href="subject.html#1043">[ subject ]</a><a href="author.html#1043">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1044.html">Linus Torvalds: "Re: [patch] smp tlb flushing"</a>
<li> <b>Previous message:</b> <a href="1042.html">Benno Senoner: "Re: low-latency benchmarks: excellent results of RTC clock + SIGIO notification, audio-latency now down to 2.1ms!"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--Boundary-=_nWlrBbmQBhCDarzOwKkYHIDdqSCD<br>
Content-Type: text/plain<br>
Content-Transfer-Encoding: 8bit<br>
<p>
Currently APM does not compile when configured as a module. Simply #ifdeffing<br>
out the offending code makes the module compile, but then it doesn't load. The<br>
missing symbols have been added to the symbol list. See attached patch.<br>
<p>
When testing this patch I found out that when it is loaded as a module, not<br>
many APM functions work. For instance power off on shutdown only works when it<br>
is compiled into the kernel. So at some point I was wondering why it is<br>
possible to compile it as a module when so many things don't work in that<br>
situation? If the answer to that question is that indeed APM should not be<br>
compilable as a module, then the patch is much simpler:<br>
tristate -&gt; bool on line 105 of arch/i386/config.in<br>
<p>
	Robert<br>
<pre>
-- 
Robert de Vries
<a href="mailto:rhdv@rhdv.cistron.nl">rhdv@rhdv.cistron.nl</a>
<p>
--Boundary-=_nWlrBbmQBhCDarzOwKkYHIDdqSCD
Content-Type: text/x-c;
  name="apm-2.3.18ac1.patch"
Content-Transfer-Encoding: 8bit
Content-Description: APM module patch
Content-Disposition: attachment; filename="apm-2.3.18ac1.patch"
<p>
--- linux-2.3.18ac1-vanilla/kernel/ksyms.c	Sat Sep 11 14:34:31 1999
+++ linux-2.3.18ac1-devt/kernel/ksyms.c	Sat Sep 11 16:21:31 1999
@@ -112,6 +112,7 @@
 EXPORT_SYMBOL(find_vma);
 EXPORT_SYMBOL(get_unmapped_area);
 EXPORT_SYMBOL(init_mm);
+EXPORT_SYMBOL(check_pgt_cache);
 
 /* filesystem internal functions */
 EXPORT_SYMBOL(in_group_p);
--- linux-2.3.18ac1-vanilla/arch/i386/kernel/apm.c	Sat Sep 11 14:34:24 1999
+++ linux-2.3.18ac1-devt/arch/i386/kernel/apm.c	Sat Sep 11 15:55:15 1999
@@ -1404,6 +1404,8 @@
 	return 0;
 }
 
+#ifndef MODULE
+
 static int __init apm_setup(char *str)
 {
 	int	invert;
@@ -1428,6 +1430,8 @@
 }
 
 __setup("apm=", apm_setup);
+
+#endif /* !MODULE */
 
 /*
  * Just start the APM thread. We do NOT want to do APM BIOS
--- linux-2.3.18ac1-vanilla/arch/i386/kernel/i386_ksyms.c	Sat Sep 11 14:34:24 1999
+++ linux-2.3.18ac1-devt/arch/i386/kernel/i386_ksyms.c	Sat Sep 11 17:43:11 1999
@@ -8,6 +8,7 @@
 #include &lt;linux/in6.h&gt;
 #include &lt;linux/interrupt.h&gt;
 #include &lt;linux/smp_lock.h&gt;
+#include &lt;linux/apm_bios.h&gt;
 
 #include &lt;asm/semaphore.h&gt;
 #include &lt;asm/processor.h&gt;
@@ -18,9 +19,12 @@
 #include &lt;asm/delay.h&gt;
 #include &lt;asm/irq.h&gt;
 #include &lt;asm/mmx.h&gt;
+#include &lt;asm/desc.h&gt;
 
 extern void dump_thread(struct pt_regs *, struct user *);
 extern int dump_fpu(elf_fpregset_t *);
+extern unsigned long get_cmos_time(void);
+extern int hlt_counter;
 
 #if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_HD) || defined(CONFIG_BLK_DEV_IDE_MODULE) || defined(CONFIG_BLK_DEV_HD_MODULE)
 extern struct drive_info_struct drive_info;
@@ -73,6 +77,12 @@
 EXPORT_SYMBOL(__generic_copy_from_user);
 EXPORT_SYMBOL(__generic_copy_to_user);
 EXPORT_SYMBOL(strlen_user);
+
+/* needed for APM */
+EXPORT_SYMBOL(get_cmos_time);
+EXPORT_SYMBOL(apm_bios_info);
+EXPORT_SYMBOL(hlt_counter);
+EXPORT_SYMBOL(gdt);
 
 #ifdef CONFIG_X86_USE_3DNOW
 EXPORT_SYMBOL(_mmx_memcpy);
<p>
--Boundary-=_nWlrBbmQBhCDarzOwKkYHIDdqSCD--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1044.html">Linus Torvalds: "Re: [patch] smp tlb flushing"</a>
<li> <b>Previous message:</b> <a href="1042.html">Benno Senoner: "Re: low-latency benchmarks: excellent results of RTC clock + SIGIO notification, audio-latency now down to 2.1ms!"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
