<!-- received="Sat Sep 11 21:35:12 1999 EET DST" -->
<!-- sent="Sat, 11 Sep 1999 19:22:16 +0100" -->
<!-- name="Nick Holloway" -->
<!-- email="alfie@alfie.demon.co.uk" -->
<!-- subject="Patch for 2.3.18 to ignore bogus APM error codes" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: Patch for 2.3.18 to ignore bogus APM error codes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Patch for 2.3.18 to ignore bogus APM error codes</h1>
<b>Nick Holloway</b> (<a href="mailto:alfie@alfie.demon.co.uk"><i>alfie@alfie.demon.co.uk</i></a>)<br>
<i>Sat, 11 Sep 1999 19:22:16 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1062">[ date ]</a><a href="index.html#1062">[ thread ]</a><a href="subject.html#1062">[ subject ]</a><a href="author.html#1062">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1063.html">Jan Kara: "Bug in __bforget()?"</a>
<li> <b>Previous message:</b> <a href="1061.html">Larry McVoy: "Re: linux threads vs. solaris threads"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--cNdxnHkX5QqsyA0e<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
I have an aging ThinkPad 755C, which has a broken APM BIOS.  When it<br>
blanks or unblanks the screen, the message "unknown error code 0x53"<br>
is reported.<br>
<p>
To work around the fact that the APM BIOS reported an error, but the<br>
operation works, the contents of eax (which is supposed to hold the error<br>
code) is compared with the supplied value of eax.  If they are identical,<br>
then the error indication is ignored.<br>
<p>
I have only added the behaviour to apm_bios_call_simple, as in my case,<br>
it is only set_power_state calls that are affected.<br>
<p>
The patch adds a new config option CONFIG_APM_IGNORE_BOGUS_ERROR to enable<br>
this behaviour, to ensure that it doesn't impact anyone but those that<br>
need it.<br>
<p>
<pre>
-- 
 `O O'  | Home: <a href="mailto:Nick.Holloway@alfie.demon.co.uk">Nick.Holloway@alfie.demon.co.uk</a>  <a href="http://www.alfie.demon.co.uk/">http://www.alfie.demon.co.uk/</a>
// ^ \\ | Work: <a href="mailto:Nick.Holloway@parallax.co.uk">Nick.Holloway@parallax.co.uk</a>
<p>
--cNdxnHkX5QqsyA0e
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="apm-2.3.diff"
<p>
--- linux-2.3/arch/i386/kernel/apm.c~	Sat Sep 11 13:13:56 1999
+++ linux-2.3/arch/i386/kernel/apm.c	Sat Sep 11 13:17:38 1999
@@ -496,6 +496,11 @@
 	}
 	APM_DO_RESTORE_SEGS;
 	__restore_flags(flags);
+#ifdef CONFIG_APM_IGNORE_BOGUS_ERROR
+	/* Ignore error reported by APM BIOS if error code was set */
+	if (error &amp;&amp; *eax == eax_in)
+		return 0;
+#endif
 	return error;
 }
 
--- linux-2.3/arch/i386/config.in~	Sat Sep 11 13:19:36 1999
+++ linux-2.3/arch/i386/config.in	Sat Sep 11 13:18:35 1999
@@ -106,6 +106,7 @@
   bool '   Ignore multiple suspend/resume cycles' CONFIG_APM_IGNORE_SUSPEND_BOUNCE
   bool '   RTC stores time in GMT' CONFIG_APM_RTC_IS_GMT
   bool '   Allow interrupts during APM BIOS calls' CONFIG_APM_ALLOW_INTS
+  bool '   Ignore bogus error returns' CONFIG_APM_IGNORE_BOGUS_ERROR
 fi
 
 endmenu
--- linux-2.3/Documentation/Configure.help~	Sat Sep 11 13:54:29 1999
+++ linux-2.3/Documentation/Configure.help	Sat Sep 11 13:10:50 1999
@@ -9350,6 +9350,14 @@
   many of the newer IBM Thinkpads.  If you experience hangs when you
   suspend, try setting this to Y.  Otherwise, say N.
 
+Ignore bogus error returns from APM BIOS.
+CONFIG_APM_IGNORE_BOGUS_ERROR
+  This option is necessary on the IBM Thinkpad 755C (and maybe others).
+  Without this, you get "unknown error code 0x53" reported on suspend and
+  display blank.  If you say Y here, when the call to the BIOS reports an
+  error, but no error code has been set, then the BIOS call is considered
+  to have been successful.
+
 Watchdog Timer Support 
 CONFIG_WATCHDOG
   If you say Y here (and to one of the following options) and create a
<p>
--cNdxnHkX5QqsyA0e--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1063.html">Jan Kara: "Bug in __bforget()?"</a>
<li> <b>Previous message:</b> <a href="1061.html">Larry McVoy: "Re: linux threads vs. solaris threads"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
