<!-- received="Sat Sep 11 21:44:50 1999 EET DST" -->
<!-- sent="Sat, 11 Sep 1999 20:28:17 +0200" -->
<!-- name="Jan Kara" -->
<!-- email="jack@atrey.karlin.mff.cuni.cz" -->
<!-- subject="Re: Quota speedup in 2.2.12 and bugfix" -->
<!-- id="" -->
<!-- inreplyto="19990911201802.60965@atrey.karlin.mff.cuni.cz" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: Quota speedup in 2.2.12 and bugfix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Quota speedup in 2.2.12 and bugfix</h1>
<b>Jan Kara</b> (<a href="mailto:jack@atrey.karlin.mff.cuni.cz"><i>jack@atrey.karlin.mff.cuni.cz</i></a>)<br>
<i>Sat, 11 Sep 1999 20:28:17 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1064">[ date ]</a><a href="index.html#1064">[ thread ]</a><a href="subject.html#1064">[ subject ]</a><a href="author.html#1064">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1065.html">Bruno Semrau: "Problem with Acard SCSI and kernel 2.2.x"</a>
<li> <b>Previous message:</b> <a href="1063.html">Jan Kara: "Bug in __bforget()?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--OKacYhQ+x31HxR33<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
<i>&gt;   Hello.</i><br>
<i>&gt; </i><br>
<i>&gt;   I'm sending you a small patch to quota code in 2.2.12. It does two things:</i><br>
<i>&gt; </i><br>
<i>&gt; 1) Fixes possible race in sync_dquots() where we could end up writing invalidated quota.</i><br>
<i>&gt; 2) Speeds up quotaoff - currently when inode cache was full of inodes with quota pointers</i><br>
<i>&gt;    set, which is likely when quota enabled on root, quotaoff could take a few seconds</i><br>
<i>&gt;    which is unpleasant. So I made a bit more finegrained detection of blocking when we</i><br>
<i>&gt;    remove references from inodes and so we don't have to restart so often.</i><br>
<i>&gt; </i><br>
<i>&gt;    The patch is attached.</i><br>
<i>&gt; </i><br>
<i>&gt; 							Bye</i><br>
<i>&gt; 								Honza.</i><br>
 Oops. The patch was NOT attached... So I'll retry ;-).<br>
<p>
<p>
--OKacYhQ+x31HxR33<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="quota-fix-2.2.12-2a.diff"<br>
<p>
--- linux/fs/dquot.c	Fri Aug 20 12:38:58 1999<br>
+++ linux/fs/dquot.c	Sat Sep 11 16:52:38 1999<br>
@@ -97,6 +97,9 @@<br>
 static struct wait_queue *dquot_wait = (struct wait_queue *)NULL,<br>
                          *update_wait = (struct wait_queue *)NULL;<br>
 <br>
+void dqput(struct dquot *);<br>
+static struct dquot *dqduplicate(struct dquot *);<br>
+<br>
 static inline char is_enabled(struct vfsmount *vfsmnt, short type)<br>
 {<br>
 	switch (type) {<br>
@@ -390,7 +393,7 @@<br>
 <br>
 int sync_dquots(kdev_t dev, short type)<br>
 {<br>
-	struct dquot *dquot, *next;<br>
+	struct dquot *dquot, *next, *ddquot;<br>
 	int need_restart;<br>
 <br>
 restart:<br>
@@ -407,9 +410,11 @@<br>
 		if (!(dquot-&gt;dq_flags &amp; (DQ_LOCKED | DQ_MOD)))<br>
 			continue;<br>
 <br>
-		wait_on_dquot(dquot);<br>
-		if (dquot-&gt;dq_flags &amp; DQ_MOD)<br>
-			write_dquot(dquot);<br>
+		if ((ddquot = dqduplicate(dquot)) == NODQUOT)<br>
+			continue;<br>
+		if (ddquot-&gt;dq_flags &amp; DQ_MOD)<br>
+			write_dquot(ddquot);<br>
+		dqput(ddquot);<br>
 		/* Set the flag for another pass. */<br>
 		need_restart = 1;<br>
 	}<br>
@@ -424,6 +429,7 @@<br>
 	return(0);<br>
 }<br>
 <br>
+/* NOTE: If you change this function please check whether dqput_blocks() works right... */<br>
 void dqput(struct dquot *dquot)<br>
 {<br>
 	if (!dquot)<br>
@@ -688,6 +694,16 @@<br>
 	}<br>
 }<br>
 <br>
+/* Return 0 if dqput() won't block (note that 1 doesn't necessarily mean blocking) */<br>
+static inline int dqput_blocks(struct dquot *dquot)<br>
+{<br>
+	if (dquot-&gt;dq_flags &amp; DQ_LOCKED)<br>
+		return 1;<br>
+	if (dquot-&gt;dq_count == 1)<br>
+		return 1;<br>
+	return 0;<br>
+}<br>
+<br>
 static int reset_inode_dquot_ptrs(struct inode *inode, short type)<br>
 {<br>
 	struct dquot *dquot = inode-&gt;i_dquot[type];<br>
@@ -701,13 +717,16 @@<br>
 	}<br>
 	inode-&gt;i_flags &amp;= ~S_QUOTA;<br>
 put_it:<br>
-	if (dquot != NODQUOT) {<br>
-		spin_unlock(&amp;inode_lock);	/* We may block so drop the lock... */<br>
-		dqput(dquot);<br>
-		spin_lock(&amp;inode_lock);		/* And capture lock again */<br>
-		/* we may have blocked ... */<br>
-		return 1;<br>
-	}<br>
+	if (dquot != NODQUOT)<br>
+		if (dqput_blocks(dquot)) {<br>
+			spin_unlock(&amp;inode_lock);	/* We may block so drop the lock... */<br>
+			dqput(dquot);<br>
+			spin_lock(&amp;inode_lock);		/* And capture lock again */<br>
+			/* we may have blocked ... */<br>
+			return 1;<br>
+		}<br>
+		else<br>
+			dqput(dquot);	/* dqput() won't block so we can hold locks... */<br>
 	return 0;<br>
 }<br>
 <br>
<p>
--OKacYhQ+x31HxR33--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1065.html">Bruno Semrau: "Problem with Acard SCSI and kernel 2.2.x"</a>
<li> <b>Previous message:</b> <a href="1063.html">Jan Kara: "Bug in __bforget()?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
