<!-- received="Sat Sep 11 21:59:58 1999 EET DST" -->
<!-- sent="Sat, 11 Sep 1999 21:41:18 +0300 (EEST)" -->
<!-- name="Victor STANESCU" -->
<!-- email="bruno@Heineken.lmn.pub.ro" -->
<!-- subject="dynamic allocation problem in linux =&gt; DoS for all" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: dynamic allocation problem in linux =&gt; DoS for all</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>dynamic allocation problem in linux =&gt; DoS for all</h1>
<b>Victor STANESCU</b> (<a href="mailto:bruno@Heineken.lmn.pub.ro"><i>bruno@Heineken.lmn.pub.ro</i></a>)<br>
<i>Sat, 11 Sep 1999 21:41:18 +0300 (EEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1068">[ date ]</a><a href="index.html#1068">[ thread ]</a><a href="subject.html#1068">[ subject ]</a><a href="author.html#1068">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1069.html">Dr J Pelan: "NFS *client* locking issues in 2.2.x ?"</a>
<li> <b>Previous message:</b> <a href="1067.html">Christopher Thompson: "multinic patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This small sample of code, as can be found in any c++ book, should<br>
allocate memory until it cannot, and then just exit, with a message:<br>
<p>
#include &lt;new&gt;<br>
#include &lt;iostream&gt;<br>
<p>
void leave_program()<br>
{<br>
	cout&lt;&lt;"Cannot allocate anymore.."&lt;&lt;endl;<br>
	exit(1);<br>
}<br>
<p>
int main()<br>
{<br>
	set_new_handler(leave_program);<br>
	while(1)<br>
		new int[1000];<br>
}<br>
<p>
But, surprise:<br>
Instead of allocating some memory, then exiting with the message "Cannot<br>
allocate anymore..", it allocates all the memory. All other applications<br>
are swapped. When it cannot find any free space (all the RAM and the swap<br>
are full), it dies with something like bus error, or out of memory, BUT<br>
NOT EXECUTING THE NEW HANDLER.<br>
<p>
Well, this is not so much a security problem, but the collateral effects<br>
that it generates are sure very ugly, and they are:<br>
<p>
If another user is working in X, and when this mallicious program is<br>
running, he tries to move the mouse or launch an application, all the X<br>
server dies because it cannot find any free memory in ram or swap for that<br>
new request. Just run this small code and try to use X in the same time.<br>
This thing allows an user to attack the user logged in locally.<br>
<p>
AND MORE SEVERE: if any other application (like syslog, klog, sendmail,<br>
named, httpd) needs to run in that precise moment when this small program<br>
is executed, it dies. This way i have succesfully killed the programs<br>
mentioned above, as a normal user. So anyone with local acces to the<br>
machine can kill the mail, http, dns servers you are running. This is sure<br>
an ugly thing and a very severe denial of service atack from local users.<br>
I do not like to know that all my services can be put down in 5 minutes by<br>
anyone of my users.<br>
<p>
Some correction can be made with ulimit -v in bash2, but a program can be<br>
launched in many other ways (from the window manager for example), so it<br>
is not enough, and there are users which do not use bash2.<br>
<p>
The problem affects a Redhat 6.0 (glibc 2.1)  and a Slackware 3.6<br>
(libc.so.5) , tested both with 2.0.36 and 2.2.5 kernels. <br>
<p>
Victor STANESCU-network administrator<br>
The  Numerical  Methods  Laboratory,<br>
Politehnica  University of Bucharest<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1069.html">Dr J Pelan: "NFS *client* locking issues in 2.2.x ?"</a>
<li> <b>Previous message:</b> <a href="1067.html">Christopher Thompson: "multinic patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
