<!-- received="Sat Sep 11 23:53:27 1999 EET DST" -->
<!-- sent="Sat, 11 Sep 1999 14:41:35 -0600 (MDT)" -->
<!-- name="Vincent Stemen" -->
<!-- email="vstemen@crel.com" -->
<!-- subject="[patch] Updated PS/2 mouse detection patch" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [patch] Updated PS/2 mouse detection patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] Updated PS/2 mouse detection patch</h1>
<b>Vincent Stemen</b> (<a href="mailto:vstemen@crel.com"><i>vstemen@crel.com</i></a>)<br>
<i>Sat, 11 Sep 1999 14:41:35 -0600 (MDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1087">[ date ]</a><a href="index.html#1087">[ thread ]</a><a href="subject.html#1087">[ subject ]</a><a href="author.html#1087">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1088.html">Matthew: "Re: 2.2.x crashes when MemShared &gt; 2G?"</a>
<li> <b>Previous message:</b> <a href="1086.html">Steven N. Hirsch: "Re: 2.2.13-pre6"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Johan Myreen suggested that I modify the patch I posted earlier to skip<br>
the auxiliary port detection logic if the BIOS detected a PS/2 mouse<br>
connected because the port detection logic did not always work on all<br>
machines.  Here is an updated patch with that change.<br>
<p>
<p>
--- linux.orig/Documentation/Configure.help	Wed Aug 25 18:29:45 1999<br>
+++ linux/Documentation/Configure.help	Fri Sep 10 20:38:47 1999<br>
@@ -8426,6 +8426,15 @@<br>
   <a href="ftp://metalab.unc.edu/pub/Linux/system/Daemons">ftp://metalab.unc.edu/pub/Linux/system/Daemons</a>) solves this<br>
   problem, or you can get the "mconv" utility also from metalab.<br>
 <br>
+Initialize the psaux driver even if a PS/2 mouse is not connected<br>
+CONFIG_ALWAYS_INITIALIZE_PSAUX<br>
+  If set to yes, the PS/2 auxiliary device driver will be loaded if<br>
+  there is a PS/2 Mouse Port on your computer whether there is a mouse<br>
+  connected to it or not.  Normally this is set to no.  This way boot up<br>
+  init scripts can attempt to auto-configure the mouse, assuming there<br>
+  is no PS/2 mouse if there is no psaux device.  If set to no the PS/2<br>
+  mouse must be plugged in at boot time to enable it.<br>
+  <br>
 C&amp;T 82C710 mouse port support (as on TI Travelmate)<br>
 CONFIG_82C710_MOUSE<br>
   This is a certain kind of PS/2 mouse used on the TI Travelmate. If<br>
diff -urN linux.orig/drivers/char/Config.in linux/drivers/char/Config.in<br>
--- linux.orig/drivers/char/Config.in	Wed Aug 25 18:29:46 1999<br>
+++ linux/drivers/char/Config.in	Fri Sep 10 20:37:32 1999<br>
@@ -69,6 +69,9 @@<br>
 	tristate 'Logitech busmouse support' CONFIG_BUSMOUSE<br>
 	tristate 'Microsoft busmouse support' CONFIG_MS_BUSMOUSE<br>
 	bool 'PS/2 mouse (aka "auxiliary device") support' CONFIG_PSMOUSE<br>
+	if [ "$CONFIG_PSMOUSE" = "y" ]; then<br>
+	  bool 'Initialize the psaux driver even if a PS/2 mouse is not connected' CONFIG_ALWAYS_INITIALIZE_PSAUX<br>
+	fi<br>
 	tristate 'C&amp;T 82C710 mouse port support (as on TI Travelmate)' CONFIG_82C710_MOUSE<br>
 	tristate 'PC110 digitizer pad support' CONFIG_PC110_PAD<br>
 	endmenu<br>
diff -urN linux.orig/drivers/char/pc_keyb.c linux/drivers/char/pc_keyb.c<br>
--- linux.orig/drivers/char/pc_keyb.c	Mon Aug  9 13:04:39 1999<br>
+++ linux/drivers/char/pc_keyb.c	Fri Sep 10 21:55:23 1999<br>
@@ -13,6 +13,10 @@<br>
  * Code fixes to handle mouse ACKs properly.<br>
  * C. Scott Ananian &lt;<a href="mailto:cananian@alumni.princeton.edu">cananian@alumni.princeton.edu</a>&gt; 1999-01-29.<br>
  *<br>
+ * Added #ifndef CONFIG_ALWAYS_INITIALIZE_PSAUX code to optionally load<br>
+ * the psaux driver if a PS/2 mouse is not connected.<br>
+ * 1999-09-09  Vincent Stemen  &lt;<a href="mailto:vstemen@crel.com">vstemen@crel.com</a>&gt;<br>
+ *<br>
  */<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
@@ -731,6 +735,10 @@<br>
 	int loops = 10;<br>
 	int retval = 0;<br>
 <br>
+        /* Check if the BIOS detected a device on the auxiliary port. */<br>
+        if (aux_device_present == 0xaa)   <br>
+                return 1;<br>
+<br>
 	spin_lock_irqsave(&amp;kbd_controller_lock, flags);<br>
 <br>
 	/* Put the value 0x5A in the output buffer using the "Write<br>
@@ -968,6 +976,14 @@<br>
 {<br>
 	if (!detect_auxiliary_port())<br>
 		return -EIO;<br>
+<br>
+#ifndef CONFIG_ALWAYS_INITIALIZE_PSAUX<br>
+        /* Check if the BIOS detected a device on the auxiliary port. */<br>
+	if (aux_device_present != 0xaa) <br>
+                return -EIO;<br>
+        else<br>
+                printk(KERN_INFO "PS/2 auxiliary pointing device detected -- driver installed.\n");<br>
+#endif<br>
 <br>
 	misc_register(&amp;psaux_mouse);<br>
 	queue = (struct aux_queue *) kmalloc(sizeof(*queue), GFP_KERNEL);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1088.html">Matthew: "Re: 2.2.x crashes when MemShared &gt; 2G?"</a>
<li> <b>Previous message:</b> <a href="1086.html">Steven N. Hirsch: "Re: 2.2.13-pre6"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
