<!-- received="Mon Oct 11 00:52:58 1999 EET DST" -->
<!-- sent="Sun, 10 Oct 1999 23:47:35 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] 2.3.20 simple fs-corruption fix [Re: [patch] [possible race" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9910101649370.364-100000@alpha.random" -->
<title>Linux-kernel mailing list archive 1999-41,: [patch] 2.3.20 simple fs-corruption fix [Re: [patch] [possible race</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] 2.3.20 simple fs-corruption fix [Re: [patch] [possible race</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Sun, 10 Oct 1999 23:47:35 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#141">[ date ]</a><a href="index.html#141">[ thread ]</a><a href="subject.html#141">[ subject ]</a><a href="author.html#141">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0142.html">Andrea Arcangeli: "Re: locking question: do_mmap(), do_munmap()"</a>
<li> <b>Previous message:</b> <a href="0140.html">Garst R. Reese: "Re: PATCH Re: 2.3.20 missing module symbols"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sun, 10 Oct 1999, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;As the fix I am proposing is only a bit more than a one liner, I think I</i><br>
<i>&gt;can implement it. Of course if there is a better fix I won't want my</i><br>
<p>
I implemented it. Here my simple fix against 2.3.20:<br>
<p>
--- 2.3.20/fs/buffer.c	Sun Oct 10 16:59:57 1999<br>
+++ 2.3.20-pagecache/fs/buffer.c	Sun Oct 10 19:57:36 1999<br>
@@ -1205,6 +1205,18 @@<br>
 	return 0;<br>
 }<br>
 <br>
+static void unmap_buffer(struct buffer_head * bh)<br>
+{<br>
+	if (buffer_mapped(bh))<br>
+	{<br>
+		mark_buffer_clean(bh);<br>
+		wait_on_buffer(bh);<br>
+		clear_bit(BH_Uptodate, &amp;bh-&gt;b_state);<br>
+		clear_bit(BH_Mapped, &amp;bh-&gt;b_state);<br>
+		clear_bit(BH_Req, &amp;bh-&gt;b_state);<br>
+	}<br>
+}<br>
+<br>
 /*<br>
  * We don't have to release all buffers here, but<br>
  * we have to be sure that no dirty buffer is left<br>
@@ -1231,16 +1243,8 @@<br>
 		/*<br>
 		 * is this block fully flushed?<br>
 		 */<br>
-		if (offset &lt;= curr_off) {<br>
-			if (buffer_mapped(bh)) {<br>
-				mark_buffer_clean(bh);<br>
-				wait_on_buffer(bh);<br>
-				clear_bit(BH_Uptodate, &amp;bh-&gt;b_state);<br>
-				clear_bit(BH_Mapped, &amp;bh-&gt;b_state);<br>
-				clear_bit(BH_Req, &amp;bh-&gt;b_state);<br>
-				bh-&gt;b_blocknr = 0;<br>
-			}<br>
-		}<br>
+		if (offset &lt;= curr_off)<br>
+			unmap_buffer(bh);<br>
 		curr_off = next_off;<br>
 		bh = next;<br>
 	} while (bh != head);<br>
@@ -1286,6 +1290,19 @@<br>
 	get_page(page);<br>
 }<br>
 <br>
+static void unmap_underlying_metadata(struct buffer_head * bh)<br>
+{<br>
+	bh = get_hash_table(bh-&gt;b_dev, bh-&gt;b_blocknr, bh-&gt;b_size);<br>
+	if (bh)<br>
+	{<br>
+		unmap_buffer(bh);<br>
+		/* Here we could run brelse or bforget. We use<br>
+		   bforget because it will try to put the buffer<br>
+		   in the freelist. */<br>
+		__bforget(bh);<br>
+	}<br>
+}<br>
+<br>
 /*<br>
  * block_write_full_page() is SMP-safe - currently it's still<br>
  * being called with the kernel lock held, but the code is ready.<br>
@@ -1331,6 +1348,7 @@<br>
 			err = inode-&gt;i_op-&gt;get_block(inode, block, bh, 1);<br>
 			if (err)<br>
 				goto out;<br>
+			unmap_underlying_metadata(bh);<br>
 		}<br>
 		set_bit(BH_Uptodate, &amp;bh-&gt;b_state);<br>
 		mark_buffer_dirty(bh,0);<br>
@@ -1420,6 +1438,7 @@<br>
 			err = inode-&gt;i_op-&gt;get_block(inode, block, bh, 1);<br>
 			if (err)<br>
 				goto out;<br>
+			unmap_underlying_metadata(bh);<br>
 		}<br>
 <br>
 		if (!buffer_uptodate(bh) &amp;&amp; (start_offset || (end_bytes &amp;&amp; (i == end_block)))) {<br>
@@ -1582,6 +1601,7 @@<br>
 			err = inode-&gt;i_op-&gt;get_block(inode, block, bh, 1);<br>
 			if (err)<br>
 				goto out;<br>
+			unmap_underlying_metadata(bh);<br>
 		}<br>
 <br>
 		if (!buffer_uptodate(bh) &amp;&amp; (start_offset || (end_bytes &amp;&amp; (i == end_block)))) {<br>
<p>
<p>
<p>
I know it has the downside of doing an hash lookup for each buffer we want<br>
overlap on the pagecache for writing into it.<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0142.html">Andrea Arcangeli: "Re: locking question: do_mmap(), do_munmap()"</a>
<li> <b>Previous message:</b> <a href="0140.html">Garst R. Reese: "Re: PATCH Re: 2.3.20 missing module symbols"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
