<!-- received="Mon Oct 11 17:47:31 1999 EET DST" -->
<!-- sent="Mon, 11 Oct 1999 10:40:19 -0400 (EDT)" -->
<!-- name="Chuck Lever" -->
<!-- email="cel@monkey.org" -->
<!-- subject="Re: [PATCH] _isofs_bmap warning and readahead cache in 2.3" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.991011094715.22631A-200000@alpha.ifdtung.if.ua" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: [PATCH] _isofs_bmap warning and readahead cache in 2.3</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [PATCH] _isofs_bmap warning and readahead cache in 2.3</h1>
<b>Chuck Lever</b> (<a href="mailto:cel@monkey.org"><i>cel@monkey.org</i></a>)<br>
<i>Mon, 11 Oct 1999 10:40:19 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#251">[ date ]</a><a href="index.html#251">[ thread ]</a><a href="subject.html#251">[ subject ]</a><a href="author.html#251">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0252.html">David S. Miller: "Re: Andrea's pending 2.2.x patches"</a>
<li> <b>Previous message:</b> <a href="0250.html">Harald Koenig: "Re: mmapping of page 0xfffff000 impossible ?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 11 Oct 1999, Vladimir Chernyshov wrote:<br>
<i>&gt; The readahead cache in development kernels often tries to get</i><br>
<i>&gt; additional blocks from block device without checking for the next block</i><br>
<i>&gt; to be inside file boundary. This cause annoying messages when reading</i><br>
<i>&gt; file from filesystem, that make additional checking itself.</i><br>
<i>&gt; Like this:</i><br>
<i>&gt; </i><br>
<i>&gt; Oct  7 17:04:05 greengrass kernel: _isofs_bmap: block &gt;= EOF (4, 5542) </i><br>
<i>&gt; Oct  7 17:04:05 greengrass kernel: _isofs_bmap: block &gt;= EOF (5, 5542) </i><br>
<i>&gt; Oct  7 17:04:05 greengrass kernel: _isofs_bmap: block &gt;= EOF (6, 5542) </i><br>
<i>&gt; Oct  7 17:04:05 greengrass kernel: _isofs_bmap: block &gt;= EOF (7, 5542) </i><br>
<i>&gt; </i><br>
<i>&gt; Seems, the check has been removed from mm/filemap.c some time ago.</i><br>
<i>&gt; Is it a bug or a feature?</i><br>
<i>&gt; If it's a bug, here's a patch...</i><br>
<p>
page_cache_read has to be able to read past the end of a file, in order to<br>
create empty file pages in some cases.  your check really belongs in<br>
generic_file_readahead.  here's the patch again, against 2.3.18ac10, i<br>
think.<br>
<p>
--- filemap.c.orig	Fri Oct  1 14:33:06 1999<br>
+++ filemap.c	Fri Oct  1 14:41:20 1999<br>
@@ -923,8 +923,10 @@<br>
 	ahead = 0;<br>
 	while (ahead &lt; max_ahead) {<br>
 		ahead += PAGE_CACHE_SIZE;<br>
-		if (page_cache_read(filp, raend + ahead) &lt; 0)<br>
-			break;<br>
+		if ((raend + ahead) &lt; inode-&gt;i_size)<br>
+			if (page_cache_read(filp, raend + ahead) &gt;= 0)<br>
+				continue;<br>
+		break;<br>
 	}<br>
 /*<br>
  * If we tried to read ahead some pages,<br>
<p>
	- Chuck Lever<br>
<pre>
--
corporate:	&lt;<a href="mailto:chuckl@netscape.com">chuckl@netscape.com</a>&gt;
personal:	&lt;<a href="mailto:chucklever@netscape.net">chucklever@netscape.net</a>&gt; or &lt;cel@monkey.org&gt;
<p>
The Linux Scalability project:
	<a href="http://www.citi.umich.edu/projects/linux-scalability/">http://www.citi.umich.edu/projects/linux-scalability/</a>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0252.html">David S. Miller: "Re: Andrea's pending 2.2.x patches"</a>
<li> <b>Previous message:</b> <a href="0250.html">Harald Koenig: "Re: mmapping of page 0xfffff000 impossible ?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
