<!-- received="Tue Oct 12 09:35:56 1999 EET DST" -->
<!-- sent="Mon, 11 Oct 1999 21:59:49 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@suse.cz" -->
<!-- subject="Re: kapmd taking large amounts of cpu" -->
<!-- id="" -->
<!-- inreplyto="38005D3D.DC1224DD@kalifornia.com" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: kapmd taking large amounts of cpu</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: kapmd taking large amounts of cpu</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@suse.cz"><i>pavel@suse.cz</i></a>)<br>
<i>Mon, 11 Oct 1999 21:59:49 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#397">[ date ]</a><a href="index.html#397">[ thread ]</a><a href="subject.html#397">[ subject ]</a><a href="author.html#397">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0398.html">Richard Gooch: "Re: My $0.02 on devd and devfs"</a>
<li> <b>Previous message:</b> <a href="0396.html">riq: "a little patch to fs/ufs/super.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
<i>&gt; just an idle question out of the blue, over the last few releases, i've</i><br>
<i>&gt; noticed kapmd is taking anywhere between 10 and 40% of the cpu.  it</i><br>
<i>&gt; isn't having a huge impact most of the time but does contribute.</i><br>
<p>
It happens here, too.<br>
<p>
I'm just taking a look. The code is perverted.<br>
<p>
If system is idle (that is measured once a second *), it starts<br>
spinning within the loop telling bios that we are idle. That "idle<br>
call" in a loop is maybe done with disabled interrupts (damaging<br>
killing interrupt response?)<br>
<p>
What is more funny is that in case of cpu being idle, apm_do_idle() is<br>
probably going to be called only half of a time. See:<br>
<p>
schedule_timeout(HZ)<br>
<p>
apm_do_idle()<br>
	while (1)<br>
		if (jiffies-start &gt; HZ)<br>
			break<br>
and repeat. That gives calls being done only half of a time. Patch<br>
appended.<br>
<p>
* -- what happens if there's _another_ program that wakes up once a<br>
second? I think that with 0.01 probability apm_do_idle() will be never<br>
called on such system. I think that this is ugly and that it can hurt<br>
in real life.<br>
<p>
--- clean/arch/i386/kernel/apm.c	Sat Sep 11 20:55:53 1999<br>
+++ linux/arch/i386/kernel/apm.c	Mon Oct 11 21:56:50 1999<br>
@@ -1073,8 +1078,10 @@<br>
 			unsigned long start = jiffies;<br>
 			do {<br>
 				apm_do_idle();<br>
-				if (jiffies - start &gt; APM_CHECK_TIMEOUT)<br>
-					break;<br>
+				if (jiffies - start &gt; APM_CHECK_TIMEOUT) {<br>
+					apm_event_handler();<br>
+					start = jiffies;<br>
+				}<br>
 			} while (system_idle());<br>
 			apm_do_busy();<br>
 			apm_event_handler();<br>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. Look at <a href="http://195.113.31.123/~pavel">http://195.113.31.123/~pavel</a>.  Pavel
Hi! I'm a .signature virus! Copy me into your ~/.signature, please!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0398.html">Richard Gooch: "Re: My $0.02 on devd and devfs"</a>
<li> <b>Previous message:</b> <a href="0396.html">riq: "a little patch to fs/ufs/super.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
