<!-- received="Tue Oct 12 11:30:15 1999 EET DST" -->
<!-- sent="Mon, 11 Oct 1999 16:52:31 -0300" -->
<!-- name="Eduardo Trapani" -->
<!-- email="etrapani@unesco.org.uy" -->
<!-- subject="PATCH:  SPX 0.2 for Linux 2.2.12" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: PATCH:  SPX 0.2 for Linux 2.2.12</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PATCH:  SPX 0.2 for Linux 2.2.12</h1>
<b>Eduardo Trapani</b> (<a href="mailto:etrapani@unesco.org.uy"><i>etrapani@unesco.org.uy</i></a>)<br>
<i>Mon, 11 Oct 1999 16:52:31 -0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#418">[ date ]</a><a href="index.html#418">[ thread ]</a><a href="subject.html#418">[ subject ]</a><a href="author.html#418">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0419.html">Frank v Waveren: "Re: Temporal wormhole?"</a>
<li> <b>Previous message:</b> <a href="0417.html">Chris Noe: "Re: [patch] 2.3.31 i386/bootsect.S"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------DBC946C5A0A990BE7ACE10E1<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
While using SPX as a module running the kernel 2.2.12 I found the<br>
following problems and I wrote a patch that seems to solve them.<br>
<p>
- select() does not work for an SPX socket (waiting to read)<br>
The patch adds a function spx_datagram_poll() that is basically the same<br>
function as the one in net/core.  spx_datagram_poll() however checks the<br>
buffers where the SPX implementation really puts the data.<br>
<p>
- only three SPX packets can be exchanged between the server (not Linux)<br>
and a Linux client<br>
If the server checks the alloc field of the SPX frame it will notice<br>
that the number stops increasing at three.  When this happens the server<br>
refuses to send packets whose sequence number is greater than three.<br>
<p>
- kernel oops if the net number has no route to it<br>
When trying to connect on a network to which there is no route IPX might<br>
return a ENETUNREACH error code.  The SPX code was not checking this,<br>
what lead to an error in sock_alloc_send_skb() (the size parameter got<br>
set to a huge unsigned number) after which the system would freeze.<br>
<p>
This is the first time I send a patch.  I read all the documents I could<br>
find on sending patches and I looked at other people's patches but still<br>
something might be wrong formatted.  If that is the case please let me<br>
know.<br>
<p>
Bye, Eduardo.<br>
--------------DBC946C5A0A990BE7ACE10E1<br>
Content-Type: text/plain; charset=us-ascii;<br>
 name="patch-spx-0.2-linux-2.2.12.txt"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline;<br>
 filename="patch-spx-0.2-linux-2.2.12.txt"<br>
<p>
--- linux/net/ipx/af_spx.c.orig	Mon Oct 11 16:20:52 1999<br>
+++ linux/net/ipx/af_spx.c	Mon Oct 11 16:38:36 1999<br>
@@ -15,6 +15,11 @@<br>
  *				made static the ipx ops. Removed the hack<br>
  *				ipx methods interface. Dropped AF_SPX - its<br>
  *				the wrong abstraction.<br>
+ *	Eduardo Trapani	:	Added a check for the return value of<br>
+ *				ipx_if_offset that crashed sock_alloc_send_skb.<br>
+ *				Added spx_datagram_poll() so that select()<br>
+ *				works now on SPX sockets.  Added updating<br>
+ *				of the alloc count to follow rmt_seq.<br>
  *<br>
  *	This program is free software; you can redistribute it and/or<br>
  *      modify it under the terms of the GNU General Public License<br>
@@ -37,6 +42,7 @@<br>
 #include &lt;linux/uio.h&gt;<br>
 #include &lt;linux/unistd.h&gt;<br>
 #include &lt;linux/firewall.h&gt;<br>
+#include &lt;linux/poll.h&gt;<br>
 <br>
 static struct proto_ops *ipx_operations;<br>
 static struct proto_ops spx_operations;<br>
@@ -50,6 +56,45 @@<br>
 <br>
 extern void ipx_remove_socket(struct sock *sk);<br>
 <br>
+/* Datagram poll:	the same code as datagram_poll() in net/core<br>
+			but the right spx buffers are looked at and<br>
+			there is no question on the type of the socket<br>
+			*/<br>
+static unsigned int spx_datagram_poll(struct file * file, struct socket *sock, poll_table *wait)<br>
+{<br>
+	struct sock *sk = sock-&gt;sk;<br>
+	struct spx_opt *pdata = &amp;sk-&gt;tp_pinfo.af_spx;<br>
+	unsigned int mask;<br>
+<br>
+	poll_wait(file, sk-&gt;sleep, wait);<br>
+	mask = 0;<br>
+<br>
+	/* exceptional events? */<br>
+	if (sk-&gt;err || !skb_queue_empty(&amp;sk-&gt;error_queue))<br>
+		mask |= POLLERR;<br>
+	if (sk-&gt;shutdown &amp; RCV_SHUTDOWN)<br>
+		mask |= POLLHUP;<br>
+<br>
+	/* readable? */<br>
+	if (!skb_queue_empty(&amp;pdata-&gt;rcv_queue))<br>
+		mask |= POLLIN | POLLRDNORM;<br>
+<br>
+	/* Need to check for termination and startup */<br>
+	if (sk-&gt;state==TCP_CLOSE)<br>
+		mask |= POLLHUP;<br>
+	/* connection hasn't started yet? */<br>
+	if (sk-&gt;state == TCP_SYN_SENT)<br>
+		return mask;<br>
+<br>
+	/* writable? */<br>
+	if (sock_writeable(sk))<br>
+		mask |= POLLOUT | POLLWRNORM | POLLWRBAND;<br>
+	else<br>
+		sk-&gt;socket-&gt;flags |= SO_NOSPACE;<br>
+<br>
+	return mask;<br>
+}<br>
+<br>
 /* Create the SPX specific data */<br>
 static int spx_sock_init(struct sock *sk)<br>
 {<br>
@@ -403,6 +448,9 @@<br>
 		int offset  = ipx_if_offset(pdata-&gt;dest_addr.net);<br>
         	int size    = offset + sizeof(struct ipxspxhdr);<br>
 <br>
+        	if (offset &lt; 0) /* ENETUNREACH */<br>
+        		return(-ENETUNREACH);<br>
+<br>
 		save_flags(flags);<br>
 		cli();<br>
         	skb = sock_alloc_send_skb(sk, size, 1, 0, &amp;err);<br>
@@ -662,6 +710,7 @@<br>
 			{<br>
 				pdata-&gt;rmt_seq = ntohs(ipxh-&gt;spx.sequence);<br>
 				pdata-&gt;rmt_ack = ntohs(ipxh-&gt;spx.ackseq);<br>
+				pdata-&gt;alloc   = pdata-&gt;rmt_seq + 3;<br>
 				if(pdata-&gt;rmt_ack &gt; 0 || pdata-&gt;rmt_ack == 0)<br>
 					spx_retransmit_chk(pdata,pdata-&gt;rmt_ack, ACK);<br>
 <br>
@@ -856,7 +905,7 @@<br>
         sock_no_socketpair,<br>
         spx_accept,<br>
 	spx_getname,<br>
-        datagram_poll,  /* this does seqpacket too */<br>
+        spx_datagram_poll,<br>
 	spx_ioctl,<br>
         spx_listen,<br>
         spx_shutdown,<br>
<p>
--------------DBC946C5A0A990BE7ACE10E1--<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0419.html">Frank v Waveren: "Re: Temporal wormhole?"</a>
<li> <b>Previous message:</b> <a href="0417.html">Chris Noe: "Re: [patch] 2.3.31 i386/bootsect.S"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
