<!-- received="Tue Oct 12 12:20:16 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 02:13:45 -0700" -->
<!-- name="David S. Miller" -->
<!-- email="davem@redhat.com" -->
<!-- subject="[PATCH] Fix RT signal OOPS's in 2.2.x" -->
<!-- id="199910120913.CAA05118@pizda.ninka.net" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [PATCH] Fix RT signal OOPS's in 2.2.x</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Fix RT signal OOPS's in 2.2.x</h1>
<b>David S. Miller</b> (<a href="mailto:davem@redhat.com"><i>davem@redhat.com</i></a>)<br>
<i>Tue, 12 Oct 1999 02:13:45 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#422">[ date ]</a><a href="index.html#422">[ thread ]</a><a href="subject.html#422">[ subject ]</a><a href="author.html#422">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0423.html">Koblinger Egmont: "Re: load avg += 1"</a>
<li> <b>Previous message:</b> <a href="0421.html">Sean Hunter: "Re: [2.3.20] cat /dev/psaux freezes machine"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Alan, this is a critical fix, please consider putting<br>
it into 2.2.13pre if possible.<br>
<p>
When using RT signals, during do_sigaction(), if the signal is queued<br>
already and this queued instance it is not exactly at<br>
current-&gt;sigqueue, then the queue structure is freed however<br>
current-&gt;sigqueue_tail is not updated and thus later during<br>
dequeue_signal() and other places we will reference it again<br>
and even kfree it a second time, which causes an instant oops<br>
in kmem_cache_free.<br>
<p>
This behavior was seen on an SMP system running several concurrent<br>
copies of ncml mirroring software under heavy load.<br>
<p>
Here is the fix, it makes the freeing logic identical to similar<br>
code in dequeue_signal().<br>
<p>
--- kernel/signal.c.~1~	Wed Sep 22 06:00:40 1999<br>
+++ kernel/signal.c	Tue Oct 12 02:01:23 1999<br>
@@ -872,7 +872,8 @@<br>
 					if (q-&gt;info.si_signo != sig)<br>
 						pp = &amp;q-&gt;next;<br>
 					else {<br>
-						*pp = q-&gt;next;<br>
+						if ((*pp = q-&gt;next) == NULL)<br>
+							current-&gt;sigqueue_tail = pp;<br>
 						kmem_cache_free(signal_queue_cachep, q);<br>
 						atomic_dec(&amp;nr_queued_signals);<br>
 					}<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0423.html">Koblinger Egmont: "Re: load avg += 1"</a>
<li> <b>Previous message:</b> <a href="0421.html">Sean Hunter: "Re: [2.3.20] cat /dev/psaux freezes machine"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
