<!-- received="Tue Oct 12 17:09:04 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 10:06:06 -0400 (EDT)" -->
<!-- name="Alexander Viro" -->
<!-- email="viro@math.psu.edu" -->
<!-- subject="[more fun] Re: locking question: do_mmap(), do_munmap()" -->
<!-- id="" -->
<!-- inreplyto="Pine.GSO.4.10.9910111850370.18777-100000@weyl.math.psu.edu" -->
<title>Linux-kernel mailing list archive 1999-41,: [more fun] Re: locking question: do_mmap(), do_munmap()</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[more fun] Re: locking question: do_mmap(), do_munmap()</h1>
<b>Alexander Viro</b> (<a href="mailto:viro@math.psu.edu"><i>viro@math.psu.edu</i></a>)<br>
<i>Tue, 12 Oct 1999 10:06:06 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#450">[ date ]</a><a href="index.html#450">[ thread ]</a><a href="subject.html#450">[ subject ]</a><a href="author.html#450">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0451.html">Natapov Gleb: "/dev/random and nonblocking I/O bug ?"</a>
<li> <b>Previous message:</b> <a href="0449.html">Andrea Arcangeli: "Re: [patch] [possible race in ext2] Re: how to write get_block?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Funny path #1: on 386 (sucky WP) copy_to_user() -&gt; access_ok() -&gt;<br>
__verify_write() -&gt; handle_mm_fault() and no mmap_sem in sight. Ditto for<br>
__verify_write() on sh.<br>
<p>
Another one: ptrace_readdata() -&gt; access_process_vm() -&gt; find_extend_vma()<br>
-&gt; make_pages_present(). Again, no mmap_sem in sight.<br>
<p>
irix_brk(): calls do_brk() without mmap_sem.<br>
<p>
sys_cacheflush() (on m68k): plays with vma without mmap_sem.<br>
<p>
Patch follows (2.3.20, but these files didn't change in .21).<br>
<p>
diff -urN linux-2.3.20/arch/i386/mm/fault.c linux-bird.mm/arch/i386/mm/fault.c<br>
--- linux-2.3.20/arch/i386/mm/fault.c	Sun Sep 12 11:01:01 1999<br>
+++ linux-bird.mm/arch/i386/mm/fault.c	Tue Oct 12 07:44:55 1999<br>
@@ -35,6 +35,7 @@<br>
 	if (!size)<br>
 		return 1;<br>
 <br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	vma = find_vma(current-&gt;mm, start);<br>
 	if (!vma)<br>
 		goto bad_area;<br>
@@ -64,6 +65,7 @@<br>
 		if (!(vma-&gt;vm_flags &amp; VM_WRITE))<br>
 			goto bad_area;;<br>
 	}<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return 1;<br>
 <br>
 check_stack:<br>
@@ -73,6 +75,7 @@<br>
 		goto good_area;<br>
 <br>
 bad_area:<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return 0;<br>
 }<br>
 <br>
diff -urN linux-2.3.20/arch/m68k/kernel/sys_m68k.c linux-bird.mm/arch/m68k/kernel/sys_m68k.c<br>
--- linux-2.3.20/arch/m68k/kernel/sys_m68k.c	Mon Jun 21 12:35:55 1999<br>
+++ linux-bird.mm/arch/m68k/kernel/sys_m68k.c	Tue Oct 12 09:56:24 1999<br>
@@ -535,6 +535,7 @@<br>
 	int ret = -EINVAL;<br>
 <br>
 	lock_kernel();<br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	if (scope &lt; FLUSH_SCOPE_LINE || scope &gt; FLUSH_SCOPE_ALL ||<br>
 	    cache &amp; ~FLUSH_CACHE_BOTH)<br>
 		goto out;<br>
@@ -591,6 +592,7 @@<br>
 		ret = cache_flush_060 (addr, scope, cache, len);<br>
 	}<br>
 out:<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	unlock_kernel();<br>
 	return ret;<br>
 }<br>
diff -urN linux-2.3.20/arch/mips/kernel/sysirix.c linux-bird.mm/arch/mips/kernel/sysirix.c<br>
--- linux-2.3.20/arch/mips/kernel/sysirix.c	Sun Sep 12 05:54:08 1999<br>
+++ linux-bird.mm/arch/mips/kernel/sysirix.c	Tue Oct 12 09:46:09 1999<br>
@@ -534,6 +534,7 @@<br>
 	int ret;<br>
 <br>
 	lock_kernel();<br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	if (brk &lt; current-&gt;mm-&gt;end_code) {<br>
 		ret = -ENOMEM;<br>
 		goto out;<br>
@@ -591,6 +592,7 @@<br>
 	ret = 0;<br>
 <br>
 out:<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	unlock_kernel();<br>
 	return ret;<br>
 }<br>
diff -urN linux-2.3.20/arch/sh/mm/fault.c linux-bird.mm/arch/sh/mm/fault.c<br>
--- linux-2.3.20/arch/sh/mm/fault.c	Sun Sep 12 13:29:49 1999<br>
+++ linux-bird.mm/arch/sh/mm/fault.c	Tue Oct 12 09:57:03 1999<br>
@@ -38,6 +38,7 @@<br>
 	if (!size)<br>
 		return 1;<br>
 <br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	vma = find_vma(current-&gt;mm, start);<br>
 	if (!vma)<br>
 		goto bad_area;<br>
@@ -67,6 +68,7 @@<br>
 		if (!(vma-&gt;vm_flags &amp; VM_WRITE))<br>
 			goto bad_area;;<br>
 	}<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return 1;<br>
 <br>
 check_stack:<br>
@@ -76,6 +78,7 @@<br>
 		goto good_area;<br>
 <br>
 bad_area:<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return 0;<br>
 }<br>
 <br>
diff -urN linux-2.3.20/kernel/ptrace.c linux-bird.mm/kernel/ptrace.c<br>
--- linux-2.3.20/kernel/ptrace.c	Sun Sep 12 13:03:24 1999<br>
+++ linux-bird.mm/kernel/ptrace.c	Tue Oct 12 09:15:27 1999<br>
@@ -79,14 +79,15 @@<br>
 <br>
 int access_process_vm(struct task_struct *tsk, unsigned long addr, void *buf, int len, int write)<br>
 {<br>
-	int copied;<br>
-	struct vm_area_struct * vma = find_extend_vma(tsk, addr);<br>
+	int copied = 0;<br>
+	struct vm_area_struct * vma;<br>
+<br>
+	down(&amp;tsk-&gt;mm-&gt;mmap_sem);<br>
+	vma = find_extend_vma(tsk, addr);<br>
 <br>
 	if (!vma)<br>
-		return 0;<br>
+		goto out;<br>
 <br>
-	down(&amp;tsk-&gt;mm-&gt;mmap_sem);<br>
-	copied = 0;<br>
 	for (;;) {<br>
 		unsigned long offset = addr &amp; ~PAGE_MASK;<br>
 		int this_len = PAGE_SIZE - offset;<br>
@@ -115,6 +116,7 @@<br>
 	<br>
 		vma = vma-&gt;vm_next;<br>
 	}<br>
+out:<br>
 	up(&amp;tsk-&gt;mm-&gt;mmap_sem);<br>
 	return copied;<br>
 }<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0451.html">Natapov Gleb: "/dev/random and nonblocking I/O bug ?"</a>
<li> <b>Previous message:</b> <a href="0449.html">Andrea Arcangeli: "Re: [patch] [possible race in ext2] Re: how to write get_block?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
