<!-- received="Tue Oct 12 17:15:42 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 16:09:10 +0200" -->
<!-- name="Natapov Gleb" -->
<!-- email="gnatapov@qualcomm.com" -->
<!-- subject="/dev/random and nonblocking I/O bug ?" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: /dev/random and nonblocking I/O bug ?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>/dev/random and nonblocking I/O bug ?</h1>
<b>Natapov Gleb</b> (<a href="mailto:gnatapov@qualcomm.com"><i>gnatapov@qualcomm.com</i></a>)<br>
<i>Tue, 12 Oct 1999 16:09:10 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#451">[ date ]</a><a href="index.html#451">[ thread ]</a><a href="subject.html#451">[ subject ]</a><a href="author.html#451">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0452.html">Martin Weinberg: "raid0_map bug and disk corruption"</a>
<li> <b>Previous message:</b> <a href="0450.html">Alexander Viro: "[more fun] Re: locking question: do_mmap(), do_munmap()"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0821.html">tytso@mit.edu: "Re: /dev/random and nonblocking I/O bug ?"</a>
<li> <b>Reply:</b> <a href="0821.html">tytso@mit.edu: "Re: /dev/random and nonblocking I/O bug ?"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi.<br>
<p>
It seems that read from /dev/random can block even if the device was<br>
opened with O_NONBLOCK flag.<br>
<p>
I wrote the following program:<br>
=================================================================<br>
#include &lt;errno.h&gt;<br>
#include &lt;unistd.h&gt;<br>
#include &lt;sys/types.h&gt;<br>
#include &lt;sys/stat.h&gt;<br>
#include &lt;fcntl.h&gt;<br>
#include &lt;stdio.h&gt;<br>
<p>
void main()<br>
{<br>
  int randfd;<br>
  char c;<br>
  if( (randfd = open("/dev/random", O_RDONLY | O_NONBLOCK)) &gt;= 0){<br>
    while(1){                                                     <br>
      if(read(randfd, &amp;c, 1) != 1){<br>
        if( errno != EWOULDBLOCK &amp;&amp; errno != 0 )<br>
          fprintf(stderr, "read error form random device");<br>
        break;<br>
      }       <br>
     fprintf(stderr,".");<br>
    }                    <br>
  }  <br>
}<br>
=====================================================================<br>
If you'll run this program when there are many bytes available in random<br>
pool you'll see that at some point program stops to print dots until<br>
some event, that adds data to random pool (mouse movement, keyboard<br>
stroke), will happen.<br>
<p>
The problem is in random_read() (linux/drivers/char/random.c).<br>
The task puts itself in random_read_wait queue and change state to <br>
TASK_INTERRUPTIBLE.<br>
<p>
If the random pool is empty and O_NONBLOCK is set it returns EAGAIN (as<br>
we are expecting) else it calls extract_entropy(). <br>
<p>
current-&gt;state == TASK_INTERRUPTIBLE at this point. <br>
<p>
extract_entropy() fills the user's buffer with random data and if<br>
current-&gt;need_resched is not zero it calls resched(). The task goes to<br>
sleep in state TASK_INTERRUPTIBLE until somebody will write new random<br>
data into the pool and call wake_up_interruptible(&amp;random_read_wait);<br>
It's exactly what we don't want - go to sleep while in nonblocking<br>
syscall. <br>
<p>
The following patch solves this problem for me(2.2.10, 2.2.12):<br>
===================================================================<br>
--- random.c.org        Tue Oct 12 10:49:13 1999<br>
+++ random.c    Tue Oct 12 14:20:44 1999<br>
@@ -1328,6 +1328,7 @@<br>
                        schedule();<br>
                        continue;<br>
                }<br>
+                current-&gt;state = TASK_RUNNING;<br>
                n = extract_entropy(&amp;random_state, buf, n, 1);<br>
                if (n &lt; 0) {<br>
                        retval = n;<br>
====================================================================<br>
<p>
But may be there is a better solution.<br>
<p>
(I've looked at sources of 2.3.21 and, as far as I can see, it has the<br>
same problem). <br>
<p>
				Gleb.<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0452.html">Martin Weinberg: "raid0_map bug and disk corruption"</a>
<li> <b>Previous message:</b> <a href="0450.html">Alexander Viro: "[more fun] Re: locking question: do_mmap(), do_munmap()"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0821.html">tytso@mit.edu: "Re: /dev/random and nonblocking I/O bug ?"</a>
<li> <b>Reply:</b> <a href="0821.html">tytso@mit.edu: "Re: /dev/random and nonblocking I/O bug ?"</a>
<!-- reply="end" -->
</ul>
</font></body>
