<!-- received="Tue Oct 12 19:20:40 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 20:13:49 +0400" -->
<!-- name="Ivan Kokshaysky" -->
<!-- email="ink@jurassic.park.msu.ru" -->
<!-- subject="[patch] alpha fixes for 2.3.21" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [patch] alpha fixes for 2.3.21</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] alpha fixes for 2.3.21</h1>
<b>Ivan Kokshaysky</b> (<a href="mailto:ink@jurassic.park.msu.ru"><i>ink@jurassic.park.msu.ru</i></a>)<br>
<i>Tue, 12 Oct 1999 20:13:49 +0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#466">[ date ]</a><a href="index.html#466">[ thread ]</a><a href="subject.html#466">[ subject ]</a><a href="author.html#466">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0467.html">Drew Bernat: "Advice wanted: WebFS term project"</a>
<li> <b>Previous message:</b> <a href="0465.html">Mohit Aron: "paper on fine-grained OS timers"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Here is a couple of obvious compile fixes, and cleaned up<br>
PCI/IDE fixup code.<br>
<p>
Ivan.<br>
<p>
diff -ur 2.3.21/arch/alpha/kernel/pci.c linux/arch/alpha/kernel/pci.c<br>
--- 2.3.21/arch/alpha/kernel/pci.c	Thu Oct  7 23:23:21 1999<br>
+++ linux/arch/alpha/kernel/pci.c	Tue Oct 12 18:37:48 1999<br>
@@ -73,22 +73,24 @@<br>
 	struct pci_dev *dev;<br>
 	int i;<br>
 <br>
-	/* The first three resources of an IDE controler are often magic, <br>
-	   so leave them unchanged.  This is true, for instance, of the<br>
-	   Contaq 82C693 as seen on SX164 and DP264.  */<br>
+	/* The resources 0-3 of an IDE controler are often magic, so leave<br>
+	   them unchanged. Let the resource 4 (bus master control) be<br>
+	   modified since some firmware puts it above 64K. This is true,<br>
+	   for instance, of the Contaq 82C693 as seen on SX164 and DP264.<br>
+	   Besides that we have to adjust IO region of an IDE control<br>
+	   register to avoid resource conflict with an AT-style floppy<br>
+	   controller. */<br>
 <br>
 	for (dev = pci_devices; dev; dev = dev-&gt;next) {<br>
 		if (dev-&gt;class &gt;&gt; 8 != PCI_CLASS_STORAGE_IDE)<br>
 			continue;<br>
-		/* Resource 1 of IDE controller is the address of HD_CMD<br>
-		   register which actually occupies a single byte (0x3f6<br>
-		   for ide0) in reported 0x3f4-3f7 range. We have to fix<br>
-		   that to avoid resource conflict with AT-style floppy<br>
-		   controller. */<br>
-		dev-&gt;resource[1].start += 2;<br>
-		dev-&gt;resource[1].end = dev-&gt;resource[1].start;<br>
-	        for (i = 0; i &lt; PCI_NUM_RESOURCES; i++) {<br>
-			if (dev-&gt;resource[i].flags)<br>
+	        for (i = 0; i &lt; 4; i++) {<br>
+			struct resource *r = &amp;dev-&gt;resource[i];<br>
+			if ((r-&gt;start &amp; ~0x80) == 0x374) {<br>
+				r-&gt;start |= 2;<br>
+				r-&gt;end = r-&gt;start;<br>
+			}<br>
+			if (r-&gt;flags)<br>
 				pci_claim_resource(dev, i);<br>
 		}<br>
 	}<br>
diff -ur 2.3.21/arch/alpha/kernel/process.c linux/arch/alpha/kernel/process.c<br>
--- 2.3.21/arch/alpha/kernel/process.c	Tue Aug 31 21:50:44 1999<br>
+++ linux/arch/alpha/kernel/process.c	Tue Oct 12 14:56:50 1999<br>
@@ -236,10 +236,6 @@<br>
 	wrfpcr(FPCR_DYN_NORMAL | FPCR_INVD | FPCR_DZED | FPCR_OVFD | FPCR_INED);<br>
 }<br>
 <br>
-void release_thread(struct task_struct *dead_task)<br>
-{<br>
-}<br>
-<br>
 /*<br>
  * "alpha_clone()".. By the time we get here, the<br>
  * non-volatile registers have also been saved on the<br>
diff -ur 2.3.21/include/asm-alpha/pgtable.h linux/include/asm-alpha/pgtable.h<br>
--- 2.3.21/include/asm-alpha/pgtable.h	Wed Sep  8 22:54:14 1999<br>
+++ linux/include/asm-alpha/pgtable.h	Tue Oct 12 14:56:50 1999<br>
@@ -622,6 +622,6 @@<br>
 #define kern_addr_valid(addr)	(1)<br>
 <br>
 #define io_remap_page_range(start, busaddr, size, prot) \<br>
-	remap_page_range(start, virt_to_phys(ioremap(busaddr)), size, prot)<br>
+	remap_page_range(start, virt_to_phys(ioremap(busaddr, 0)), size, prot)<br>
 <br>
 #endif /* _ALPHA_PGTABLE_H */<br>
diff -ur 2.3.21/include/asm-alpha/processor.h linux/include/asm-alpha/processor.h<br>
--- 2.3.21/include/asm-alpha/processor.h	Thu Aug  5 02:48:00 1999<br>
+++ linux/include/asm-alpha/processor.h	Tue Oct 12 14:56:50 1999<br>
@@ -115,7 +115,7 @@<br>
 extern void start_thread(struct pt_regs *, unsigned long, unsigned long);<br>
 <br>
 /* Free all resources held by a thread. */<br>
-extern void release_thread(struct task_struct *);<br>
+#define release_thread(tsk)		do { } while (0)<br>
 <br>
 /* Create a kernel thread without removing it from tasklists.  */<br>
 extern long kernel_thread(int (*fn)(void *), void *arg, unsigned long flags);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0467.html">Drew Bernat: "Advice wanted: WebFS term project"</a>
<li> <b>Previous message:</b> <a href="0465.html">Mohit Aron: "paper on fine-grained OS timers"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
