<!-- received="Tue Oct 12 20:01:37 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 18:46:21 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="[PATCH] parport_pc fix for 2.3.21" -->
<!-- id="199910121646.SAA24651@harpo.csd.uu.se" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [PATCH] parport_pc fix for 2.3.21</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] parport_pc fix for 2.3.21</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Tue, 12 Oct 1999 18:46:21 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#474">[ date ]</a><a href="index.html#474">[ thread ]</a><a href="subject.html#474">[ subject ]</a><a href="author.html#474">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0475.html">Erik Mouw: "Re: Advice wanted: WebFS term project"</a>
<li> <b>Previous message:</b> <a href="0473.html">Tim Hockin: "Re: SMP process/processor binding"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
parport_pc.c in all recent 2.3.x kernels has two minor buglets:<br>
1. CONFIGA(pb) not FIFO(pb) should be used to read config register A<br>
   after placing the port in config mode.<br>
2. The code which checks the interrupt type incorrectly reads bit 7<br>
   in config register B. That info is in config register A.<br>
<p>
Fix follows below.<br>
<p>
/Mikael<br>
<p>
--- linux-2.3.21/drivers/parport/parport_pc.c.~1~	Sun Oct 10 12:40:41 1999<br>
+++ linux-2.3.21/drivers/parport/parport_pc.c	Tue Oct 12 13:10:24 1999<br>
@@ -1207,7 +1207,7 @@<br>
 <br>
 	outb (ECR_SPP &lt;&lt; 5, ECONTROL (pb)); /* Reset FIFO */<br>
 	outb (0xf4, ECONTROL (pb)); /* Configuration mode */<br>
-	config = inb (FIFO (pb));<br>
+	config = inb (CONFIGA (pb));<br>
 	pword = (config &gt;&gt; 4) &amp; 0x7;<br>
 	switch (pword) {<br>
 	case 0:<br>
@@ -1230,10 +1230,10 @@<br>
 	priv-&gt;pword = pword;<br>
 	printk (KERN_DEBUG "0x%lx: PWord is %d bits\n", pb-&gt;base, 8 * pword);<br>
 <br>
-	config = inb (CONFIGB (pb));<br>
 	printk (KERN_DEBUG "0x%lx: Interrupts are ISA-%s\n", pb-&gt;base,<br>
 		config &amp; 0x80 ? "Level" : "Pulses");<br>
 <br>
+	config = inb (CONFIGB (pb));<br>
 	if (!(config &amp; 0x40)) {<br>
 		printk (KERN_WARNING "0x%lx: IRQ conflict!\n", pb-&gt;base);<br>
 		pb-&gt;irq = PARPORT_IRQ_NONE;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0475.html">Erik Mouw: "Re: Advice wanted: WebFS term project"</a>
<li> <b>Previous message:</b> <a href="0473.html">Tim Hockin: "Re: SMP process/processor binding"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
