<!-- received="Tue Oct 12 20:13:08 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 18:48:40 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="[PATCH] drivers/net/wan/sbni.c fix for 2.3.21" -->
<!-- id="199910121648.SAA25952@harpo.csd.uu.se" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [PATCH] drivers/net/wan/sbni.c fix for 2.3.21</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] drivers/net/wan/sbni.c fix for 2.3.21</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Tue, 12 Oct 1999 18:48:40 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#477">[ date ]</a><a href="index.html#477">[ thread ]</a><a href="subject.html#477">[ subject ]</a><a href="author.html#477">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0478.html">Andi Kleen: "Re: load avg += 1"</a>
<li> <b>Previous message:</b> <a href="0476.html">Andi Kleen: "Re: How to create kernel semaphore that will timeout?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Building 2.3.21 with CONFIG_SBNI=y (that's drivers/net/wan/sbni.c)<br>
and gcc-2.95.1 results in:<br>
<p>
sbni.c: In function `sbni_ioctl':<br>
sbni.c:1283: warning: assignment makes pointer from integer without a cast<br>
sbni.c: In function `calc_crc':<br>
sbni.c:1375: Invalid `asm' statement:<br>
sbni.c:1375: fixed or forbidden register 1 (dx) was spilled for class DREG.<br>
sbni.c:1377: warning: control reaches end of non-void function<br>
<p>
The patch below fixes these problems.<br>
<p>
/Mikael<br>
<p>
[I reported this before for 2.3.18ac10, but apparently the<br>
 fix was lost or queued up somewhere.]<br>
<p>
--- linux-2.3.21/drivers/net/wan/sbni.c.~1~	Tue Oct 12 12:51:02 1999<br>
+++ linux-2.3.21/drivers/net/wan/sbni.c	Tue Oct 12 13:22:54 1999<br>
@@ -1280,10 +1280,12 @@<br>
 				return -EPERM;<br>
 			if(copy_from_user( tmpstr, ifr-&gt;ifr_data, 6))<br>
 				return -EFAULT;<br>
-			slave=dev_get(tmpstr);<br>
+			slave = dev_get_by_name(tmpstr);<br>
 			if(!(slave &amp;&amp; slave-&gt;flags &amp; IFF_UP &amp;&amp; dev-&gt;flags &amp; IFF_UP))<br>
 			{<br>
 				printk("%s: Both devices should be UP to enslave!\n",dev-&gt;name);<br>
+				if (slave)<br>
+					dev_put(slave);<br>
 				return -EINVAL;<br>
 			}<br>
 		<br>
@@ -1304,8 +1306,9 @@<br>
 				else<br>
 				{<br>
 					printk("%s: one of devices is already slave!\n",dev-&gt;name);<br>
-					return -EBUSY;<br>
+					error = -EBUSY;<br>
 				}<br>
+				dev_put(slave);<br>
 			}<br>
 			else<br>
 			{<br>
@@ -1359,7 +1362,7 @@<br>
 <br>
 unsigned long calc_crc(char *mem, int len, unsigned initial)<br>
 {<br>
-   <br>
+	unsigned crc, dummy_len;<br>
 	__asm__ (<br>
 		"xorl %%eax,%%eax\n\t"<br>
 		"1:\n\t"<br>
@@ -1367,13 +1370,12 @@<br>
 		"xorb %%dl,%%al\n\t"<br>
 		"shrl $8,%%edx\n\t"<br>
 		"xorl (%%edi,%%eax,4),%%edx\n\t"<br>
-		"loop 1b\n\t"<br>
-		"movl %%edx,%%eax"<br>
-		: <br>
-		: "S" (mem), "D" (&amp;crc32tab[0]), "c" (len), "d" (initial)<br>
-		: "eax", "edx", "ecx"<br>
+		"loop 1b"<br>
+		: "=d" (crc), "=c" (dummy_len)<br>
+		: "S" (mem), "D" (&amp;crc32tab[0]), "1" (len), "0" (initial)<br>
+		: "eax"<br>
 	);<br>
-	/* return crc; */<br>
+	return crc;<br>
 }<br>
 <br>
 #else<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0478.html">Andi Kleen: "Re: load avg += 1"</a>
<li> <b>Previous message:</b> <a href="0476.html">Andi Kleen: "Re: How to create kernel semaphore that will timeout?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
