<!-- received="Tue Oct 12 21:16:32 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 12:13:22 -0600" -->
<!-- name="Russell Kroll" -->
<!-- email="rkroll@exploits.org" -->
<!-- subject="RFC: ncr53c8xx fix for 2.3" -->
<!-- id="199910121813.MAA24431@exploits.org" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: RFC: ncr53c8xx fix for 2.3</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>RFC: ncr53c8xx fix for 2.3</h1>
<b>Russell Kroll</b> (<a href="mailto:rkroll@exploits.org"><i>rkroll@exploits.org</i></a>)<br>
<i>Tue, 12 Oct 1999 12:13:22 -0600</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#489">[ date ]</a><a href="index.html#489">[ thread ]</a><a href="subject.html#489">[ subject ]</a><a href="author.html#489">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0490.html">Bret Indrelee: "RE: How to create kernel semaphore that will timeout?"</a>
<li> <b>Previous message:</b> <a href="0488.html">Christian Reis: "Re: knfsd 1.5.x and patches provided with it.?? (I am so confused)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The ncr53c8xx driver quit finding my adapter around 2.3.15.  It turns out<br>
that the driver was just fine, and the kernel wasn't building the list of<br>
PCI devices properly.  In the 2.3.15 patch, a bunch of code got swapped<br>
around in arch/i386/bios/kernel/bios32.c, like this:<br>
<p>
The old way before 2.3.15:<br>
<p>
    if (device_fn &amp; 0x80)<br>
       return PCIBIOS_DEVICE_NOT_FOUND;<br>
    outb (FUNC(device_fn), 0xCF8);<br>
    outb (bus, 0xCFA);<br>
<p>
The new way after 2.3.15:<br>
<p>
#define SET(dev)               if (dev-&gt;devfn) return PCIBIOS_DEVICE_NOT_FOUND;                \<br>
                               outb(FUNC(dev-&gt;devfn), 0xCF8);                                  \<br>
                               outb(dev-&gt;bus-&gt;number, 0xCFA);<br>
<p>
Basically those 4 lines up in the "old way" were all replaced by SET(dev)<br>
macro calls in about 6 functions.<br>
<p>
Maybe it's just me, but (dev-&gt;devfn) != (dev-&gt;devfn &amp; 0x80)...  Miss that<br>
&amp; and you hit that return for every device other than the first one (#0)!<br>
<p>
So, here's the patch that works for me (tm) and makes the SCSI adapter<br>
(among others) show up again.  The "RFC" is to get some input from those<br>
in the know... am I breaking something fundamental by "fixing" it this<br>
way, or was the 2.3.15 patch which introduced SET() just broken?<br>
<p>
This is against 2.3.20.<br>
<p>
--- linux/arch/i386/kernel/pci-pc.c.stock	Tue Oct 12 10:50:47 1999<br>
+++ linux/arch/i386/kernel/pci-pc.c	Tue Oct 12 11:00:20 1999<br>
@@ -120,7 +120,7 @@<br>
 <br>
 #define IOADDR(devfn, where)	((0xC000 | ((devfn &amp; 0x78) &lt;&lt; 5)) + where)<br>
 #define FUNC(devfn)		(((devfn &amp; 7) &lt;&lt; 1) | 0xf0)<br>
-#define SET(dev)		if (dev-&gt;devfn) return PCIBIOS_DEVICE_NOT_FOUND;		\<br>
+#define SET(dev)		if (dev-&gt;devfn &amp; 0x80) return PCIBIOS_DEVICE_NOT_FOUND;		\<br>
 				outb(FUNC(dev-&gt;devfn), 0xCF8);					\<br>
 				outb(dev-&gt;bus-&gt;number, 0xCFA);<br>
 <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0490.html">Bret Indrelee: "RE: How to create kernel semaphore that will timeout?"</a>
<li> <b>Previous message:</b> <a href="0488.html">Christian Reis: "Re: knfsd 1.5.x and patches provided with it.?? (I am so confused)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
