<!-- received="Tue Oct 12 21:51:45 1999 EET DST" -->
<!-- sent="Tue, 12 Oct 1999 14:48:46 -0400 (EDT)" -->
<!-- name="Alexander Viro" -->
<!-- email="viro@math.psu.edu" -->
<!-- subject="Re: vma_list_sem" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9910121943300.17128-100000@clmsdevli" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: vma_list_sem</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: vma_list_sem</h1>
<b>Alexander Viro</b> (<a href="mailto:viro@math.psu.edu"><i>viro@math.psu.edu</i></a>)<br>
<i>Tue, 12 Oct 1999 14:48:46 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#493">[ date ]</a><a href="index.html#493">[ thread ]</a><a href="subject.html#493">[ subject ]</a><a href="author.html#493">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0494.html">Michael H. Warfield: "2.3.21: Serial mouse problem..."</a>
<li> <b>Previous message:</b> <a href="0492.html">Peter Hanecak: "[2.2.13-pre15] null pointer exception in find_inode"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Tue, 12 Oct 1999, manfreds wrote:<br>
<p>
<i>&gt; I've merged your patch and my patch, the result is below.</i><br>
<i>&gt; It still contains the complete debugging code, and I've not</i><br>
<i>&gt; yet performed any low-memory testing.</i><br>
<i>&gt; </i><br>
<i>&gt; I found one more find_vma() caller which performs no locking:</i><br>
<i>&gt; fs/super.c: copy_mount_options().</i><br>
<i>&gt; </i><br>
<i>&gt; Unfortunately, I found no clean solution for this function, but</i><br>
<i>&gt; I think my fix is acceptable. [there is an obscure race possible,</i><br>
<i>&gt; a multi-threaded application could fail with -EFAULT although</i><br>
<i>&gt; all parameters are valid].</i><br>
<p>
a) you've missed several pieces in arch/* and drivers/*<br>
b) correct code should not be punished. Ever. ASSERT is wrong.<br>
<p>
Some of missing pieces (modulo binfmt-related stuff):<br>
<p>
diff -urN linux-2.3.20/arch/mips/kernel/sysmips.c linux-bird.mm/arch/mips/kernel/sysmips.c<br>
--- linux-2.3.20/arch/mips/kernel/sysmips.c	Sun Sep 12 05:54:08 1999<br>
+++ linux-bird.mm/arch/mips/kernel/sysmips.c	Tue Oct 12 14:09:01 1999<br>
@@ -23,29 +23,6 @@<br>
 #include &lt;asm/sysmips.h&gt;<br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
-/*<br>
- * How long a hostname can we get from user space?<br>
- *  -EFAULT if invalid area or too long<br>
- *  0 if ok<br>
- *  &gt;0 EFAULT after xx bytes<br>
- */<br>
-static inline int<br>
-get_max_hostname(unsigned long address)<br>
-{<br>
-	struct vm_area_struct * vma;<br>
-<br>
-	vma = find_vma(current-&gt;mm, address);<br>
-	if (!vma || vma-&gt;vm_start &gt; address || !(vma-&gt;vm_flags &amp; VM_READ))<br>
-		return -EFAULT;<br>
-	address = vma-&gt;vm_end - address;<br>
-	if (address &gt; PAGE_SIZE)<br>
-		return 0;<br>
-	if (vma-&gt;vm_next &amp;&amp; vma-&gt;vm_next-&gt;vm_start == vma-&gt;vm_end &amp;&amp;<br>
-	   (vma-&gt;vm_next-&gt;vm_flags &amp; VM_READ))<br>
-		return 0;<br>
-	return address;<br>
-}<br>
-<br>
 asmlinkage int<br>
 sys_sysmips(int cmd, int arg1, int arg2, int arg3)<br>
 {<br>
diff -urN linux-2.3.20/arch/sparc64/kernel/sys_sparc32.c linux-bird.mm/arch/sparc64/kernel/sys_sparc32.c<br>
--- linux-2.3.20/arch/sparc64/kernel/sys_sparc32.c	Sun Sep 12 13:27:24 1999<br>
+++ linux-bird.mm/arch/sparc64/kernel/sys_sparc32.c	Tue Oct 12 14:31:18 1999<br>
@@ -1331,26 +1331,34 @@<br>
 	int i;<br>
 	unsigned long page;<br>
 	struct vm_area_struct *vma;<br>
+	int err;<br>
 <br>
 	*kernel = 0;<br>
 	if(!user)<br>
 		return 0;<br>
+	if(!(page = __get_free_page(GFP_KERNEL)))<br>
+		return -ENOMEM;<br>
+	down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	vma = find_vma(current-&gt;mm, (unsigned long)user);<br>
+	err = -EFAULT;<br>
 	if(!vma || (unsigned long)user &lt; vma-&gt;vm_start)<br>
-		return -EFAULT;<br>
+		goto out;<br>
 	if(!(vma-&gt;vm_flags &amp; VM_READ))<br>
-		return -EFAULT;<br>
+		goto out;<br>
 	i = vma-&gt;vm_end - (unsigned long) user;<br>
 	if(PAGE_SIZE &lt;= (unsigned long) i)<br>
 		i = PAGE_SIZE - 1;<br>
-	if(!(page = __get_free_page(GFP_KERNEL)))<br>
-		return -ENOMEM;<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	if(copy_from_user((void *) page, user, i)) {<br>
 		free_page(page);<br>
 		return -EFAULT;<br>
 	}<br>
 	*kernel = page;<br>
 	return 0;<br>
+out:<br>
+	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
+	free_page(page);<br>
+	return err;<br>
 }<br>
 <br>
 extern asmlinkage int sys_mount(char * dev_name, char * dir_name, char * type,<br>
diff -urN linux-2.3.20/drivers/char/drm/bufs.c linux-bird.mm/drivers/char/drm/bufs.c<br>
--- linux-2.3.20/drivers/char/drm/bufs.c	Tue Sep 21 16:13:03 1999<br>
+++ linux-bird.mm/drivers/char/drm/bufs.c	Tue Oct 12 14:10:51 1999<br>
@@ -477,8 +477,10 @@<br>
 			   -EFAULT);<br>
 <br>
 	if (request.count &gt;= dma-&gt;buf_count) {<br>
+		down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		virtual = do_mmap(filp, 0, dma-&gt;byte_count,<br>
 				  PROT_READ|PROT_WRITE, MAP_SHARED, 0);<br>
+		up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		if (virtual &gt; -1024UL) {<br>
 				/* Real error */<br>
 			retcode = (signed long)virtual;<br>
diff -urN linux-2.3.20/drivers/sgi/char/graphics.c linux-bird.mm/drivers/sgi/char/graphics.c<br>
--- linux-2.3.20/drivers/sgi/char/graphics.c	Sun Sep 12 13:27:36 1999<br>
+++ linux-bird.mm/drivers/sgi/char/graphics.c	Tue Oct 12 14:12:33 1999<br>
@@ -150,9 +150,11 @@<br>
 		 * sgi_graphics_mmap<br>
 		 */<br>
 		disable_gconsole ();<br>
+		down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		r = do_mmap (file, (unsigned long)vaddr,<br>
 			     cards[board].g_regs_size, PROT_READ|PROT_WRITE,<br>
 			     MAP_FIXED|MAP_PRIVATE, 0);<br>
+		up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		if (r)<br>
 			return r;<br>
 	}<br>
diff -urN linux-2.3.20/drivers/sgi/char/shmiq.c linux-bird.mm/drivers/sgi/char/shmiq.c<br>
--- linux-2.3.20/drivers/sgi/char/shmiq.c	Sun Sep 12 12:45:47 1999<br>
+++ linux-bird.mm/drivers/sgi/char/shmiq.c	Tue Oct 12 14:07:48 1999<br>
@@ -272,14 +272,17 @@<br>
 		}<br>
 <br>
 		vaddr = (unsigned long) req.user_vaddr;<br>
+		down(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		vma = find_vma (current-&gt;mm, vaddr);<br>
 		if (!vma){<br>
 			printk ("SHMIQ: could not find %lx the vma\n", vaddr);<br>
+			up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 			return -EINVAL;<br>
 		}<br>
 		s = req.arg * sizeof (struct shmqevent) + sizeof (struct sharedMemoryInputQueue);<br>
-		v = sys_munmap (vaddr, s);<br>
+		v = do_munmap (vaddr, s);<br>
 		do_mmap (filp, vaddr, s, PROT_READ | PROT_WRITE, MAP_PRIVATE|MAP_FIXED, 0);<br>
+		up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 		shmiqs [minor].events = req.arg;<br>
 		shmiqs [minor].mapped = 1;<br>
 		return 0;<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0494.html">Michael H. Warfield: "2.3.21: Serial mouse problem..."</a>
<li> <b>Previous message:</b> <a href="0492.html">Peter Hanecak: "[2.2.13-pre15] null pointer exception in find_inode"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
