<!-- received="Wed Oct 13 11:39:07 1999 EET DST" -->
<!-- sent="Wed, 13 Oct 1999 04:33:13 -0400" -->
<!-- name="Jeff Garzik" -->
<!-- email="jgarzik@pobox.com" -->
<!-- subject="[patch] dynamic char and block devices" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [patch] dynamic char and block devices</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] dynamic char and block devices</h1>
<b>Jeff Garzik</b> (<a href="mailto:jgarzik@pobox.com"><i>jgarzik@pobox.com</i></a>)<br>
<i>Wed, 13 Oct 1999 04:33:13 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#580">[ date ]</a><a href="index.html#580">[ thread ]</a><a href="subject.html#580">[ subject ]</a><a href="author.html#580">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0581.html">avik@altavista.net: "Re: [PATCH] Binding processes to selected CPUs"</a>
<li> <b>Previous message:</b> <a href="0579.html">Horst von Brand: "Re: PATCH - assembler glitches"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0661.html">Martin Dalecki: "Re: [patch] dynamic char and block devices"</a>
<li> <b>Reply:</b> <a href="0661.html">Martin Dalecki: "Re: [patch] dynamic char and block devices"</a>
<li> <b>Reply:</b> <a href="0686.html">Jeff Garzik: "Re: [patch] dynamic char and block devices"</a>
<li> <b>Reply:</b> <a href="0688.html">Jeff Garzik: "Re: [patch] dynamic char and block devices"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------6490499963B66DF0BB388384<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Linus and other penguins--<br>
<p>
The attached patch against 2.3.21 updates fs/devices.c to be dynamic,<br>
instead of using two static arrays indexed by major number.<br>
<p>
This shrinks the code, and gets rid of something indexed by major/minor<br>
-- helpful on the road to a better kdev_t.<br>
<p>
Tests ok on local system after a few days.  HFS was only tested to<br>
compile, not actually run-time tested, due to its experimental (a.k.a.<br>
probably broken) nature.<br>
<p>
The only other comment is that STATIC_ENT_POOL_MAX could probably be<br>
made smaller, as it is only needed during boot time.<br>
<p>
Full changelog below.<br>
<p>
Regards,<br>
<p>
	Jeff<br>
<p>
<p>
fs/devices.c:<br>
* replace chrdevs[], blkdevs[] static arrays with sorted linked list of<br>
devices.  This saves some space by eliminating two static, pre-init'd<br>
arrays and some duplicate code.<br>
* const-ify [kbc]devname return values.  All callers checked.<br>
<p>
include/linux/fs.h:<br>
* update [kbc]devname prototypes<br>
<p>
include/linux/kdev_t.h:<br>
* update kdevname prototype<br>
<p>
include/linux/hfs_sysdep.h:<br>
* update for new kdevname return type<br>
<p>
<pre>
-- 
Custom driver development	|    Never worry about theory as long
Open source programming		|    as the machinery does what it's
				|    supposed to do.  -- R. A. Heinlein
--------------6490499963B66DF0BB388384
Content-Type: text/plain; charset=us-ascii;
 name="dynamic-devices.patch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="dynamic-devices.patch"
<p>
Index: fs/devices.c
===================================================================
RCS file: /g/cvslan/linux_2_3/fs/devices.c,v
retrieving revision 1.1.1.1
diff -u -r1.1.1.1 devices.c
--- fs/devices.c	1999/10/07 07:42:42	1.1.1.1
+++ fs/devices.c	1999/10/13 08:25:26
@@ -7,6 +7,10 @@
  *
  *  Added kerneld support: Jacques Gelinas and Bjorn Ekwall
  *  (changed to kmod)
+ *
+ *  Ditched static array indexed by major number, and updated
+ *  to use a linked list:  Jeff Garzik, 13 Oct 1999
+ *
  */
 
 #include &lt;linux/config.h&gt;
@@ -15,49 +19,83 @@
 #include &lt;linux/string.h&gt;
 #include &lt;linux/sched.h&gt;
 #include &lt;linux/stat.h&gt;
+#include &lt;linux/slab.h&gt;
 #include &lt;linux/fcntl.h&gt;
+#include &lt;linux/init.h&gt;
 #include &lt;linux/errno.h&gt;
+
 #ifdef CONFIG_KMOD
 #include &lt;linux/kmod.h&gt;
-
 #include &lt;linux/tty.h&gt;
 
 /* serial module kmod load support */
 struct tty_driver *get_tty_driver(kdev_t device);
 #define isa_tty_dev(ma)	(ma == TTY_MAJOR || ma == TTYAUX_MAJOR)
 #define need_serial(ma,mi) (get_tty_driver(MKDEV(ma,mi)) == NULL)
-#endif
+#endif /* CONFIG_KMOD */
 
+typedef enum {
+	CHRDEV,
+	BLKDEV
+} devtype_t;
+	
+struct device_struct;
 struct device_struct {
+	devtype_t devtype;
+	int major;
 	const char * name;
 	struct file_operations * fops;
+	struct device_struct *next;
 };
 
-static struct device_struct chrdevs[MAX_CHRDEV] = {
-	{ NULL, NULL },
-};
+/* static array used during initialization, when kmalloc is absent */
+#define STATIC_ENT_POOL_MAX 512
+static struct device_struct __initdata static_ent_pool[STATIC_ENT_POOL_MAX];
+static unsigned int __initdata static_ent_pool_len = 0;
 
-static struct device_struct blkdevs[MAX_BLKDEV] = {
-	{ NULL, NULL },
-};
+/* linked list of registered char and block devices */
+static struct device_struct *devlist = NULL;
+
+/* is it safe to use kmalloc? */
+static int use_kmalloc = 0;
+
+static struct device_struct *ent_from_major(devtype_t devtype, int major)
+{
+	struct device_struct *tmp;
+	
+	for (tmp = devlist; tmp; tmp = tmp-&gt;next)
+		if (tmp-&gt;devtype == devtype &amp;&amp; tmp-&gt;major == major)
+			return tmp;
+
+	return NULL;
+}
+
+extern inline struct device_struct * chrdev_from_major (int major) {
+	return ent_from_major (CHRDEV, major);
+}
+
+extern inline struct device_struct * blkdev_from_major (int major) {
+	return ent_from_major (BLKDEV, major);
+}
 
+/* generate /proc/devices output */
 int get_device_list(char * page)
 {
-	int i;
 	int len;
-
+	struct device_struct *tmp;
+	
 	len = sprintf(page, "Character devices:\n");
-	for (i = 0; i &lt; MAX_CHRDEV ; i++) {
-		if (chrdevs[i].fops) {
-			len += sprintf(page+len, "%3d %s\n", i, chrdevs[i].name);
-		}
-	}
+
+	for (tmp = devlist; tmp; tmp = tmp-&gt;next)
+		if (tmp-&gt;devtype == CHRDEV)
+			len += sprintf(page+len, "%3d %s\n", tmp-&gt;major, tmp-&gt;name);
+
 	len += sprintf(page+len, "\nBlock devices:\n");
-	for (i = 0; i &lt; MAX_BLKDEV ; i++) {
-		if (blkdevs[i].fops) {
-			len += sprintf(page+len, "%3d %s\n", i, blkdevs[i].name);
-		}
-	}
+
+	for (tmp = devlist; tmp; tmp = tmp-&gt;next)
+		if (tmp-&gt;devtype == BLKDEV)
+			len += sprintf(page+len, "%3d %s\n", tmp-&gt;major, tmp-&gt;name);
+
 	return len;
 }
 
@@ -66,41 +104,44 @@
 	Load the driver if needed.
 */
 static struct file_operations * get_fops(
+	devtype_t devtype,
 	unsigned int major,
 	unsigned int minor,
 	unsigned int maxdev,
-	const char *mangle,		/* String to use to build the module name */
-	struct device_struct tb[])
+	const char *mangle)	/* String to use to build the module name */
 {
-	struct file_operations *ret = NULL;
+	struct device_struct *ent = ent_from_major (devtype, major);
+	
+	/*
+	 * I do get request for device 0. I have no idea why. It happen
+	 * at shutdown time for one. Without the following test, the
+	 * kernel will happily trigger a request_module() which will
+	 * trigger kmod and modprobe for nothing (since there
+	 * is no device with major number == 0. And furthermore
+	 * it locks the reboot process :-(
+	 *
+	 * Jacques Gelinas (<a href="mailto:jacques@solucorp.qc.ca">jacques@solucorp.qc.ca</a>)
+	 */
+	if (major == 0 || major &gt;= maxdev)
+		return NULL;
 
-	if (major &lt; maxdev){
 #ifdef CONFIG_KMOD
-		/*
-		 * I do get request for device 0. I have no idea why. It happen
-		 * at shutdown time for one. Without the following test, the
-		 * kernel will happily trigger a request_module() which will
-		 * trigger kmod and modprobe for nothing (since there
-		 * is no device with major number == 0. And furthermore
-		 * it locks the reboot process :-(
-		 *
-		 * Jacques Gelinas (<a href="mailto:jacques@solucorp.qc.ca">jacques@solucorp.qc.ca</a>)
-		 *
-		 * A. Haritsis &lt;<a href="mailto:ah@doc.ic.ac.uk">ah@doc.ic.ac.uk</a>&gt;: fix for serial module
-		 *  though we need the minor here to check if serial dev,
-		 *  we pass only the normal major char dev to kmod 
-		 *  as there is no other loadable dev on these majors
-		 */
-		if ((isa_tty_dev(major) &amp;&amp; need_serial(major,minor)) ||
-		    (major != 0 &amp;&amp; !tb[major].fops)) {
-			char name[20];
-			sprintf(name, mangle, major);
-			request_module(name);
-		}
-#endif
-		ret = tb[major].fops;
+	/*
+	 * A. Haritsis &lt;<a href="mailto:ah@doc.ic.ac.uk">ah@doc.ic.ac.uk</a>&gt;: fix for serial module
+	 *  though we need the minor here to check if serial dev,
+	 *  we pass only the normal major char dev to kmod 
+	 *  as there is no other loadable dev on these majors
+	 */
+	if ((isa_tty_dev(major) &amp;&amp; need_serial(major,minor)) || !ent) {
+		char name[20];
+		sprintf(name, mangle, major);
+		request_module(name);
+
+		ent = ent_from_major (devtype, major);
 	}
-	return ret;
+#endif
+
+	return ent ? ent-&gt;fops : NULL;
 }
 
 
@@ -110,82 +151,164 @@
 */
 struct file_operations * get_blkfops(unsigned int major)
 {
-	return get_fops (major,0,MAX_BLKDEV,"block-major-%d",blkdevs);
+	return get_fops (BLKDEV, major, 0, MAX_BLKDEV, "block-major-%d");
 }
 
 struct file_operations * get_chrfops(unsigned int major, unsigned int minor)
 {
-	return get_fops (major,minor,MAX_CHRDEV,"char-major-%d",chrdevs);
+	return get_fops (CHRDEV, major, minor, MAX_CHRDEV, "char-major-%d");
 }
 
-int register_chrdev(unsigned int major, const char * name, struct file_operations *fops)
+static struct device_struct * __init new_static_device (void)
+{
+	if (static_ent_pool_len &lt; STATIC_ENT_POOL_MAX) {
+		static_ent_pool_len++;
+		return &amp;static_ent_pool[static_ent_pool_len - 1];
+	}
+	return NULL;
+}
+
+static struct device_struct *new_device_struct
+			   (devtype_t devtype,
+			    unsigned int major,
+			    const char * name,
+			    struct file_operations *fops)
 {
+	struct device_struct *last, *tmp, *ent;
+
+	if (use_kmalloc)
+		ent = kmalloc (sizeof (*ent), GFP_KERNEL);
+	else
+		ent = new_static_device ();
+
+	if (!ent)
+		return NULL;
+	
+	ent-&gt;devtype = devtype;
+	ent-&gt;major = major;
+	ent-&gt;name = name;
+	ent-&gt;fops = fops;
+	ent-&gt;next = NULL;
+	
+	if (!devlist) {
+		devlist = ent;
+		return ent;
+	}
+	
+	tmp = devlist;
+	last = NULL;
+	while (tmp &amp;&amp; tmp-&gt;major &lt; major) {
+		last = tmp;
+		tmp = tmp-&gt;next;
+	}
+	
+	if (!last) {
+		ent-&gt;next = devlist;
+		devlist = ent;
+	} else {
+		ent-&gt;next = last-&gt;next;
+		last-&gt;next = ent;
+	}
+
+	return ent;
+}
+
+/*
+ * note - fops==NULL must succeed -jgarzik
+ */
+static int register_anydev(unsigned int maxdev,
+			   devtype_t devtype,
+			   unsigned int major,
+			   const char * name,
+			   struct file_operations *fops)
+{
+	struct device_struct *ent;
+	
+	if (major &gt;= maxdev)
+		return -EINVAL;
+
 	if (major == 0) {
-		for (major = MAX_CHRDEV-1; major &gt; 0; major--) {
-			if (chrdevs[major].fops == NULL) {
-				chrdevs[major].name = name;
-				chrdevs[major].fops = fops;
+		for (major = maxdev-1; major &gt; 0; major--) {
+			ent = ent_from_major(devtype, major);
+			if (!ent) {
+				ent = new_device_struct (devtype, major, name, fops);
+				if (!ent) return -ENOMEM;
 				return major;
 			}
+			else if (ent &amp;&amp; !ent-&gt;fops) {
+				ent-&gt;name = name;
+				ent-&gt;fops = fops;
+				return major;
+			}
 		}
 		return -EBUSY;
 	}
-	if (major &gt;= MAX_CHRDEV)
-		return -EINVAL;
-	if (chrdevs[major].fops &amp;&amp; chrdevs[major].fops != fops)
-		return -EBUSY;
-	chrdevs[major].name = name;
-	chrdevs[major].fops = fops;
+
+	ent = ent_from_major(devtype, major);
+
+	if (!ent) {
+		ent = new_device_struct (devtype, major, name, fops);
+		if (!ent) return -ENOMEM;
+	} else {
+		ent-&gt;name = name;
+		ent-&gt;fops = fops;
+	}
+
 	return 0;
 }
 
+
+
+int register_chrdev(unsigned int major, const char * name, struct file_operations *fops)
+{
+	return register_anydev (MAX_CHRDEV, CHRDEV, major, name, fops);
+}
+
 int register_blkdev(unsigned int major, const char * name, struct file_operations *fops)
 {
-	if (major == 0) {
-		for (major = MAX_BLKDEV-1; major &gt; 0; major--) {
-			if (blkdevs[major].fops == NULL) {
-				blkdevs[major].name = name;
-				blkdevs[major].fops = fops;
-				return major;
-			}
-		}
-		return -EBUSY;
+	return register_anydev (MAX_BLKDEV, BLKDEV, major, name, fops);
+}
+
+static int unregister_anydev(devtype_t devtype,
+			     unsigned int major,
+			     const char * name)
+{
+	struct device_struct *tmp, *last;
+
+	if (!devlist)
+		return -EINVAL;
+
+	tmp = devlist;
+	last = NULL;
+	while (tmp &amp;&amp; tmp-&gt;major != major) {
+		last = tmp;
+		tmp = tmp-&gt;next;
 	}
-	if (major &gt;= MAX_BLKDEV)
+	if (!tmp || strcmp(tmp-&gt;name, name))
 		return -EINVAL;
-	if (blkdevs[major].fops &amp;&amp; blkdevs[major].fops != fops)
-		return -EBUSY;
-	blkdevs[major].name = name;
-	blkdevs[major].fops = fops;
+
+	if (!last)
+		devlist = devlist-&gt;next;
+	else
+		last-&gt;next = tmp-&gt;next;
+
+	if (use_kmalloc)
+		kfree (tmp);
+
 	return 0;
 }
 
 int unregister_chrdev(unsigned int major, const char * name)
 {
-	if (major &gt;= MAX_CHRDEV)
-		return -EINVAL;
-	if (!chrdevs[major].fops)
-		return -EINVAL;
-	if (strcmp(chrdevs[major].name, name))
-		return -EINVAL;
-	chrdevs[major].name = NULL;
-	chrdevs[major].fops = NULL;
-	return 0;
+	return unregister_anydev (CHRDEV, major, name);
 }
 
 int unregister_blkdev(unsigned int major, const char * name)
 {
-	if (major &gt;= MAX_BLKDEV)
-		return -EINVAL;
-	if (!blkdevs[major].fops)
-		return -EINVAL;
-	if (strcmp(blkdevs[major].name, name))
-		return -EINVAL;
-	blkdevs[major].name = NULL;
-	blkdevs[major].fops = NULL;
-	return 0;
+	return unregister_anydev (BLKDEV, major, name);
 }
 
+
 /*
  * This routine checks whether a removable media has been changed,
  * and invalidates all buffer-cache-entries in that case. This
@@ -197,16 +320,17 @@
  */
 int check_disk_change(kdev_t dev)
 {
-	int i;
 	struct file_operations * fops;
 	struct super_block * sb;
+	struct device_struct *ent;
 
-	i = MAJOR(dev);
-	if (i &gt;= MAX_BLKDEV || (fops = blkdevs[i].fops) == NULL)
-		return 0;
-	if (fops-&gt;check_media_change == NULL)
+	ent = blkdev_from_major(MAJOR(dev));
+	if (!ent || !ent-&gt;fops)
 		return 0;
-	if (!fops-&gt;check_media_change(dev))
+
+	fops = ent-&gt;fops;
+	if (!fops-&gt;check_media_change ||
+	    !fops-&gt;check_media_change(dev))
 		return 0;
 
 	printk(KERN_DEBUG "VFS: Disk change detected on device %s\n",
@@ -349,34 +473,40 @@
  * Print device name (in decimal, hexadecimal or symbolic)
  * Note: returns pointer to static data!
  */
-char * kdevname(kdev_t dev)
+const char * kdevname(kdev_t dev)
 {
 	static char buffer[32];
 	sprintf(buffer, "%02x:%02x", MAJOR(dev), MINOR(dev));
 	return buffer;
 }
 
-char * bdevname(kdev_t dev)
+static const char *anydevname (devtype_t devtype, kdev_t dev)
 {
 	static char buffer[32];
-	const char * name = blkdevs[MAJOR(dev)].name;
+	const char * name;
+	struct device_struct *ent = ent_from_major(devtype, MAJOR(dev));
 
-	if (!name)
-		name = "unknown-block";
+	if (ent)
+		name = ent-&gt;name;
+	else
+		switch (devtype) {
+		case CHRDEV:	name = "unknown-char"; break;
+		case BLKDEV:	name = "unknown-block"; break;
+		default:	name = "unknown"; break;
+		}
 
 	sprintf(buffer, "%s(%d,%d)", name, MAJOR(dev), MINOR(dev));
 	return buffer;
 }
 
-char * cdevname(kdev_t dev)
+const char * bdevname(kdev_t dev)
 {
-	static char buffer[32];
-	const char * name = chrdevs[MAJOR(dev)].name;
+	return anydevname (BLKDEV, dev);
+}
 
-	if (!name)
-		name = "unknown-char";
-	sprintf(buffer, "%s(%d,%d)", name, MAJOR(dev), MINOR(dev));
-	return buffer;
+const char * cdevname(kdev_t dev)
+{
+	return anydevname (CHRDEV, dev);
 }
 
 void init_special_inode(struct inode *inode, umode_t mode, int rdev)
@@ -396,3 +526,38 @@
 	else
 		printk(KERN_DEBUG "init_special_inode: bogus imode (%o)\n", mode);
 }
+
+
+/*
+ * copy device list from static, __initdata'd vector into dynamic RAM
+ */
+
+static int __init devices_copy_init_list (void)
+{
+	struct device_struct *ent, *tmp, *last;
+	
+	tmp = devlist;
+	last = NULL;
+	while (tmp != NULL) {
+		ent = kmalloc (sizeof (*ent), GFP_KERNEL);
+		if (!ent)
+			panic("kmalloc failed: Cannot init devices subsystem");
+		memcpy (ent, tmp, sizeof (*ent));
+		
+		if (last == NULL) {
+			devlist = tmp = ent;
+		} else {
+			last-&gt;next = tmp = ent;
+		}
+		
+		last = tmp;
+		tmp = tmp-&gt;next;
+	}
+	
+	use_kmalloc = 1;
+	
+	return 0;
+}
+
+/* cheap way to get something done "sometime after kmalloc works" */
+module_init(devices_copy_init_list); 
Index: include/linux/fs.h
===================================================================
RCS file: /g/cvslan/linux_2_3/include/linux/fs.h,v
retrieving revision 1.1.1.5
retrieving revision 1.1.1.5.2.1
diff -u -r1.1.1.5 -r1.1.1.5.2.1
--- include/linux/fs.h	1999/10/12 01:24:41	1.1.1.5
+++ include/linux/fs.h	1999/10/12 10:23:54	1.1.1.5.2.1
@@ -741,9 +741,9 @@
 extern int chrdev_open(struct inode *, struct file *);
 extern struct file_operations def_chr_fops;
 extern struct inode_operations chrdev_inode_operations;
-extern char * bdevname(kdev_t);
-extern char * cdevname(kdev_t);
-extern char * kdevname(kdev_t);
+extern const char * bdevname(kdev_t);
+extern const char * cdevname(kdev_t);
+extern const char * kdevname(kdev_t);
 extern void init_special_inode(struct inode *, umode_t, int);
 
 extern void init_fifo(struct inode *);
Index: include/linux/hfs_sysdep.h
===================================================================
RCS file: /g/cvslan/linux_2_3/include/linux/hfs_sysdep.h,v
retrieving revision 1.1.1.1
retrieving revision 1.1.1.1.18.1
diff -u -r1.1.1.1 -r1.1.1.1.18.1
--- include/linux/hfs_sysdep.h	1999/10/07 07:42:52	1.1.1.1
+++ include/linux/hfs_sysdep.h	1999/10/12 10:23:54	1.1.1.1.18.1
@@ -121,7 +121,7 @@
 	sys_mdb-&gt;s_dirt = 1;
 }
 
-extern inline char *hfs_mdb_name(hfs_sysmdb sys_mdb) {
+extern inline const char *hfs_mdb_name(hfs_sysmdb sys_mdb) {
 	return kdevname(sys_mdb-&gt;s_dev);
 }
 
Index: include/linux/kdev_t.h
===================================================================
RCS file: /g/cvslan/linux_2_3/include/linux/kdev_t.h,v
retrieving revision 1.1.1.1
retrieving revision 1.1.1.1.18.1
diff -u -r1.1.1.1 -r1.1.1.1.18.1
--- include/linux/kdev_t.h	1999/10/07 07:42:51	1.1.1.1
+++ include/linux/kdev_t.h	1999/10/12 10:23:54	1.1.1.1.18.1
@@ -73,7 +73,8 @@
 #define MKDEV(ma,mi)	(((ma) &lt;&lt; MINORBITS) | (mi))
 #define B_FREE		0xffff		/* yuk */
 
-extern char * kdevname(kdev_t);	/* note: returns pointer to static data! */
+/* note: returns pointer to static data! */
+extern const char * kdevname(kdev_t);
 
 /*
 As long as device numbers in the outside world have 16 bits only,
<p>
--------------6490499963B66DF0BB388384--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0581.html">avik@altavista.net: "Re: [PATCH] Binding processes to selected CPUs"</a>
<li> <b>Previous message:</b> <a href="0579.html">Horst von Brand: "Re: PATCH - assembler glitches"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0661.html">Martin Dalecki: "Re: [patch] dynamic char and block devices"</a>
<li> <b>Reply:</b> <a href="0661.html">Martin Dalecki: "Re: [patch] dynamic char and block devices"</a>
<li> <b>Reply:</b> <a href="0686.html">Jeff Garzik: "Re: [patch] dynamic char and block devices"</a>
<li> <b>Reply:</b> <a href="0688.html">Jeff Garzik: "Re: [patch] dynamic char and block devices"</a>
<!-- reply="end" -->
</ul>
</font></body>
