<!-- received="Wed Oct 13 13:40:04 1999 EET DST" -->
<!-- sent="Wed, 13 Oct 1999 20:30:06 +1000" -->
<!-- name="Bruce Janson" -->
<!-- email="bruce@cs.usyd.edu.au" -->
<!-- subject="bug: linux 2.2.12 SMP NFS client directory entry race" -->
<!-- id="19991013103318Z156983-13328+176@vger.rutgers.edu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: bug: linux 2.2.12 SMP NFS client directory entry race</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>bug: linux 2.2.12 SMP NFS client directory entry race</h1>
<b>Bruce Janson</b> (<a href="mailto:bruce@cs.usyd.edu.au"><i>bruce@cs.usyd.edu.au</i></a>)<br>
<i>Wed, 13 Oct 1999 20:30:06 +1000</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#605">[ date ]</a><a href="index.html#605">[ thread ]</a><a href="subject.html#605">[ subject ]</a><a href="author.html#605">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0606.html">Stephen C. Tweedie: "Re: locking question: do_mmap(), do_munmap()"</a>
<li> <b>Previous message:</b> <a href="0604.html">David Woodhouse: "Re: Monterey apps under Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
When executed on an otherwise idle Linux 2.2.12 kernel (SMP, on a dual<br>
processor) in a directory on an NFS file system the following program should<br>
be silent, but it eventually does produce output.  Apparently after some<br>
(alas, variable) number of attempts the ".." entry returned by readdir() in<br>
two separate processes in two separate directories becomes confused (usually<br>
swapped).  I am using a Slackware 4.0 distribution.  The NFS file server<br>
is a SunOS 5.6 computer.<br>
<p>
$ cat &gt; 1.c &lt;&lt;EOF<br>
#include	&lt;sys/types.h&gt;<br>
#include	&lt;sys/stat.h&gt;<br>
#include	&lt;errno.h&gt;<br>
#include	&lt;dirent.h&gt;<br>
<p>
main()<br>
{<br>
	char		*r;<br>
	struct stat	root_statb;<br>
	int		tries;<br>
<p>
	switch (fork())<br>
	{<br>
	case -1:<br>
		perror("fork");<br>
		exit(1);<br>
	<br>
	case 0:		/* child */<br>
		r = "x";<br>
		break;<br>
	<br>
	default:	/* self */<br>
		r = "y";<br>
		break;<br>
	}<br>
<p>
	mkdir(r, 0700);<br>
	chdir(r);<br>
<p>
	lstat(".", &amp;root_statb);<br>
<p>
	tries = 0;<br>
<p>
	for (;;)<br>
	{<br>
		DIR		*d;<br>
		struct dirent	*e;<br>
<p>
		tries++;<br>
<p>
		rmdir("0");<br>
		mkdir("0", 0700);<br>
<p>
		d = opendir("0");<br>
<p>
		while ((e = readdir(d)) != (struct dirent *)0)<br>
		{<br>
			if (e-&gt;d_ino == (long)0)<br>
				continue;<br>
<p>
			if (e-&gt;d_name[0] == '\0')<br>
				continue;<br>
<p>
			if (strcmp(&amp;e-&gt;d_name[0], "..") == 0)<br>
			{<br>
				if (e-&gt;d_ino != root_statb.st_ino)<br>
				{<br>
					printf("readdir_inumber %ld, root_statb.st_ino %ld, %d tries\n", e-&gt;d_ino, root_statb.st_ino, tries);<br>
					exit(0);<br>
				}<br>
<p>
				break;<br>
			}<br>
		}<br>
<p>
		closedir(d);<br>
	}<br>
}<br>
EOF<br>
$ cc -o 1 1.c<br>
$ ./1<br>
readdir_inumber 954631, root_statb.st_ino 358799, 48 tries<br>
readdir_inumber 358799, root_statb.st_ino 954631, 50 tries<br>
$ ldd ./1<br>
        libc.so.5 =&gt; /lib/libc.so.5 (0x4000b000)<br>
$ cc -v<br>
Reading specs from /usr/lib/gcc-lib/i486-linux/2.7.2.3/specs<br>
gcc version 2.7.2.3<br>
$ uname -a<br>
Linux citrix 2.2.12 #3 SMP Tue Oct 5 01:15:04 EST 1999 i686 unknown<br>
$ <br>
<p>
Regards,<br>
bruce.<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0606.html">Stephen C. Tweedie: "Re: locking question: do_mmap(), do_munmap()"</a>
<li> <b>Previous message:</b> <a href="0604.html">David Woodhouse: "Re: Monterey apps under Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
