<!-- received="Wed Oct 13 21:22:44 1999 EET DST" -->
<!-- sent="Wed, 13 Oct 1999 20:19:12 +0200 (CEST)" -->
<!-- name="manfreds" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="[patch,beta] ipc/sem threaded" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [patch,beta] ipc/sem threaded</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch,beta] ipc/sem threaded</h1>
<b>manfreds</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Wed, 13 Oct 1999 20:19:12 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#664">[ date ]</a><a href="index.html#664">[ thread ]</a><a href="subject.html#664">[ subject ]</a><a href="author.html#664">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0665.html">Stephen Frost: "Re: i486 can't keep up with 2.2.12 ?"</a>
<li> <b>Previous message:</b> <a href="0663.html">Jean-Francois Brousseau: "Fwd: Re: : : Becoming a Linux Hacker?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I've threaded ipc/sem.c. The core implementation remained unchanged,<br>
but now every semaphore set has it's own spinlock instead of lock_kernel()<br>
[The synchronization is copied from ipc/msg.c]<br>
<p>
The code is beta quality [it compiles, it boots, and samba doesn't<br>
crash immediately, but not yet fully tested].<br>
<p>
The patch is again 2.3.20, but the affected file [ipc/sem.c and<br>
include/linux/sem.h] didn't change in 2.3.21<br>
<p>
Please comment,<br>
	Manfred<br>
<p>
&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;<br>
// $Header: /pub/cvs/ms/patches/patch-ipcsem,v 1.1 1999/10/13 18:15:37 manfreds Exp $<br>
// Kernel Version:<br>
//  VERSION = 2<br>
//  PATCHLEVEL = 3<br>
//  SUBLEVEL = 20<br>
//  EXTRAVERSION =<br>
diff -r -u 2.3/include/linux/sem.h build-2.3/include/linux/sem.h<br>
--- 2.3/include/linux/sem.h	Thu Aug 26 17:59:51 1999<br>
+++ build-2.3/include/linux/sem.h	Wed Oct 13 19:23:50 1999<br>
@@ -81,15 +81,16 @@<br>
 	int	sempid;		/* pid of last operation */<br>
 };<br>
 <br>
-/* One queue for each semaphore set in the system. */<br>
+/* One queue for each sleeping process in the system. */<br>
 struct sem_queue {<br>
 	struct sem_queue *	next;	 /* next entry in the queue */<br>
 	struct sem_queue **	prev;	 /* previous entry in the queue, *(q-&gt;prev) == q */<br>
-	wait_queue_head_t	sleeper; /* sleeping process */<br>
+	struct task_struct*	sleeper; /* this process */<br>
 	struct sem_undo *	undo;	 /* undo structure */<br>
 	int    			pid;	 /* process id of requesting process */<br>
 	int    			status;	 /* completion status of operation */<br>
 	struct semid_ds *	sma;	 /* semaphore array for operations */<br>
+	int			id;	 /* internal sem id */<br>
 	struct sembuf *		sops;	 /* array of pending operations */<br>
 	int			nsops;	 /* number of operations */<br>
 	int			alter;	 /* operation will alter semaphore */<br>
diff -r -u 2.3/ipc/sem.c build-2.3/ipc/sem.c<br>
--- 2.3/ipc/sem.c	Thu Aug 26 17:59:52 1999<br>
+++ build-2.3/ipc/sem.c	Wed Oct 13 20:06:08 1999<br>
@@ -54,7 +54,7 @@<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
 #include &lt;linux/malloc.h&gt;<br>
-#include &lt;linux/smp_lock.h&gt;<br>
+#include &lt;linux/spinlock.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/proc_fs.h&gt;<br>
 <br>
@@ -68,10 +68,18 @@<br>
 static int sysvipc_sem_read_proc(char *buffer, char **start, off_t offset, int length, int *eof, void *data);<br>
 #endif<br>
 <br>
-static struct semid_ds *semary[SEMMNI];<br>
-static int used_sems = 0, used_semids = 0;<br>
-static DECLARE_WAIT_QUEUE_HEAD(sem_lock);<br>
+struct semid_ary<br>
+{<br>
+	spinlock_t lock;<br>
+	struct semid_ds* s;<br>
+};<br>
+<br>
+static struct semid_ary semary[SEMMNI];<br>
+<br>
+static DECLARE_MUTEX(sem_lock);<br>
 static int max_semid = 0;<br>
+static int used_sems = 0;<br>
+static int used_semids = 0;<br>
 <br>
 static unsigned short sem_seq = 0;<br>
 <br>
@@ -82,10 +90,11 @@<br>
 	struct proc_dir_entry *ent;<br>
 #endif<br>
 <br>
-	init_waitqueue_head(&amp;sem_lock);<br>
 	used_sems = used_semids = max_semid = sem_seq = 0;<br>
-	for (i = 0; i &lt; SEMMNI; i++)<br>
-		semary[i] = (struct semid_ds *) IPC_UNUSED;<br>
+	for (i = 0; i &lt; SEMMNI; i++) {<br>
+		semary[i].lock = SPIN_LOCK_UNLOCKED;<br>
+		semary[i].s = NULL;<br>
+	}<br>
 #ifdef CONFIG_PROC_FS<br>
 	ent = create_proc_entry("sysvipc/sem", 0, 0);<br>
 	ent-&gt;read_proc = sysvipc_sem_read_proc;<br>
@@ -99,10 +108,10 @@<br>
 	struct semid_ds *sma;<br>
 <br>
 	for (id = 0; id &lt;= max_semid; id++) {<br>
-		while ((sma = semary[id]) == IPC_NOID)<br>
-			interruptible_sleep_on (&amp;sem_lock);<br>
-		if (sma == IPC_UNUSED)<br>
+		sma = semary[id].s;<br>
+		if(sma==NULL)<br>
 			continue;<br>
+<br>
 		if (key == sma-&gt;sem_perm.key)<br>
 			return id;<br>
 	}<br>
@@ -120,20 +129,17 @@<br>
 		return -EINVAL;<br>
 	if (used_sems + nsems &gt; SEMMNS)<br>
 		return -ENOSPC;<br>
-	for (id = 0; id &lt; SEMMNI; id++)<br>
-		if (semary[id] == IPC_UNUSED) {<br>
-			semary[id] = (struct semid_ds *) IPC_NOID;<br>
+	for (id = 0; id &lt; SEMMNI; id++) {<br>
+		if(semary[id].s == NULL)<br>
 			goto found;<br>
-		}<br>
+	}<br>
 	return -ENOSPC;<br>
 found:<br>
 	size = sizeof (*sma) + nsems * sizeof (struct sem);<br>
 	used_sems += nsems;<br>
 	sma = (struct semid_ds *) kmalloc (size, GFP_KERNEL);<br>
 	if (!sma) {<br>
-		semary[id] = (struct semid_ds *) IPC_UNUSED;<br>
 		used_sems -= nsems;<br>
-		wake_up (&amp;sem_lock);<br>
 		return -ENOMEM;<br>
 	}<br>
 	memset (sma, 0, size);<br>
@@ -152,8 +158,9 @@<br>
 	if (id &gt; max_semid)<br>
 		max_semid = id;<br>
 	used_semids++;<br>
-	semary[id] = sma;<br>
-	wake_up (&amp;sem_lock);<br>
+	spin_lock(&amp;semary[id].lock);<br>
+	semary[id].s = sma;<br>
+	spin_unlock(&amp;semary[id].lock);<br>
 	return (unsigned int) sma-&gt;sem_perm.seq * SEMMNI + id;<br>
 }<br>
 <br>
@@ -162,9 +169,10 @@<br>
 	int id, err = -EINVAL;<br>
 	struct semid_ds *sma;<br>
 <br>
-	lock_kernel();<br>
 	if (nsems &lt; 0 || nsems &gt; SEMMSL)<br>
-		goto out;<br>
+		return -EINVAL;<br>
+	down(&amp;sem_lock);<br>
+	<br>
 	if (key == IPC_PRIVATE) {<br>
 		err = newary(key, nsems, semflg);<br>
 	} else if ((id = findkey (key)) == -1) {  /* key not used */<br>
@@ -175,7 +183,7 @@<br>
 	} else if (semflg &amp; IPC_CREAT &amp;&amp; semflg &amp; IPC_EXCL) {<br>
 		err = -EEXIST;<br>
 	} else {<br>
-		sma = semary[id];<br>
+		sma = semary[id].s;<br>
 		if (nsems &gt; sma-&gt;sem_nsems)<br>
 			err = -EINVAL;<br>
 		else if (ipcperms(&amp;sma-&gt;sem_perm, semflg))<br>
@@ -183,8 +191,8 @@<br>
 		else<br>
 			err = (int) sma-&gt;sem_perm.seq * SEMMNI + id;<br>
 	}<br>
-out:<br>
-	unlock_kernel();<br>
+<br>
+	up(&amp;sem_lock);<br>
 	return err;<br>
 }<br>
 <br>
@@ -304,7 +312,7 @@<br>
                 /* Does q-&gt;sleeper still need to sleep? */<br>
                 if (error &lt;= 0) {<br>
                                 /* Found one, wake it up */<br>
-                        wake_up_interruptible(&amp;q-&gt;sleeper);<br>
+			wake_up_process(q-&gt;sleeper);<br>
                         if (error == 0 &amp;&amp; q-&gt;alter) {<br>
                                 /* if q-&gt; alter let it self try */<br>
                                 q-&gt;status = 1;<br>
@@ -365,17 +373,17 @@<br>
 /* Free a semaphore set. */<br>
 static void freeary (int id)<br>
 {<br>
-	struct semid_ds *sma = semary[id];<br>
+	struct semid_ds *sma;<br>
 	struct sem_undo *un;<br>
 	struct sem_queue *q;<br>
 <br>
-	/* Invalidate this semaphore set */<br>
-	sma-&gt;sem_perm.seq++;<br>
-	sem_seq = (sem_seq+1) % ((unsigned)(1&lt;&lt;31)/SEMMNI); /* increment, but avoid overflow */<br>
+	/* we own both locks, noone can get in */<br>
+	sma = semary[id].s;<br>
+<br>
 	used_sems -= sma-&gt;sem_nsems;<br>
+	semary[id].s = NULL;<br>
 	if (id == max_semid)<br>
-		while (max_semid &amp;&amp; (semary[--max_semid] == IPC_UNUSED));<br>
-	semary[id] = (struct semid_ds *) IPC_UNUSED;<br>
+		while (max_semid &amp;&amp; (semary[--max_semid].s == NULL));<br>
 	used_semids--;<br>
 <br>
 	/* Invalidate the existing undo structures for this semaphore set.<br>
@@ -388,31 +396,18 @@<br>
 	for (q = sma-&gt;sem_pending; q; q = q-&gt;next) {<br>
 		q-&gt;status = -EIDRM;<br>
 		q-&gt;prev = NULL;<br>
-		wake_up_interruptible(&amp;q-&gt;sleeper); /* doesn't sleep! */<br>
+		wake_up_process(q-&gt;sleeper); /* doesn't sleep */<br>
 	}<br>
 <br>
 	kfree(sma);<br>
 }<br>
 <br>
-asmlinkage long sys_semctl (int semid, int semnum, int cmd, union semun arg)<br>
+int semctl_nolock(int semid, int semnum, int cmd, union semun arg)<br>
 {<br>
-	struct semid_ds *buf = NULL;<br>
-	struct semid_ds tbuf;<br>
-	int i, id, val = 0;<br>
-	struct semid_ds *sma;<br>
-	struct ipc_perm *ipcp;<br>
-	struct sem *curr = NULL;<br>
-	struct sem_undo *un;<br>
-	unsigned int nsems;<br>
-	ushort *array = NULL;<br>
-	ushort sem_io[SEMMSL];<br>
 	int err = -EINVAL;<br>
+	int lid = semid % SEMMNI;<br>
 <br>
-	lock_kernel();<br>
-	if (semid &lt; 0 || semnum &lt; 0 || cmd &lt; 0)<br>
-		goto out;<br>
-<br>
-	switch (cmd) {<br>
+	switch(cmd) {<br>
 	case IPC_INFO:<br>
 	case SEM_INFO:<br>
 	{<br>
@@ -428,174 +423,201 @@<br>
 		seminfo.semusz = SEMUSZ;<br>
 		seminfo.semaem = SEMAEM;<br>
 		if (cmd == SEM_INFO) {<br>
+			down(&amp;sem_lock);<br>
 			seminfo.semusz = used_semids;<br>
 			seminfo.semaem = used_sems;<br>
+			up(&amp;sem_lock);<br>
 		}<br>
-		err = -EFAULT;<br>
 		if (copy_to_user (tmp, &amp;seminfo, sizeof(struct seminfo))) <br>
-			goto out;<br>
-		err = max_semid;<br>
-		goto out;<br>
+			return -EFAULT;<br>
+		return max_semid;<br>
 	}<br>
-<br>
 	case SEM_STAT:<br>
-		buf = arg.buf;<br>
-		err = -EINVAL;<br>
+	{<br>
+		struct semid_ds *sma;<br>
+		struct semid_ds tbuf;<br>
+		int id;<br>
+<br>
 		if (semid &gt; max_semid)<br>
-			goto out;<br>
-		sma = semary[semid];<br>
-		if (sma == IPC_UNUSED || sma == IPC_NOID)<br>
-			goto out;<br>
+			return -EINVAL;<br>
+<br>
+		spin_lock(&amp;semary[lid].lock);<br>
+		err = -EINVAL;<br>
+		sma = semary[semid].s;<br>
+		if (sma ==  NULL)<br>
+			goto out_unlock;<br>
 		err = -EACCES;<br>
 		if (ipcperms (&amp;sma-&gt;sem_perm, S_IRUGO))<br>
-			goto out;<br>
+			goto out_unlock;<br>
 		id = (unsigned int) sma-&gt;sem_perm.seq * SEMMNI + semid;<br>
+		memset(&amp;tbuf,0,sizeof(tbuf));<br>
 		tbuf.sem_perm   = sma-&gt;sem_perm;<br>
 		tbuf.sem_otime  = sma-&gt;sem_otime;<br>
 		tbuf.sem_ctime  = sma-&gt;sem_ctime;<br>
 		tbuf.sem_nsems  = sma-&gt;sem_nsems;<br>
-		err = -EFAULT;<br>
-		if (copy_to_user (buf, &amp;tbuf, sizeof(*buf)) == 0)<br>
-			err = id;<br>
-		goto out;<br>
+		spin_unlock(&amp;semary[lid].lock);<br>
+		if (copy_to_user (arg.buf, &amp;tbuf, sizeof(tbuf)))<br>
+			return -EFAULT;<br>
+		return id;<br>
 	}<br>
+	default:<br>
+		return -EINVAL;<br>
+	}<br>
+	return err;<br>
+out_unlock:<br>
+	spin_unlock(&amp;semary[lid].lock);<br>
+	return err;<br>
+}<br>
 <br>
-	id = (unsigned int) semid % SEMMNI;<br>
-	sma = semary [id];<br>
-	err = -EINVAL;<br>
-	if (sma == IPC_UNUSED || sma == IPC_NOID)<br>
-		goto out;<br>
-	ipcp = &amp;sma-&gt;sem_perm;<br>
-	nsems = sma-&gt;sem_nsems;<br>
-	err = -EIDRM;<br>
+int semctl_locked_unlock(int semid, int semnum, int cmd, union semun arg)<br>
+{<br>
+	struct semid_ds *sma;<br>
+	struct semid_ds tbuf;<br>
+	int err;<br>
+	int lid = semid % SEMMNI;<br>
+<br>
+	sma = semary[lid].s;<br>
+	err=-EINVAL;<br>
+	if (sma == NULL)<br>
+		goto out_unlock;<br>
+	err=-EIDRM;<br>
 	if (sma-&gt;sem_perm.seq != (unsigned int) semid / SEMMNI)<br>
-		goto out;<br>
+		goto out_unlock;<br>
 <br>
+	err = -EACCES;<br>
+	if (ipcperms(&amp;sma-&gt;sem_perm, S_IRUGO))<br>
+			goto out_unlock;	<br>
+	<br>
 	switch (cmd) {<br>
-	case GETVAL:<br>
-	case GETPID:<br>
-	case GETNCNT:<br>
-	case GETZCNT:<br>
-	case SETVAL:<br>
+	case GETALL:<br>
+	{<br>
+		ushort *array = arg.array;<br>
+		ushort sem_io[SEMMSL];<br>
+		int i;<br>
+		int nsems = sma-&gt;sem_nsems;<br>
+<br>
+		for (i = 0; i &lt; sma-&gt;sem_nsems; i++)<br>
+			sem_io[i] = sma-&gt;sem_base[i].semval;<br>
+		spin_unlock(&amp;semary[lid].lock);<br>
+		if (copy_to_user (array, sem_io, nsems*sizeof(ushort)))<br>
+			return -EFAULT;<br>
+		return 0;<br>
+	}<br>
+	case IPC_STAT:<br>
+		memset(&amp;tbuf,0,sizeof(tbuf));<br>
+		tbuf.sem_perm   = sma-&gt;sem_perm;<br>
+		tbuf.sem_otime  = sma-&gt;sem_otime;<br>
+		tbuf.sem_ctime  = sma-&gt;sem_ctime;<br>
+		tbuf.sem_nsems  = sma-&gt;sem_nsems;<br>
+		spin_unlock(&amp;semary[lid].lock);<br>
+		if (copy_to_user (arg.buf, &amp;tbuf, sizeof(tbuf)))<br>
+			return -EFAULT;<br>
+		return 0;<br>
+default:<br>
 		err = -EINVAL;<br>
-		if (semnum &gt;= nsems)<br>
-			goto out;<br>
-		curr = &amp;sma-&gt;sem_base[semnum];<br>
-		break;<br>
 	}<br>
+out_unlock:<br>
+	spin_unlock(&amp;semary[lid].lock);<br>
+	return err;<br>
+<br>
+}<br>
+<br>
+int semctl_locked(int semid, int semnum, int cmd, union semun arg)<br>
+{<br>
+	struct semid_ds *sma;<br>
+	int lid = semid % SEMMNI;<br>
+	struct sem *curr;<br>
+<br>
+	sma = semary[lid].s;<br>
+	if (sma == NULL)<br>
+		return -EINVAL;<br>
+<br>
+	if (ipcperms (&amp;sma-&gt;sem_perm, S_IRUGO))<br>
+		return -EACCES;<br>
+<br>
+	if (sma-&gt;sem_perm.seq != (unsigned int) semid / SEMMNI)<br>
+		return -EIDRM;<br>
+<br>
+	if (semnum &gt;= sma-&gt;sem_nsems)<br>
+		return -EINVAL;<br>
+<br>
+	curr = &amp;sma-&gt;sem_base[semnum];<br>
 <br>
 	switch (cmd) {<br>
 	case GETVAL:<br>
+		return curr-&gt;semval;<br>
 	case GETPID:<br>
+		return curr-&gt;sempid &amp; 0xffff;<br>
 	case GETNCNT:<br>
+		return count_semncnt(sma,semnum);<br>
 	case GETZCNT:<br>
-	case GETALL:<br>
-		err = -EACCES;<br>
-		if (ipcperms (ipcp, S_IRUGO))<br>
-			goto out;<br>
-		switch (cmd) {<br>
-		case GETVAL : err = curr-&gt;semval; goto out;<br>
-		case GETPID : err = curr-&gt;sempid &amp; 0xffff; goto out;<br>
-		case GETNCNT: err = count_semncnt(sma,semnum); goto out;<br>
-		case GETZCNT: err = count_semzcnt(sma,semnum); goto out;<br>
-		case GETALL:<br>
-			array = arg.array;<br>
-			break;<br>
-		}<br>
-		break;<br>
+		return count_semzcnt(sma,semnum);<br>
 	case SETVAL:<br>
-		val = arg.val;<br>
-		err = -ERANGE;<br>
+	{<br>
+		int val = arg.val;<br>
+		struct sem_undo *un;<br>
 		if (val &gt; SEMVMX || val &lt; 0)<br>
-			goto out;<br>
-		break;<br>
-	case IPC_RMID:<br>
-		if (current-&gt;euid == ipcp-&gt;cuid || <br>
-		    current-&gt;euid == ipcp-&gt;uid || capable(CAP_SYS_ADMIN)) {<br>
-			freeary (id);<br>
-			err = 0;<br>
-			goto out;<br>
-		}<br>
-		err = -EPERM;<br>
-		goto out;<br>
-	case SETALL: /* arg is a pointer to an array of ushort */<br>
-		array = arg.array;<br>
-		err = -EFAULT;<br>
-		if (copy_from_user (sem_io, array, nsems*sizeof(ushort)))<br>
-		       goto out;<br>
-		err = 0;<br>
-		for (i = 0; i &lt; nsems; i++)<br>
-			if (sem_io[i] &gt; SEMVMX) {<br>
-				err = -ERANGE;<br>
-				goto out;<br>
-			}<br>
-		break;<br>
-	case IPC_STAT:<br>
-		buf = arg.buf;<br>
-		break;<br>
-	case IPC_SET:<br>
-		buf = arg.buf;<br>
-		err = copy_from_user (&amp;tbuf, buf, sizeof (*buf));<br>
-		if (err)<br>
-			err = -EFAULT;<br>
-		break;<br>
-	}<br>
-<br>
-	err = -EIDRM;<br>
-	if (semary[id] == IPC_UNUSED || semary[id] == IPC_NOID)<br>
-		goto out;<br>
-	if (sma-&gt;sem_perm.seq != (unsigned int) semid / SEMMNI)<br>
-		goto out;<br>
+			return -ERANGE;<br>
 <br>
-	switch (cmd) {<br>
-	case GETALL:<br>
-		err = -EACCES;<br>
-		if (ipcperms (ipcp, S_IRUGO))<br>
-			goto out;<br>
-		for (i = 0; i &lt; sma-&gt;sem_nsems; i++)<br>
-			sem_io[i] = sma-&gt;sem_base[i].semval;<br>
-		if (copy_to_user (array, sem_io, nsems*sizeof(ushort)))<br>
-			err = -EFAULT;<br>
-		break;<br>
-	case SETVAL:<br>
-		err = -EACCES;<br>
-		if (ipcperms (ipcp, S_IWUGO))<br>
-			goto out;<br>
 		for (un = sma-&gt;undo; un; un = un-&gt;id_next)<br>
 			un-&gt;semadj[semnum] = 0;<br>
 		curr-&gt;semval = val;<br>
 		sma-&gt;sem_ctime = CURRENT_TIME;<br>
 		/* maybe some queued-up processes were waiting for this */<br>
 		update_queue(sma);<br>
-		break;<br>
-	case IPC_SET:<br>
-		if (current-&gt;euid == ipcp-&gt;cuid || <br>
-		    current-&gt;euid == ipcp-&gt;uid || capable(CAP_SYS_ADMIN)) {<br>
-			ipcp-&gt;uid = tbuf.sem_perm.uid;<br>
-			ipcp-&gt;gid = tbuf.sem_perm.gid;<br>
-			ipcp-&gt;mode = (ipcp-&gt;mode &amp; ~S_IRWXUGO)<br>
-				| (tbuf.sem_perm.mode &amp; S_IRWXUGO);<br>
-			sma-&gt;sem_ctime = CURRENT_TIME;<br>
-			err = 0;<br>
-			goto out;<br>
-		}<br>
-		err = -EPERM;<br>
-		goto out;<br>
-	case IPC_STAT:<br>
-		err = -EACCES;<br>
+		return 0;<br>
+	}<br>
+	}<br>
+	return -EINVAL;<br>
+}<br>
+<br>
+int semctl_down(int semid, int semnum, int cmd, union semun arg)<br>
+{<br>
+	struct semid_ds *sma;<br>
+	int err;<br>
+	int lid = semid % SEMMNI;<br>
+	struct semid_ds tbuf;<br>
+	struct ipc_perm *ipcp;<br>
+<br>
+	if(cmd == IPC_SET) {<br>
+		if(copy_from_user (&amp;tbuf, arg.buf, sizeof (tbuf)))<br>
+			return -EFAULT;<br>
+	}<br>
+	spin_lock(&amp;semary[lid].lock);<br>
+	sma = semary[lid].s;<br>
+	err=-EINVAL;<br>
+	if (sma == NULL)<br>
+		goto out_unlock;<br>
+	ipcp = &amp;sma-&gt;sem_perm;<br>
+	<br>
+	if(cmd == SETALL) {<br>
+		int i;<br>
+		struct sem_undo *un;<br>
+		unsigned int nsems;<br>
+		ushort sem_io[SEMMSL];<br>
+		/* SETALL doesn't belong into this<br>
+		 * group, but I need the semaphore<br>
+		 * for atomically reading nsems<br>
+		 * and changing the semaphore values<br>
+		 */<br>
+		err=-EACCES;<br>
 		if (ipcperms (ipcp, S_IRUGO))<br>
-			goto out;<br>
-		tbuf.sem_perm   = sma-&gt;sem_perm;<br>
-		tbuf.sem_otime  = sma-&gt;sem_otime;<br>
-		tbuf.sem_ctime  = sma-&gt;sem_ctime;<br>
-		tbuf.sem_nsems  = sma-&gt;sem_nsems;<br>
-		if (copy_to_user (buf, &amp;tbuf, sizeof(*buf)))<br>
-			err = -EFAULT;<br>
-		break;<br>
-	case SETALL:<br>
-		err = -EACCES;<br>
-		if (ipcperms (ipcp, S_IWUGO))<br>
-			goto out;<br>
+			goto out_unlock;<br>
+		nsems=sma-&gt;sem_nsems;<br>
+		spin_unlock(&amp;semary[lid].lock);<br>
+<br>
+		if (copy_from_user (sem_io, arg.array, nsems*sizeof(ushort)))<br>
+			return -EFAULT;<br>
+		for (i = 0; i &lt; nsems; i++) {<br>
+			if (sem_io[i] &gt; SEMVMX) {<br>
+				return -ERANGE;<br>
+			}<br>
+		}<br>
+		/* we still own sem_lock, ie neither ownership<br>
+		 * nor permissions of the sem array could<br>
+		 * have changed. Just continue.<br>
+		 */<br>
+		spin_lock(&amp;semary[lid].lock);<br>
 		for (i = 0; i &lt; nsems; i++)<br>
 			sma-&gt;sem_base[i].semval = sem_io[i];<br>
 		for (un = sma-&gt;undo; un; un = un-&gt;id_next)<br>
@@ -604,17 +626,85 @@<br>
 		sma-&gt;sem_ctime = CURRENT_TIME;<br>
 		/* maybe some queued-up processes were waiting for this */<br>
 		update_queue(sma);<br>
+		err = 0;<br>
+		goto out_unlock;<br>
+	}<br>
+<br>
+	if (current-&gt;euid != ipcp-&gt;cuid &amp;&amp; <br>
+	    current-&gt;euid != ipcp-&gt;uid &amp;&amp; !capable(CAP_SYS_ADMIN)) {<br>
+	    	err=-EPERM;<br>
+		goto out_unlock;<br>
+	}<br>
+		<br>
+	if (sma-&gt;sem_perm.seq != (unsigned int) semid / SEMMNI) {<br>
+		err=-EIDRM;<br>
+		goto out_unlock;<br>
+	}	<br>
+	switch(cmd){<br>
+	case IPC_RMID:<br>
+		freeary(lid);<br>
+		err = 0;<br>
+		break;<br>
+	case IPC_SET:<br>
+		ipcp-&gt;uid = tbuf.sem_perm.uid;<br>
+		ipcp-&gt;gid = tbuf.sem_perm.gid;<br>
+		ipcp-&gt;mode = (ipcp-&gt;mode &amp; ~S_IRWXUGO)<br>
+				| (tbuf.sem_perm.mode &amp; S_IRWXUGO);<br>
+		sma-&gt;sem_ctime = CURRENT_TIME;<br>
+		err = 0;<br>
 		break;<br>
 	default:<br>
 		err = -EINVAL;<br>
-		goto out;<br>
 	}<br>
-	err = 0;<br>
-out:<br>
-	unlock_kernel();<br>
+<br>
+out_unlock:<br>
+	spin_unlock(&amp;semary[lid].lock);<br>
 	return err;<br>
 }<br>
 <br>
+asmlinkage long sys_semctl (int semid, int semnum, int cmd, union semun arg)<br>
+{<br>
+	int lid; /* lock id */<br>
+	int err = -EINVAL;<br>
+<br>
+	if (semid &lt; 0 || semnum &lt; 0 || cmd &lt; 0)<br>
+		return -EINVAL;<br>
+<br>
+	lid = semid % SEMMNI;<br>
+<br>
+	switch(cmd) {<br>
+	case IPC_INFO:<br>
+	case SEM_INFO:<br>
+	case SEM_STAT:<br>
+		err = semctl_nolock(semid,semnum,cmd,arg);<br>
+		return err;<br>
+	case GETALL:<br>
+	case IPC_STAT:<br>
+		spin_lock(&amp;semary[lid].lock);<br>
+		err = semctl_locked_unlock(semid,semnum,cmd,arg);<br>
+		return err;<br>
+	case GETVAL:<br>
+	case GETPID:<br>
+	case GETNCNT:<br>
+	case GETZCNT:<br>
+	case SETVAL:<br>
+		spin_lock(&amp;semary[lid].lock);<br>
+		err= semctl_locked(semid,semnum,cmd,arg);<br>
+		spin_unlock(&amp;semary[lid].lock);<br>
+		return err;<br>
+<br>
+	case SETALL:<br>
+	case IPC_RMID:<br>
+	case IPC_SET:<br>
+		down(&amp;sem_lock);<br>
+		err= semctl_down(semid,semnum,cmd,arg);<br>
+		up(&amp;sem_lock);<br>
+		return err;<br>
+	default:<br>
+		return -EINVAL;<br>
+	}<br>
+}<br>
+<br>
 asmlinkage long sys_semop (int semid, struct sembuf *tsops, unsigned nsops)<br>
 {<br>
 	int id, size, error = -EINVAL;<br>
@@ -624,24 +714,25 @@<br>
 	int undos = 0, decrease = 0, alter = 0;<br>
 	struct sem_queue queue;<br>
 <br>
-	lock_kernel();<br>
 	if (nsops &lt; 1 || semid &lt; 0)<br>
-		goto out;<br>
-	error = -E2BIG;<br>
+		return -EINVAL;<br>
+<br>
 	if (nsops &gt; SEMOPM)<br>
-		goto out;<br>
-	error = -EFAULT;<br>
+		return -E2BIG;<br>
 	if (copy_from_user (sops, tsops, nsops * sizeof(*tsops)))<br>
-		goto out;<br>
+		return -EFAULT;<br>
+<br>
 	id = (unsigned int) semid % SEMMNI;<br>
+	spin_lock(&amp;semary[id].lock);<br>
+	sma = semary[id].s;<br>
 	error = -EINVAL;<br>
-	if ((sma = semary[id]) == IPC_UNUSED || sma == IPC_NOID)<br>
+	if (sma == NULL)<br>
 		goto out;<br>
 	error = -EIDRM;<br>
 	if (sma-&gt;sem_perm.seq != (unsigned int) semid / SEMMNI)<br>
 		goto out;<br>
 <br>
-		error = -EFBIG;<br>
+	error = -EFBIG;<br>
 	for (sop = sops; sop &lt; sops + nsops; sop++) {<br>
 		if (sop-&gt;sem_num &gt;= sma-&gt;sem_nsems)<br>
 			goto out;<br>
@@ -696,6 +787,7 @@<br>
         queue.undo = un;<br>
         queue.pid = current-&gt;pid;<br>
         queue.alter = decrease;<br>
+	queue.id = id;<br>
         current-&gt;semsleeping = &amp;queue;<br>
         if (alter)<br>
                 append_to_queue(sma ,&amp;queue);<br>
@@ -704,9 +796,16 @@<br>
 <br>
         for (;;) {<br>
                 queue.status = -EINTR;<br>
-                init_waitqueue_head(&amp;queue.sleeper);<br>
-                interruptible_sleep_on(&amp;queue.sleeper);<br>
+		queue.sleeper = current;<br>
+		current-&gt;state = TASK_INTERRUPTIBLE;<br>
+		spin_unlock(&amp;semary[id].lock);<br>
 <br>
+		schedule();<br>
+<br>
+		/* we can lock the semary even if it was<br>
+		 * deleted.<br>
+		 */<br>
+		spin_lock(&amp;semary[id].lock);<br>
                 /*<br>
                  * If queue.status == 1 we where woken up and<br>
                  * have to retry else we simply return.<br>
@@ -735,7 +834,7 @@<br>
         if (alter)<br>
                 update_queue (sma);<br>
 out:<br>
-	unlock_kernel();<br>
+	spin_unlock(&amp;semary[id].lock);<br>
 	return error;<br>
 }<br>
 <br>
@@ -761,27 +860,42 @@<br>
 	/* If the current process was sleeping for a semaphore,<br>
 	 * remove it from the queue.<br>
 	 */<br>
+	/* semsleeping is part of "current", and it<br>
+	 * is never modified by another thread.<br>
+	 * No synchronization required.<br>
+	 */<br>
 	if ((q = current-&gt;semsleeping)) {<br>
+		spin_lock(&amp;semary[current-&gt;semsleeping-&gt;id].lock);<br>
+<br>
 		if (q-&gt;prev)<br>
 			remove_from_queue(q-&gt;sma,q);<br>
 		current-&gt;semsleeping = NULL;<br>
+		spin_unlock(&amp;semary[current-&gt;semsleeping-&gt;id].lock);<br>
 	}<br>
 <br>
 	for (up = &amp;current-&gt;semundo; (u = *up); *up = u-&gt;proc_next, kfree(u)) {<br>
-		if (u-&gt;semid == -1)<br>
-			continue;<br>
-		sma = semary[(unsigned int) u-&gt;semid % SEMMNI];<br>
-		if (sma == IPC_UNUSED || sma == IPC_NOID)<br>
+		int semid = u-&gt;semid;<br>
+		int lid;<br>
+		if(semid == -1)<br>
 			continue;<br>
+		lid = semid % SEMMNI;<br>
+		spin_lock(&amp;semary[lid].lock);<br>
+<br>
+		if (u-&gt;semid == -1)<br>
+			goto next_entry;<br>
+		sma = semary[lid].s;<br>
+		if (sma == NULL);<br>
+			goto next_entry;<br>
 		if (sma-&gt;sem_perm.seq != (unsigned int) u-&gt;semid / SEMMNI)<br>
-			continue;<br>
+			goto next_entry;<br>
+<br>
 		/* remove u from the sma-&gt;undo list */<br>
 		for (unp = &amp;sma-&gt;undo; (un = *unp); unp = &amp;un-&gt;id_next) {<br>
 			if (u == un)<br>
 				goto found;<br>
 		}<br>
 		printk ("sem_exit undo list error id=%d\n", u-&gt;semid);<br>
-		break;<br>
+		goto next_entry;<br>
 found:<br>
 		*unp = un-&gt;id_next;<br>
 		/* perform adjustments registered in u */<br>
@@ -796,6 +910,8 @@<br>
 		sma-&gt;sem_otime = CURRENT_TIME;<br>
 		/* maybe some queued-up processes were waiting for this */<br>
 		update_queue(sma);<br>
+next_entry:<br>
+		spin_unlock(&amp;semary[lid].lock);<br>
 	}<br>
 	current-&gt;semundo = NULL;<br>
 }<br>
@@ -808,20 +924,23 @@<br>
 	int i, len = 0;<br>
 <br>
 	len += sprintf(buffer, "       key      semid perms nsems   uid   gid  cuid  cgid      otime      ctime\n");<br>
+	down(&amp;sem_lock);<br>
 <br>
 	for(i = 0; i &lt; SEMMNI; i++)<br>
-		if(semary[i] != IPC_UNUSED) {<br>
+		if(semary[i].s != NULL) {<br>
+			spin_lock(&amp;semary[i].lock);<br>
 			len += sprintf(buffer + len, "%10d %10d  %4o %5u %5u %5u %5u %5u %10lu %10lu\n",<br>
-				semary[i]-&gt;sem_perm.key,<br>
-				semary[i]-&gt;sem_perm.seq * SEMMNI + i,<br>
-				semary[i]-&gt;sem_perm.mode,<br>
-				semary[i]-&gt;sem_nsems,<br>
-				semary[i]-&gt;sem_perm.uid,<br>
-				semary[i]-&gt;sem_perm.gid,<br>
-				semary[i]-&gt;sem_perm.cuid,<br>
-				semary[i]-&gt;sem_perm.cgid,<br>
-				semary[i]-&gt;sem_otime,<br>
-				semary[i]-&gt;sem_ctime);<br>
+				semary[i].s-&gt;sem_perm.key,<br>
+				semary[i].s-&gt;sem_perm.seq * SEMMNI + i,<br>
+				semary[i].s-&gt;sem_perm.mode,<br>
+				semary[i].s-&gt;sem_nsems,<br>
+				semary[i].s-&gt;sem_perm.uid,<br>
+				semary[i].s-&gt;sem_perm.gid,<br>
+				semary[i].s-&gt;sem_perm.cuid,<br>
+				semary[i].s-&gt;sem_perm.cgid,<br>
+				semary[i].s-&gt;sem_otime,<br>
+				semary[i].s-&gt;sem_ctime);<br>
+			spin_unlock(&amp;semary[i].lock);<br>
 <br>
 			pos += len;<br>
 			if(pos &lt; offset) {<br>
@@ -833,6 +952,7 @@<br>
 		}<br>
 	*eof = 1;<br>
 done:<br>
+	up(&amp;sem_lock);<br>
 	*start = buffer + (offset - begin);<br>
 	len -= (offset - begin);<br>
 	if(len &gt; length)<br>
<i>&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;</i><br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0665.html">Stephen Frost: "Re: i486 can't keep up with 2.2.12 ?"</a>
<li> <b>Previous message:</b> <a href="0663.html">Jean-Francois Brousseau: "Fwd: Re: : : Becoming a Linux Hacker?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
