<!-- received="Thu Oct 14 08:24:55 1999 EET DST" -->
<!-- sent="Thu, 14 Oct 1999 14:20:58 +0900" -->
<!-- name="kumon@flab.fujitsu.co.jp" -->
<!-- email="kumon@flab.fujitsu.co.jp" -->
<!-- subject="Re: PROBLEM: kernel 2.3.21 cannot boot with large memory." -->
<!-- id="199910140520.OAA15112@asami.proc.flab.fujitsu.co.jp" -->
<!-- inreplyto="Pine.LNX.4.10.9910132310430.2140-100000@alpha.random" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: PROBLEM: kernel 2.3.21 cannot boot with large memory.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: PROBLEM: kernel 2.3.21 cannot boot with large memory.</h1>
<a href="mailto:kumon@flab.fujitsu.co.jp"><i>kumon@flab.fujitsu.co.jp</i></a><br>
<i>Thu, 14 Oct 1999 14:20:58 +0900</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#735">[ date ]</a><a href="index.html#735">[ thread ]</a><a href="subject.html#735">[ subject ]</a><a href="author.html#735">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0736.html">Mike Galbraith: "Re: Linux 2.3.21 Gripes."</a>
<li> <b>Previous message:</b> <a href="0734.html">Chris Noe: "Re: [patch] 2.3.31 i386/bootsect.S"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Andrea Arcangeli writes:<br>
<i> &gt; On Wed, 13 Oct 1999 <a href="mailto:kumon@flab.fujitsu.co.jp">kumon@flab.fujitsu.co.jp</a> wrote:</i><br>
<i> &gt; </i><br>
<i> &gt; &gt;	free -= (page_cache.min_percent + buffer_mem.min_percent + 2)*num_physpages/100; </i><br>
<i> &gt; </i><br>
<i> &gt; IMHO we could kill the above two lines (the min_percent on the buffer</i><br>
<i> &gt; cache is not preserved anymore in 2.3.x btw).</i><br>
<p>
I see, this can prevent the value free from being negative, but<br>
shortage of nr_free_pages is still exist.<br>
 After my previous posting, we found the fundamental reason which<br>
cause the trouble.<br>
<p>
About weeks ago, I posted the memory page initialization bug in<br>
mem_init() of linux-2.3.21/arch/i386/mm/init.c.<br>
<p>
It had been fixed in 2.3.19. But 2^32 wraparound bug exists in<br>
mem_init() function.<br>
<p>
The following patch will fix it.  This patch also prevents miss<br>
recognition of blocks with start address overflowed.  which will<br>
happens if a memory block starting at physical address 0x40000000<br>
(1GB), the resulting 'PAGE_ OFFSET + addr' wraps around to lower<br>
address.<br>
<p>
diff -urN linux-2.3.21/arch/i386/mm/init.c linux-2.3.21-new/arch/i386/mm/init.c<br>
--- linux-2.3.21/arch/i386/mm/init.c	Wed Sep 29 23:02:59 1999<br>
+++ linux-2.3.21-new/arch/i386/mm/init.c	Thu Oct 14 12:45:50 1999<br>
@@ -429,7 +429,19 @@<br>
 		end = PAGE_OFFSET + ((addr + size) &amp; PAGE_MASK);<br>
 		addr= PAGE_OFFSET + PAGE_ALIGN(addr);<br>
 <br>
-		for ( ; addr &lt; end; addr += PAGE_SIZE) {<br>
+		/* if we have start address beyond 4GB, then ignore<br>
+                   the block */<br>
+		if (addr &lt; PAGE_OFFSET)<br>
+		  continue;<br>
+<br>
+		/* end address should be limited in the 4GB region */<br>
+		if (end &lt; PAGE_OFFSET)<br>
+		  end = 0UL;<br>
+		  <br>
+		/* don't use less-than operator for exit cheking.<br>
+		   if the end equals to 2^32 = 0UL, it fails to work */<br>
+<br>
+		for ( ; addr != end; addr += PAGE_SIZE) {<br>
 <br>
 			/* this little bit of grossness is for dealing<br>
 			 * with memory borrowing for system bookkeeping<br>
<p>
In our original situation, our machine has a block starting at 64MB<br>
which ends at 2GB.  The original for statement is not executed because:<br>
	addr= PAGE_OFFSET+64MB<br>
	end= PAGE_OFFSET+2GB<br>
 With PAGE_OFFSET = 0xc0000000, end overflows and the condition (addr<br>
&lt; end) is always false.  Being ignored this block causes the shotage<br>
of memory.<br>
<p>
This problem may happen, if 1GB config option is used with more than<br>
1GB physical memory, or 2GB with more than 2GB.<br>
<p>
<pre>
--
Computer Systems Laboratory, Fujitsu Labs.
<a href="mailto:kumon@flab.fujitsu.co.jp">kumon@flab.fujitsu.co.jp</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0736.html">Mike Galbraith: "Re: Linux 2.3.21 Gripes."</a>
<li> <b>Previous message:</b> <a href="0734.html">Chris Noe: "Re: [patch] 2.3.31 i386/bootsect.S"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
