<!-- received="Thu Oct 14 17:45:24 1999 EET DST" -->
<!-- sent="Thu, 14 Oct 1999 16:38:21 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="Re: is lock_kernel() required for lookup_swap_cache() and swap_free()?" -->
<!-- id="" -->
<!-- inreplyto="3805CE1F.90940757@colorfullife.com" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: is lock_kernel() required for lookup_swap_cache() and swap_free()?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: is lock_kernel() required for lookup_swap_cache() and swap_free()?</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Thu, 14 Oct 1999 16:38:21 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#795">[ date ]</a><a href="index.html#795">[ thread ]</a><a href="subject.html#795">[ subject ]</a><a href="author.html#795">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0796.html">Jamie Lokier: "2.1.20: e820 crash data"</a>
<li> <b>Previous message:</b> <a href="0794.html">Andrea Arcangeli: "Re: [PATCH] scheduler cleanup"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 14 Oct 1999, Manfred Spraul wrote:<br>
<p>
<i>&gt;* do_swap_page() calls lookup_swap_cache() without lock_kernel(), but</i><br>
<p>
lookup_swap_cache doesn't need the kernel lock.<br>
<p>
<i>&gt;* shrink_mmap() calls __delete_from_swap_cache() without any special</i><br>
<i>&gt;locking. __delete_from_swap_cache() calls swap_free(), and it seems that</i><br>
<i>&gt;this function is not thread-safe.</i><br>
<p>
No. You just hold the per page lock and the pagecache lock before calling<br>
__delete_from_swap_cache. That's the only thing you need.<br>
<p>
shrink_mmap is completly SMP threaded (I made it SMP threaded while<br>
replacing the sloww clock algorithm with a real page-LRU). It only rely on<br>
the per-page lock and on the pagecache_lock when necessary (to avoid<br>
somebody to find the page under us).<br>
<p>
<i>&gt;[__delete_from_swap_cache() also increases a non-atomic global variable,</i><br>
<i>&gt;but this looks like debug code].</i><br>
<p>
There's also a missing lock kernel around swap_free. Here the obviously<br>
right fix I did some time ago (it applyed cleanly on the top of 2.3.21).<br>
<p>
--- 2.3.18ac2/mm/swap_state.c	Wed Sep  8 00:26:08 1999<br>
+++ /tmp/swap_state.c	Mon Sep 13 18:49:18 1999<br>
@@ -13,6 +13,7 @@<br>
 #include &lt;linux/swapctl.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/pagemap.h&gt;<br>
+#include &lt;linux/smp_lock.h&gt;<br>
 <br>
 #include &lt;asm/pgtable.h&gt;<br>
 <br>
@@ -234,7 +235,9 @@<br>
 		   page_address(page), page_count(page), entry);<br>
 #endif<br>
 	remove_from_swap_cache (page);<br>
+	lock_kernel();<br>
 	swap_free (entry);<br>
+	unlock_kernel();<br>
 }<br>
 <br>
 static void delete_from_swap_cache_nolock(struct page *page)<br>
<p>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0796.html">Jamie Lokier: "2.1.20: e820 crash data"</a>
<li> <b>Previous message:</b> <a href="0794.html">Andrea Arcangeli: "Re: [PATCH] scheduler cleanup"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
