<!-- received="Thu Oct 14 19:31:26 1999 EET DST" -->
<!-- sent="Thu, 14 Oct 1999 18:28:38 +0200 (MET DST)" -->
<!-- name="Guest section DW" -->
<!-- email="dwguest@win.tue.nl" -->
<!-- subject="Re: Question about /proc/ide" -->
<!-- id="199910141628.SAA18888@wsdw01.win.tue.nl" -->
<!-- inreplyto="Question about /proc/ide" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: Question about /proc/ide</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Question about /proc/ide</h1>
<b>Guest section DW</b> (<a href="mailto:dwguest@win.tue.nl"><i>dwguest@win.tue.nl</i></a>)<br>
<i>Thu, 14 Oct 1999 18:28:38 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#812">[ date ]</a><a href="index.html#812">[ thread ]</a><a href="subject.html#812">[ subject ]</a><a href="author.html#812">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0813.html">Brian Hall: "PIII kernel support- hardware randomizer"</a>
<li> <b>Previous message:</b> <a href="0811.html">Jamie Lokier: "Re: 2.3.20: e820 crash data"</a>
<li> <b>Maybe in reply to:</b> <a href="0791.html">tenthumbs: "Question about /proc/ide"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0816.html">Wakko Warner: "Re: Question about /proc/ide"</a>
<li> <b>Reply:</b> <a href="0816.html">Wakko Warner: "Re: Question about /proc/ide"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
	From: tenthumbs &lt;10@dhyp2-158.cybernex.net&gt;<br>
<p>
	While trying to track down some problems with my old i486 dropping ppp<br>
	packets, I ran into some anomalies with /proc/ide.<br>
<p>
	I have 4 IDE drives and I noticed that /proc/hd[ac]/geometry reports a<br>
	negative physical cylinder count while /proc/hd[bd]/geometry reports<br>
	positive values. The logical geometries are correct. Is this a problem?<br>
<p>
No.<br>
The patch below will make them positive again, I suppose.<br>
(this is on /usr/src/linux/drivers/block/ide-proc.c or so)<br>
<p>
<p>
--- ide-proc.c~ Wed May  6 23:42:53 1998<br>
+++ ide-proc.c  Thu Oct 14 18:18:31 1999<br>
@@ -516,8 +516,10 @@<br>
        char            *out = page;<br>
        int             len;<br>
 <br>
-       out += sprintf(out,"physical     %hi/%hi/%hi\n", drive-&gt;cyl, drive-&gt;head, drive-&gt;sect);<br>
-       out += sprintf(out,"logical      %hi/%hi/%hi\n", drive-&gt;bios_cyl, drive-&gt;bios_head, drive-&gt;bios_sect);<br>
+       out += sprintf(out,"physical     %d/%d/%d\n",<br>
+                      drive-&gt;cyl, drive-&gt;head, drive-&gt;sect);<br>
+       out += sprintf(out,"logical      %d/%d/%d\n",<br>
+                      drive-&gt;bios_cyl, drive-&gt;bios_head, drive-&gt;bios_sect);<br>
        len = out - page;<br>
        PROC_IDE_READ_RETURN(page,start,off,count,eof,len);<br>
 }<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0813.html">Brian Hall: "PIII kernel support- hardware randomizer"</a>
<li> <b>Previous message:</b> <a href="0811.html">Jamie Lokier: "Re: 2.3.20: e820 crash data"</a>
<li> <b>Maybe in reply to:</b> <a href="0791.html">tenthumbs: "Question about /proc/ide"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0816.html">Wakko Warner: "Re: Question about /proc/ide"</a>
<li> <b>Reply:</b> <a href="0816.html">Wakko Warner: "Re: Question about /proc/ide"</a>
<!-- reply="end" -->
</ul>
</font></body>
