<!-- received="Thu Oct 14 22:37:26 1999 EET DST" -->
<!-- sent="Thu, 14 Oct 1999 15:33:34 -0400" -->
<!-- name="Michael Zappe" -->
<!-- email="zapman@interlan.net" -->
<!-- subject="[patch] Timeout semaphores..." -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [patch] Timeout semaphores...</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] Timeout semaphores...</h1>
<b>Michael Zappe</b> (<a href="mailto:zapman@interlan.net"><i>zapman@interlan.net</i></a>)<br>
<i>Thu, 14 Oct 1999 15:33:34 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#855">[ date ]</a><a href="index.html#855">[ thread ]</a><a href="subject.html#855">[ subject ]</a><a href="author.html#855">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0856.html">Thomas Sailer: "serial.c patch in 2.3.19"</a>
<li> <b>Previous message:</b> <a href="0854.html">Bill Huey: "Re: Kernel OSS vs ALSA"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
    This is a patch to give timeoutable semaphores with 2.2.12 (and probably earlier, but i havent tested the patch on any earlier kernels).  Right now it uses the same algorithm as the rest of the 2.2 semaphores, although i noted that 2.3.xx has new semaphore code to eliminate a race condition.  Are there any plans to back-port this code?  (I'm not sure how such things are looked upon for production kernels.)  I'll have a patch for 2.3.21 later.  I'm not sure when i'll get around to it, but if anyone needs it, just let me know.  ;-)<br>
<p>
    Later,<br>
<p>
        Mike<br>
<p>
diff -r -u linux-2.2.12/arch/i386/kernel/i386_ksyms.c linux/arch/i386/kernel/i386_ksyms.c<br>
--- linux-2.2.12/arch/i386/kernel/i386_ksyms.c Mon Aug  9 15:05:05 1999<br>
+++ linux/arch/i386/kernel/i386_ksyms.c Thu Oct 14 11:37:48 1999<br>
@@ -47,6 +47,7 @@<br>
 EXPORT_SYMBOL_NOVERS(__down_failed);<br>
 EXPORT_SYMBOL_NOVERS(__down_failed_interruptible);<br>
 EXPORT_SYMBOL_NOVERS(__down_failed_trylock);<br>
+EXPORT_SYMBOL_NOVERS(__down_failed_timeout);<br>
 EXPORT_SYMBOL_NOVERS(__up_wakeup);<br>
 /* Networking helper routines. */<br>
 EXPORT_SYMBOL(csum_partial_copy);<br>
diff -r -u linux-2.2.12/arch/i386/lib/semaphore.S linux/arch/i386/lib/semaphore.S<br>
--- linux-2.2.12/arch/i386/lib/semaphore.S Wed Feb 17 12:34:13 1999<br>
+++ linux/arch/i386/lib/semaphore.S Thu Oct 14 11:50:44 1999<br>
@@ -40,6 +40,15 @@<br>
  popl %edx /* restore %edx */<br>
  ret<br>
<p>
+/* Don't save/restore %eax, because that will be our return value */<br>
+ENTRY(__down_failed_timeout)<br>
+ pushl %edx /* save %edx */<br>
+ pushl %ecx /* save %ecx (and argument) */<br>
+ call SYMBOL_NAME(__down_timeout)<br>
+ popl %ecx /* restore %ecx (count on __down_trylock not changing it) */<br>
+ popl %edx /* restore %edx */<br>
+ ret<br>
+<br>
 ENTRY(__up_wakeup)<br>
  pushl %eax /* save %eax */<br>
  pushl %edx /* save %edx */<br>
diff -r -u linux-2.2.12/include/asm-i386/semaphore-helper.h linux/include/asm-i386/semaphore-helper.h<br>
--- linux-2.2.12/include/asm-i386/semaphore-helper.h Mon Aug  9 15:04:41 1999<br>
+++ linux/include/asm-i386/semaphore-helper.h Wed Oct 13 18:40:05 1999<br>
@@ -99,4 +99,32 @@<br>
  return ret;<br>
 }<br>
<p>
+/*<br>
+ * waking_non_zero_interruptible_timeout:<br>
+ * 1 got the lock<br>
+ * 0 go to sleep<br>
+ * -EINTR interrupted<br>
+ *<br>
+ * We must undo the sem-&gt;count down_interruptible() increment while we are<br>
+ * protected by the spinlock in order to make atomic this atomic_inc() with the<br>
+ * atomic_read() in wake_one_more(), otherwise we can race. -arca<br>
+ */<br>
+static inline int waking_non_zero_interruptible_timeout(struct semaphore *sem,<br>
+      struct task_struct *tsk)<br>
+{<br>
+ unsigned long flags;<br>
+ int ret = 0;<br>
+<br>
+ spin_lock_irqsave(&amp;semaphore_wake_lock, flags);<br>
+ if (sem-&gt;waking &gt; 0) {<br>
+  sem-&gt;waking--;<br>
+  ret = 1;<br>
+ } else if (signal_pending(tsk)) {<br>
+  atomic_inc(&amp;sem-&gt;count);<br>
+  ret = -EINTR;<br>
+ }<br>
+ spin_unlock_irqrestore(&amp;semaphore_wake_lock, flags);<br>
+ return ret;<br>
+}<br>
+<br>
 #endif<br>
diff -r -u linux-2.2.12/include/asm-i386/semaphore.h linux/include/asm-i386/semaphore.h<br>
--- linux-2.2.12/include/asm-i386/semaphore.h Mon Aug  9 15:04:57 1999<br>
+++ linux/include/asm-i386/semaphore.h Thu Oct 14 12:14:48 1999<br>
@@ -44,16 +44,23 @@<br>
 asmlinkage void __down_failed(void /* special register calling convention */);<br>
 asmlinkage int  __down_failed_interruptible(void  /* params in registers */);<br>
 asmlinkage int  __down_failed_trylock(void  /* params in registers */);<br>
+asmlinkage int  __down_failed_timeout(void /* params in registers */);<br>
 asmlinkage void __up_wakeup(void /* special register calling convention */);<br>
<p>
 asmlinkage void __down(struct semaphore * sem);<br>
 asmlinkage int  __down_interruptible(struct semaphore * sem);<br>
 asmlinkage int  __down_trylock(struct semaphore * sem);<br>
+asmlinkage int __down_timeout(struct semaphore *sem, signed long timeout);<br>
 asmlinkage void __up(struct semaphore * sem);<br>
<p>
 extern spinlock_t semaphore_wake_lock;<br>
<p>
-#define sema_init(sem, val) atomic_set(&amp;((sem)-&gt;count), (val))<br>
+extern inline void sema_init(struct semaphore *sem, int val)<br>
+{<br>
+ sem-&gt;waking = 0;<br>
+ sem-&gt;wait = NULL;<br>
+ atomic_set(&amp;sem-&gt;count, val);<br>
+}<br>
<p>
 /*<br>
  * This is ugly, but we want the default case to fall through.<br>
@@ -124,6 +131,29 @@<br>
   :"memory");<br>
  return result;<br>
 }<br>
+<br>
+extern inline int down_timeout(struct semaphore * sem, signed long timeout)<br>
+{<br>
+ int result;<br>
+<br>
+ __asm__ __volatile__(<br>
+  "# atomic interruptible down operation\n\t"<br>
+#ifdef __SMP__<br>
+  "lock ; "<br>
+#endif<br>
+  "decl 0(%1)\n\t"<br>
+  "js 1f\n\t"<br>
+  "xorl %0,%0\n"<br>
+  "1:\tmovl %2,%%edx\n"<br>
+  "\tmovl %1,%%ecx\n"<br>
+  "\tcall __down_failed_timeout\n"<br>
+  :"=a" (result)<br>
+  :"g" (sem), "g" (timeout)<br>
+  :"memory");<br>
+<br>
+ return result;<br>
+}<br>
+<br>
<p>
 /*<br>
  * Note! This is subtle. We jump to wake people up only if<br>
diff -r -u linux-2.2.12/kernel/ksyms.c linux/kernel/ksyms.c<br>
--- linux-2.2.12/kernel/ksyms.c Mon Aug  9 15:04:41 1999<br>
+++ linux/kernel/ksyms.c Wed Oct 13 20:26:26 1999<br>
@@ -380,6 +380,7 @@<br>
 EXPORT_SYMBOL(__down);<br>
 EXPORT_SYMBOL(__down_interruptible);<br>
 EXPORT_SYMBOL(__down_trylock);<br>
+EXPORT_SYMBOL(__down_timeout);<br>
 EXPORT_SYMBOL(__up);<br>
 EXPORT_SYMBOL(brw_page);<br>
<p>
diff -r -u linux-2.2.12/kernel/sched.c linux/kernel/sched.c<br>
--- linux-2.2.12/kernel/sched.c Mon May 10 12:55:21 1999<br>
+++ linux/kernel/sched.c Thu Oct 14 15:15:40 1999<br>
@@ -1037,6 +1037,44 @@<br>
  return waking_non_zero_trylock(sem);<br>
 }<br>
<p>
+int __down_timeout(struct semaphore *sem, signed long timeout)<br>
+{<br>
+ DOWN_VAR<br>
+ signed long start_time = jiffies;<br>
+ signed long remaining = timeout,<br>
+       elapsed = 0;<br>
+ int ret = 0;<br>
+<br>
+ DOWN_HEAD(TASK_INTERRUPTIBLE)<br>
+<br>
+ ret = waking_non_zero_interruptible_timeout(sem, tsk);<br>
+<br>
+ elapsed = jiffies - start_time;<br>
+ remaining -= elapsed;<br>
+<br>
+ if((ret != 1) &amp;&amp; remaining &lt;= 0)<br>
+ {<br>
+  ret = -EBUSY;<br>
+<br>
+  break;<br>
+ }<br>
+<br>
+ if (ret)<br>
+ {<br>
+  if (ret == 1)<br>
+   /* ret != 0 only if we get interrupted -arca */<br>
+   ret = 0;<br>
+  break;<br>
+ }<br>
+<br>
+ schedule_timeout(remaining);<br>
+<br>
+ DOWN_TAIL(TASK_INTERRUPTIBLE)<br>
+<br>
+ return ret;<br>
+}<br>
+<br>
+<br>
 #define SLEEP_ON_VAR    \<br>
  unsigned long flags;   \<br>
  struct wait_queue wait;<br>
<p>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0856.html">Thomas Sailer: "serial.c patch in 2.3.19"</a>
<li> <b>Previous message:</b> <a href="0854.html">Bill Huey: "Re: Kernel OSS vs ALSA"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
