<!-- received="Fri Oct 15 03:09:47 1999 EET DST" -->
<!-- sent="Thu, 14 Oct 1999 17:06:00 -0700 (PDT)" -->
<!-- name="Kanoj Sarcar" -->
<!-- email="kanoj@google.engr.sgi.com" -->
<!-- subject="[PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection" -->
<!-- id="199910150006.RAA47575@google.engr.sgi.com" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection</h1>
<b>Kanoj Sarcar</b> (<a href="mailto:kanoj@google.engr.sgi.com"><i>kanoj@google.engr.sgi.com</i></a>)<br>
<i>Thu, 14 Oct 1999 17:06:00 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#893">[ date ]</a><a href="index.html#893">[ thread ]</a><a href="subject.html#893">[ subject ]</a><a href="author.html#893">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0894.html">Andrej Todosic: "compaq raid smart 2 xx array"</a>
<li> <b>Previous message:</b> <a href="0892.html">David S. Miller: "Re: Is the list dead?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0894.html">Andrej Todosic: "compaq raid smart 2 xx array"</a>
<li> <b>Reply:</b> <a href="0894.html">Andrej Todosic: "compaq raid smart 2 xx array"</a>
<li> <b>Reply:</b> <a href="0959.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Reply:</b> <a href="1047.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Reply:</b> <a href="1073.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Reply:</b> <a href="1095.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Linus,<br>
<p>
This 2.3 patch fixes the race between page stealing code doing vma<br>
list traversal, and other pieces of code adding/deleting elements<br>
to the list, or otherwise changing fields in the list elements<br>
that might confuse the stealing code. Let me know if things seem<br>
fine, or you want me to alter some code. <br>
<p>
There will probably be a second, independent part to this patch, <br>
where vma list scanners (callers to find_vma() for example) other<br>
than the page stealing code are fixed to grab mmap_sem. Some of<br>
this has already been pointed out by Manfred Spraul.<br>
<p>
We should also probably spawn an independent discussion thread<br>
about the driver swapout() method parameter passing, invoked from<br>
try_to_swap_out(). swapout() currently takes the vma as an input,<br>
but the vma might be getting deleted (the documentation which is<br>
part of the patch describes currently how things are protected),<br>
so it might be prudent to pass individual fields of the vma to the<br>
swapout() method, rather than a pointer to the structure. <br>
<p>
Thanks.<br>
<p>
Kanoj<br>
<p>
--- Documentation/vm/locking	Thu Oct 14 15:38:03 1999<br>
+++ Documentation/vm/locking	Thu Oct 14 15:44:40 1999<br>
@@ -0,0 +1,83 @@<br>
+Started Oct 1999 by Kanoj Sarcar &lt;<a href="mailto:kanoj@sgi.com">kanoj@sgi.com</a>&gt;<br>
+<br>
+The intent of this file is to have an uptodate, running commentary <br>
+from different people about how locking and synchronization is done <br>
+in the Linux vm code.<br>
+<br>
+vmlist_access_lock/vmlist_modify_lock<br>
+--------------------------------------<br>
+<br>
+Page stealers pick processes out of the process pool and scan for <br>
+the best process to steal pages from. To guarantee the existance <br>
+of the victim mm, a mm_count inc and a mmdrop are done in swap_out().<br>
+Page stealers hold kernel_lock to protect against a bunch of races.<br>
+The vma list of the victim mm is also scanned by the stealer, <br>
+and the vmlist_lock is used to preserve list sanity against the<br>
+process adding/deleting to the list. This also gurantees existance<br>
+of the vma. Vma existance gurantee while invoking the driver<br>
+swapout() method in try_to_swap_out() also relies on the fact<br>
+that do_munmap() temporarily gets lock_kernel before decimating<br>
+the vma, thus the swapout() method must snapshot all the vma <br>
+fields it needs before going to sleep (which will release the<br>
+lock_kernel held by the page stealer). Currently, filemap_swapout<br>
+is the only method that depends on this shaky interlocking.<br>
+<br>
+Any code that modifies the vmlist, or the vm_start/vm_end/<br>
+vm_flags:VM_LOCKED/vm_next of any vma *in the list* must prevent <br>
+kswapd from looking at the chain. This does not include driver mmap() <br>
+methods, for example, since the vma is still not in the list.<br>
+<br>
+The rules are:<br>
+1. To modify the vmlist (add/delete or change fields in an element), <br>
+you must hold mmap_sem to guard against clones doing mmap/munmap/faults, <br>
+(ie all vm system calls and faults), and from ptrace, swapin due to <br>
+swap deletion etc.<br>
+2. To modify the vmlist (add/delete or change fields in an element), <br>
+you must also hold vmlist_modify_lock, to guard against page stealers <br>
+scanning the list.<br>
+3. To scan the vmlist (find_vma()), you must either <br>
+        a. grab mmap_sem, which should be done by all cases except <br>
+	   page stealer.<br>
+or<br>
+        b. grab vmlist_access_lock, only done by page stealer.<br>
+4. While holding the vmlist_modify_lock, you must be able to guarantee<br>
+that no code path will lead to page stealing. A better guarantee is<br>
+to claim non sleepability, which ensures that you are not sleeping<br>
+for a lock, whose holder might in turn be doing page stealing.<br>
+5. You must be able to guarantee that while holding vmlist_modify_lock<br>
+or vmlist_access_lock of mm A, you will not try to get either lock<br>
+for mm B.<br>
+<br>
+The caveats are:<br>
+1. find_vma() makes use of, and updates, the mmap_cache pointer hint.<br>
+The update of mmap_cache is racy (page stealer can race with other code<br>
+that invokes find_vma with mmap_sem held), but that is okay, since it <br>
+is a hint. This can be fixed, if desired, by having find_vma grab the<br>
+vmlist lock.<br>
+<br>
+<br>
+Code that add/delete elements from the vmlist chain are<br>
+1. callers of insert_vm_struct<br>
+2. callers of merge_segments<br>
+3. callers of avl_remove<br>
+<br>
+Code that changes vm_start/vm_end/vm_flags:VM_LOCKED of vma's on<br>
+the list:<br>
+1. expand_stack<br>
+2. mprotect<br>
+3. mlock<br>
+4. mremap<br>
+<br>
+It is advisable that changes to vm_start/vm_end be protected, although <br>
+in some cases it is not really needed. Eg, vm_start is modified by <br>
+expand_stack(), it is hard to come up with a destructive scenario without <br>
+having the vmlist protection in this case.<br>
+<br>
+The vmlist lock nests with the inode i_shared_lock and the kmem cache<br>
+c_spinlock spinlocks. This is okay, since code that holds i_shared_lock <br>
+never asks for memory, and the kmem code asks for pages after dropping<br>
+c_spinlock.<br>
+<br>
+The vmlist lock can be a sleeping or spin lock. In either case, care<br>
+must be taken that it is not held on entry to the driver methods, since<br>
+those methods might sleep or ask for memory, causing deadlocks.<br>
--- /usr/tmp/p_rdiff_a003hF/exec.c	Thu Oct 14 16:35:50 1999<br>
+++ fs/exec.c	Thu Oct 14 09:50:25 1999<br>
@@ -276,7 +276,9 @@<br>
 		mpnt-&gt;vm_offset = 0;<br>
 		mpnt-&gt;vm_file = NULL;<br>
 		mpnt-&gt;vm_private_data = (void *) 0;<br>
+		vmlist_modify_lock(current-&gt;mm);<br>
 		insert_vm_struct(current-&gt;mm, mpnt);<br>
+		vmlist_modify_unlock(current-&gt;mm);<br>
 		current-&gt;mm-&gt;total_vm = (mpnt-&gt;vm_end - mpnt-&gt;vm_start) &gt;&gt; PAGE_SHIFT;<br>
 	} <br>
 <br>
--- /usr/tmp/p_rdiff_a003hO/mm.h	Thu Oct 14 16:35:59 1999<br>
+++ include/linux/mm.h	Thu Oct 14 13:45:29 1999<br>
@@ -427,6 +427,12 @@<br>
 #define pgcache_under_min()	(atomic_read(&amp;page_cache_size) * 100 &lt; \<br>
 				page_cache.min_percent * num_physpages)<br>
 <br>
+#define vmlist_access_lock(mm)		down(&amp;mm-&gt;vmlist_lock)<br>
+#define vmlist_access_unlock(mm)	up(&amp;mm-&gt;vmlist_lock)<br>
+#define vmlist_modify_lock(mm)		vmlist_access_lock(mm)<br>
+#define vmlist_modify_unlock(mm)	vmlist_access_unlock(mm)<br>
+<br>
+<br>
 #endif /* __KERNEL__ */<br>
 <br>
 #endif<br>
--- /usr/tmp/p_rdiff_a003hX/sched.h	Thu Oct 14 16:36:08 1999<br>
+++ include/linux/sched.h	Thu Oct 14 13:45:24 1999<br>
@@ -213,6 +213,7 @@<br>
 	atomic_t mm_count;			/* How many references to "struct mm_struct" (users count as 1) */<br>
 	int map_count;				/* number of VMAs */<br>
 	struct semaphore mmap_sem;<br>
+	struct semaphore vmlist_lock;		/* protect against kswapd */<br>
 	spinlock_t page_table_lock;<br>
 	unsigned long context;<br>
 	unsigned long start_code, end_code, start_data, end_data;<br>
@@ -235,6 +236,7 @@<br>
 		swapper_pg_dir, 			\<br>
 		ATOMIC_INIT(2), ATOMIC_INIT(1), 1,	\<br>
 		__MUTEX_INITIALIZER(name.mmap_sem),	\<br>
+		__MUTEX_INITIALIZER(name.vmlist_lock),	\<br>
 		SPIN_LOCK_UNLOCKED,			\<br>
 		0,					\<br>
 		0, 0, 0, 0,				\<br>
--- /usr/tmp/p_rdiff_a003he/shm.c	Thu Oct 14 16:36:17 1999<br>
+++ ipc/shm.c	Wed Oct 13 14:31:47 1999<br>
@@ -462,8 +462,10 @@<br>
<i> 	   &gt; (unsigned long) current-&gt;rlim[RLIMIT_AS].rlim_cur)</i><br>
 		return -ENOMEM;<br>
 	current-&gt;mm-&gt;total_vm += tmp &gt;&gt; PAGE_SHIFT;<br>
+	vmlist_modify_lock(current-&gt;mm);<br>
 	insert_vm_struct(current-&gt;mm, shmd);<br>
 	merge_segments(current-&gt;mm, shmd-&gt;vm_start, shmd-&gt;vm_end);<br>
+	vmlist_modify_unlock(current-&gt;mm);<br>
 <br>
 	return 0;<br>
 }<br>
--- /usr/tmp/p_rdiff_a003hn/fork.c	Thu Oct 14 16:36:26 1999<br>
+++ kernel/fork.c	Thu Oct 14 13:47:37 1999<br>
@@ -303,6 +303,7 @@<br>
 		atomic_set(&amp;mm-&gt;mm_users, 1);<br>
 		atomic_set(&amp;mm-&gt;mm_count, 1);<br>
 		init_MUTEX(&amp;mm-&gt;mmap_sem);<br>
+		init_MUTEX(&amp;mm-&gt;vmlist_lock);<br>
 		mm-&gt;page_table_lock = SPIN_LOCK_UNLOCKED;<br>
 		mm-&gt;pgd = pgd_alloc();<br>
 		if (mm-&gt;pgd)<br>
--- /usr/tmp/p_rdiff_a003hw/ptrace.c	Thu Oct 14 16:36:34 1999<br>
+++ kernel/ptrace.c	Wed Oct 13 10:43:38 1999<br>
@@ -80,12 +80,14 @@<br>
 int access_process_vm(struct task_struct *tsk, unsigned long addr, void *buf, int len, int write)<br>
 {<br>
 	int copied;<br>
-	struct vm_area_struct * vma = find_extend_vma(tsk, addr);<br>
+	struct vm_area_struct * vma;<br>
 <br>
-	if (!vma)<br>
-		return 0;<br>
-<br>
 	down(&amp;tsk-&gt;mm-&gt;mmap_sem);<br>
+	vma = find_extend_vma(tsk, addr);<br>
+	if (!vma) {<br>
+		up(&amp;tsk-&gt;mm-&gt;mmap_sem);<br>
+		return 0;<br>
+	}<br>
 	copied = 0;<br>
 	for (;;) {<br>
 		unsigned long offset = addr &amp; ~PAGE_MASK;<br>
--- /usr/tmp/p_rdiff_a003i5/mlock.c	Thu Oct 14 16:36:43 1999<br>
+++ mm/mlock.c	Tue Oct 12 16:35:25 1999<br>
@@ -13,7 +13,9 @@<br>
 <br>
 static inline int mlock_fixup_all(struct vm_area_struct * vma, int newflags)<br>
 {<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
 	vma-&gt;vm_flags = newflags;<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -26,15 +28,17 @@<br>
 	if (!n)<br>
 		return -EAGAIN;<br>
 	*n = *vma;<br>
-	vma-&gt;vm_start = end;<br>
 	n-&gt;vm_end = end;<br>
-	vma-&gt;vm_offset += vma-&gt;vm_start - n-&gt;vm_start;<br>
 	n-&gt;vm_flags = newflags;<br>
 	if (n-&gt;vm_file)<br>
 		get_file(n-&gt;vm_file);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
+	vma-&gt;vm_offset += end - vma-&gt;vm_start;<br>
+	vma-&gt;vm_start = end;<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -47,7 +51,6 @@<br>
 	if (!n)<br>
 		return -EAGAIN;<br>
 	*n = *vma;<br>
-	vma-&gt;vm_end = start;<br>
 	n-&gt;vm_start = start;<br>
 	n-&gt;vm_offset += n-&gt;vm_start - vma-&gt;vm_start;<br>
 	n-&gt;vm_flags = newflags;<br>
@@ -55,7 +58,10 @@<br>
 		get_file(n-&gt;vm_file);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
+	vma-&gt;vm_end = start;<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -75,10 +81,7 @@<br>
 	*left = *vma;<br>
 	*right = *vma;<br>
 	left-&gt;vm_end = start;<br>
-	vma-&gt;vm_start = start;<br>
-	vma-&gt;vm_end = end;<br>
 	right-&gt;vm_start = end;<br>
-	vma-&gt;vm_offset += vma-&gt;vm_start - left-&gt;vm_start;<br>
 	right-&gt;vm_offset += right-&gt;vm_start - left-&gt;vm_start;<br>
 	vma-&gt;vm_flags = newflags;<br>
 	if (vma-&gt;vm_file)<br>
@@ -88,8 +91,14 @@<br>
 		vma-&gt;vm_ops-&gt;open(left);<br>
 		vma-&gt;vm_ops-&gt;open(right);<br>
 	}<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
+	vma-&gt;vm_offset += start - vma-&gt;vm_start;<br>
+	vma-&gt;vm_start = start;<br>
+	vma-&gt;vm_end = end;<br>
+	vma-&gt;vm_flags = newflags;<br>
 	insert_vm_struct(current-&gt;mm, left);<br>
 	insert_vm_struct(current-&gt;mm, right);<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -168,7 +177,9 @@<br>
 			break;<br>
 		}<br>
 	}<br>
+	vmlist_modify_lock(current-&gt;mm);<br>
 	merge_segments(current-&gt;mm, start, end);<br>
+	vmlist_modify_unlock(current-&gt;mm);<br>
 	return error;<br>
 }<br>
 <br>
@@ -240,7 +251,9 @@<br>
 		if (error)<br>
 			break;<br>
 	}<br>
+	vmlist_modify_lock(current-&gt;mm);<br>
 	merge_segments(current-&gt;mm, 0, TASK_SIZE);<br>
+	vmlist_modify_unlock(current-&gt;mm);<br>
 	return error;<br>
 }<br>
 <br>
--- /usr/tmp/p_rdiff_a003iE/mmap.c	Thu Oct 14 16:36:52 1999<br>
+++ mm/mmap.c	Thu Oct 14 15:30:30 1999<br>
@@ -324,8 +324,10 @@<br>
 	 */<br>
 	flags = vma-&gt;vm_flags;<br>
 	addr = vma-&gt;vm_start; /* can addr have changed?? */<br>
+	vmlist_modify_lock(mm);<br>
 	insert_vm_struct(mm, vma);<br>
 	merge_segments(mm, vma-&gt;vm_start, vma-&gt;vm_end);<br>
+	vmlist_modify_unlock(mm);<br>
 	<br>
 	mm-&gt;total_vm += len &gt;&gt; PAGE_SHIFT;<br>
 	if (flags &amp; VM_LOCKED) {<br>
@@ -528,11 +530,13 @@<br>
 	}<br>
 <br>
 	/* Work out to one of the ends. */<br>
-	if (end == area-&gt;vm_end)<br>
+	if (end == area-&gt;vm_end) {<br>
 		area-&gt;vm_end = addr;<br>
-	else if (addr == area-&gt;vm_start) {<br>
+		vmlist_modify_lock(current-&gt;mm);<br>
+	} else if (addr == area-&gt;vm_start) {<br>
 		area-&gt;vm_offset += (end - area-&gt;vm_start);<br>
 		area-&gt;vm_start = end;<br>
+		vmlist_modify_lock(current-&gt;mm);<br>
 	} else {<br>
 	/* Unmapping a hole: area-&gt;vm_start &lt; addr &lt;= end &lt; area-&gt;vm_end */<br>
 		/* Add end mapping -- leave beginning for below */<br>
@@ -553,10 +557,12 @@<br>
 		if (mpnt-&gt;vm_ops &amp;&amp; mpnt-&gt;vm_ops-&gt;open)<br>
 			mpnt-&gt;vm_ops-&gt;open(mpnt);<br>
 		area-&gt;vm_end = addr;	/* Truncate area */<br>
+		vmlist_modify_lock(current-&gt;mm);<br>
 		insert_vm_struct(current-&gt;mm, mpnt);<br>
 	}<br>
 <br>
 	insert_vm_struct(current-&gt;mm, area);<br>
+	vmlist_modify_unlock(current-&gt;mm);<br>
 	return extra;<br>
 }<br>
 <br>
@@ -656,6 +662,7 @@<br>
 <br>
 	npp = (prev ? &amp;prev-&gt;vm_next : &amp;mm-&gt;mmap);<br>
 	free = NULL;<br>
+	vmlist_modify_lock(mm);<br>
 	for ( ; mpnt &amp;&amp; mpnt-&gt;vm_start &lt; addr+len; mpnt = *npp) {<br>
 		*npp = mpnt-&gt;vm_next;<br>
 		mpnt-&gt;vm_next = free;<br>
@@ -663,6 +670,8 @@<br>
 		if (mm-&gt;mmap_avl)<br>
 			avl_remove(mpnt, &amp;mm-&gt;mmap_avl);<br>
 	}<br>
+	mm-&gt;mmap_cache = NULL;	/* Kill the cache. */<br>
+	vmlist_modify_unlock(mm);<br>
 <br>
 	/* Ok - we have the memory areas we should free on the 'free' list,<br>
 	 * so release them, and unmap the page range..<br>
@@ -679,6 +688,11 @@<br>
 		end = end &gt; mpnt-&gt;vm_end ? mpnt-&gt;vm_end : end;<br>
 		size = end - st;<br>
 <br>
+		/*<br>
+		 * The lock_kernel interlocks with kswapd try_to_swap_out<br>
+		 * invoking a driver swapout() method, and being able to<br>
+		 * guarantee vma existance.<br>
+		 */<br>
 		lock_kernel();<br>
 		if (mpnt-&gt;vm_ops &amp;&amp; mpnt-&gt;vm_ops-&gt;unmap)<br>
 			mpnt-&gt;vm_ops-&gt;unmap(mpnt, st, size);<br>
@@ -703,7 +717,6 @@<br>
 <br>
 	free_pgtables(mm, prev, addr, addr+len);<br>
 <br>
-	mm-&gt;mmap_cache = NULL;	/* Kill the cache. */<br>
 	return 0;<br>
 }<br>
 <br>
@@ -787,8 +800,10 @@<br>
 	flags = vma-&gt;vm_flags;<br>
 	addr = vma-&gt;vm_start;<br>
 <br>
+	vmlist_modify_lock(mm);<br>
 	insert_vm_struct(mm, vma);<br>
 	merge_segments(mm, vma-&gt;vm_start, vma-&gt;vm_end);<br>
+	vmlist_modify_unlock(mm);<br>
 	<br>
 	mm-&gt;total_vm += len &gt;&gt; PAGE_SHIFT;<br>
 	if (flags &amp; VM_LOCKED) {<br>
@@ -815,7 +830,9 @@<br>
 <br>
 	release_segments(mm);<br>
 	mpnt = mm-&gt;mmap;<br>
+	vmlist_modify_lock(mm);<br>
 	mm-&gt;mmap = mm-&gt;mmap_avl = mm-&gt;mmap_cache = NULL;<br>
+	vmlist_modify_unlock(mm);<br>
 	mm-&gt;rss = 0;<br>
 	mm-&gt;total_vm = 0;<br>
 	mm-&gt;locked_vm = 0;<br>
@@ -911,6 +928,7 @@<br>
 		prev = mpnt;<br>
 		mpnt = mpnt-&gt;vm_next;<br>
 	}<br>
+	mm-&gt;mmap_cache = NULL;		/* Kill the cache. */<br>
 <br>
 	/* prev and mpnt cycle through the list, as long as<br>
 	 * start_addr &lt; mpnt-&gt;vm_end &amp;&amp; prev-&gt;vm_start &lt; end_addr<br>
@@ -947,7 +965,9 @@<br>
 		if (mpnt-&gt;vm_ops &amp;&amp; mpnt-&gt;vm_ops-&gt;close) {<br>
 			mpnt-&gt;vm_offset += mpnt-&gt;vm_end - mpnt-&gt;vm_start;<br>
 			mpnt-&gt;vm_start = mpnt-&gt;vm_end;<br>
+			vmlist_modify_unlock(mm);<br>
 			mpnt-&gt;vm_ops-&gt;close(mpnt);<br>
+			vmlist_modify_lock(mm);<br>
 		}<br>
 		mm-&gt;map_count--;<br>
 		remove_shared_vm_struct(mpnt);<br>
@@ -956,7 +976,6 @@<br>
 		kmem_cache_free(vm_area_cachep, mpnt);<br>
 		mpnt = prev;<br>
 	}<br>
-	mm-&gt;mmap_cache = NULL;		/* Kill the cache. */<br>
 }<br>
 <br>
 void __init vma_init(void)<br>
--- /usr/tmp/p_rdiff_a003iN/mprotect.c	Thu Oct 14 16:37:02 1999<br>
+++ mm/mprotect.c	Wed Oct 13 10:57:02 1999<br>
@@ -82,8 +82,10 @@<br>
 static inline int mprotect_fixup_all(struct vm_area_struct * vma,<br>
 	int newflags, pgprot_t prot)<br>
 {<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
 	vma-&gt;vm_flags = newflags;<br>
 	vma-&gt;vm_page_prot = prot;<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -97,9 +99,7 @@<br>
 	if (!n)<br>
 		return -ENOMEM;<br>
 	*n = *vma;<br>
-	vma-&gt;vm_start = end;<br>
 	n-&gt;vm_end = end;<br>
-	vma-&gt;vm_offset += vma-&gt;vm_start - n-&gt;vm_start;<br>
 	n-&gt;vm_flags = newflags;<br>
 	n-&gt;vm_page_prot = prot;<br>
 	if (n-&gt;vm_file)<br>
@@ -106,7 +106,11 @@<br>
 		get_file(n-&gt;vm_file);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
+	vma-&gt;vm_offset += end - vma-&gt;vm_start;<br>
+	vma-&gt;vm_start = end;<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -120,7 +124,6 @@<br>
 	if (!n)<br>
 		return -ENOMEM;<br>
 	*n = *vma;<br>
-	vma-&gt;vm_end = start;<br>
 	n-&gt;vm_start = start;<br>
 	n-&gt;vm_offset += n-&gt;vm_start - vma-&gt;vm_start;<br>
 	n-&gt;vm_flags = newflags;<br>
@@ -129,7 +132,10 @@<br>
 		get_file(n-&gt;vm_file);<br>
 	if (n-&gt;vm_ops &amp;&amp; n-&gt;vm_ops-&gt;open)<br>
 		n-&gt;vm_ops-&gt;open(n);<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
+	vma-&gt;vm_end = start;<br>
 	insert_vm_struct(current-&gt;mm, n);<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -150,13 +156,8 @@<br>
 	*left = *vma;<br>
 	*right = *vma;<br>
 	left-&gt;vm_end = start;<br>
-	vma-&gt;vm_start = start;<br>
-	vma-&gt;vm_end = end;<br>
 	right-&gt;vm_start = end;<br>
-	vma-&gt;vm_offset += vma-&gt;vm_start - left-&gt;vm_start;<br>
 	right-&gt;vm_offset += right-&gt;vm_start - left-&gt;vm_start;<br>
-	vma-&gt;vm_flags = newflags;<br>
-	vma-&gt;vm_page_prot = prot;<br>
 	if (vma-&gt;vm_file)<br>
 		atomic_add(2,&amp;vma-&gt;vm_file-&gt;f_count);<br>
 	if (vma-&gt;vm_ops &amp;&amp; vma-&gt;vm_ops-&gt;open) {<br>
@@ -163,8 +164,15 @@<br>
 		vma-&gt;vm_ops-&gt;open(left);<br>
 		vma-&gt;vm_ops-&gt;open(right);<br>
 	}<br>
+	vmlist_modify_lock(vma-&gt;vm_mm);<br>
+	vma-&gt;vm_offset += start - vma-&gt;vm_start;<br>
+	vma-&gt;vm_start = start;<br>
+	vma-&gt;vm_end = end;<br>
+	vma-&gt;vm_flags = newflags;<br>
+	vma-&gt;vm_page_prot = prot;<br>
 	insert_vm_struct(current-&gt;mm, left);<br>
 	insert_vm_struct(current-&gt;mm, right);<br>
+	vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -246,7 +254,9 @@<br>
 			break;<br>
 		}<br>
 	}<br>
+	vmlist_modify_lock(current-&gt;mm);<br>
 	merge_segments(current-&gt;mm, start, end);<br>
+	vmlist_modify_unlock(current-&gt;mm);<br>
 out:<br>
 	up(&amp;current-&gt;mm-&gt;mmap_sem);<br>
 	return error;<br>
--- /usr/tmp/p_rdiff_a003iW/mremap.c	Thu Oct 14 16:37:10 1999<br>
+++ mm/mremap.c	Wed Oct 13 10:58:54 1999<br>
@@ -141,8 +141,10 @@<br>
 				get_file(new_vma-&gt;vm_file);<br>
 			if (new_vma-&gt;vm_ops &amp;&amp; new_vma-&gt;vm_ops-&gt;open)<br>
 				new_vma-&gt;vm_ops-&gt;open(new_vma);<br>
+			vmlist_modify_lock(current-&gt;mm);<br>
 			insert_vm_struct(current-&gt;mm, new_vma);<br>
 			merge_segments(current-&gt;mm, new_vma-&gt;vm_start, new_vma-&gt;vm_end);<br>
+			vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 			do_munmap(addr, old_len);<br>
 			current-&gt;mm-&gt;total_vm += new_len &gt;&gt; PAGE_SHIFT;<br>
 			if (new_vma-&gt;vm_flags &amp; VM_LOCKED) {<br>
@@ -220,7 +222,9 @@<br>
 		/* can we just expand the current mapping? */<br>
 		if (max_addr - addr &gt;= new_len) {<br>
 			int pages = (new_len - old_len) &gt;&gt; PAGE_SHIFT;<br>
+			vmlist_modify_lock(vma-&gt;vm_mm);<br>
 			vma-&gt;vm_end = addr + new_len;<br>
+			vmlist_modify_unlock(vma-&gt;vm_mm);<br>
 			current-&gt;mm-&gt;total_vm += pages;<br>
 			if (vma-&gt;vm_flags &amp; VM_LOCKED) {<br>
 				current-&gt;mm-&gt;locked_vm += pages;<br>
--- /usr/tmp/p_rdiff_a003id/vmscan.c	Thu Oct 14 16:37:19 1999<br>
+++ mm/vmscan.c	Thu Oct 14 14:49:38 1999<br>
@@ -139,6 +139,7 @@<br>
 		spin_unlock(&amp;vma-&gt;vm_mm-&gt;page_table_lock);<br>
 		flush_tlb_page(vma, address);<br>
 		vma-&gt;vm_mm-&gt;rss--;<br>
+		vmlist_access_unlock(vma-&gt;vm_mm);<br>
 		error = vma-&gt;vm_ops-&gt;swapout(vma, page);<br>
 		if (!error)<br>
 			goto out_free_success;<br>
@@ -164,6 +165,7 @@<br>
 	spin_unlock(&amp;vma-&gt;vm_mm-&gt;page_table_lock);<br>
 <br>
 	flush_tlb_page(vma, address);<br>
+	vmlist_access_unlock(vma-&gt;vm_mm);<br>
 	swap_duplicate(entry);	/* One for the process, one for the swap cache */<br>
 <br>
 	/* This will also lock the page */<br>
@@ -295,6 +297,7 @@<br>
 	/*<br>
 	 * Find the proper vm-area<br>
 	 */<br>
+	vmlist_access_lock(mm);<br>
 	vma = find_vma(mm, address);<br>
 	if (vma) {<br>
 		if (address &lt; vma-&gt;vm_start)<br>
@@ -310,6 +313,7 @@<br>
 			address = vma-&gt;vm_start;<br>
 		}<br>
 	}<br>
+	vmlist_access_unlock(mm);<br>
 <br>
 	/* We didn't find anything for the process */<br>
 	mm-&gt;swap_cnt = 0;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0894.html">Andrej Todosic: "compaq raid smart 2 xx array"</a>
<li> <b>Previous message:</b> <a href="0892.html">David S. Miller: "Re: Is the list dead?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0894.html">Andrej Todosic: "compaq raid smart 2 xx array"</a>
<li> <b>Reply:</b> <a href="0894.html">Andrej Todosic: "compaq raid smart 2 xx array"</a>
<li> <b>Reply:</b> <a href="0959.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Reply:</b> <a href="1047.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Reply:</b> <a href="1073.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Reply:</b> <a href="1095.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<!-- reply="end" -->
</ul>
</font></body>
