<!-- received="Fri Oct 15 04:55:02 1999 EET DST" -->
<!-- sent="Fri, 15 Oct 1999 02:48:49 +0100" -->
<!-- name="Alan Cox" -->
<!-- email="alan@lxorguk.ukuu.org.uk" -->
<!-- subject="Fixing the VIA rhine a bit" -->
<!-- id="E11bwUD-00045W-00@the-village.bc.nu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: Fixing the VIA rhine a bit</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Fixing the VIA rhine a bit</h1>
<b>Alan Cox</b> (<a href="mailto:alan@lxorguk.ukuu.org.uk"><i>alan@lxorguk.ukuu.org.uk</i></a>)<br>
<i>Fri, 15 Oct 1999 02:48:49 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#903">[ date ]</a><a href="index.html#903">[ thread ]</a><a href="subject.html#903">[ subject ]</a><a href="author.html#903">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0904.html">Alan Cox: "Acard ATP870U SCSI fixes: testers needed"</a>
<li> <b>Previous message:</b> <a href="0902.html">Colleen & Ken: "Compiling 2.2.5-15smp &amp; RH 6.0--"No setup signature found""</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1034.html">Urban Widmark: "Re: Fixing the VIA rhine a bit"</a>
<li> <b>Reply:</b> <a href="1034.html">Urban Widmark: "Re: Fixing the VIA rhine a bit"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Can someone with 2.3.22pre and a via rhine card test this out<br>
<p>
It should fix the memory allocation checks and also reserve memory space<br>
in MMIO mode<br>
<p>
diff -u --new-file --recursive --exclude-from ../exclude linux.22p2/drivers/net/via-rhine.c linux.ac/drivers/net/via-rhine.c<br>
--- linux.22p2/drivers/net/via-rhine.c	Fri Oct 15 02:43:46 1999<br>
+++ linux.ac/drivers/net/via-rhine.c	Thu Oct 14 15:24:57 1999<br>
@@ -110,14 +110,9 @@<br>
 #define RUN_AT(x) (jiffies + (x))<br>
 <br>
 #ifdef MODULE<br>
-char kernel_version[] = UTS_RELEASE;<br>
-#else<br>
-#ifndef __alpha__<br>
-#define ioremap vremap<br>
-#define iounmap vfree<br>
-#endif<br>
+static char kernel_version[] = UTS_RELEASE;<br>
 #endif<br>
-#if defined(MODULE) &amp;&amp; LINUX_VERSION_CODE &gt; 0x20115<br>
+<br>
 MODULE_AUTHOR("Donald Becker &lt;<a href="mailto:becker@cesdis.gsfc.nasa.gov">becker@cesdis.gsfc.nasa.gov</a>&gt;");<br>
 MODULE_DESCRIPTION("VIA Rhine PCI Fast Ethernet driver");<br>
 MODULE_PARM(max_interrupt_work, "i");<br>
@@ -126,15 +121,7 @@<br>
 MODULE_PARM(rx_copybreak, "i");<br>
 MODULE_PARM(options, "1-" __MODULE_STRING(MAX_UNITS) "i");<br>
 MODULE_PARM(full_duplex, "1-" __MODULE_STRING(MAX_UNITS) "i");<br>
-#endif<br>
-#if LINUX_VERSION_CODE &lt; 0x20123<br>
-#define test_and_set_bit(val, addr) set_bit(val, addr)<br>
-#endif<br>
-#if LINUX_VERSION_CODE &lt;= 0x20139<br>
-#define	net_device_stats enet_statistics<br>
-#else<br>
-#define NETSTATS_VER2<br>
-#endif<br>
+<br>
 #if LINUX_VERSION_CODE &lt; 0x20155  ||  defined(CARDBUS)<br>
 /* Grrrr, the PCI code changed, but did not consider CardBus... */<br>
 #include &lt;linux/bios32.h&gt;<br>
@@ -142,11 +129,8 @@<br>
 #else<br>
 #define PCI_SUPPORT_VER2<br>
 #endif<br>
-#if LINUX_VERSION_CODE &lt; 0x20159<br>
-#define dev_free_skb(skb) dev_kfree_skb(skb, FREE_WRITE);<br>
-#else<br>
+<br>
 #define dev_free_skb(skb) dev_kfree_skb(skb);<br>
-#endif<br>
 <br>
 <br>
 /*<br>
@@ -254,12 +238,12 @@<br>
 	u16	vendor_id, device_id, device_id_mask, flags;<br>
 	int io_size;<br>
 	struct net_device *(*probe1)(int pci_bus, int pci_devfn, struct net_device *dev,<br>
-							 long ioaddr, int irq, int chip_idx, int fnd_cnt);<br>
+							 long ioaddr, int irq, int chip_idx, int fnd_cnt, unsigned long pciaddr);<br>
 };<br>
 <br>
 static struct net_device *via_probe1(int pci_bus, int pci_devfn,<br>
 								 struct net_device *dev, long ioaddr, int irq,<br>
-								 int chp_idx, int fnd_cnt);<br>
+								 int chp_idx, int fnd_cnt, unsigned long pciaddr);<br>
 <br>
 static struct pci_id_info pci_tbl[] = {<br>
 	{ "VIA VT86C100A Rhine-II", 0x1106, 0x6100, 0xffff,<br>
@@ -370,6 +354,7 @@<br>
 	int mii_cnt;						/* MII device addresses. */<br>
 	u16 advertising;					/* NWay media advertisement */<br>
 	unsigned char phys[2];				/* MII device addresses. */<br>
+	unsigned long physaddr;				/* Physical address if MMIO */<br>
 };<br>
 <br>
 static int  mdio_read(struct net_device *dev, int phy_id, int location);<br>
@@ -465,11 +450,16 @@<br>
 			ioaddr = pciaddr &amp; ~3;<br>
 			if (check_region(ioaddr, pci_tbl[chip_idx].io_size))<br>
 				continue;<br>
-		} else if ((ioaddr = (long)ioremap(pciaddr &amp; ~0xf,<br>
-										 pci_tbl[chip_idx].io_size)) == 0) {<br>
-			printk(KERN_INFO "Failed to map PCI address %#lx.\n",<br>
-				   pciaddr);<br>
-			continue;<br>
+		} <br>
+		else <br>
+		{<br>
+			if(check_mem_region(pciaddr, pci_tbl[chip_idx].io_size))<br>
+				continue;<br>
+			if ((ioaddr = (long)ioremap(pciaddr &amp; ~0xf,  pci_tbl[chip_idx].io_size)) == 0) {<br>
+				printk(KERN_INFO "Failed to map PCI address %#lx.\n",<br>
+					   pciaddr);<br>
+				continue;<br>
+			}<br>
 		}<br>
 <br>
 		pcibios_read_config_word(pci_bus, pci_device_fn,<br>
@@ -484,7 +474,7 @@<br>
 		}<br>
 <br>
 		dev = pci_tbl[chip_idx].probe1(pci_bus, pci_device_fn, dev, ioaddr,<br>
-									   irq, chip_idx, cards_found);<br>
+									   irq, chip_idx, cards_found, pciaddr);<br>
 <br>
 		if (dev  &amp;&amp; (pci_tbl[chip_idx].flags &amp; PCI_COMMAND_MASTER)) {<br>
 			u8 pci_latency;<br>
@@ -513,14 +503,17 @@<br>
 }<br>
 #endif<br>
 <br>
+<br>
 static struct net_device *via_probe1(int pci_bus, int pci_devfn,<br>
 								 struct net_device *dev, long ioaddr, int irq,<br>
-								 int chip_id, int card_idx)<br>
+								 int chip_id, int card_idx, unsigned long pciaddr)<br>
 {<br>
 	struct netdev_private *np;<br>
 	int i, option = card_idx &lt; MAX_UNITS ? options[card_idx] : 0;<br>
 <br>
 	dev = init_etherdev(dev, 0);<br>
+	if(dev==NULL)<br>
+		return NULL;<br>
 <br>
 	printk(KERN_INFO "%s: %s at 0x%lx, ",<br>
 		   dev-&gt;name, pci_tbl[chip_id].name, ioaddr);<br>
@@ -532,8 +525,19 @@<br>
 			printk("%2.2x:", dev-&gt;dev_addr[i]);<br>
 	printk("%2.2x, IRQ %d.\n", dev-&gt;dev_addr[i], irq);<br>
 <br>
+	/* Make certain the descriptor lists are cache-aligned. */<br>
+	np = (void *)(((long)kmalloc(sizeof(*np), GFP_KERNEL) + 31) &amp; ~31);<br>
+	if(np==NULL)<br>
+	{<br>
+		printk(KERN_ERR "%s: No memory for descriptor buffers.\n",<br>
+			dev-&gt;name);<br>
+		return NULL;<br>
+	}<br>
+<br>
 #ifdef VIA_USE_IO<br>
 	request_region(ioaddr, pci_tbl[chip_id].io_size, dev-&gt;name);<br>
+#else<br>
+	request_mem_region(pciaddr, pci_tbl[chip_id].io_size, dev-&gt;name);	<br>
 #endif<br>
 <br>
 	/* Reset the chip to erase previous misconfiguration. */<br>
@@ -542,8 +546,6 @@<br>
 	dev-&gt;base_addr = ioaddr;<br>
 	dev-&gt;irq = irq;<br>
 <br>
-	/* Make certain the descriptor lists are cache-aligned. */<br>
-	np = (void *)(((long)kmalloc(sizeof(*np), GFP_KERNEL) + 31) &amp; ~31);<br>
 	memset(np, 0, sizeof(*np));<br>
 	dev-&gt;priv = np;<br>
 <br>
@@ -553,6 +555,7 @@<br>
 	np-&gt;pci_bus = pci_bus;<br>
 	np-&gt;pci_devfn = pci_devfn;<br>
 	np-&gt;chip_id = chip_id;<br>
+	np-&gt;physaddr = pciaddr;<br>
 <br>
 	if (dev-&gt;mem_start)<br>
 		option = dev-&gt;mem_start;<br>
@@ -761,15 +764,14 @@<br>
 		   dev-&gt;name, readw(ioaddr + IntrStatus),<br>
 		   mdio_read(dev, np-&gt;phys[0], 1));<br>
 <br>
-  /* Perhaps we should reinitialize the hardware here. */<br>
-  dev-&gt;if_port = 0;<br>
-  /* Stop and restart the chip's Tx processes . */<br>
-<br>
-  /* Trigger an immediate transmit demand. */<br>
-<br>
-  dev-&gt;trans_start = jiffies;<br>
-  np-&gt;stats.tx_errors++;<br>
-  return;<br>
+	/* Perhaps we should reinitialize the hardware here. */<br>
+	dev-&gt;if_port = 0;<br>
+	/* Stop and restart the chip's Tx processes . */<br>
+<br>
+	/* Trigger an immediate transmit demand. */<br>
+<br>
+	dev-&gt;trans_start = jiffies;<br>
+	np-&gt;stats.tx_errors++;<br>
 }<br>
 <br>
 <br>
@@ -947,9 +949,7 @@<br>
 				if (txstatus &amp; 0x0001) np-&gt;stats.tx_deferred++;<br>
 #endif<br>
 				np-&gt;stats.collisions += (txstatus &gt;&gt; 3) &amp; 15;<br>
-#if defined(NETSTATS_VER2)<br>
 				np-&gt;stats.tx_bytes += np-&gt;tx_ring[entry].desc_length &amp; 0x7ff;<br>
-#endif<br>
 				np-&gt;stats.tx_packets++;<br>
 			}<br>
 			/* Free the original skb. */<br>
@@ -1288,6 +1288,7 @@<br>
 #ifdef VIA_USE_IO<br>
 		release_region(root_net_dev-&gt;base_addr, pci_tbl[np-&gt;chip_id].io_size);<br>
 #else<br>
+		release_mem_region(np-&gt;physaddr, pci_tbl[np-&gt;chip_id].io_size);<br>
 		iounmap((char *)(root_net_dev-&gt;base_addr));<br>
 #endif<br>
 		kfree(root_net_dev);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0904.html">Alan Cox: "Acard ATP870U SCSI fixes: testers needed"</a>
<li> <b>Previous message:</b> <a href="0902.html">Colleen & Ken: "Compiling 2.2.5-15smp &amp; RH 6.0--"No setup signature found""</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1034.html">Urban Widmark: "Re: Fixing the VIA rhine a bit"</a>
<li> <b>Reply:</b> <a href="1034.html">Urban Widmark: "Re: Fixing the VIA rhine a bit"</a>
<!-- reply="end" -->
</ul>
</font></body>
