<!-- received="Fri Oct 15 05:10:33 1999 EET DST" -->
<!-- sent="Fri, 15 Oct 1999 03:03:37 +0100" -->
<!-- name="Alan Cox" -->
<!-- email="alan@lxorguk.ukuu.org.uk" -->
<!-- subject="Acard ATP870U SCSI fixes: testers needed" -->
<!-- id="E11bwiX-00047Y-00@the-village.bc.nu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: Acard ATP870U SCSI fixes: testers needed</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Acard ATP870U SCSI fixes: testers needed</h1>
<b>Alan Cox</b> (<a href="mailto:alan@lxorguk.ukuu.org.uk"><i>alan@lxorguk.ukuu.org.uk</i></a>)<br>
<i>Fri, 15 Oct 1999 03:03:37 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#904">[ date ]</a><a href="index.html#904">[ thread ]</a><a href="subject.html#904">[ subject ]</a><a href="author.html#904">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0905.html">Dale Harris: "RNDGETPOOL ioctl wierdness"</a>
<li> <b>Previous message:</b> <a href="0903.html">Alan Cox: "Fixing the VIA rhine a bit"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
These should fix the problems with the Acard only working compiled in<br>
with 2.0, not working with 2.2 or 2.3. Can someone with this card provide<br>
feedback<br>
<p>
diff -u --new-file --recursive --exclude-from ../exclude linux.22p2/drivers/scsi/atp870u.c linux.ac/drivers/scsi/atp870u.c<br>
--- linux.22p2/drivers/scsi/atp870u.c	Fri Oct 15 02:44:00 1999<br>
+++ linux.ac/drivers/scsi/atp870u.c	Thu Oct 14 15:25:49 1999<br>
@@ -1,7 +1,7 @@<br>
 /* $Id: atp870u.c,v 1.0 1997/05/07 15:22:00 root Exp root $<br>
  *  linux/kernel/atp870u.c<br>
  *<br>
- *  Copyright (C) 1997	Wu Ching Chen<br>
+ *  Copyright (C) 1997  Wu Ching Chen<br>
  *  2.1.x update (C) 1998  Krzysztof G. Baranowski<br>
  *   <br>
  * Marcelo Tosatti &lt;<a href="mailto:marcelo@conectiva.com.br">marcelo@conectiva.com.br</a>&gt; : SMP fixes <br>
@@ -30,745 +30,620 @@<br>
 <br>
 #include&lt;linux/stat.h&gt;<br>
 <br>
-struct proc_dir_entry proc_scsi_atp870u = {<br>
-    PROC_SCSI_ATP870U, 7, "atp870u",<br>
-    S_IFDIR | S_IRUGO | S_IXUGO, 2<br>
+struct proc_dir_entry proc_scsi_atp870u =<br>
+{<br>
+	PROC_SCSI_ATP870U, 7, "atp870u",<br>
+	S_IFDIR | S_IRUGO | S_IXUGO, 2<br>
 };<br>
 <br>
 void mydlyu(unsigned int);<br>
+<br>
 /*<br>
-static const char RCSid[] = "$Header: /usr/src/linux/kernel/blk_drv/scsi/RCS/atp870u.c,v 1.0 1997/05/07 15:22:00 root Exp root $";<br>
-*/<br>
+ *   static const char RCSid[] = "$Header: /usr/src/linux/kernel/blk_drv/scsi/RCS/atp870u.c,v 1.0 1997/05/07 15:22:00 root Exp root $";<br>
+ */<br>
+<br>
+static unsigned char admaxu = 1, host_idu[2], chip_veru[2], scam_on[2], global_map[2];<br>
+static unsigned short int active_idu[2], wide_idu[2], sync_idu, ultra_map[2];<br>
+static int workingu[2] = {0, 0};<br>
+<br>
+static Scsi_Cmnd *querequ[2][qcnt], *curr_req[2][16];<br>
+<br>
+static unsigned char devspu[2][16] = {<br>
+	{0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,<br>
+	 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20},<br>
+	{0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,<br>
+	 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20}<br>
+};<br>
 <br>
-static unsigned char admaxu=1,host_idu[2],chip_veru[2],scam_on[2],global_map[2];<br>
-static unsigned short int active_idu[2],wide_idu[2],sync_idu,ultra_map[2];<br>
-static int  workingu[2]={0,0};<br>
-static Scsi_Cmnd *querequ[2][qcnt],*curr_req[2][16];<br>
-static unsigned char devspu[2][16] = {{0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,<br>
-				0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20},<br>
-			       {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,<br>
-				0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20}};<br>
-static unsigned char dirctu[2][16],last_cmd[2],in_snd[2],in_int[2];<br>
+static unsigned char dirctu[2][16], last_cmd[2], in_snd[2], in_int[2];<br>
 static unsigned char ata_cdbu[2][16];<br>
-static unsigned int ioportu[2]={0,0};<br>
-static unsigned int irqnumu[2]={0,0};<br>
+static unsigned int ioportu[2] = {0, 0};<br>
+static unsigned int irqnumu[2] = {0, 0};<br>
 static unsigned short int pciportu[2];<br>
-static unsigned long prdaddru[2][16],tran_lenu[2][16],last_lenu[2][16];<br>
+static unsigned long prdaddru[2][16], tran_lenu[2][16], last_lenu[2][16];<br>
 static unsigned char prd_tableu[2][16][1024];<br>
 static unsigned char *prd_posu[2][16];<br>
-static unsigned char quhdu[2],quendu[2];<br>
-static unsigned char devtypeu[2][16] = {{ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},<br>
-				 { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};<br>
-static struct Scsi_Host * atp_host[2]={NULL,NULL};<br>
+static unsigned char quhdu[2], quendu[2];<br>
+<br>
+static unsigned char devtypeu[2][16] =<br>
+{<br>
+	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},<br>
+	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}<br>
+};<br>
+<br>
+static struct Scsi_Host *atp_host[2] = {NULL, NULL};<br>
 <br>
 static void atp870u_intr_handle(int irq, void *dev_id, struct pt_regs *regs)<br>
 {<br>
-	 unsigned long flags;<br>
-    unsigned short int	tmpcip,id;<br>
-    unsigned char	i,j,h,tarid,lun;<br>
-    unsigned char  *prd;<br>
-    Scsi_Cmnd *workrequ;<br>
-    unsigned int workportu,tmport;<br>
-    unsigned long adrcntu,k;<br>
-    int      errstus;<br>
-<br>
-    for ( h=0; h &lt; 2; h++ )<br>
-    {<br>
-	if ( ( irq &amp; 0x0f ) == irqnumu[h] )<br>
-	{<br>
-	   goto irq_numok;<br>
+	unsigned long flags;<br>
+	unsigned short int tmpcip, id;<br>
+	unsigned char i, j, h, tarid, lun;<br>
+	unsigned char *prd;<br>
+	Scsi_Cmnd *workrequ;<br>
+	unsigned int workportu, tmport;<br>
+	unsigned long adrcntu, k;<br>
+	int errstus;<br>
+<br>
+	for (h = 0; h &lt; 2; h++) {<br>
+		if (irq == irqnumu[h]) {<br>
+			goto irq_numok;<br>
+		}<br>
 	}<br>
-    }<br>
-    return;<br>
+	return;<br>
 irq_numok:<br>
-    in_int[h]=1;<br>
-    workportu=ioportu[h];<br>
-    tmport=workportu;<br>
-<br>
-    if ( workingu[h] != 0 )<br>
-    {<br>
-       tmport += 0x1f;<br>
-       j=inb(tmport);<br>
-       tmpcip=pciportu[h];<br>
-       if ((inb(tmpcip) &amp; 0x08) != 0)<br>
-       {<br>
-	  tmpcip += 0x2;<br>
-	  while((inb(tmpcip) &amp; 0x08) != 0);<br>
-       }<br>
-       tmpcip=pciportu[h];<br>
-       outb(0x00,tmpcip);<br>
-       tmport -=0x08;<br>
-       i=inb(tmport);<br>
-       if ((j &amp; 0x40) == 0)<br>
-       {<br>
-	  if ((last_cmd[h] &amp; 0x40) == 0)<br>
-	  {<br>
-	     last_cmd[h]=0xff;<br>
-	  }<br>
-       }<br>
-       else<br>
-       {<br>
-	  last_cmd[h] |= 0x40;<br>
-       }<br>
-       tmport -= 0x02;<br>
-       tarid=inb(tmport);<br>
-       tmport += 0x02;<br>
-       if ((tarid &amp; 0x40) != 0)<br>
-       {<br>
-	  tarid=(tarid &amp; 0x07) | 0x08;<br>
-       }<br>
-       else<br>
-       {<br>
-	  tarid &amp;= 0x07;<br>
-       }<br>
-       if ( i == 0x85 )<br>
-       {<br>
-	  if (wide_idu[h] != 0)<br>
-	  {<br>
-	     tmport=workportu+0x1b;<br>
-	     j=inb(tmport) &amp; 0x0e;<br>
-	     j |= 0x01;<br>
-	     outb(j,tmport);<br>
-	  }<br>
-	  if (((quhdu[h] != quendu[h]) || (last_cmd[h] != 0xff)) &amp;&amp;<br>
-	      (in_snd[h] == 0))<br>
-	  {<br>
-	     send_s870(h);<br>
-	  }<br>
-	  in_int[h]=0;<br>
-	  return;<br>
-       }<br>
-       if ( i == 0x21 )<br>
-       {<br>
-	  tmport -= 0x05;<br>
-	  adrcntu=0;<br>
-	  ((unsigned char *)&amp;adrcntu)[2]=inb(tmport++);<br>
-	  ((unsigned char *)&amp;adrcntu)[1]=inb(tmport++);<br>
-	  ((unsigned char *)&amp;adrcntu)[0]=inb(tmport);<br>
-	  k=last_lenu[h][tarid];<br>
-	  k -= adrcntu;<br>
-	  tran_lenu[h][tarid]= k;<br>
-	  last_lenu[h][tarid]=adrcntu;<br>
-	  tmport -= 0x04;<br>
-	  outb(0x41,tmport);<br>
-	  tmport += 0x08;<br>
-	  outb(0x08,tmport);<br>
-	  in_int[h]=0;<br>
-	  return ;<br>
-       }<br>
-<br>
-       if ((i == 0x80) || (i == 0x8f))<br>
-       {<br>
-	  lun=0;<br>
-	  tmport -= 0x07;<br>
-	  j=inb(tmport);<br>
-	  if ( j == 0x44 )<br>
-	  {<br>
-	     tmport += 0x0d;<br>
-	     lun=inb(tmport) &amp; 0x07;<br>
-	  }<br>
-	  else<br>
-	  {<br>
-	     if ( j == 0x41 )<br>
-	     {<br>
+	in_int[h] = 1;<br>
+	workportu = ioportu[h];<br>
+	tmport = workportu;<br>
+<br>
+	if (workingu[h] != 0) <br>
+	{<br>
+		tmport += 0x1f;<br>
+		j = inb(tmport);<br>
+<br>
+		tmpcip = pciportu[h];<br>
+		if ((inb(tmpcip) &amp; 0x08) != 0) <br>
+		{<br>
+			tmpcip += 0x2;<br>
+			while ((inb(tmpcip) &amp; 0x08) != 0);<br>
+		}<br>
+		tmpcip = pciportu[h];<br>
+		outb(0x00, tmpcip);<br>
+		tmport -= 0x08;<br>
+<br>
+		i = inb(tmport);<br>
+		if ((j &amp; 0x40) == 0) <br>
+		{<br>
+			if ((last_cmd[h] &amp; 0x40) == 0) <br>
+			{<br>
+				last_cmd[h] = 0xff;<br>
+			}<br>
+		}<br>
+		else last_cmd[h] |= 0x40;<br>
+<br>
+		tmport -= 0x02;<br>
+		tarid = inb(tmport);<br>
 		tmport += 0x02;<br>
-		adrcntu=0;<br>
-		((unsigned char *)&amp;adrcntu)[2]=inb(tmport++);<br>
-		((unsigned char *)&amp;adrcntu)[1]=inb(tmport++);<br>
-		((unsigned char *)&amp;adrcntu)[0]=inb(tmport);<br>
-		k=last_lenu[h][tarid];<br>
-		k -= adrcntu;<br>
-		tran_lenu[h][tarid]= k;<br>
-		last_lenu[h][tarid]=adrcntu;<br>
-		tmport += 0x04;<br>
-		outb(0x08,tmport);<br>
-		in_int[h]=0;<br>
-		return ;<br>
-	     }<br>
-	     else<br>
-	     {<br>
-		outb(0x46,tmport);<br>
-		dirctu[h][tarid]=0x00;<br>
+<br>
+		if ((tarid &amp; 0x40) != 0) {<br>
+			tarid = (tarid &amp; 0x07) | 0x08;<br>
+		} else {<br>
+			tarid &amp;= 0x07;<br>
+		}<br>
+		if (i == 0x85) <br>
+		{<br>
+			if (wide_idu[h] != 0) <br>
+			{<br>
+				tmport = workportu + 0x1b;<br>
+				j = inb(tmport) &amp; 0x0e;<br>
+				j |= 0x01;<br>
+				outb(j, tmport);<br>
+			}<br>
+			if (((quhdu[h] != quendu[h]) || (last_cmd[h] != 0xff)) &amp;&amp;<br>
+			    (in_snd[h] == 0)) <br>
+			{<br>
+				send_s870(h);<br>
+			}<br>
+			in_int[h] = 0;<br>
+			return;<br>
+		}<br>
+		if (i == 0x21) <br>
+		{<br>
+			tmport -= 0x05;<br>
+			adrcntu = 0;<br>
+			((unsigned char *) &amp;adrcntu)[2] = inb(tmport++);<br>
+			((unsigned char *) &amp;adrcntu)[1] = inb(tmport++);<br>
+			((unsigned char *) &amp;adrcntu)[0] = inb(tmport);<br>
+			k = last_lenu[h][tarid];<br>
+			k -= adrcntu;<br>
+			tran_lenu[h][tarid] = k;<br>
+			last_lenu[h][tarid] = adrcntu;<br>
+			tmport -= 0x04;<br>
+			outb(0x41, tmport);<br>
+			tmport += 0x08;<br>
+			outb(0x08, tmport);<br>
+			in_int[h] = 0;<br>
+			return;<br>
+		}<br>
+		if ((i == 0x80) || (i == 0x8f)) <br>
+		{<br>
+			lun = 0;<br>
+			tmport -= 0x07;<br>
+			j = inb(tmport);<br>
+			if (j == 0x44) {<br>
+				tmport += 0x0d;<br>
+				lun = inb(tmport) &amp; 0x07;<br>
+			} else {<br>
+				if (j == 0x41) <br>
+				{<br>
+					tmport += 0x02;<br>
+					adrcntu = 0;<br>
+					((unsigned char *) &amp;adrcntu)[2] = inb(tmport++);<br>
+					((unsigned char *) &amp;adrcntu)[1] = inb(tmport++);<br>
+					((unsigned char *) &amp;adrcntu)[0] = inb(tmport);<br>
+					k = last_lenu[h][tarid];<br>
+					k -= adrcntu;<br>
+					tran_lenu[h][tarid] = k;<br>
+					last_lenu[h][tarid] = adrcntu;<br>
+					tmport += 0x04;<br>
+					outb(0x08, tmport);<br>
+					in_int[h] = 0;<br>
+					return;<br>
+				}<br>
+				else <br>
+				{<br>
+					outb(0x46, tmport);<br>
+					dirctu[h][tarid] = 0x00;<br>
+					tmport += 0x02;<br>
+					outb(0x00, tmport++);<br>
+					outb(0x00, tmport++);<br>
+					outb(0x00, tmport++);<br>
+					tmport += 0x03;<br>
+					outb(0x08, tmport);<br>
+					in_int[h] = 0;<br>
+					return;<br>
+				}<br>
+			}<br>
+			tmport = workportu + 0x10;<br>
+			outb(0x45, tmport);<br>
+			tmport += 0x06;<br>
+			tarid = inb(tmport);<br>
+			if ((tarid &amp; 0x10) != 0) <br>
+			{<br>
+				tarid = (tarid &amp; 0x07) | 0x08;<br>
+			} else {<br>
+				tarid &amp;= 0x07;<br>
+			}<br>
+			workrequ = curr_req[h][tarid];<br>
+			tmport = workportu + 0x0f;<br>
+			outb(lun, tmport);<br>
+			tmport += 0x02;<br>
+			outb(devspu[h][tarid], tmport++);<br>
+			adrcntu = tran_lenu[h][tarid];<br>
+			k = last_lenu[h][tarid];<br>
+			outb(((unsigned char *) &amp;k)[2], tmport++);<br>
+			outb(((unsigned char *) &amp;k)[1], tmport++);<br>
+			outb(((unsigned char *) &amp;k)[0], tmport++);<br>
+			j = tarid;<br>
+			if (tarid &gt; 7) {<br>
+				j = (j &amp; 0x07) | 0x40;<br>
+			}<br>
+			j |= dirctu[h][tarid];<br>
+			outb(j, tmport++);<br>
+			outb(0x80, tmport);<br>
+			tmport = workportu + 0x1b;<br>
+			j = inb(tmport) &amp; 0x0e;<br>
+			id = 1;<br>
+			id = id &lt;&lt; tarid;<br>
+			if ((id &amp; wide_idu[h]) != 0) {<br>
+				j |= 0x01;<br>
+			}<br>
+			outb(j, tmport);<br>
+			if (last_lenu[h][tarid] == 0) {<br>
+				tmport = workportu + 0x18;<br>
+				outb(0x08, tmport);<br>
+				in_int[h] = 0;<br>
+				return;<br>
+			}<br>
+			prd = prd_posu[h][tarid];<br>
+			while (adrcntu != 0) <br>
+			{<br>
+				id = ((unsigned short int *) (prd))[2];<br>
+				if (id == 0) {<br>
+					k = 0x10000;<br>
+				} else {<br>
+					k = id;<br>
+				}<br>
+				if (k &gt; adrcntu) {<br>
+					((unsigned short int *) (prd))[2] = (unsigned short int)<br>
+					    (k - adrcntu);<br>
+					((unsigned long *) (prd))[0] += adrcntu;<br>
+					adrcntu = 0;<br>
+					prd_posu[h][tarid] = prd;<br>
+				} else {<br>
+					adrcntu -= k;<br>
+					prdaddru[h][tarid] += 0x08;<br>
+					prd += 0x08;<br>
+					if (adrcntu == 0) {<br>
+						prd_posu[h][tarid] = prd;<br>
+					}<br>
+				}<br>
+			}<br>
+			tmpcip = pciportu[h] + 0x04;<br>
+			outl(prdaddru[h][tarid], tmpcip);<br>
+			tmpcip -= 0x02;<br>
+			outb(0x06, tmpcip);<br>
+			outb(0x00, tmpcip);<br>
+			tmpcip -= 0x02;<br>
+			tmport = workportu + 0x18;<br>
+			if (dirctu[h][tarid] != 0) {<br>
+				outb(0x08, tmport);<br>
+				outb(0x01, tmpcip);<br>
+				in_int[h] = 0;<br>
+				return;<br>
+			}<br>
+			outb(0x08, tmport);<br>
+			outb(0x09, tmpcip);<br>
+			in_int[h] = 0;<br>
+			return;<br>
+		}<br>
+		workrequ = curr_req[h][tarid];<br>
+		if (i == 0x42) {<br>
+			errstus = 0x02;<br>
+			workrequ-&gt;result = errstus;<br>
+			goto go_42;<br>
+		}<br>
+		if (i == 0x16) <br>
+		{<br>
+			errstus = 0;<br>
+			tmport -= 0x08;<br>
+			errstus = inb(tmport);<br>
+			workrequ-&gt;result = errstus;<br>
+go_42:<br>
+			spin_lock_irqsave(&amp;io_request_lock, flags);<br>
+			(*workrequ-&gt;scsi_done) (workrequ);<br>
+			spin_unlock_irqrestore(&amp;io_request_lock, flags);<br>
+<br>
+			curr_req[h][tarid] = 0;<br>
+			workingu[h]--;<br>
+			if (wide_idu[h] != 0) {<br>
+				tmport = workportu + 0x1b;<br>
+				j = inb(tmport) &amp; 0x0e;<br>
+				j |= 0x01;<br>
+				outb(j, tmport);<br>
+			}<br>
+			if (((last_cmd[h] != 0xff) || (quhdu[h] != quendu[h])) &amp;&amp;<br>
+			    (in_snd[h] == 0)) <br>
+			{<br>
+				send_s870(h);<br>
+			}<br>
+			in_int[h] = 0;<br>
+			return;<br>
+		}<br>
+		if (i == 0x4f) {<br>
+			i = 0x89;<br>
+		}<br>
+		i &amp;= 0x0f;<br>
+		if (i == 0x09) {<br>
+			tmpcip = tmpcip + 4;<br>
+			outl(prdaddru[h][tarid], tmpcip);<br>
+			tmpcip = tmpcip - 2;<br>
+			outb(0x06, tmpcip);<br>
+			outb(0x00, tmpcip);<br>
+			tmpcip = tmpcip - 2;<br>
+			tmport = workportu + 0x10;<br>
+			outb(0x41, tmport);<br>
+			dirctu[h][tarid] = 0x00;<br>
+			tmport += 0x08;<br>
+			outb(0x08, tmport);<br>
+			outb(0x09, tmpcip);<br>
+			in_int[h] = 0;<br>
+			return;<br>
+		}<br>
+		if (i == 0x08) {<br>
+			tmpcip = tmpcip + 4;<br>
+			outl(prdaddru[h][tarid], tmpcip);<br>
+			tmpcip = tmpcip - 2;<br>
+			outb(0x06, tmpcip);<br>
+			outb(0x00, tmpcip);<br>
+			tmpcip = tmpcip - 2;<br>
+			tmport = workportu + 0x10;<br>
+			outb(0x41, tmport);<br>
+			tmport += 0x05;<br>
+			outb((unsigned char) (inb(tmport) | 0x20), tmport);<br>
+			dirctu[h][tarid] = 0x20;<br>
+			tmport += 0x03;<br>
+			outb(0x08, tmport);<br>
+			outb(0x01, tmpcip);<br>
+			in_int[h] = 0;<br>
+			return;<br>
+		}<br>
+		tmport -= 0x07;<br>
+		if (i == 0x0a) {<br>
+			outb(0x30, tmport);<br>
+		} else {<br>
+			outb(0x46, tmport);<br>
+		}<br>
+		dirctu[h][tarid] = 0x00;<br>
 		tmport += 0x02;<br>
-		outb(0x00,tmport++);<br>
-		outb(0x00,tmport++);<br>
-		outb(0x00,tmport++);<br>
-		tmport+=0x03;<br>
-		outb(0x08,tmport);<br>
-		in_int[h]=0;<br>
+		outb(0x00, tmport++);<br>
+		outb(0x00, tmport++);<br>
+		outb(0x00, tmport++);<br>
+		tmport += 0x03;<br>
+		outb(0x08, tmport);<br>
+		in_int[h] = 0;<br>
 		return;<br>
-	     }<br>
-	  }<br>
-	  tmport=workportu + 0x10;<br>
-	  outb(0x45,tmport);<br>
-	  tmport += 0x06;<br>
-	  tarid=inb(tmport);<br>
-	  if ((tarid &amp; 0x10) != 0)<br>
-	  {<br>
-	     tarid=(tarid &amp; 0x07) | 0x08;<br>
-	  }<br>
-	  else<br>
-	  {<br>
-	     tarid &amp;= 0x07;<br>
-	  }<br>
-	  workrequ=curr_req[h][tarid];<br>
-	  tmport=workportu + 0x0f;<br>
-	  outb(lun,tmport);<br>
-	  tmport += 0x02;<br>
-	  outb(devspu[h][tarid],tmport++);<br>
-	  adrcntu=tran_lenu[h][tarid];<br>
-	  k=last_lenu[h][tarid];<br>
-	  outb(((unsigned char *)&amp;k)[2],tmport++);<br>
-	  outb(((unsigned char *)&amp;k)[1],tmport++);<br>
-	  outb(((unsigned char *)&amp;k)[0],tmport++);<br>
-	  j=tarid;<br>
-	  if ( tarid &gt; 7 )<br>
-	  {<br>
-	     j = (j &amp; 0x07) | 0x40;<br>
-	  }<br>
-	  j |= dirctu[h][tarid];<br>
-	  outb(j,tmport++);<br>
-	  outb(0x80,tmport);<br>
-	  tmport=workportu + 0x1b;<br>
-	  j=inb(tmport) &amp; 0x0e;<br>
-	  id=1;<br>
-	  id=id &lt;&lt; tarid;<br>
-	  if ((id &amp; wide_idu[h]) != 0)<br>
-	  {<br>
-	     j |= 0x01;<br>
-	  }<br>
-	  outb(j,tmport);<br>
-	  if ( last_lenu[h][tarid] == 0 )<br>
-	  {<br>
-	     tmport=workportu + 0x18;<br>
-	     outb(0x08,tmport);<br>
-	     in_int[h]=0;<br>
-	     return ;<br>
-	  }<br>
-	  prd=prd_posu[h][tarid];<br>
-	  while ( adrcntu != 0 )<br>
-	  {<br>
-	       id=((unsigned short int *)(prd))[2];<br>
-	       if ( id == 0 )<br>
-	       {<br>
-		  k=0x10000;<br>
-	       }<br>
-	       else<br>
-	       {<br>
-		  k=id;<br>
-	       }<br>
-	       if ( k &gt; adrcntu )<br>
-	       {<br>
-		  ((unsigned short int *)(prd))[2] =(unsigned short int)<br>
-						     (k - adrcntu);<br>
-		  ((unsigned long *)(prd))[0] += adrcntu;<br>
-		  adrcntu=0;<br>
-		  prd_posu[h][tarid]=prd;<br>
-	       }<br>
-	       else<br>
-	       {<br>
-		  adrcntu -= k;<br>
-		  prdaddru[h][tarid] += 0x08;<br>
-		  prd += 0x08;<br>
-		  if ( adrcntu == 0 )<br>
-		  {<br>
-		     prd_posu[h][tarid]=prd;<br>
-		  }<br>
-	       }<br>
-	  }<br>
-	  tmpcip=pciportu[h] + 0x04;<br>
-	  outl(prdaddru[h][tarid],tmpcip);<br>
-	  tmpcip -= 0x02;<br>
-	  outb(0x06,tmpcip);<br>
-	  outb(0x00,tmpcip);<br>
-	  tmpcip -= 0x02;<br>
-	  tmport=workportu + 0x18;<br>
-	  if ( dirctu[h][tarid] != 0 )<br>
-	  {<br>
-	     outb(0x08,tmport);<br>
-	     outb(0x01,tmpcip);<br>
-	     in_int[h]=0;<br>
-	     return;<br>
-	  }<br>
-	  outb(0x08,tmport);<br>
-	  outb(0x09,tmpcip);<br>
-	  in_int[h]=0;<br>
-	  return;<br>
-       }<br>
-<br>
-       workrequ=curr_req[h][tarid];<br>
-       if ( i == 0x42 )<br>
-       {<br>
-	  errstus=0x02;<br>
-	  workrequ-&gt;result=errstus;<br>
-	  goto go_42;<br>
-       }<br>
-       if ( i == 0x16 )<br>
-       {<br>
-	  errstus=0;<br>
-	  tmport -= 0x08;<br>
-	  errstus=inb(tmport);<br>
-	  workrequ-&gt;result=errstus;<br>
-/*	  if ( errstus == 0x02 )<br>
-	  {<br>
-	     tmport +=0x10;<br>
-	     if ((inb(tmport) &amp; 0x80) != 0)<br>
-	     {<br>
-		printk(" autosense ");<br>
-	     }<br>
-	     tmport -=0x09;<br>
-	     outb(0,tmport);<br>
-	     tmport=workportu+0x3a;<br>
-	     outb((unsigned char)(inb(tmport) | 0x10),tmport);<br>
-	     tmport -= 0x39;<br>
-<br>
-	     outb(0x08,tmport++);<br>
-	     outb(0x7f,tmport++);<br>
-	     outb(0x03,tmport++);<br>
-	     outb(0x00,tmport++);<br>
-	     outb(0x00,tmport++);<br>
-	     outb(0x00,tmport++);<br>
-	     outb(0x0e,tmport++);<br>
-	     outb(0x00,tmport);<br>
-	     tmport+=0x07;<br>
-	     outb(0x00,tmport++);<br>
-	     tmport++;<br>
-	     outb(devspu[h][workrequ-&gt;target],tmport++);<br>
-	     outb(0x00,tmport++);<br>
-	     outb(0x00,tmport++);<br>
-	     outb(0x0e,tmport++);<br>
-	     tmport+=0x03;<br>
-	     outb(0x09,tmport);<br>
-	     tmport+=0x07;<br>
-	     i=0;<br>
-	     adrcntu=(unsigned long)(&amp;workrequ-&gt;sense_buffer[0]);<br>
-get_sens:<br>
-	     j=inb(tmport);<br>
-	     if ((j &amp; 0x01) != 0)<br>
-	     {<br>
-		tmport-=0x06;<br>
-		(unsigned char)(((caddr_t) adrcntu)[i++])=inb(tmport);<br>
-		tmport+=0x06;<br>
-		goto get_sens;<br>
-	     }<br>
-	     if ((j &amp; 0x80) == 0)<br>
-	     {<br>
-		goto get_sens;<br>
-	     }<br>
-	     if ((j &amp; 0x40) == 0)<br>
-	     {<br>
-		tmport-=0x08;<br>
-		i=inb(tmport);<br>
-	     }<br>
-	     tmport=workportu+0x3a;<br>
-	     outb((unsigned char)(inb(tmport) &amp; 0xef),tmport);<br>
-	     tmport=workportu+0x01;<br>
-	     outb(0x2c,tmport);<br>
-	     tmport += 0x15;<br>
-	     outb(0x80,tmport);<br>
-	  }   */<br>
-go_42:<br>
-	  spin_lock_irqsave(&amp;io_request_lock, flags);<br>
-	  (*workrequ-&gt;scsi_done)(workrequ);<br>
-	  spin_unlock_irqrestore(&amp;io_request_lock, flags);<br>
-<br>
-	  curr_req[h][tarid]=0;<br>
-	  workingu[h]--;<br>
-	  if (wide_idu[h] != 0)<br>
-	  {<br>
-	     tmport=workportu+0x1b;<br>
-	     j=inb(tmport) &amp; 0x0e;<br>
-	     j |= 0x01;<br>
-	     outb(j,tmport);<br>
-	  }<br>
-	  if (((last_cmd[h] != 0xff) || (quhdu[h] != quendu[h])) &amp;&amp;<br>
-	      (in_snd[h] == 0))<br>
-	  {<br>
-	     send_s870(h);<br>
-	  }<br>
-	  in_int[h]=0;<br>
-	  return;<br>
-       }<br>
-   if ( i == 0x4f )<br>
-   {<br>
-      i=0x89;<br>
-   }<br>
-   i &amp;= 0x0f;<br>
-   if ( i == 0x09 )<br>
-   {<br>
-      tmpcip=tmpcip+4;<br>
-      outl(prdaddru[h][tarid],tmpcip);<br>
-      tmpcip=tmpcip-2;<br>
-      outb(0x06,tmpcip);<br>
-      outb(0x00,tmpcip);<br>
-      tmpcip=tmpcip-2;<br>
-      tmport=workportu+0x10;<br>
-      outb(0x41,tmport);<br>
-      dirctu[h][tarid]=0x00;<br>
-      tmport += 0x08;<br>
-      outb(0x08,tmport);<br>
-      outb(0x09,tmpcip);<br>
-      in_int[h]=0;<br>
-      return;<br>
-   }<br>
-   if ( i == 0x08 )<br>
-   {<br>
-      tmpcip=tmpcip+4;<br>
-      outl(prdaddru[h][tarid],tmpcip);<br>
-      tmpcip=tmpcip-2;<br>
-      outb(0x06,tmpcip);<br>
-      outb(0x00,tmpcip);<br>
-      tmpcip=tmpcip-2;<br>
-      tmport=workportu+0x10;<br>
-      outb(0x41,tmport);<br>
-      tmport += 0x05;<br>
-      outb((unsigned char)(inb(tmport) | 0x20),tmport);<br>
-      dirctu[h][tarid]=0x20;<br>
-      tmport += 0x03;<br>
-      outb(0x08,tmport);<br>
-      outb(0x01,tmpcip);<br>
-      in_int[h]=0;<br>
-      return;<br>
-   }<br>
-   tmport -= 0x07;<br>
-   if ( i == 0x0a )<br>
-   {<br>
-      outb(0x30,tmport);<br>
-   }<br>
-   else<br>
-   {<br>
-      outb(0x46,tmport);<br>
-   }<br>
-   dirctu[h][tarid]=0x00;<br>
-   tmport += 0x02;<br>
-   outb(0x00,tmport++);<br>
-   outb(0x00,tmport++);<br>
-   outb(0x00,tmport++);<br>
-   tmport+=0x03;<br>
-   outb(0x08,tmport);<br>
-   in_int[h]=0;<br>
-   return;<br>
-  }<br>
-  else<br>
-  {<br>
-     tmport=workportu+0x17;<br>
-     inb(tmport);<br>
-     workingu[h]=0;<br>
-     in_int[h]=0;<br>
-     return;<br>
-  }<br>
+	} else {<br>
+		tmport = workportu + 0x17;<br>
+		inb(tmport);<br>
+		workingu[h] = 0;<br>
+		in_int[h] = 0;<br>
+		return;<br>
+	}<br>
 }<br>
 <br>
-int atp870u_queuecommand(Scsi_Cmnd * req_p, void (*done)(Scsi_Cmnd *))<br>
+int atp870u_queuecommand(Scsi_Cmnd * req_p, void (*done) (Scsi_Cmnd *))<br>
 {<br>
-    unsigned char i,h;<br>
-    unsigned long flags;<br>
-    unsigned short int m;<br>
-    unsigned int tmport;<br>
-<br>
-    for( h=0; h &lt;= admaxu; h++ )<br>
-    {<br>
-       if ( req_p-&gt;host == atp_host[h] )<br>
-       {<br>
-	  goto host_ok;<br>
-       }<br>
-    }<br>
-    return 0;<br>
+	unsigned char i, h;<br>
+	unsigned long flags;<br>
+	unsigned short int m;<br>
+	unsigned int tmport;<br>
+<br>
+	for (h = 0; h &lt;= admaxu; h++) {<br>
+		if (req_p-&gt;host == atp_host[h]) {<br>
+			goto host_ok;<br>
+		}<br>
+	}<br>
+	return 0;<br>
 host_ok:<br>
-   if ( req_p-&gt;channel != 0 )<br>
-   {<br>
-      req_p-&gt;result = 0x00040000;<br>
-      done(req_p);<br>
-      return 0;<br>
-   }<br>
-   m=1;<br>
-   m=  m &lt;&lt; req_p-&gt;target;<br>
-   if ( ( m &amp; active_idu[h] ) == 0 )<br>
-   {<br>
-      req_p-&gt;result = 0x00040000;<br>
-      done(req_p);<br>
-      return 0;<br>
-   }<br>
-   if (done)<br>
-   {<br>
-      req_p-&gt;scsi_done = done;<br>
-   }<br>
-   else<br>
-   {<br>
-      printk("atp870u_queuecommand: done can't be NULL\n");<br>
-      req_p-&gt;result = 0;<br>
-      done(req_p);<br>
-      return 0;<br>
-   }<br>
-   quendu[h]++;<br>
-   if ( quendu[h] &gt;= qcnt )<br>
-   {<br>
-      quendu[h]=0;<br>
-   }<br>
-   wait_que_empty:<br>
-     if ( quhdu[h] == quendu[h] )<br>
-     {<br>
-	goto wait_que_empty;<br>
-     }<br>
-     save_flags(flags);<br>
-     cli();<br>
-     querequ[h][quendu[h]]=req_p;<br>
-     if ( quendu[h] == 0 )<br>
-     {<br>
-	i=qcnt-1;<br>
-     }<br>
-     else<br>
-     {<br>
-	i=quendu[h]-1;<br>
-     }<br>
-     tmport = ioportu[h]+0x1c;<br>
-     restore_flags(flags);<br>
-     if ((inb(tmport) == 0) &amp;&amp; (in_int[h] == 0) &amp;&amp; (in_snd[h] == 0))<br>
-     {<br>
-	 send_s870(h);<br>
-     }<br>
-     return 0;<br>
+	if (req_p-&gt;channel != 0) {<br>
+		req_p-&gt;result = 0x00040000;<br>
+		done(req_p);<br>
+		return 0;<br>
+	}<br>
+	m = 1;<br>
+	m = m &lt;&lt; req_p-&gt;target;<br>
+	if ((m &amp; active_idu[h]) == 0) {<br>
+		req_p-&gt;result = 0x00040000;<br>
+		done(req_p);<br>
+		return 0;<br>
+	}<br>
+	if (done) {<br>
+		req_p-&gt;scsi_done = done;<br>
+	} else {<br>
+		printk("atp870u_queuecommand: done can't be NULL\n");<br>
+		req_p-&gt;result = 0;<br>
+		done(req_p);<br>
+		return 0;<br>
+	}<br>
+	quendu[h]++;<br>
+	if (quendu[h] &gt;= qcnt) {<br>
+		quendu[h] = 0;<br>
+	}<br>
+wait_que_empty:<br>
+	if (quhdu[h] == quendu[h]) {<br>
+		goto wait_que_empty;<br>
+	}<br>
+	save_flags(flags);<br>
+	cli();<br>
+	querequ[h][quendu[h]] = req_p;<br>
+	if (quendu[h] == 0) {<br>
+		i = qcnt - 1;<br>
+	} else {<br>
+		i = quendu[h] - 1;<br>
+	}<br>
+	tmport = ioportu[h] + 0x1c;<br>
+	restore_flags(flags);<br>
+	if ((inb(tmport) == 0) &amp;&amp; (in_int[h] == 0) &amp;&amp; (in_snd[h] == 0)) {<br>
+		send_s870(h);<br>
+	}<br>
+	return 0;<br>
 }<br>
 <br>
-void mydlyu(unsigned int dlycnt )<br>
+void mydlyu(unsigned int dlycnt)<br>
 {<br>
-    unsigned int i ;<br>
-    for ( i = 0 ; i &lt; dlycnt ; i++ )<br>
-    {<br>
-       inb(0x80);<br>
-    }<br>
+	unsigned int i;<br>
+	for (i = 0; i &lt; dlycnt; i++) {<br>
+		inb(0x80);<br>
+	}<br>
 }<br>
 <br>
 void send_s870(unsigned char h)<br>
 {<br>
-     unsigned int  tmport;<br>
-     Scsi_Cmnd *workrequ;<br>
-     unsigned long flags;<br>
-     unsigned int   i;<br>
-     unsigned char  j,tarid;<br>
-     unsigned char  *prd;<br>
-     unsigned short int   tmpcip,w;<br>
-     unsigned long  l,bttl;<br>
-     unsigned int workportu;<br>
-     struct scatterlist * sgpnt;<br>
+	unsigned int tmport;<br>
+	Scsi_Cmnd *workrequ;<br>
+	unsigned long flags;<br>
+	unsigned int i;<br>
+	unsigned char j, tarid;<br>
+	unsigned char *prd;<br>
+	unsigned short int tmpcip, w;<br>
+	unsigned long l, bttl;<br>
+	unsigned int workportu;<br>
+	struct scatterlist *sgpnt;<br>
 <br>
 	save_flags(flags);<br>
 	cli();<br>
-	if ( in_snd[h] != 0 )<br>
-	{<br>
-	   restore_flags(flags);<br>
-	   return;<br>
+	if (in_snd[h] != 0) {<br>
+		restore_flags(flags);<br>
+		return;<br>
 	}<br>
-	in_snd[h]=1;<br>
-	if ((last_cmd[h] != 0xff) &amp;&amp; ((last_cmd[h] &amp; 0x40) != 0))<br>
-	{<br>
-	   last_cmd[h] &amp;= 0x0f;<br>
-	   workrequ=curr_req[h][last_cmd[h]];<br>
-	   goto cmd_subp;<br>
+	in_snd[h] = 1;<br>
+	if ((last_cmd[h] != 0xff) &amp;&amp; ((last_cmd[h] &amp; 0x40) != 0)) {<br>
+		last_cmd[h] &amp;= 0x0f;<br>
+		workrequ = curr_req[h][last_cmd[h]];<br>
+		goto cmd_subp;<br>
 	}<br>
 	workingu[h]++;<br>
-	j=quhdu[h];<br>
+	j = quhdu[h];<br>
 	quhdu[h]++;<br>
-	if ( quhdu[h] &gt;= qcnt )<br>
-	{<br>
-	   quhdu[h]=0;<br>
+	if (quhdu[h] &gt;= qcnt) {<br>
+		quhdu[h] = 0;<br>
 	}<br>
-	workrequ=querequ[h][quhdu[h]];<br>
-	if ( curr_req[h][workrequ-&gt;target] == 0 )<br>
-	{<br>
-	   curr_req[h][workrequ-&gt;target]=workrequ;<br>
-	   last_cmd[h]=workrequ-&gt;target;<br>
-	   goto cmd_subp;<br>
+	workrequ = querequ[h][quhdu[h]];<br>
+	if (curr_req[h][workrequ-&gt;target] == 0) {<br>
+		curr_req[h][workrequ-&gt;target] = workrequ;<br>
+		last_cmd[h] = workrequ-&gt;target;<br>
+		goto cmd_subp;<br>
 	}<br>
-	quhdu[h]=j;<br>
+	quhdu[h] = j;<br>
 	workingu[h]--;<br>
-	in_snd[h]=0;<br>
+	in_snd[h] = 0;<br>
 	restore_flags(flags);<br>
-	return ;<br>
+	return;<br>
 cmd_subp:<br>
-   workportu=ioportu[h];<br>
-   tmport=workportu+0x1f;<br>
-   if ((inb(tmport) &amp; 0xb0) != 0)<br>
-   {<br>
-      goto abortsnd;<br>
-   }<br>
-   tmport=workportu+0x1c;<br>
-   if ( inb(tmport) == 0 )<br>
-   {<br>
-      goto oktosend;<br>
-   }<br>
+	workportu = ioportu[h];<br>
+	tmport = workportu + 0x1f;<br>
+	if ((inb(tmport) &amp; 0xb0) != 0) {<br>
+		goto abortsnd;<br>
+	}<br>
+	tmport = workportu + 0x1c;<br>
+	if (inb(tmport) == 0) {<br>
+		goto oktosend;<br>
+	}<br>
 abortsnd:<br>
-   last_cmd[h] |= 0x40;<br>
-   in_snd[h]=0;<br>
-   restore_flags(flags);<br>
-   return;<br>
-oktosend:<br>
-   memcpy(&amp;ata_cdbu[h][0], &amp;workrequ-&gt;cmnd[0], workrequ-&gt;cmd_len);<br>
-   if ( ata_cdbu[h][0] == 0x25 )<br>
-   {<br>
-      if ( workrequ-&gt;request_bufflen &gt; 8 )<br>
-      {<br>
-	 workrequ-&gt;request_bufflen=0x08;<br>
-      }<br>
-   }<br>
-   if ( ata_cdbu[h][0] == 0x12 )<br>
-   {<br>
-      if ( workrequ-&gt;request_bufflen &gt; 0x24 )<br>
-      {<br>
-	 workrequ-&gt;request_bufflen = 0x24;<br>
-	 ata_cdbu[h][4]=0x24;<br>
-      }<br>
-   }<br>
-<br>
-   tmport=workportu+0x1b;<br>
-   j=inb(tmport) &amp; 0x0e;<br>
-   tarid=workrequ-&gt;target;<br>
-   w=1;<br>
-   w = w &lt;&lt; tarid;<br>
-   if ((w &amp; wide_idu[h]) != 0)<br>
-   {<br>
-      j |= 0x01;<br>
-   }<br>
-   outb(j,tmport);<br>
-   tmport=workportu;<br>
-   outb(workrequ-&gt;cmd_len,tmport++);<br>
-   outb(0x2c,tmport++);<br>
-   outb(0xcf,tmport++);<br>
-   for ( i=0 ; i &lt; workrequ-&gt;cmd_len ; i++ )<br>
-   {<br>
-       outb(ata_cdbu[h][i],tmport++);<br>
-   }<br>
-   tmport=workportu+0x0f;<br>
-   outb(0x00,tmport);<br>
-   tmport+=0x02;<br>
-   outb(devspu[h][tarid],tmport++);<br>
-   if (workrequ-&gt;use_sg)<br>
-   {<br>
-<br>
-     l=0;<br>
-     sgpnt = (struct scatterlist *) workrequ-&gt;request_buffer;<br>
-     for(i=0; i&lt;workrequ-&gt;use_sg; i++)<br>
-     {<br>
-       if(sgpnt[i].length == 0 || workrequ-&gt;use_sg &gt; ATP870U_SCATTER)<br>
-       {<br>
-	 panic("Foooooooood fight!");<br>
-       }<br>
-       l += sgpnt[i].length;<br>
-     }<br>
-   }<br>
-   else<br>
-   {<br>
-     l=workrequ-&gt;request_bufflen;<br>
-   }<br>
-   outb((unsigned char)(((unsigned char *)(&amp;l))[2]),tmport++);<br>
-   outb((unsigned char)(((unsigned char *)(&amp;l))[1]),tmport++);<br>
-   outb((unsigned char)(((unsigned char *)(&amp;l))[0]),tmport++);<br>
-   j=tarid;<br>
-   last_lenu[h][j]=l;<br>
-   tran_lenu[h][j]=0;<br>
-   if ((j &amp; 0x08) != 0)<br>
-   {<br>
-      j=(j &amp; 0x07) | 0x40;<br>
-   }<br>
-   if ((ata_cdbu[h][0] == 0x0a) || (ata_cdbu[h][0] == 0x2a) ||<br>
-       (ata_cdbu[h][0] == 0xaa) || (ata_cdbu[h][0] == 0x15))<br>
-   {<br>
-      outb((unsigned char)(j | 0x20),tmport++);<br>
-   }<br>
-   else<br>
-   {<br>
-      outb(j,tmport++);<br>
-   }<br>
-   outb(0x80,tmport);<br>
-   tmport=workportu + 0x1c;<br>
-   dirctu[h][tarid]=0;<br>
-   if ( l == 0 )<br>
-   {<br>
-      if ( inb(tmport) == 0 )<br>
-      {<br>
-	 tmport=workportu+0x18;<br>
-	 outb(0x08,tmport);<br>
-      }<br>
-      else<br>
-      {<br>
 	last_cmd[h] |= 0x40;<br>
-      }<br>
-      in_snd[h]=0;<br>
-      restore_flags(flags);<br>
-      return;<br>
-   }<br>
-   tmpcip=pciportu[h];<br>
-   prd=&amp;prd_tableu[h][tarid][0];<br>
-   prd_posu[h][tarid]=prd;<br>
-   if (workrequ-&gt;use_sg)<br>
-   {<br>
-     sgpnt = (struct scatterlist *) workrequ-&gt;request_buffer;<br>
-     i=0;<br>
-     for(j=0; j&lt;workrequ-&gt;use_sg; j++)<br>
-     {<br>
-	(unsigned long)(((unsigned long *)(prd))[i &gt;&gt; 1])=(unsigned long)sgpnt[j].address;<br>
-	(unsigned short int)(((unsigned short int *)(prd))[i+2])=sgpnt[j].length;<br>
-	(unsigned short int)(((unsigned short int *)(prd))[i+3])=0;<br>
-	i +=0x04;<br>
-     }<br>
-     (unsigned short int)(((unsigned short int *)(prd))[i-1])=0x8000;<br>
-   }<br>
-   else<br>
-   {<br>
-     bttl=(unsigned long)workrequ-&gt;request_buffer;<br>
-     l=workrequ-&gt;request_bufflen;<br>
-     i=0;<br>
-     while ( l &gt; 0x10000 )<br>
-     {<br>
-	(unsigned short int)(((unsigned short int *)(prd))[i+3])=0x0000;<br>
-	(unsigned short int)(((unsigned short int *)(prd))[i+2])=0x0000;<br>
-	(unsigned long)(((unsigned long *)(prd))[i &gt;&gt; 1])=bttl;<br>
-	l -= 0x10000;<br>
-	bttl += 0x10000;<br>
-	i += 0x04;<br>
-     }<br>
-     (unsigned short int)(((unsigned short int *)(prd))[i+3])=0x8000;<br>
-     (unsigned short int)(((unsigned short int *)(prd))[i+2])=l;<br>
-     (unsigned long)(((unsigned long *)(prd))[i &gt;&gt; 1])=bttl;<br>
-   }<br>
-   tmpcip=tmpcip+4;<br>
-   prdaddru[h][tarid]=(unsigned long)&amp;prd_tableu[h][tarid][0];<br>
-   outl(prdaddru[h][tarid],tmpcip);<br>
-   tmpcip=tmpcip-2;<br>
-   outb(0x06,tmpcip);<br>
-   outb(0x00,tmpcip);<br>
-   tmpcip=tmpcip-2;<br>
-   if ((ata_cdbu[h][0] == 0x0a) || (ata_cdbu[h][0] == 0x2a) ||<br>
-       (ata_cdbu[h][0] == 0xaa) || (ata_cdbu[h][0] == 0x15))<br>
-   {<br>
-      dirctu[h][tarid]=0x20;<br>
-      if ( inb(tmport) == 0 )<br>
-      {<br>
-	 tmport=workportu+0x18;<br>
-	 outb(0x08,tmport);<br>
-	 outb(0x01,tmpcip);<br>
-      }<br>
-      else<br>
-      {<br>
-	 last_cmd[h] |= 0x40;<br>
-      }<br>
-      in_snd[h]=0;<br>
-      restore_flags(flags);<br>
-      return;<br>
-   }<br>
-   if ( inb(tmport) == 0 )<br>
-   {<br>
-      tmport=workportu+0x18;<br>
-      outb(0x08,tmport);<br>
-      outb(0x09,tmpcip);<br>
-   }<br>
-   else<br>
-   {<br>
-      last_cmd[h] |= 0x40;<br>
-   }<br>
-   in_snd[h]=0;<br>
-   restore_flags(flags);<br>
-   return;<br>
+	in_snd[h] = 0;<br>
+	restore_flags(flags);<br>
+	return;<br>
+oktosend:<br>
+	memcpy(&amp;ata_cdbu[h][0], &amp;workrequ-&gt;cmnd[0], workrequ-&gt;cmd_len);<br>
+	if (ata_cdbu[h][0] == 0x25) {<br>
+		if (workrequ-&gt;request_bufflen &gt; 8) {<br>
+			workrequ-&gt;request_bufflen = 0x08;<br>
+		}<br>
+	}<br>
+	if (ata_cdbu[h][0] == 0x12) {<br>
+		if (workrequ-&gt;request_bufflen &gt; 0x24) {<br>
+			workrequ-&gt;request_bufflen = 0x24;<br>
+			ata_cdbu[h][4] = 0x24;<br>
+		}<br>
+	}<br>
+	tmport = workportu + 0x1b;<br>
+	j = inb(tmport) &amp; 0x0e;<br>
+	tarid = workrequ-&gt;target;<br>
+	w = 1;<br>
+	w = w &lt;&lt; tarid;<br>
+	if ((w &amp; wide_idu[h]) != 0) {<br>
+		j |= 0x01;<br>
+	}<br>
+	outb(j, tmport);<br>
+	tmport = workportu;<br>
+	outb(workrequ-&gt;cmd_len, tmport++);<br>
+	outb(0x2c, tmport++);<br>
+	outb(0xcf, tmport++);<br>
+	for (i = 0; i &lt; workrequ-&gt;cmd_len; i++) {<br>
+		outb(ata_cdbu[h][i], tmport++);<br>
+	}<br>
+	tmport = workportu + 0x0f;<br>
+	outb(0x00, tmport);<br>
+	tmport += 0x02;<br>
+	outb(devspu[h][tarid], tmport++);<br>
+	if (workrequ-&gt;use_sg) <br>
+	{<br>
+		l = 0;<br>
+		sgpnt = (struct scatterlist *) workrequ-&gt;request_buffer;<br>
+		for (i = 0; i &lt; workrequ-&gt;use_sg; i++) <br>
+		{<br>
+			if (sgpnt[i].length == 0 || workrequ-&gt;use_sg &gt; ATP870U_SCATTER) <br>
+			{<br>
+				panic("Foooooooood fight!");<br>
+			}<br>
+			l += sgpnt[i].length;<br>
+		}<br>
+	} else {<br>
+		l = workrequ-&gt;request_bufflen;<br>
+	}<br>
+	outb((unsigned char) (((unsigned char *) (&amp;l))[2]), tmport++);<br>
+	outb((unsigned char) (((unsigned char *) (&amp;l))[1]), tmport++);<br>
+	outb((unsigned char) (((unsigned char *) (&amp;l))[0]), tmport++);<br>
+	j = tarid;<br>
+	last_lenu[h][j] = l;<br>
+	tran_lenu[h][j] = 0;<br>
+	if ((j &amp; 0x08) != 0) {<br>
+		j = (j &amp; 0x07) | 0x40;<br>
+	}<br>
+	if ((ata_cdbu[h][0] == 0x0a) || (ata_cdbu[h][0] == 0x2a) ||<br>
+	    (ata_cdbu[h][0] == 0xaa) || (ata_cdbu[h][0] == 0x15)) {<br>
+		outb((unsigned char) (j | 0x20), tmport++);<br>
+	} else {<br>
+		outb(j, tmport++);<br>
+	}<br>
+	outb(0x80, tmport);<br>
+	tmport = workportu + 0x1c;<br>
+	dirctu[h][tarid] = 0;<br>
+	if (l == 0) {<br>
+		if (inb(tmport) == 0) {<br>
+			tmport = workportu + 0x18;<br>
+			outb(0x08, tmport);<br>
+		} else {<br>
+			last_cmd[h] |= 0x40;<br>
+		}<br>
+		in_snd[h] = 0;<br>
+		restore_flags(flags);<br>
+		return;<br>
+	}<br>
+	tmpcip = pciportu[h];<br>
+	prd = &amp;prd_tableu[h][tarid][0];<br>
+	prd_posu[h][tarid] = prd;<br>
+	if (workrequ-&gt;use_sg) <br>
+	{<br>
+		sgpnt = (struct scatterlist *) workrequ-&gt;request_buffer;<br>
+		i = 0;<br>
+		for (j = 0; j &lt; workrequ-&gt;use_sg; j++) {<br>
+			(unsigned long) (((unsigned long *) (prd))[i &gt;&gt; 1]) = virt_to_bus(sgpnt[j].address);<br>
+			(unsigned short int) (((unsigned short int *) (prd))[i + 2]) = sgpnt[j].length;<br>
+			(unsigned short int) (((unsigned short int *) (prd))[i + 3]) = 0;<br>
+			i += 0x04;<br>
+		}<br>
+		(unsigned short int) (((unsigned short int *) (prd))[i - 1]) = 0x8000;<br>
+	} else {<br>
+		bttl = virt_to_bus(workrequ-&gt;request_buffer);<br>
+		l = workrequ-&gt;request_bufflen;<br>
+		i = 0;<br>
+		while (l &gt; 0x10000) {<br>
+			(unsigned short int) (((unsigned short int *) (prd))[i + 3]) = 0x0000;<br>
+			(unsigned short int) (((unsigned short int *) (prd))[i + 2]) = 0x0000;<br>
+			(unsigned long) (((unsigned long *) (prd))[i &gt;&gt; 1]) = bttl;<br>
+			l -= 0x10000;<br>
+			bttl += 0x10000;<br>
+			i += 0x04;<br>
+		}<br>
+		(unsigned short int) (((unsigned short int *) (prd))[i + 3]) = 0x8000;<br>
+		(unsigned short int) (((unsigned short int *) (prd))[i + 2]) = l;<br>
+		(unsigned long) (((unsigned long *) (prd))[i &gt;&gt; 1]) = bttl;<br>
+	}<br>
+	tmpcip = tmpcip + 4;<br>
+	prdaddru[h][tarid] = virt_to_bus(&amp;prd_tableu[h][tarid][0]);<br>
+	outl(prdaddru[h][tarid], tmpcip);<br>
+	tmpcip = tmpcip - 2;<br>
+	outb(0x06, tmpcip);<br>
+	outb(0x00, tmpcip);<br>
+	tmpcip = tmpcip - 2;<br>
+	if ((ata_cdbu[h][0] == 0x0a) || (ata_cdbu[h][0] == 0x2a) ||<br>
+	    (ata_cdbu[h][0] == 0xaa) || (ata_cdbu[h][0] == 0x15)) <br>
+	{<br>
+		dirctu[h][tarid] = 0x20;<br>
+		if (inb(tmport) == 0) {<br>
+			tmport = workportu + 0x18;<br>
+			outb(0x08, tmport);<br>
+			outb(0x01, tmpcip);<br>
+		} else {<br>
+			last_cmd[h] |= 0x40;<br>
+		}<br>
+		in_snd[h] = 0;<br>
+		restore_flags(flags);<br>
+		return;<br>
+	}<br>
+	if (inb(tmport) == 0) <br>
+	{<br>
+		tmport = workportu + 0x18;<br>
+		outb(0x08, tmport);<br>
+		outb(0x09, tmpcip);<br>
+	} else {<br>
+		last_cmd[h] |= 0x40;<br>
+	}<br>
+	in_snd[h] = 0;<br>
+	restore_flags(flags);<br>
+	return;<br>
 <br>
 }<br>
 <br>
@@ -780,1101 +655,964 @@<br>
 int atp870u_command(Scsi_Cmnd * SCpnt)<br>
 {<br>
 <br>
-    atp870u_queuecommand(SCpnt, internal_done);<br>
+	atp870u_queuecommand(SCpnt, internal_done);<br>
 <br>
-    SCpnt-&gt;SCp.Status = 0;<br>
-    while (!SCpnt-&gt;SCp.Status)<br>
-	barrier();<br>
-    return SCpnt-&gt;result;<br>
+	SCpnt-&gt;SCp.Status = 0;<br>
+	while (!SCpnt-&gt;SCp.Status)<br>
+		barrier();<br>
+	return SCpnt-&gt;result;<br>
 }<br>
 <br>
-unsigned char fun_scam ( unsigned char host,unsigned short int * val )<br>
+unsigned char fun_scam(unsigned char host, unsigned short int *val)<br>
 {<br>
-    unsigned int  tmport ;<br>
-    unsigned short int	 i,k;<br>
-    unsigned char     j;<br>
+	unsigned int tmport;<br>
+	unsigned short int i, k;<br>
+	unsigned char j;<br>
 <br>
-    tmport = ioportu[host]+0x1c;<br>
-    outw(*val,tmport);<br>
+	tmport = ioportu[host] + 0x1c;<br>
+	outw(*val, tmport);<br>
 FUN_D7:<br>
-    for ( i=0; i &lt; 10; i++ )	     /* stable &gt;= bus settle delay(400 ns)  */<br>
-    {<br>
-	k=inw(tmport);<br>
-	j= (unsigned char)(k &gt;&gt; 8);<br>
-	if ((k &amp; 0x8000) != 0)	     /* DB7 all release?    */<br>
-	{<br>
-	   goto  FUN_D7;<br>
+	for (i = 0; i &lt; 10; i++) {	/* stable &gt;= bus settle delay(400 ns)  */<br>
+		k = inw(tmport);<br>
+		j = (unsigned char) (k &gt;&gt; 8);<br>
+		if ((k &amp; 0x8000) != 0) {	/* DB7 all release?    */<br>
+			goto FUN_D7;<br>
+		}<br>
 	}<br>
-    }<br>
-    *val |= 0x4000;		    /* assert DB6	    */<br>
-    outw(*val,tmport);<br>
-    *val &amp;= 0xdfff;		    /* assert DB5	    */<br>
-    outw(*val,tmport);<br>
+	*val |= 0x4000;		/* assert DB6           */<br>
+	outw(*val, tmport);<br>
+	*val &amp;= 0xdfff;		/* assert DB5           */<br>
+	outw(*val, tmport);<br>
 FUN_D5:<br>
-    for ( i=0; i &lt; 10; i++ )	    /* stable &gt;= bus settle delay(400 ns) */<br>
-    {<br>
-       if ((inw(tmport) &amp; 0x2000) != 0)   /* DB5 all release?	*/<br>
-       {<br>
-	  goto	FUN_D5;<br>
-       }<br>
-    }<br>
-    *val |= 0x8000;		     /* no DB4-0, assert DB7	*/<br>
-    *val &amp;= 0xe0ff;<br>
-    outw(*val,tmport);<br>
-    *val &amp;= 0xbfff;		     /* release DB6		*/<br>
-    outw(*val,tmport);<br>
-FUN_D6:<br>
-    for ( i=0; i &lt; 10; i++ )	     /* stable &gt;= bus settle delay(400 ns)  */<br>
-    {<br>
-       if ((inw(tmport) &amp; 0x4000) != 0)   /* DB6 all release?  */<br>
-       {<br>
-	  goto	FUN_D6;<br>
-       }<br>
-    }<br>
+	for (i = 0; i &lt; 10; i++) {	/* stable &gt;= bus settle delay(400 ns) */<br>
+		if ((inw(tmport) &amp; 0x2000) != 0) {	/* DB5 all release?       */<br>
+			goto FUN_D5;<br>
+		}<br>
+	}<br>
+	*val |= 0x8000;		/* no DB4-0, assert DB7    */<br>
+	*val &amp;= 0xe0ff;<br>
+	outw(*val, tmport);<br>
+	*val &amp;= 0xbfff;		/* release DB6             */<br>
+	outw(*val, tmport);<br>
+      FUN_D6:<br>
+	for (i = 0; i &lt; 10; i++) {	/* stable &gt;= bus settle delay(400 ns)  */<br>
+		if ((inw(tmport) &amp; 0x4000) != 0) {	/* DB6 all release?  */<br>
+			goto FUN_D6;<br>
+		}<br>
+	}<br>
 <br>
-    return j;<br>
+	return j;<br>
 }<br>
 <br>
-void tscam( unsigned char host )<br>
+void tscam(unsigned char host)<br>
 {<br>
 <br>
-    unsigned int  tmport ;<br>
-    unsigned char  i,j,k;<br>
-    unsigned long  n;<br>
-    unsigned short int	m,assignid_map,val;<br>
-    unsigned char  mbuf[33],quintet[2];<br>
-    static unsigned char g2q_tab[8]={ 0x38,0x31,0x32,0x2b,0x34,0x2d,0x2e,0x27 };<br>
+	unsigned int tmport;<br>
+	unsigned char i, j, k;<br>
+	unsigned long n;<br>
+	unsigned short int m, assignid_map, val;<br>
+	unsigned char mbuf[33], quintet[2];<br>
+	static unsigned char g2q_tab[8] =<br>
+	{0x38, 0x31, 0x32, 0x2b, 0x34, 0x2d, 0x2e, 0x27};<br>
 <br>
 <br>
-    for ( i=0; i &lt; 0x10; i++ )<br>
-    {<br>
-	mydlyu(0xffff);<br>
-    }<br>
+	for (i = 0; i &lt; 0x10; i++) {<br>
+		mydlyu(0xffff);<br>
+	}<br>
 <br>
-    tmport = ioportu[host]+1;<br>
-    outb(0x08,tmport++);<br>
-    outb(0x7f,tmport);<br>
-    tmport = ioportu[host]+0x11;<br>
-    outb(0x20,tmport);<br>
-<br>
-    if ((scam_on[host] &amp; 0x40) == 0)<br>
-    {<br>
-       return;<br>
-    }<br>
-<br>
-    m=1;<br>
-    m &lt;&lt;= host_idu[host];<br>
-    j=16;<br>
-    if ( chip_veru[host] &lt; 4 )<br>
-    {<br>
-       m |= 0xff00;<br>
-       j=8;<br>
-    }<br>
-    assignid_map=m;<br>
-    tmport = ioportu[host]+0x02;<br>
-    outb(0x02,tmport++);	/* 2*2=4ms,3EH 2/32*3E=3.9ms */<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-<br>
-    for ( i = 0 ; i &lt; j ; i ++ )<br>
-    {<br>
-	m=1;<br>
-	m=m&lt;&lt;i;<br>
-	if ( ( m &amp; assignid_map ) != 0 )<br>
-	{<br>
-	   continue;<br>
+	tmport = ioportu[host] + 1;<br>
+	outb(0x08, tmport++);<br>
+	outb(0x7f, tmport);<br>
+	tmport = ioportu[host] + 0x11;<br>
+	outb(0x20, tmport);<br>
+<br>
+	if ((scam_on[host] &amp; 0x40) == 0) {<br>
+		return;<br>
+	}<br>
+	m = 1;<br>
+	m &lt;&lt;= host_idu[host];<br>
+	j = 16;<br>
+	if (chip_veru[host] &lt; 4) {<br>
+		m |= 0xff00;<br>
+		j = 8;<br>
 	}<br>
-    tmport = ioportu[host]+0x0f;<br>
-    outb(0,tmport++);<br>
-    tmport += 0x02;<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    if ( i &gt; 7 )<br>
-    {<br>
-       k=(i &amp; 0x07) | 0x40;<br>
-    }<br>
-    else<br>
-    {<br>
-       k=i;<br>
-    }<br>
-    outb(k,tmport++);<br>
-    tmport = ioportu[host]+0x1b;<br>
-    if ( chip_veru[host] == 4 )<br>
-    {<br>
-       outb((unsigned char)((inb(tmport) &amp; 0x0e) | 0x01),tmport);<br>
-    }<br>
-    else<br>
-    {<br>
-       outb((unsigned char)(inb(tmport) &amp; 0x0e),tmport);<br>
-    }<br>
+	assignid_map = m;<br>
+	tmport = ioportu[host] + 0x02;<br>
+	outb(0x02, tmport++);	/* 2*2=4ms,3EH 2/32*3E=3.9ms */<br>
+	outb(0, tmport++);<br>
+	outb(0, tmport++);<br>
+	outb(0, tmport++);<br>
+	outb(0, tmport++);<br>
+	outb(0, tmport++);<br>
+	outb(0, tmport++);<br>
+<br>
+	for (i = 0; i &lt; j; i++) {<br>
+		m = 1;<br>
+		m = m &lt;&lt; i;<br>
+		if ((m &amp; assignid_map) != 0) {<br>
+			continue;<br>
+		}<br>
+		tmport = ioportu[host] + 0x0f;<br>
+		outb(0, tmport++);<br>
+		tmport += 0x02;<br>
+		outb(0, tmport++);<br>
+		outb(0, tmport++);<br>
+		outb(0, tmport++);<br>
+		if (i &gt; 7) {<br>
+			k = (i &amp; 0x07) | 0x40;<br>
+		} else {<br>
+			k = i;<br>
+		}<br>
+		outb(k, tmport++);<br>
+		tmport = ioportu[host] + 0x1b;<br>
+		if (chip_veru[host] == 4) {<br>
+			outb((unsigned char) ((inb(tmport) &amp; 0x0e) | 0x01), tmport);<br>
+		} else {<br>
+			outb((unsigned char) (inb(tmport) &amp; 0x0e), tmport);<br>
+		}<br>
 wait_rdyok:<br>
-    tmport = ioportu[host]+0x18;<br>
-    outb(0x09,tmport);<br>
-    tmport += 0x07;<br>
-<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport -= 0x08;<br>
-    k=inb(tmport);<br>
-    if ( k != 0x16 )<br>
-    {<br>
-       if ((k == 0x85) || (k == 0x42))<br>
-       {<br>
-	  continue;<br>
-       }<br>
-       tmport = ioportu[host]+0x10;<br>
-       outb(0x41,tmport);<br>
-       goto wait_rdyok;<br>
-    }<br>
-    assignid_map |= m;<br>
-<br>
-    }<br>
-    tmport = ioportu[host]+0x02;<br>
-    outb(0x7f,tmport);<br>
-    tmport = ioportu[host]+0x1b;<br>
-    outb(0x02,tmport);<br>
-<br>
-    outb(0,0x80);<br>
-<br>
-    val=0x0080;      /* bsy  */<br>
-    tmport = ioportu[host]+0x1c;<br>
-    outw(val,tmport);<br>
-    val |=0x0040;    /* sel  */<br>
-    outw(val,tmport);<br>
-    val |=0x0004;    /* msg  */<br>
-    outw(val,tmport);<br>
-    inb(0x80);		      /* 2 deskew delay(45ns*2=90ns) */<br>
-    val &amp;=0x007f;    /* no bsy	*/<br>
-    outw(val,tmport);<br>
-    mydlyu(0xffff);  /* recommanded SCAM selection response time */<br>
-    mydlyu(0xffff);<br>
-    val &amp;=0x00fb;    /* after 1ms no msg */<br>
-    outw(val,tmport);<br>
+		tmport = ioportu[host] + 0x18;<br>
+		outb(0x09, tmport);<br>
+		tmport += 0x07;<br>
+<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		k = inb(tmport);<br>
+		if (k != 0x16) {<br>
+			if ((k == 0x85) || (k == 0x42)) {<br>
+				continue;<br>
+			}<br>
+			tmport = ioportu[host] + 0x10;<br>
+			outb(0x41, tmport);<br>
+			goto wait_rdyok;<br>
+		}<br>
+		assignid_map |= m;<br>
+<br>
+	}<br>
+	tmport = ioportu[host] + 0x02;<br>
+	outb(0x7f, tmport);<br>
+	tmport = ioportu[host] + 0x1b;<br>
+	outb(0x02, tmport);<br>
+<br>
+	outb(0, 0x80);<br>
+<br>
+	val = 0x0080;		/* bsy  */<br>
+	tmport = ioportu[host] + 0x1c;<br>
+	outw(val, tmport);<br>
+	val |= 0x0040;		/* sel  */<br>
+	outw(val, tmport);<br>
+	val |= 0x0004;		/* msg  */<br>
+	outw(val, tmport);<br>
+	inb(0x80);		/* 2 deskew delay(45ns*2=90ns) */<br>
+	val &amp;= 0x007f;		/* no bsy  */<br>
+	outw(val, tmport);<br>
+	mydlyu(0xffff);		/* recommanded SCAM selection response time */<br>
+	mydlyu(0xffff);<br>
+	val &amp;= 0x00fb;		/* after 1ms no msg */<br>
+	outw(val, tmport);<br>
 wait_nomsg:<br>
-    if ((inb(tmport) &amp; 0x04) != 0)<br>
-    {<br>
-       goto wait_nomsg;<br>
-    }<br>
-    outb(1,0x80);<br>
-    mydlyu(100);<br>
-    for ( n=0; n &lt; 0x30000; n++ )<br>
-    {<br>
-	if ((inb(tmport) &amp; 0x80) != 0)	   /* bsy ? */<br>
-	{<br>
-	   goto wait_io;<br>
+	if ((inb(tmport) &amp; 0x04) != 0) {<br>
+		goto wait_nomsg;<br>
+	}<br>
+	outb(1, 0x80);<br>
+	mydlyu(100);<br>
+	for (n = 0; n &lt; 0x30000; n++) {<br>
+		if ((inb(tmport) &amp; 0x80) != 0) {	/* bsy ? */<br>
+			goto wait_io;<br>
+		}<br>
 	}<br>
-    }<br>
-    goto  TCM_SYNC;<br>
+	goto TCM_SYNC;<br>
 wait_io:<br>
-    for ( n=0; n &lt; 0x30000; n++ )<br>
-    {<br>
-	if ((inb(tmport) &amp; 0x81) == 0x0081)<br>
-	{<br>
-	   goto wait_io1;<br>
+	for (n = 0; n &lt; 0x30000; n++) {<br>
+		if ((inb(tmport) &amp; 0x81) == 0x0081) {<br>
+			goto wait_io1;<br>
+		}<br>
 	}<br>
-    }<br>
-    goto  TCM_SYNC;<br>
+	goto TCM_SYNC;<br>
 wait_io1:<br>
-    inb(0x80);<br>
-    val |=0x8003;    /* io,cd,db7  */<br>
-    outw(val,tmport);<br>
-    inb(0x80);<br>
-    val &amp;=0x00bf;    /* no sel	   */<br>
-    outw(val,tmport);<br>
-    outb(2,0x80);<br>
+	inb(0x80);<br>
+	val |= 0x8003;		/* io,cd,db7  */<br>
+	outw(val, tmport);<br>
+	inb(0x80);<br>
+	val &amp;= 0x00bf;		/* no sel     */<br>
+	outw(val, tmport);<br>
+	outb(2, 0x80);<br>
 TCM_SYNC:<br>
-    mydlyu(0x800);<br>
-    if ((inb(tmport) &amp; 0x80) == 0x00)	 /* bsy ? */<br>
-    {<br>
-       outw(0,tmport--);<br>
-       outb(0,tmport);<br>
-       tmport=ioportu[host] + 0x15;<br>
-       outb(0,tmport);<br>
-       tmport += 0x03;<br>
-       outb(0x09,tmport);<br>
-       tmport += 0x07;<br>
-       while ((inb(tmport) &amp; 0x80) == 0);<br>
-       tmport -= 0x08;<br>
-       inb(tmport);<br>
-       return;<br>
-    }<br>
-<br>
-    val &amp;= 0x00ff;		 /* synchronization  */<br>
-    val |= 0x3f00;<br>
-    fun_scam(host,&amp;val);<br>
-    outb(3,0x80);<br>
-    val &amp;= 0x00ff;		 /* isolation	     */<br>
-    val |= 0x2000;<br>
-    fun_scam(host,&amp;val);<br>
-    outb(4,0x80);<br>
-    i=8;<br>
-    j=0;<br>
+	mydlyu(0x800);<br>
+	if ((inb(tmport) &amp; 0x80) == 0x00) {	/* bsy ? */<br>
+		outw(0, tmport--);<br>
+		outb(0, tmport);<br>
+		tmport = ioportu[host] + 0x15;<br>
+		outb(0, tmport);<br>
+		tmport += 0x03;<br>
+		outb(0x09, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0);<br>
+		tmport -= 0x08;<br>
+		inb(tmport);<br>
+		return;<br>
+	}<br>
+	val &amp;= 0x00ff;		/* synchronization  */<br>
+	val |= 0x3f00;<br>
+	fun_scam(host, &amp;val);<br>
+	outb(3, 0x80);<br>
+	val &amp;= 0x00ff;		/* isolation        */<br>
+	val |= 0x2000;<br>
+	fun_scam(host, &amp;val);<br>
+	outb(4, 0x80);<br>
+	i = 8;<br>
+	j = 0;<br>
 TCM_ID:<br>
-    if ((inw(tmport) &amp; 0x2000) == 0)<br>
-    {<br>
-       goto TCM_ID;<br>
-    }<br>
-    outb(5,0x80);<br>
-    val &amp;= 0x00ff;		 /* get ID_STRING */<br>
-    val |= 0x2000;<br>
-    k=fun_scam(host,&amp;val);<br>
-    if ((k &amp; 0x03) == 0)<br>
-    {<br>
-       goto TCM_5;<br>
-    }<br>
-    mbuf[j] &lt;&lt;= 0x01;<br>
-    mbuf[j] &amp;= 0xfe;<br>
-    if ((k &amp; 0x02) != 0)<br>
-    {<br>
-       mbuf[j] |= 0x01;<br>
-    }<br>
-    i--;<br>
-    if ( i &gt; 0 )<br>
-    {<br>
-       goto TCM_ID;<br>
-    }<br>
-    j++;<br>
-    i=8;<br>
-    goto TCM_ID;<br>
+	if ((inw(tmport) &amp; 0x2000) == 0) {<br>
+		goto TCM_ID;<br>
+	}<br>
+	outb(5, 0x80);<br>
+	val &amp;= 0x00ff;		/* get ID_STRING */<br>
+	val |= 0x2000;<br>
+	k = fun_scam(host, &amp;val);<br>
+	if ((k &amp; 0x03) == 0) {<br>
+		goto TCM_5;<br>
+	}<br>
+	mbuf[j] &lt;&lt;= 0x01;<br>
+	mbuf[j] &amp;= 0xfe;<br>
+	if ((k &amp; 0x02) != 0) {<br>
+		mbuf[j] |= 0x01;<br>
+	}<br>
+	i--;<br>
+	if (i &gt; 0) {<br>
+		goto TCM_ID;<br>
+	}<br>
+	j++;<br>
+	i = 8;<br>
+	goto TCM_ID;<br>
 <br>
-TCM_5:			     /* isolation complete..  */<br>
+TCM_5:			/* isolation complete..  */<br>
 /*    mbuf[32]=0;<br>
-    printk(" \n%x %x %x %s\n ",assignid_map,mbuf[0],mbuf[1],&amp;mbuf[2]); */<br>
-    i=15;<br>
-    j=mbuf[0];<br>
-    if ((j &amp; 0x20) != 0)     /* bit5=1:ID upto 7      */<br>
-    {<br>
-       i=7;<br>
-    }<br>
-    if ((j &amp; 0x06) == 0)     /* IDvalid?	      */<br>
-    {<br>
-       goto  G2Q5;<br>
-    }<br>
-    k=mbuf[1];<br>
+	printk(" \n%x %x %x %s\n ",assignid_map,mbuf[0],mbuf[1],&amp;mbuf[2]); */<br>
+	i = 15;<br>
+	j = mbuf[0];<br>
+	if ((j &amp; 0x20) != 0) {	/* bit5=1:ID upto 7      */<br>
+		i = 7;<br>
+	}<br>
+	if ((j &amp; 0x06) == 0) {	/* IDvalid?             */<br>
+		goto G2Q5;<br>
+	}<br>
+	k = mbuf[1];<br>
 small_id:<br>
-    m=1;<br>
-    m &lt;&lt;= k;<br>
-    if ((m &amp; assignid_map) == 0)<br>
-    {<br>
-       goto G2Q_QUIN;<br>
-    }<br>
-    if ( k &gt; 0 )<br>
-    {<br>
-       k--;<br>
-       goto small_id;<br>
-    }<br>
-G2Q5:			      /* srch from max acceptable ID#  */<br>
-    k=i;		      /* max acceptable ID#	       */<br>
+	m = 1;<br>
+	m &lt;&lt;= k;<br>
+	if ((m &amp; assignid_map) == 0) {<br>
+		goto G2Q_QUIN;<br>
+	}<br>
+	if (k &gt; 0) {<br>
+		k--;<br>
+		goto small_id;<br>
+	}<br>
+G2Q5:				/* srch from max acceptable ID#  */<br>
+	k = i;			/* max acceptable ID#            */<br>
 G2Q_LP:<br>
-    m=1;<br>
-    m &lt;&lt;= k;<br>
-    if ((m &amp; assignid_map) == 0)<br>
-    {<br>
-       goto G2Q_QUIN;<br>
-    }<br>
-    if ( k &gt; 0 )<br>
-    {<br>
-       k--;<br>
-       goto G2Q_LP;<br>
-    }<br>
-G2Q_QUIN:		      /* k=binID#,	 */<br>
-    assignid_map |= m;<br>
-    if ( k &lt; 8 )<br>
-    {<br>
-       quintet[0]=0x38;       /* 1st dft ID&lt;8	 */<br>
-    }<br>
-    else<br>
-    {<br>
-       quintet[0]=0x31;       /* 1st  ID&gt;=8	 */<br>
-    }<br>
-    k &amp;= 0x07;<br>
-    quintet[1]=g2q_tab[k];<br>
-<br>
-    val &amp;= 0x00ff;	       /* AssignID 1stQuintet,AH=001xxxxx  */<br>
-    m=quintet[0] &lt;&lt; 8;<br>
-    val |= m;<br>
-    fun_scam(host,&amp;val);<br>
-    val &amp;= 0x00ff;	       /* AssignID 2ndQuintet,AH=001xxxxx */<br>
-    m=quintet[1] &lt;&lt; 8;<br>
-    val |= m;<br>
-    fun_scam(host,&amp;val);<br>
+	m = 1;<br>
+	m &lt;&lt;= k;<br>
+	if ((m &amp; assignid_map) == 0) {<br>
+		goto G2Q_QUIN;<br>
+	}<br>
+	if (k &gt; 0) {<br>
+		k--;<br>
+		goto G2Q_LP;<br>
+	}<br>
+G2Q_QUIN:		/* k=binID#,       */<br>
+	assignid_map |= m;<br>
+	if (k &lt; 8) {<br>
+		quintet[0] = 0x38;	/* 1st dft ID&lt;8    */<br>
+	} else {<br>
+		quintet[0] = 0x31;	/* 1st  ID&gt;=8      */<br>
+	}<br>
+	k &amp;= 0x07;<br>
+	quintet[1] = g2q_tab[k];<br>
 <br>
-    goto TCM_SYNC;<br>
+	val &amp;= 0x00ff;		/* AssignID 1stQuintet,AH=001xxxxx  */<br>
+	m = quintet[0] &lt;&lt; 8;<br>
+	val |= m;<br>
+	fun_scam(host, &amp;val);<br>
+	val &amp;= 0x00ff;		/* AssignID 2ndQuintet,AH=001xxxxx */<br>
+	m = quintet[1] &lt;&lt; 8;<br>
+	val |= m;<br>
+	fun_scam(host, &amp;val);<br>
+<br>
+	goto TCM_SYNC;<br>
 <br>
 }<br>
 <br>
-void is870(unsigned long host,unsigned int wkport )<br>
+void is870(unsigned long host, unsigned int wkport)<br>
 {<br>
-    unsigned int  tmport ;<br>
-    unsigned char i,j,k,rmb;<br>
-    unsigned short int m;<br>
-    static unsigned char mbuf[512];<br>
-    static unsigned char satn[9] = { 0,0,0,0,0,0,0,6,6 };<br>
-    static unsigned char inqd[9] = { 0x12,0,0,0,0x24,0,0,0x24,6 };<br>
-    static unsigned char synn[6] = { 0x80,1,3,1,0x19,0x0e };<br>
-    static unsigned char synu[6] = { 0x80,1,3,1,0x0c,0x0e };<br>
-    static unsigned char synw[6] = { 0x80,1,3,1,0x0c,0x07 };<br>
-    static unsigned char wide[6] = { 0x80,1,2,3,1,0 };<br>
-<br>
-    sync_idu=0;<br>
-    tmport=wkport+0x3a;<br>
-    outb((unsigned char)(inb(tmport) | 0x10),tmport);<br>
-<br>
-    for ( i = 0 ; i &lt; 16 ; i ++ )<br>
-    {<br>
-	if ((chip_veru[host] != 4) &amp;&amp; (i &gt; 7))<br>
-	{<br>
-	   break;<br>
-	}<br>
-	m=1;<br>
-	m=m&lt;&lt;i;<br>
-	if ( ( m &amp; active_idu[host] ) != 0 )<br>
-	{<br>
-	   continue;<br>
-	}<br>
-	if ( i == host_idu[host] )<br>
-	{<br>
-	   printk("         ID: %2d  Host Adapter\n",host_idu[host]);<br>
-	   continue;<br>
-	}<br>
-	if ( chip_veru[host] == 4 )<br>
-	{<br>
-	   tmport=wkport+0x1b;<br>
-	   j=(inb(tmport) &amp; 0x0e) | 0x01;<br>
-	   outb(j,tmport);<br>
-	}<br>
-    tmport=wkport+1;<br>
-    outb(0x08,tmport++);<br>
-    outb(0x7f,tmport++);<br>
-    outb(satn[0],tmport++);<br>
-    outb(satn[1],tmport++);<br>
-    outb(satn[2],tmport++);<br>
-    outb(satn[3],tmport++);<br>
-    outb(satn[4],tmport++);<br>
-    outb(satn[5],tmport++);<br>
-    tmport+=0x06;<br>
-    outb(0,tmport);<br>
-    tmport+=0x02;<br>
-    outb(devspu[host][i],tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(satn[6],tmport++);<br>
-    outb(satn[7],tmport++);<br>
-    j=i;<br>
-    if ((j &amp; 0x08) != 0)<br>
-    {<br>
-       j=(j &amp; 0x07) | 0x40;<br>
-    }<br>
-    outb(j,tmport);<br>
-    tmport+=0x03;<br>
-    outb(satn[8],tmport);<br>
-    tmport+=0x07;<br>
-<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport-=0x08;<br>
-    if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e))<br>
-    {<br>
-       continue;<br>
-    }<br>
-    while ( inb(tmport) != 0x8e );<br>
-    active_idu[host] |= m;<br>
-<br>
-    tmport=wkport+0x10;<br>
-    outb(0x30,tmport);<br>
-    tmport=wkport+0x04;<br>
-    outb(0x00,tmport);<br>
+	unsigned int tmport;<br>
+	unsigned char i, j, k, rmb;<br>
+	unsigned short int m;<br>
+	static unsigned char mbuf[512];<br>
+	static unsigned char satn[9] = 	{0, 0, 0, 0, 0, 0, 0, 6, 6};<br>
+	static unsigned char inqd[9] =	{0x12, 0, 0, 0, 0x24, 0, 0, 0x24, 6};<br>
+	static unsigned char synn[6] =  {0x80, 1, 3, 1, 0x19, 0x0e};<br>
+	static unsigned char synu[6] =	{0x80, 1, 3, 1, 0x0c, 0x0e};<br>
+	static unsigned char synw[6] =	{0x80, 1, 3, 1, 0x0c, 0x07};<br>
+	static unsigned char wide[6] =  {0x80, 1, 2, 3, 1, 0};<br>
+<br>
+	sync_idu = 0;<br>
+	tmport = wkport + 0x3a;<br>
+	outb((unsigned char) (inb(tmport) | 0x10), tmport);<br>
+<br>
+	for (i = 0; i &lt; 16; i++) {<br>
+		if ((chip_veru[host] != 4) &amp;&amp; (i &gt; 7)) {<br>
+			break;<br>
+		}<br>
+		m = 1;<br>
+		m = m &lt;&lt; i;<br>
+		if ((m &amp; active_idu[host]) != 0) {<br>
+			continue;<br>
+		}<br>
+		if (i == host_idu[host]) {<br>
+			printk("         ID: %2d  Host Adapter\n", host_idu[host]);<br>
+			continue;<br>
+		}<br>
+		if (chip_veru[host] == 4) {<br>
+			tmport = wkport + 0x1b;<br>
+			j = (inb(tmport) &amp; 0x0e) | 0x01;<br>
+			outb(j, tmport);<br>
+		}<br>
+		tmport = wkport + 1;<br>
+		outb(0x08, tmport++);<br>
+		outb(0x7f, tmport++);<br>
+		outb(satn[0], tmport++);<br>
+		outb(satn[1], tmport++);<br>
+		outb(satn[2], tmport++);<br>
+		outb(satn[3], tmport++);<br>
+		outb(satn[4], tmport++);<br>
+		outb(satn[5], tmport++);<br>
+		tmport += 0x06;<br>
+		outb(0, tmport);<br>
+		tmport += 0x02;<br>
+		outb(devspu[host][i], tmport++);<br>
+		outb(0, tmport++);<br>
+		outb(satn[6], tmport++);<br>
+		outb(satn[7], tmport++);<br>
+		j = i;<br>
+		if ((j &amp; 0x08) != 0) {<br>
+			j = (j &amp; 0x07) | 0x40;<br>
+		}<br>
+		outb(j, tmport);<br>
+		tmport += 0x03;<br>
+		outb(satn[8], tmport);<br>
+		tmport += 0x07;<br>
+<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e)) {<br>
+			continue;<br>
+		}<br>
+		while (inb(tmport) != 0x8e);<br>
+		active_idu[host] |= m;<br>
+<br>
+		tmport = wkport + 0x10;<br>
+		outb(0x30, tmport);<br>
+		tmport = wkport + 0x04;<br>
+		outb(0x00, tmport);<br>
 <br>
 phase_cmd:<br>
-    tmport=wkport+0x18;<br>
-    outb(0x08,tmport);<br>
-    tmport+=0x07;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport-=0x08;<br>
-    j=inb(tmport);<br>
-    if ( j != 0x16 )<br>
-    {<br>
-       tmport=wkport+0x10;<br>
-       outb(0x41,tmport);<br>
-       goto phase_cmd;<br>
-    }<br>
+		tmport = wkport + 0x18;<br>
+		outb(0x08, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		j = inb(tmport);<br>
+		if (j != 0x16) {<br>
+			tmport = wkport + 0x10;<br>
+			outb(0x41, tmport);<br>
+			goto phase_cmd;<br>
+		}<br>
 sel_ok:<br>
-       tmport=wkport+3;<br>
-       outb(inqd[0],tmport++);<br>
-       outb(inqd[1],tmport++);<br>
-       outb(inqd[2],tmport++);<br>
-       outb(inqd[3],tmport++);<br>
-       outb(inqd[4],tmport++);<br>
-       outb(inqd[5],tmport);<br>
-       tmport+=0x07;<br>
-       outb(0,tmport);<br>
-       tmport+=0x02;<br>
-       outb(devspu[host][i],tmport++);<br>
-       outb(0,tmport++);<br>
-       outb(inqd[6],tmport++);<br>
-       outb(inqd[7],tmport++);<br>
-       tmport+=0x03;<br>
-       outb(inqd[8],tmport);<br>
-       tmport+=0x07;<br>
-       while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-       tmport-=0x08;<br>
-       if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e))<br>
-       {<br>
-	  continue;<br>
-       }<br>
-       while ( inb(tmport) != 0x8e );<br>
-       if ( chip_veru[host] == 4 )<br>
-       {<br>
-	  tmport=wkport+0x1b;<br>
-	  j=inb(tmport) &amp; 0x0e;<br>
-	  outb(j,tmport);<br>
-       }<br>
-       tmport=wkport+0x18;<br>
-       outb(0x08,tmport);<br>
-       tmport += 0x07;<br>
-       j=0;<br>
+		tmport = wkport + 3;<br>
+		outb(inqd[0], tmport++);<br>
+		outb(inqd[1], tmport++);<br>
+		outb(inqd[2], tmport++);<br>
+		outb(inqd[3], tmport++);<br>
+		outb(inqd[4], tmport++);<br>
+		outb(inqd[5], tmport);<br>
+		tmport += 0x07;<br>
+		outb(0, tmport);<br>
+		tmport += 0x02;<br>
+		outb(devspu[host][i], tmport++);<br>
+		outb(0, tmport++);<br>
+		outb(inqd[6], tmport++);<br>
+		outb(inqd[7], tmport++);<br>
+		tmport += 0x03;<br>
+		outb(inqd[8], tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e)) {<br>
+			continue;<br>
+		}<br>
+		while (inb(tmport) != 0x8e);<br>
+		if (chip_veru[host] == 4) {<br>
+			tmport = wkport + 0x1b;<br>
+			j = inb(tmport) &amp; 0x0e;<br>
+			outb(j, tmport);<br>
+		}<br>
+		tmport = wkport + 0x18;<br>
+		outb(0x08, tmport);<br>
+		tmport += 0x07;<br>
+		j = 0;<br>
 rd_inq_data:<br>
-       k=inb(tmport);<br>
-       if ((k &amp; 0x01) != 0 )<br>
-       {<br>
-	  tmport-=0x06;<br>
-	  mbuf[j++]=inb(tmport);<br>
-	  tmport+=0x06;<br>
-	  goto rd_inq_data;<br>
-       }<br>
-       if ((k &amp; 0x80) == 0 )<br>
-       {<br>
-	  goto rd_inq_data;<br>
-       }<br>
-       tmport-=0x08;<br>
-       j=inb(tmport);<br>
-       if ( j == 0x16 )<br>
-       {<br>
-	  goto inq_ok;<br>
-       }<br>
-    tmport=wkport+0x10;<br>
-    outb(0x46,tmport);<br>
-    tmport+=0x02;<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(0,tmport++);<br>
-    tmport+=0x03;<br>
-    outb(0x08,tmport);<br>
-    tmport+=0x07;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport-=0x08;<br>
-    if (inb(tmport) != 0x16)<br>
-    {<br>
-       goto sel_ok;<br>
-    }<br>
+		k = inb(tmport);<br>
+		if ((k &amp; 0x01) != 0) {<br>
+			tmport -= 0x06;<br>
+			mbuf[j++] = inb(tmport);<br>
+			tmport += 0x06;<br>
+			goto rd_inq_data;<br>
+		}<br>
+		if ((k &amp; 0x80) == 0) {<br>
+			goto rd_inq_data;<br>
+		}<br>
+		tmport -= 0x08;<br>
+		j = inb(tmport);<br>
+		if (j == 0x16) {<br>
+			goto inq_ok;<br>
+		}<br>
+		tmport = wkport + 0x10;<br>
+		outb(0x46, tmport);<br>
+		tmport += 0x02;<br>
+		outb(0, tmport++);<br>
+		outb(0, tmport++);<br>
+		outb(0, tmport++);<br>
+		tmport += 0x03;<br>
+		outb(0x08, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		if (inb(tmport) != 0x16) {<br>
+			goto sel_ok;<br>
+		}<br>
 inq_ok:<br>
-     mbuf[36]=0;<br>
-     printk("         ID: %2d  %s\n",i,&amp;mbuf[8]);<br>
-     devtypeu[host][i]=mbuf[0];<br>
-     rmb=mbuf[1];<br>
-     if ( chip_veru[host] != 4 )<br>
-     {<br>
-	goto not_wide;<br>
-     }<br>
-     if ((mbuf[7] &amp; 0x60) == 0)<br>
-     {<br>
-	goto not_wide;<br>
-     }<br>
-     if ((global_map[host] &amp; 0x20) == 0)<br>
-     {<br>
-	goto not_wide;<br>
-     }<br>
-     tmport=wkport+0x1b;<br>
-     j=(inb(tmport) &amp; 0x0e) | 0x01;<br>
-     outb(j,tmport);<br>
-    tmport=wkport+3;<br>
-    outb(satn[0],tmport++);<br>
-    outb(satn[1],tmport++);<br>
-    outb(satn[2],tmport++);<br>
-    outb(satn[3],tmport++);<br>
-    outb(satn[4],tmport++);<br>
-    outb(satn[5],tmport++);<br>
-    tmport+=0x06;<br>
-    outb(0,tmport);<br>
-    tmport+=0x02;<br>
-    outb(devspu[host][i],tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(satn[6],tmport++);<br>
-    outb(satn[7],tmport++);<br>
-    tmport+=0x03;<br>
-    outb(satn[8],tmport);<br>
-    tmport+=0x07;<br>
-<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport-=0x08;<br>
-    if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e))<br>
-    {<br>
-       continue;<br>
-    }<br>
-    while ( inb(tmport) != 0x8e );<br>
+		mbuf[36] = 0;<br>
+		printk("         ID: %2d  %s\n", i, &amp;mbuf[8]);<br>
+		devtypeu[host][i] = mbuf[0];<br>
+		rmb = mbuf[1];<br>
+		if (chip_veru[host] != 4) {<br>
+			goto not_wide;<br>
+		}<br>
+		if ((mbuf[7] &amp; 0x60) == 0) {<br>
+			goto not_wide;<br>
+		}<br>
+		if ((global_map[host] &amp; 0x20) == 0) {<br>
+			goto not_wide;<br>
+		}<br>
+		tmport = wkport + 0x1b;<br>
+		j = (inb(tmport) &amp; 0x0e) | 0x01;<br>
+		outb(j, tmport);<br>
+		tmport = wkport + 3;<br>
+		outb(satn[0], tmport++);<br>
+		outb(satn[1], tmport++);<br>
+		outb(satn[2], tmport++);<br>
+		outb(satn[3], tmport++);<br>
+		outb(satn[4], tmport++);<br>
+		outb(satn[5], tmport++);<br>
+		tmport += 0x06;<br>
+		outb(0, tmport);<br>
+		tmport += 0x02;<br>
+		outb(devspu[host][i], tmport++);<br>
+		outb(0, tmport++);<br>
+		outb(satn[6], tmport++);<br>
+		outb(satn[7], tmport++);<br>
+		tmport += 0x03;<br>
+		outb(satn[8], tmport);<br>
+		tmport += 0x07;<br>
+<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e)) {<br>
+			continue;<br>
+		}<br>
+		while (inb(tmport) != 0x8e);<br>
 try_wide:<br>
-    j=0;<br>
-    tmport=wkport+0x14;<br>
-    outb(0x05,tmport);<br>
-    tmport += 0x04;<br>
-    outb(0x20,tmport);<br>
-    tmport+=0x07;<br>
-<br>
-    while ((inb(tmport) &amp; 0x80) == 0 )<br>
-    {<br>
-       if ((inb(tmport) &amp; 0x01) != 0 )<br>
-       {<br>
-	  tmport-=0x06;<br>
-	  outb(wide[j++],tmport);<br>
-	  tmport+=0x06;<br>
-       }<br>
-    }<br>
-    tmport-=0x08;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    j=inb(tmport) &amp; 0x0f;<br>
-    if ( j == 0x0f )<br>
-    {<br>
-       goto widep_in;<br>
-    }<br>
-    if ( j == 0x0a )<br>
-    {<br>
-       goto widep_cmd;<br>
-    }<br>
-    if ( j == 0x0e )<br>
-    {<br>
-       goto try_wide;<br>
-    }<br>
-    continue;<br>
+		j = 0;<br>
+		tmport = wkport + 0x14;<br>
+		outb(0x05, tmport);<br>
+		tmport += 0x04;<br>
+		outb(0x20, tmport);<br>
+		tmport += 0x07;<br>
+<br>
+		while ((inb(tmport) &amp; 0x80) == 0) {<br>
+			if ((inb(tmport) &amp; 0x01) != 0) {<br>
+				tmport -= 0x06;<br>
+				outb(wide[j++], tmport);<br>
+				tmport += 0x06;<br>
+			}<br>
+		}<br>
+		tmport -= 0x08;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		j = inb(tmport) &amp; 0x0f;<br>
+		if (j == 0x0f) {<br>
+			goto widep_in;<br>
+		}<br>
+		if (j == 0x0a) {<br>
+			goto widep_cmd;<br>
+		}<br>
+		if (j == 0x0e) {<br>
+			goto try_wide;<br>
+		}<br>
+		continue;<br>
 widep_out:<br>
-    tmport=wkport+0x18;<br>
-    outb(0x20,tmport);<br>
-    tmport+=0x07;<br>
-    while ((inb(tmport) &amp; 0x80) == 0 )<br>
-    {<br>
-	if ((inb(tmport) &amp; 0x01) != 0 )<br>
-	{<br>
-	   tmport-=0x06;<br>
-	   outb(0,tmport);<br>
-	   tmport+=0x06;<br>
-	}<br>
-    }<br>
-    tmport-=0x08;<br>
-    j=inb(tmport) &amp; 0x0f;<br>
-    if ( j == 0x0f )<br>
-    {<br>
-       goto widep_in;<br>
-    }<br>
-    if ( j == 0x0a )<br>
-    {<br>
-       goto widep_cmd;<br>
-    }<br>
-    if ( j == 0x0e )<br>
-    {<br>
-       goto widep_out;<br>
-    }<br>
-    continue;<br>
+		tmport = wkport + 0x18;<br>
+		outb(0x20, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0) {<br>
+			if ((inb(tmport) &amp; 0x01) != 0) {<br>
+				tmport -= 0x06;<br>
+				outb(0, tmport);<br>
+				tmport += 0x06;<br>
+			}<br>
+		}<br>
+		tmport -= 0x08;<br>
+		j = inb(tmport) &amp; 0x0f;<br>
+		if (j == 0x0f) {<br>
+			goto widep_in;<br>
+		}<br>
+		if (j == 0x0a) {<br>
+			goto widep_cmd;<br>
+		}<br>
+		if (j == 0x0e) {<br>
+			goto widep_out;<br>
+		}<br>
+		continue;<br>
 widep_in:<br>
-    tmport=wkport+0x14;<br>
-    outb(0xff,tmport);<br>
-    tmport += 0x04;<br>
-    outb(0x20,tmport);<br>
-    tmport+=0x07;<br>
-    k=0;<br>
+		tmport = wkport + 0x14;<br>
+		outb(0xff, tmport);<br>
+		tmport += 0x04;<br>
+		outb(0x20, tmport);<br>
+		tmport += 0x07;<br>
+		k = 0;<br>
 widep_in1:<br>
-    j=inb(tmport);<br>
-    if ((j &amp; 0x01) != 0)<br>
-    {<br>
-       tmport-=0x06;<br>
-       mbuf[k++]=inb(tmport);<br>
-       tmport+=0x06;<br>
-       goto widep_in1;<br>
-    }<br>
-    if ((j &amp; 0x80) == 0x00)<br>
-    {<br>
-       goto widep_in1;<br>
-    }<br>
-    tmport-=0x08;<br>
-    j=inb(tmport) &amp; 0x0f;<br>
-    if ( j == 0x0f )<br>
-    {<br>
-       goto widep_in;<br>
-    }<br>
-    if ( j == 0x0a )<br>
-    {<br>
-       goto widep_cmd;<br>
-    }<br>
-    if ( j == 0x0e )<br>
-    {<br>
-       goto widep_out;<br>
-    }<br>
-    continue;<br>
+		j = inb(tmport);<br>
+		if ((j &amp; 0x01) != 0) {<br>
+			tmport -= 0x06;<br>
+			mbuf[k++] = inb(tmport);<br>
+			tmport += 0x06;<br>
+			goto widep_in1;<br>
+		}<br>
+		if ((j &amp; 0x80) == 0x00) {<br>
+			goto widep_in1;<br>
+		}<br>
+		tmport -= 0x08;<br>
+		j = inb(tmport) &amp; 0x0f;<br>
+		if (j == 0x0f) {<br>
+			goto widep_in;<br>
+		}<br>
+		if (j == 0x0a) {<br>
+			goto widep_cmd;<br>
+		}<br>
+		if (j == 0x0e) {<br>
+			goto widep_out;<br>
+		}<br>
+		continue;<br>
 widep_cmd:<br>
-    tmport=wkport+0x10;<br>
-    outb(0x30,tmport);<br>
-    tmport=wkport+0x14;<br>
-    outb(0x00,tmport);<br>
-    tmport+=0x04;<br>
-    outb(0x08,tmport);<br>
-    tmport+=0x07;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport-=0x08;<br>
-    j=inb(tmport);<br>
-    if ( j != 0x16 )<br>
-    {<br>
-       if ( j == 0x4e )<br>
-       {<br>
-	  goto widep_out;<br>
-       }<br>
-       continue;<br>
-    }<br>
-    if ( mbuf[0] != 0x01 )<br>
-    {<br>
-       goto not_wide;<br>
-    }<br>
-    if ( mbuf[1] != 0x02 )<br>
-    {<br>
-       goto not_wide;<br>
-    }<br>
-    if ( mbuf[2] != 0x03 )<br>
-    {<br>
-       goto not_wide;<br>
-    }<br>
-    if ( mbuf[3] != 0x01 )<br>
-    {<br>
-       goto not_wide;<br>
-    }<br>
-    m=1;<br>
-    m = m &lt;&lt; i;<br>
-    wide_idu[host] |= m;<br>
+		tmport = wkport + 0x10;<br>
+		outb(0x30, tmport);<br>
+		tmport = wkport + 0x14;<br>
+		outb(0x00, tmport);<br>
+		tmport += 0x04;<br>
+		outb(0x08, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		j = inb(tmport);<br>
+		if (j != 0x16) {<br>
+			if (j == 0x4e) {<br>
+				goto widep_out;<br>
+			}<br>
+			continue;<br>
+		}<br>
+		if (mbuf[0] != 0x01) {<br>
+			goto not_wide;<br>
+		}<br>
+		if (mbuf[1] != 0x02) {<br>
+			goto not_wide;<br>
+		}<br>
+		if (mbuf[2] != 0x03) {<br>
+			goto not_wide;<br>
+		}<br>
+		if (mbuf[3] != 0x01) {<br>
+			goto not_wide;<br>
+		}<br>
+		m = 1;<br>
+		m = m &lt;&lt; i;<br>
+		wide_idu[host] |= m;<br>
 not_wide:<br>
-    if ((devtypeu[host][i] == 0x00) || (devtypeu[host][i] == 0x07))<br>
-    {<br>
-       goto set_sync;<br>
-    }<br>
-    continue;<br>
+		if ((devtypeu[host][i] == 0x00) || (devtypeu[host][i] == 0x07)) {<br>
+			goto set_sync;<br>
+		}<br>
+		continue;<br>
 set_sync:<br>
-    tmport=wkport+0x1b;<br>
-    j=inb(tmport) &amp; 0x0e;<br>
-    if ((m &amp; wide_idu[host]) != 0 )<br>
-    {<br>
-       j |= 0x01;<br>
-    }<br>
-    outb(j,tmport);<br>
-    tmport=wkport+3;<br>
-    outb(satn[0],tmport++);<br>
-    outb(satn[1],tmport++);<br>
-    outb(satn[2],tmport++);<br>
-    outb(satn[3],tmport++);<br>
-    outb(satn[4],tmport++);<br>
-    outb(satn[5],tmport++);<br>
-    tmport+=0x06;<br>
-    outb(0,tmport);<br>
-    tmport+=0x02;<br>
-    outb(devspu[host][i],tmport++);<br>
-    outb(0,tmport++);<br>
-    outb(satn[6],tmport++);<br>
-    outb(satn[7],tmport++);<br>
-    tmport+=0x03;<br>
-    outb(satn[8],tmport);<br>
-    tmport+=0x07;<br>
-<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport-=0x08;<br>
-    if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e))<br>
-    {<br>
-       continue;<br>
-    }<br>
-    while ( inb(tmport) != 0x8e);<br>
+		tmport = wkport + 0x1b;<br>
+		j = inb(tmport) &amp; 0x0e;<br>
+		if ((m &amp; wide_idu[host]) != 0) {<br>
+			j |= 0x01;<br>
+		}<br>
+		outb(j, tmport);<br>
+		tmport = wkport + 3;<br>
+		outb(satn[0], tmport++);<br>
+		outb(satn[1], tmport++);<br>
+		outb(satn[2], tmport++);<br>
+		outb(satn[3], tmport++);<br>
+		outb(satn[4], tmport++);<br>
+		outb(satn[5], tmport++);<br>
+		tmport += 0x06;<br>
+		outb(0, tmport);<br>
+		tmport += 0x02;<br>
+		outb(devspu[host][i], tmport++);<br>
+		outb(0, tmport++);<br>
+		outb(satn[6], tmport++);<br>
+		outb(satn[7], tmport++);<br>
+		tmport += 0x03;<br>
+		outb(satn[8], tmport);<br>
+		tmport += 0x07;<br>
+<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		if ((inb(tmport) != 0x11) &amp;&amp; (inb(tmport) != 0x8e)) {<br>
+			continue;<br>
+		}<br>
+		while (inb(tmport) != 0x8e);<br>
 try_sync:<br>
-    j=0;<br>
-    tmport=wkport+0x14;<br>
-    outb(0x06,tmport);<br>
-    tmport += 0x04;<br>
-    outb(0x20,tmport);<br>
-    tmport+=0x07;<br>
-<br>
-    while ((inb(tmport) &amp; 0x80) == 0 )<br>
-    {<br>
-       if ((inb(tmport) &amp; 0x01) != 0 )<br>
-       {<br>
-	  tmport-=0x06;<br>
-	  if ( rmb != 0 )<br>
-	  {<br>
-	     outb(synn[j++],tmport);<br>
-	  }<br>
-	  else<br>
-	  {<br>
-	     if ((m &amp; wide_idu[host]) != 0)<br>
-	     {<br>
-		outb(synw[j++],tmport);<br>
-	     }<br>
-	     else<br>
-	     {<br>
-		if ((m &amp; ultra_map[host]) != 0)<br>
-		{<br>
-		   outb(synu[j++],tmport);<br>
+		j = 0;<br>
+		tmport = wkport + 0x14;<br>
+		outb(0x06, tmport);<br>
+		tmport += 0x04;<br>
+		outb(0x20, tmport);<br>
+		tmport += 0x07;<br>
+<br>
+		while ((inb(tmport) &amp; 0x80) == 0) {<br>
+			if ((inb(tmport) &amp; 0x01) != 0) {<br>
+				tmport -= 0x06;<br>
+				if (rmb != 0) {<br>
+					outb(synn[j++], tmport);<br>
+				} else {<br>
+					if ((m &amp; wide_idu[host]) != 0) {<br>
+						outb(synw[j++], tmport);<br>
+					} else {<br>
+						if ((m &amp; ultra_map[host]) != 0) {<br>
+							outb(synu[j++], tmport);<br>
+						} else {<br>
+							outb(synn[j++], tmport);<br>
+						}<br>
+					}<br>
+				}<br>
+				tmport += 0x06;<br>
+			}<br>
 		}<br>
-		else<br>
-		{<br>
-		   outb(synn[j++],tmport);<br>
+		tmport -= 0x08;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		j = inb(tmport) &amp; 0x0f;<br>
+		if (j == 0x0f) {<br>
+			goto phase_ins;<br>
 		}<br>
-	     }<br>
-	  }<br>
-	  tmport+=0x06;<br>
-       }<br>
-    }<br>
-    tmport-=0x08;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    j=inb(tmport) &amp; 0x0f;<br>
-    if ( j == 0x0f )<br>
-    {<br>
-       goto phase_ins;<br>
-    }<br>
-    if ( j == 0x0a )<br>
-    {<br>
-       goto phase_cmds;<br>
-    }<br>
-    if ( j == 0x0e )<br>
-    {<br>
-       goto try_sync;<br>
-    }<br>
-    continue;<br>
+		if (j == 0x0a) {<br>
+			goto phase_cmds;<br>
+		}<br>
+		if (j == 0x0e) {<br>
+			goto try_sync;<br>
+		}<br>
+		continue;<br>
 phase_outs:<br>
-    tmport=wkport+0x18;<br>
-    outb(0x20,tmport);<br>
-    tmport+=0x07;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00)<br>
-    {<br>
-      if ((inb(tmport) &amp; 0x01) != 0x00)<br>
-      {<br>
-	 tmport-=0x06;<br>
-	 outb(0x00,tmport);<br>
-	 tmport+=0x06;<br>
-      }<br>
-    }<br>
-    tmport-=0x08;<br>
-    j=inb(tmport);<br>
-    if ( j == 0x85 )<br>
-    {<br>
-       goto tar_dcons;<br>
-    }<br>
-    j &amp;= 0x0f;<br>
-    if ( j == 0x0f )<br>
-    {<br>
-       goto phase_ins;<br>
-    }<br>
-    if ( j == 0x0a )<br>
-    {<br>
-       goto phase_cmds;<br>
-    }<br>
-    if ( j == 0x0e )<br>
-    {<br>
-       goto phase_outs;<br>
-    }<br>
-    continue;<br>
+		tmport = wkport + 0x18;<br>
+		outb(0x20, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00) {<br>
+			if ((inb(tmport) &amp; 0x01) != 0x00) {<br>
+				tmport -= 0x06;<br>
+				outb(0x00, tmport);<br>
+				tmport += 0x06;<br>
+			}<br>
+		}<br>
+		tmport -= 0x08;<br>
+		j = inb(tmport);<br>
+		if (j == 0x85) {<br>
+			goto tar_dcons;<br>
+		}<br>
+		j &amp;= 0x0f;<br>
+		if (j == 0x0f) {<br>
+			goto phase_ins;<br>
+		}<br>
+		if (j == 0x0a) {<br>
+			goto phase_cmds;<br>
+		}<br>
+		if (j == 0x0e) {<br>
+			goto phase_outs;<br>
+		}<br>
+		continue;<br>
 phase_ins:<br>
-    tmport=wkport+0x14;<br>
-    outb(0xff,tmport);<br>
-    tmport += 0x04;<br>
-    outb(0x20,tmport);<br>
-    tmport+=0x07;<br>
-    k=0;<br>
+		tmport = wkport + 0x14;<br>
+		outb(0xff, tmport);<br>
+		tmport += 0x04;<br>
+		outb(0x20, tmport);<br>
+		tmport += 0x07;<br>
+		k = 0;<br>
 phase_ins1:<br>
-    j=inb(tmport);<br>
-    if ((j &amp; 0x01) != 0x00)<br>
-    {<br>
-       tmport-=0x06;<br>
-       mbuf[k++]=inb(tmport);<br>
-       tmport+=0x06;<br>
-       goto phase_ins1;<br>
-    }<br>
-    if ((j &amp; 0x80) == 0x00)<br>
-    {<br>
-       goto phase_ins1;<br>
-    }<br>
-    tmport-=0x08;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    j=inb(tmport);<br>
-    if ( j == 0x85 )<br>
-    {<br>
-       goto tar_dcons;<br>
-    }<br>
-    j &amp;= 0x0f;<br>
-    if ( j == 0x0f )<br>
-    {<br>
-       goto phase_ins;<br>
-    }<br>
-    if ( j == 0x0a )<br>
-    {<br>
-       goto phase_cmds;<br>
-    }<br>
-    if ( j == 0x0e )<br>
-    {<br>
-       goto phase_outs;<br>
-    }<br>
-    continue;<br>
+		j = inb(tmport);<br>
+		if ((j &amp; 0x01) != 0x00) {<br>
+			tmport -= 0x06;<br>
+			mbuf[k++] = inb(tmport);<br>
+			tmport += 0x06;<br>
+			goto phase_ins1;<br>
+		}<br>
+		if ((j &amp; 0x80) == 0x00) {<br>
+			goto phase_ins1;<br>
+		}<br>
+		tmport -= 0x08;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		j = inb(tmport);<br>
+		if (j == 0x85) {<br>
+			goto tar_dcons;<br>
+		}<br>
+		j &amp;= 0x0f;<br>
+		if (j == 0x0f) {<br>
+			goto phase_ins;<br>
+		}<br>
+		if (j == 0x0a) {<br>
+			goto phase_cmds;<br>
+		}<br>
+		if (j == 0x0e) {<br>
+			goto phase_outs;<br>
+		}<br>
+		continue;<br>
 phase_cmds:<br>
-    tmport=wkport+0x10;<br>
-    outb(0x30,tmport);<br>
+		tmport = wkport + 0x10;<br>
+		outb(0x30, tmport);<br>
 tar_dcons:<br>
-    tmport=wkport+0x14;<br>
-    outb(0x00,tmport);<br>
-    tmport+=0x04;<br>
-    outb(0x08,tmport);<br>
-    tmport+=0x07;<br>
-    while ((inb(tmport) &amp; 0x80) == 0x00);<br>
-    tmport-=0x08;<br>
-    j=inb(tmport);<br>
-    if ( j != 0x16 )<br>
-    {<br>
-       continue;<br>
-    }<br>
-    if ( mbuf[0] != 0x01 )<br>
-    {<br>
-       continue;<br>
-    }<br>
-    if ( mbuf[1] != 0x03 )<br>
-    {<br>
-       continue;<br>
-    }<br>
-    if ( mbuf[4] == 0x00 )<br>
-    {<br>
-       continue;<br>
-    }<br>
-    if ( mbuf[3] &gt; 0x64 )<br>
-    {<br>
-       continue;<br>
-    }<br>
-    if ( mbuf[4] &gt; 0x0c )<br>
-    {<br>
-       mbuf[4]=0x0c;<br>
-    }<br>
-    devspu[host][i] = mbuf[4];<br>
-    if ((mbuf[3] &lt; 0x0d) &amp;&amp; (rmb == 0))<br>
-    {<br>
-       j=0xa0;<br>
-       goto set_syn_ok;<br>
-    }<br>
-    if ( mbuf[3] &lt; 0x1a )<br>
-    {<br>
-       j=0x20;<br>
-       goto set_syn_ok;<br>
-    }<br>
-    if ( mbuf[3] &lt; 0x33 )<br>
-    {<br>
-       j=0x40;<br>
-       goto set_syn_ok;<br>
-    }<br>
-    if ( mbuf[3] &lt; 0x4c )<br>
-    {<br>
-       j=0x50;<br>
-       goto set_syn_ok;<br>
-    }<br>
-    j=0x60;<br>
-set_syn_ok:<br>
-    devspu[host][i] = (devspu[host][i] &amp; 0x0f) | j;<br>
-   }<br>
-   tmport=wkport+0x3a;<br>
-   outb((unsigned char)(inb(tmport) &amp; 0xef),tmport);<br>
+		tmport = wkport + 0x14;<br>
+		outb(0x00, tmport);<br>
+		tmport += 0x04;<br>
+		outb(0x08, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0x00);<br>
+		tmport -= 0x08;<br>
+		j = inb(tmport);<br>
+		if (j != 0x16) {<br>
+			continue;<br>
+		}<br>
+		if (mbuf[0] != 0x01) {<br>
+			continue;<br>
+		}<br>
+		if (mbuf[1] != 0x03) {<br>
+			continue;<br>
+		}<br>
+		if (mbuf[4] == 0x00) {<br>
+			continue;<br>
+		}<br>
+		if (mbuf[3] &gt; 0x64) {<br>
+			continue;<br>
+		}<br>
+		if (mbuf[4] &gt; 0x0c) {<br>
+			mbuf[4] = 0x0c;<br>
+		}<br>
+		devspu[host][i] = mbuf[4];<br>
+		if ((mbuf[3] &lt; 0x0d) &amp;&amp; (rmb == 0)) {<br>
+			j = 0xa0;<br>
+			goto set_syn_ok;<br>
+		}<br>
+		if (mbuf[3] &lt; 0x1a) {<br>
+			j = 0x20;<br>
+			goto set_syn_ok;<br>
+		}<br>
+		if (mbuf[3] &lt; 0x33) {<br>
+			j = 0x40;<br>
+			goto set_syn_ok;<br>
+		}<br>
+		if (mbuf[3] &lt; 0x4c) {<br>
+			j = 0x50;<br>
+			goto set_syn_ok;<br>
+		}<br>
+		j = 0x60;<br>
+	      set_syn_ok:<br>
+		devspu[host][i] = (devspu[host][i] &amp; 0x0f) | j;<br>
+	}<br>
+	tmport = wkport + 0x3a;<br>
+	outb((unsigned char) (inb(tmport) &amp; 0xef), tmport);<br>
 }<br>
 <br>
 /* return non-zero on detection */<br>
 int atp870u_detect(Scsi_Host_Template * tpnt)<br>
 {<br>
-    unsigned char irq,h,k;<br>
-    unsigned long flags;<br>
-    unsigned int base_io,error,tmport;<br>
-    unsigned short index = 0;<br>
-    unsigned char pci_bus[3], pci_device_fn[3], chip_ver[3],host_id;<br>
-    struct Scsi_Host * shpnt = NULL;<br>
-    int count = 0;<br>
-    static unsigned short devid[7]={0x8002,0x8010,0x8020,0x8030,0x8040,0x8050,0};<br>
-    static struct pci_dev *pdev = NULL, *acard_pdev[3];<br>
-<br>
-    printk("aec671x_detect: \n");<br>
-    if (!pci_present())<br>
-    {<br>
-       printk("   NO BIOS32 SUPPORT.\n");<br>
-       return count;<br>
-    }<br>
-<br>
-    tpnt-&gt;proc_dir = &amp;proc_scsi_atp870u;<br>
-<br>
-    for ( h = 0 ; h &lt; 2 ; h++ )<br>
-    {<br>
-      active_idu[h]=0;<br>
-      wide_idu[h]=0;<br>
-      host_idu[h]=0x07;<br>
-      quhdu[h]=0;<br>
-      quendu[h]=0;<br>
-      pci_bus[h]=0;<br>
-      pci_device_fn[h]=0xff;<br>
-      chip_ver[h]=0;<br>
-      last_cmd[h]=0xff;<br>
-      in_snd[h]=0;<br>
-      in_int[h]=0;<br>
-      for ( k = 0 ; k &lt; qcnt ; k++ )<br>
-      {<br>
-	  querequ[h][k]=0;<br>
-      }<br>
-      for ( k = 0 ; k &lt; 16 ; k++ )<br>
-      {<br>
-	  curr_req[h][k]=0;<br>
-      }<br>
-    }<br>
-    h=0;<br>
-    while ( devid[h] != 0 )<br>
-    {<br>
-      pdev = pci_find_device(0x1191,devid[h],pdev);<br>
-      if (pdev == NULL) {<br>
-	  h++;<br>
-	  index=0;<br>
-	  continue;<br>
-       }<br>
-       chip_ver[2]=0;<br>
-	   <br>
-       /* To avoid messing with the things below...  */<br>
-       acard_pdev[2] = pdev;<br>
-       pci_device_fn[2] =  pdev-&gt;devfn;<br>
-       pci_bus[2] = pdev-&gt;bus-&gt;number;<br>
-<br>
-       if ( devid[h] == 0x8002 )<br>
-       {<br>
-	  error = pci_read_config_byte(pdev,0x08,&amp;chip_ver[2]);<br>
-	  if ( chip_ver[2] &lt; 2 )<br>
-	  {<br>
-	     goto nxt_devfn;<br>
-	  }<br>
-       }<br>
-       if ( devid[h] == 0x8010 )<br>
-       {<br>
-	  chip_ver[2]=0x04;<br>
-       }<br>
-       if ( pci_device_fn[2] &lt; pci_device_fn[0] )<br>
-       {<br>
-	  acard_pdev[1]=acard_pdev[0];<br>
-	  pci_bus[1]=pci_bus[0];<br>
-	  pci_device_fn[1]=pci_device_fn[0];<br>
-	  chip_ver[1]=chip_ver[0];<br>
-	  acard_pdev[0]=acard_pdev[2];<br>
-	  pci_bus[0]=pci_bus[2];<br>
-	  pci_device_fn[0]=pci_device_fn[2];<br>
-	  chip_ver[0]=chip_ver[2];<br>
-       }<br>
-       else if ( pci_device_fn[2] &lt; pci_device_fn[1] )<br>
-       {<br>
-	  acard_pdev[1]=acard_pdev[2];<br>
-	  pci_bus[1]=pci_bus[2];<br>
-	  pci_device_fn[1]=pci_device_fn[2];<br>
-	  chip_ver[1]=chip_ver[2];<br>
-       }<br>
-nxt_devfn:<br>
-       index++;<br>
-       if ( index &gt; 3 )<br>
-       {<br>
-	  index=0;<br>
-	  h++;<br>
-       }<br>
-    }<br>
-    for ( h=0; h &lt; 2; h++ )<br>
-    {<br>
-    if ( pci_device_fn[h] == 0xff )<br>
-    {<br>
-       return count;<br>
-    }<br>
-<br>
-    pdev = acard_pdev[h];<br>
-    pdev-&gt;devfn = pci_device_fn[h];<br>
-    pdev-&gt;bus-&gt;number = pci_bus[h];<br>
-<br>
-    /* Found an atp870u/w. */<br>
-    error = pci_read_config_dword(pdev,0x10,&amp;base_io);<br>
-    error += pci_read_config_byte(pdev,0x3c,&amp;irq);<br>
-    error += pci_read_config_byte(pdev,0x49,&amp;host_id);<br>
-<br>
-    base_io &amp;= 0xfffffff8;<br>
-    printk("   ACARD AEC-671X PCI Ultra/W SCSI-3 Host Adapter: %d    IO:%x, IRQ:%d.\n"<br>
-			     ,h,base_io,irq);<br>
-    ioportu[h]=base_io;<br>
-    pciportu[h]=base_io + 0x20;<br>
-    irqnumu[h]=irq;<br>
-    host_id &amp;= 0x07;<br>
-    host_idu[h]=host_id;<br>
-    chip_veru[h]=chip_ver[h];<br>
-<br>
-    tmport=base_io+0x22;<br>
-    scam_on[h]=inb(tmport);<br>
-    tmport += 0x0b;<br>
-    global_map[h]=inb(tmport++);<br>
-    ultra_map[h]=inw(tmport);<br>
-    if ( ultra_map[h] == 0 )<br>
-    {<br>
-       scam_on[h]=0x00;<br>
-       global_map[h]=0x20;<br>
-       ultra_map[h]=0xffff;<br>
-    }<br>
-<br>
-    shpnt = scsi_register(tpnt,4);<br>
-<br>
-    save_flags(flags);<br>
-    cli();<br>
-    if (request_irq(irq,atp870u_intr_handle, 0, "atp870u", NULL))<br>
-    {<br>
-       printk("Unable to allocate IRQ for Acard controller.\n");<br>
-       goto unregister;<br>
-    }<br>
-<br>
-    tmport=base_io+0x3a;<br>
-    k=(inb(tmport) &amp; 0xf3) | 0x10;<br>
-    outb(k,tmport);<br>
-    outb((k &amp; 0xdf),tmport);<br>
-    mydlyu(0x8000);<br>
-    outb(k,tmport);<br>
-    mydlyu(0x8000);<br>
-    tmport=base_io;<br>
-    outb((host_id | 0x08),tmport);<br>
-    tmport += 0x18;<br>
-    outb(0,tmport);<br>
-    tmport += 0x07;<br>
-    while ((inb(tmport) &amp; 0x80) == 0);<br>
-    tmport -= 0x08;<br>
-    inb(tmport);<br>
-    tmport = base_io +1;<br>
-    outb(8,tmport++);<br>
-    outb(0x7f,tmport);<br>
-    tmport = base_io + 0x11;<br>
-    outb(0x20,tmport);<br>
-<br>
-    tscam(h);<br>
-    is870(h,base_io);<br>
-    tmport=base_io+0x3a;<br>
-    outb((inb(tmport) &amp; 0xef),tmport);<br>
-<br>
-    atp_host[h] = shpnt;<br>
-    if ( chip_ver[h] == 4 )<br>
-    {<br>
-       shpnt-&gt;max_id = 16;<br>
-    }<br>
-    shpnt-&gt;this_id = host_id;<br>
-    shpnt-&gt;unique_id = base_io;<br>
-    shpnt-&gt;io_port = base_io;<br>
-    shpnt-&gt;n_io_port = 0x40;  /* Number of bytes of I/O space used */<br>
-    shpnt-&gt;irq = irq;<br>
-    restore_flags(flags);<br>
-    request_region(base_io, 0x40,"atp870u");  /* Register the IO ports that we use */<br>
-    count++;<br>
-    index++;<br>
-    continue;<br>
+	unsigned char irq, h, k;<br>
+	unsigned long flags;<br>
+	unsigned int base_io, error, tmport;<br>
+	unsigned short index = 0;<br>
+	unsigned char pci_bus[3], pci_device_fn[3], chip_ver[3], host_id;<br>
+	struct Scsi_Host *shpnt = NULL;<br>
+	int count = 0;<br>
+	static unsigned short devid[7] =<br>
+	{0x8002, 0x8010, 0x8020, 0x8030, 0x8040, 0x8050, 0};<br>
+	static struct pci_dev *pdev = NULL, *acard_pdev[3];<br>
+<br>
+	printk("aec671x_detect: \n");<br>
+	if (!pci_present()) {<br>
+		printk("   NO BIOS32 SUPPORT.\n");<br>
+		return count;<br>
+	}<br>
+	tpnt-&gt;proc_dir = &amp;proc_scsi_atp870u;<br>
+<br>
+	for (h = 0; h &lt; 2; h++) {<br>
+		active_idu[h] = 0;<br>
+		wide_idu[h] = 0;<br>
+		host_idu[h] = 0x07;<br>
+		quhdu[h] = 0;<br>
+		quendu[h] = 0;<br>
+		pci_bus[h] = 0;<br>
+		pci_device_fn[h] = 0xff;<br>
+		chip_ver[h] = 0;<br>
+		last_cmd[h] = 0xff;<br>
+		in_snd[h] = 0;<br>
+		in_int[h] = 0;<br>
+		for (k = 0; k &lt; qcnt; k++) {<br>
+			querequ[h][k] = 0;<br>
+		}<br>
+		for (k = 0; k &lt; 16; k++) {<br>
+			curr_req[h][k] = 0;<br>
+		}<br>
+	}<br>
+	h = 0;<br>
+	while (devid[h] != 0) {<br>
+		pdev = pci_find_device(0x1191, devid[h], pdev);<br>
+		if (pdev == NULL) {<br>
+			h++;<br>
+			index = 0;<br>
+			continue;<br>
+		}<br>
+		chip_ver[2] = 0;<br>
+<br>
+		/* To avoid messing with the things below...  */<br>
+		acard_pdev[2] = pdev;<br>
+		pci_device_fn[2] = pdev-&gt;devfn;<br>
+		pci_bus[2] = pdev-&gt;bus-&gt;number;<br>
+<br>
+		if (devid[h] == 0x8002) {<br>
+			error = pci_read_config_byte(pdev, 0x08, &amp;chip_ver[2]);<br>
+			if (chip_ver[2] &lt; 2) {<br>
+				goto nxt_devfn;<br>
+			}<br>
+		}<br>
+		if (devid[h] == 0x8010) {<br>
+			chip_ver[2] = 0x04;<br>
+		}<br>
+		if (pci_device_fn[2] &lt; pci_device_fn[0]) {<br>
+			acard_pdev[1] = acard_pdev[0];<br>
+			pci_bus[1] = pci_bus[0];<br>
+			pci_device_fn[1] = pci_device_fn[0];<br>
+			chip_ver[1] = chip_ver[0];<br>
+			acard_pdev[0] = acard_pdev[2];<br>
+			pci_bus[0] = pci_bus[2];<br>
+			pci_device_fn[0] = pci_device_fn[2];<br>
+			chip_ver[0] = chip_ver[2];<br>
+		} else if (pci_device_fn[2] &lt; pci_device_fn[1]) {<br>
+			acard_pdev[1] = acard_pdev[2];<br>
+			pci_bus[1] = pci_bus[2];<br>
+			pci_device_fn[1] = pci_device_fn[2];<br>
+			chip_ver[1] = chip_ver[2];<br>
+		}<br>
+	      nxt_devfn:<br>
+		index++;<br>
+		if (index &gt; 3) {<br>
+			index = 0;<br>
+			h++;<br>
+		}<br>
+	}<br>
+	for (h = 0; h &lt; 2; h++) {<br>
+		if (pci_device_fn[h] == 0xff) {<br>
+			return count;<br>
+		}<br>
+		pdev = acard_pdev[h];<br>
+		pdev-&gt;devfn = pci_device_fn[h];<br>
+		pdev-&gt;bus-&gt;number = pci_bus[h];<br>
+<br>
+		/* Found an atp870u/w. */<br>
+		error = pci_read_config_dword(pdev, 0x10, &amp;base_io);<br>
+		error += pci_read_config_byte(pdev, 0x3c, &amp;irq);<br>
+		error += pci_read_config_byte(pdev, 0x49, &amp;host_id);<br>
+<br>
+		base_io &amp;= 0xfffffff8;<br>
+		printk("   ACARD AEC-671X PCI Ultra/W SCSI-3 Host Adapter: %d    IO:%x, IRQ:%d.\n"<br>
+		       ,h, base_io, irq);<br>
+		ioportu[h] = base_io;<br>
+		pciportu[h] = base_io + 0x20;<br>
+		irqnumu[h] = irq;<br>
+		host_id &amp;= 0x07;<br>
+		host_idu[h] = host_id;<br>
+		chip_veru[h] = chip_ver[h];<br>
+<br>
+		tmport = base_io + 0x22;<br>
+		scam_on[h] = inb(tmport);<br>
+		tmport += 0x0b;<br>
+		global_map[h] = inb(tmport++);<br>
+		ultra_map[h] = inw(tmport);<br>
+		if (ultra_map[h] == 0) {<br>
+			scam_on[h] = 0x00;<br>
+			global_map[h] = 0x20;<br>
+			ultra_map[h] = 0xffff;<br>
+		}<br>
+		shpnt = scsi_register(tpnt, 4);<br>
+<br>
+		save_flags(flags);<br>
+		cli();<br>
+		if (request_irq(irq, atp870u_intr_handle, 0, "atp870u", NULL)) {<br>
+			printk("Unable to allocate IRQ for Acard controller.\n");<br>
+			goto unregister;<br>
+		}<br>
+		tmport = base_io + 0x3a;<br>
+		k = (inb(tmport) &amp; 0xf3) | 0x10;<br>
+		outb(k, tmport);<br>
+		outb((k &amp; 0xdf), tmport);<br>
+		mydlyu(0x8000);<br>
+		outb(k, tmport);<br>
+		mydlyu(0x8000);<br>
+		tmport = base_io;<br>
+		outb((host_id | 0x08), tmport);<br>
+		tmport += 0x18;<br>
+		outb(0, tmport);<br>
+		tmport += 0x07;<br>
+		while ((inb(tmport) &amp; 0x80) == 0);<br>
+		tmport -= 0x08;<br>
+		inb(tmport);<br>
+		tmport = base_io + 1;<br>
+		outb(8, tmport++);<br>
+		outb(0x7f, tmport);<br>
+		tmport = base_io + 0x11;<br>
+		outb(0x20, tmport);<br>
+<br>
+		tscam(h);<br>
+		is870(h, base_io);<br>
+		tmport = base_io + 0x3a;<br>
+		outb((inb(tmport) &amp; 0xef), tmport);<br>
+<br>
+		atp_host[h] = shpnt;<br>
+		if (chip_ver[h] == 4) {<br>
+			shpnt-&gt;max_id = 16;<br>
+		}<br>
+		shpnt-&gt;this_id = host_id;<br>
+		shpnt-&gt;unique_id = base_io;<br>
+		shpnt-&gt;io_port = base_io;<br>
+		shpnt-&gt;n_io_port = 0x40;	/* Number of bytes of I/O space used */<br>
+		shpnt-&gt;irq = irq;<br>
+		restore_flags(flags);<br>
+		request_region(base_io, 0x40, "atp870u");	/* Register the IO ports that we use */<br>
+		count++;<br>
+		index++;<br>
+		continue;<br>
 unregister:<br>
-    scsi_unregister(shpnt);<br>
-    restore_flags(flags);<br>
-    index++;<br>
-    continue;<br>
-    }<br>
+		scsi_unregister(shpnt);<br>
+		restore_flags(flags);<br>
+		index++;<br>
+		continue;<br>
+	}<br>
 <br>
-    return count;<br>
+	return count;<br>
 }<br>
 <br>
 /* The abort command does not leave the device in a clean state where<br>
@@ -1883,162 +1621,147 @@<br>
 <br>
 int atp870u_abort(Scsi_Cmnd * SCpnt)<br>
 {<br>
-    unsigned char h,j;<br>
-    unsigned int  tmport;<br>
+	unsigned char h, j;<br>
+	unsigned int tmport;<br>
 /*    printk(" atp870u_abort: \n");   */<br>
-    for ( h=0; h &lt;= admaxu; h++ )<br>
-    {<br>
-	if ( SCpnt-&gt;host == atp_host[h] )<br>
-	{<br>
-	   goto find_adp;<br>
+	for (h = 0; h &lt;= admaxu; h++) {<br>
+		if (SCpnt-&gt;host == atp_host[h]) {<br>
+			goto find_adp;<br>
+		}<br>
 	}<br>
-    }<br>
-    panic("Abort host not found !");<br>
+	panic("Abort host not found !");<br>
 find_adp:<br>
-    printk(" workingu=%x last_cmd=%x ",workingu[h],last_cmd[h]);<br>
-    printk(" quhdu=%x quendu=%x ",quhdu[h],quendu[h]);<br>
-    tmport=ioportu[h];<br>
-    for ( j=0; j &lt; 0x17; j++)<br>
-    {<br>
-	printk(" r%2x=%2x",j,inb(tmport++));<br>
-    }<br>
-    tmport += 0x05;<br>
-    printk(" r1c=%2x",inb(tmport));<br>
-    tmport += 0x03;<br>
-    printk(" r1f=%2x in_snd=%2x ",inb(tmport),in_snd[h]);<br>
-    tmport++;<br>
-    printk(" r20=%2x",inb(tmport));<br>
-    tmport += 0x02;<br>
-    printk(" r22=%2x \n",inb(tmport));<br>
-    return (SCSI_ABORT_SNOOZE);<br>
+	printk(" workingu=%x last_cmd=%x ", workingu[h], last_cmd[h]);<br>
+	printk(" quhdu=%x quendu=%x ", quhdu[h], quendu[h]);<br>
+	tmport = ioportu[h];<br>
+	for (j = 0; j &lt; 0x17; j++) {<br>
+		printk(" r%2x=%2x", j, inb(tmport++));<br>
+	}<br>
+	tmport += 0x05;<br>
+	printk(" r1c=%2x", inb(tmport));<br>
+	tmport += 0x03;<br>
+	printk(" r1f=%2x in_snd=%2x ", inb(tmport), in_snd[h]);<br>
+	tmport++;<br>
+	printk(" r20=%2x", inb(tmport));<br>
+	tmport += 0x02;<br>
+	printk(" r22=%2x \n", inb(tmport));<br>
+	return (SCSI_ABORT_SNOOZE);<br>
 }<br>
 <br>
 int atp870u_reset(Scsi_Cmnd * SCpnt, unsigned int reset_flags)<br>
 {<br>
-    unsigned char h;<br>
-    /*<br>
-     * See if a bus reset was suggested.<br>
-     */<br>
-/*    printk("atp870u_reset: \n");    */<br>
-    for( h=0; h &lt;= admaxu; h++ )<br>
-    {<br>
-       if ( SCpnt-&gt;host == atp_host[h] )<br>
-       {<br>
-	  goto find_host;<br>
-       }<br>
-    }<br>
-    panic("Reset bus host not found !");<br>
+	unsigned char h;<br>
+	/*<br>
+	 * See if a bus reset was suggested.<br>
+	 */<br>
+/*	printk("atp870u_reset: \n");    */<br>
+	for (h = 0; h &lt;= admaxu; h++) {<br>
+		if (SCpnt-&gt;host == atp_host[h]) {<br>
+			goto find_host;<br>
+		}<br>
+	}<br>
+	panic("Reset bus host not found !");<br>
 find_host:<br>
-/*    SCpnt-&gt;result = 0x00080000;<br>
-    SCpnt-&gt;scsi_done(SCpnt);<br>
-    workingu[h]=0;<br>
-    quhdu[h]=0;<br>
-    quendu[h]=0;<br>
-    return (SCSI_RESET_SUCCESS | SCSI_RESET_BUS_RESET);  */<br>
-    return (SCSI_RESET_SNOOZE);<br>
+/*      SCpnt-&gt;result = 0x00080000;<br>
+	SCpnt-&gt;scsi_done(SCpnt);<br>
+	workingu[h]=0;<br>
+	quhdu[h]=0;<br>
+	quendu[h]=0;<br>
+	return (SCSI_RESET_SUCCESS | SCSI_RESET_BUS_RESET);  */<br>
+	return (SCSI_RESET_SNOOZE);<br>
 }<br>
 <br>
-const char *<br>
-atp870u_info(struct Scsi_Host *notused)<br>
+const char *atp870u_info(struct Scsi_Host *notused)<br>
 {<br>
-  static char buffer[128];<br>
+	static char buffer[128];<br>
 <br>
-  strcpy(buffer, "ACARD AEC-6710/6712 PCI Ultra/W SCSI-3 Adapter Driver V1.0 ");<br>
+	strcpy(buffer, "ACARD AEC-6710/6712 PCI Ultra/W SCSI-3 Adapter Driver V1.0 ");<br>
 <br>
-  return buffer;<br>
+	return buffer;<br>
 }<br>
 <br>
-int<br>
-atp870u_set_info(char *buffer, int length, struct Scsi_Host *HBAptr)<br>
+int atp870u_set_info(char *buffer, int length, struct Scsi_Host *HBAptr)<br>
 {<br>
-  return (-ENOSYS);  /* Currently this is a no-op */<br>
+	return (-ENOSYS);	/* Currently this is a no-op */<br>
 }<br>
 <br>
 #define BLS buffer + len + size<br>
-int<br>
-atp870u_proc_info(char *buffer, char **start, off_t offset, int length,<br>
-    int hostno, int inout)<br>
+int atp870u_proc_info(char *buffer, char **start, off_t offset, int length,<br>
+		      int hostno, int inout)<br>
 {<br>
-  struct Scsi_Host *HBAptr;<br>
-  static u8 buff[512];<br>
-  int	i;<br>
-  int	size = 0;<br>
-  int	len = 0;<br>
-  off_t begin = 0;<br>
-  off_t pos = 0;<br>
-<br>
-  HBAptr = NULL;<br>
-  for (i = 0; i &lt; 2; i++)<br>
-  {<br>
-    if ((HBAptr = atp_host[i]) != NULL)<br>
-    {<br>
-      if (HBAptr-&gt;host_no == hostno)<br>
-      {<br>
-	break;<br>
-      }<br>
-      HBAptr = NULL;<br>
-    }<br>
-  }<br>
-<br>
-  if (HBAptr == NULL)<br>
-  {<br>
-    size += sprintf(BLS, "Can't find adapter for host number %d\n", hostno);<br>
-    len += size; pos = begin + len; size = 0;<br>
-    goto stop_output;<br>
-  }<br>
-<br>
-  if (inout == TRUE) /* Has data been written to the file? */<br>
-  {<br>
-    return (atp870u_set_info(buffer, length, HBAptr));<br>
-  }<br>
-<br>
-  if (offset == 0)<br>
-  {<br>
-    memset(buff, 0, sizeof(buff));<br>
-  }<br>
-<br>
-  size += sprintf(BLS, "ACARD AEC-671X Driver Version: 1.0\n");<br>
-  len += size; pos = begin + len; size = 0;<br>
-<br>
-  size += sprintf(BLS, "\n");<br>
-  size += sprintf(BLS, "Adapter Configuration:\n");<br>
-  size += sprintf(BLS, "               Base IO: %#.4lx\n", HBAptr-&gt;io_port);<br>
-  size += sprintf(BLS, "                   IRQ: %d\n", HBAptr-&gt;irq);<br>
-  len += size; pos = begin + len; size = 0;<br>
-<br>
-stop_output:<br>
-  *start = buffer + (offset - begin);	/* Start of wanted data */<br>
-  len -= (offset - begin);	/* Start slop */<br>
-  if (len &gt; length)<br>
-  {<br>
-    len = length;		/* Ending slop */<br>
-  }<br>
+	struct Scsi_Host *HBAptr;<br>
+	static u8 buff[512];<br>
+	int i;<br>
+	int size = 0;<br>
+	int len = 0;<br>
+	off_t begin = 0;<br>
+	off_t pos = 0;<br>
+<br>
+	HBAptr = NULL;<br>
+	for (i = 0; i &lt; 2; i++) {<br>
+		if ((HBAptr = atp_host[i]) != NULL) {<br>
+			if (HBAptr-&gt;host_no == hostno) {<br>
+				break;<br>
+			}<br>
+			HBAptr = NULL;<br>
+		}<br>
+	}<br>
 <br>
-  return (len);<br>
+	if (HBAptr == NULL) {<br>
+		size += sprintf(BLS, "Can't find adapter for host number %d\n", hostno);<br>
+		len += size;<br>
+		pos = begin + len;<br>
+		size = 0;<br>
+		goto stop_output;<br>
+	}<br>
+	if (inout == TRUE) {	/* Has data been written to the file? */<br>
+		return (atp870u_set_info(buffer, length, HBAptr));<br>
+	}<br>
+	if (offset == 0) {<br>
+		memset(buff, 0, sizeof(buff));<br>
+	}<br>
+	size += sprintf(BLS, "ACARD AEC-671X Driver Version: 1.0\n");<br>
+	len += size;<br>
+	pos = begin + len;<br>
+	size = 0;<br>
+<br>
+	size += sprintf(BLS, "\n");<br>
+	size += sprintf(BLS, "Adapter Configuration:\n");<br>
+	size += sprintf(BLS, "               Base IO: %#.4lx\n", HBAptr-&gt;io_port);<br>
+	size += sprintf(BLS, "                   IRQ: %d\n", HBAptr-&gt;irq);<br>
+	len += size;<br>
+	pos = begin + len;<br>
+	size = 0;<br>
+<br>
+      stop_output:<br>
+	*start = buffer + (offset - begin);	/* Start of wanted data */<br>
+	len -= (offset - begin);	/* Start slop */<br>
+	if (len &gt; length) {<br>
+		len = length;	/* Ending slop */<br>
+	}<br>
+	return (len);<br>
 }<br>
 <br>
 #include "sd.h"<br>
 <br>
-int atp870u_biosparam(Scsi_Disk * disk, kdev_t dev, int * ip)<br>
+int atp870u_biosparam(Scsi_Disk * disk, kdev_t dev, int *ip)<br>
 {<br>
-  int heads, sectors, cylinders;<br>
+	int heads, sectors, cylinders;<br>
 <br>
-  heads = 64;<br>
-  sectors = 32;<br>
-  cylinders = disk-&gt;capacity / (heads * sectors);<br>
-<br>
-  if ( cylinders &gt; 1024 )<br>
-  {<br>
-    heads = 255;<br>
-    sectors = 63;<br>
-    cylinders = disk-&gt;capacity / (heads * sectors);<br>
-  }<br>
-<br>
-  ip[0] = heads;<br>
-  ip[1] = sectors;<br>
-  ip[2] = cylinders;<br>
+	heads = 64;<br>
+	sectors = 32;<br>
+	cylinders = disk-&gt;capacity / (heads * sectors);<br>
+<br>
+	if (cylinders &gt; 1024) {<br>
+		heads = 255;<br>
+		sectors = 63;<br>
+		cylinders = disk-&gt;capacity / (heads * sectors);<br>
+	}<br>
+	ip[0] = heads;<br>
+	ip[1] = sectors;<br>
+	ip[2] = cylinders;<br>
 <br>
-  return 0;<br>
+	return 0;<br>
 }<br>
 <br>
 #ifdef MODULE<br>
@@ -2046,4 +1769,3 @@<br>
 <br>
 #include "scsi_module.c"<br>
 #endif<br>
-<br>
diff -u --new-file --recursive --exclude-from ../exclude linux.22p2/drivers/scsi/atp870u.h linux.ac/drivers/scsi/atp870u.h<br>
--- linux.22p2/drivers/scsi/atp870u.h	Fri Oct 15 02:44:00 1999<br>
+++ linux.ac/drivers/scsi/atp870u.h	Thu Oct 14 15:07:10 1999<br>
@@ -1,7 +1,7 @@<br>
 #ifndef _ATP870U_H<br>
 <br>
 /* $Id: atp870u.h,v 1.0 1997/05/07 15:09:00 root Exp root $<br>
- *<br>
+<br>
  * Header file for the ACARD 870U/W driver for Linux<br>
  *<br>
  * $Log: atp870u.h,v $<br>
@@ -20,10 +20,10 @@<br>
 <br>
 int atp870u_detect(Scsi_Host_Template *);<br>
 int atp870u_command(Scsi_Cmnd *);<br>
-int atp870u_queuecommand(Scsi_Cmnd *, void (*done)(Scsi_Cmnd *));<br>
+int atp870u_queuecommand(Scsi_Cmnd *, void (*done) (Scsi_Cmnd *));<br>
 int atp870u_abort(Scsi_Cmnd *);<br>
 int atp870u_reset(Scsi_Cmnd *, unsigned int);<br>
-int atp870u_biosparam(Disk *, kdev_t, int*);<br>
+int atp870u_biosparam(Disk *, kdev_t, int *);<br>
 void send_s870(unsigned char);<br>
 <br>
 #define qcnt            32<br>
@@ -31,7 +31,7 @@<br>
 #define ATP870U_CMDLUN 1<br>
 <br>
 #ifndef NULL<br>
-        #define NULL 0<br>
+#define NULL 0<br>
 #endif<br>
 <br>
 extern struct proc_dir_entry proc_scsi_atp870u;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0905.html">Dale Harris: "RNDGETPOOL ioctl wierdness"</a>
<li> <b>Previous message:</b> <a href="0903.html">Alan Cox: "Fixing the VIA rhine a bit"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
