<!-- received="Fri Oct 15 16:20:51 1999 EET DST" -->
<!-- sent="Fri, 15 Oct 1999 09:15:30 -0400 (EDT)" -->
<!-- name="Kelly STriker Price" -->
<!-- email="tygris@Glue.umd.edu" -->
<!-- subject="PATCH:  SysRq corrections on Intel Laptops [2.2.12]" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: PATCH:  SysRq corrections on Intel Laptops [2.2.12]</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PATCH:  SysRq corrections on Intel Laptops [2.2.12]</h1>
<b>Kelly STriker Price</b> (<a href="mailto:tygris@Glue.umd.edu"><i>tygris@Glue.umd.edu</i></a>)<br>
<i>Fri, 15 Oct 1999 09:15:30 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#968">[ date ]</a><a href="index.html#968">[ thread ]</a><a href="subject.html#968">[ subject ]</a><a href="author.html#968">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0969.html">Jones D: "RE: PATCH: (on Alpha) emulating missing instructions"</a>
<li> <b>Previous message:</b> <a href="0967.html">Alan Cox: "Re: PATCH: (on Alpha) emulating missing instructions"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Wheee, first patch for 2.2.12! :)<br>
<p>
Anyway, this patch for kernel 2.2.12 corrects a problem on some laptops<br>
which require a Fn key along with Alt to reach the SysRq key, which also<br>
activates the overlay keypad and changes all the keys around.<br>
<p>
This patch is baised off of a Compaq LTE Lite 4/25's laptop keyboard<br>
layout, so it might be off for slightly different configurations.  The<br>
keymap is:<br>
<p>
+--+--+--+--+<br>
<i>|7 |8 |9 |0 |   &lt;- Origonal key</i><br>
<i>| 7| 8|	9| *|  	&lt;- Fn+key mapping.  Patch corrects this.</i><br>
++-++-++-++-++ <br>
<i> |U |I |O |P | </i><br>
<i> | 4| 5| 6| -| </i><br>
 ++-++-++-++-++<br>
<i>  |J |K |L |; |</i><br>
<i>  | 1| 2| 3| +|</i><br>
+-++-++-++-++-++<br>
<i>|N |M |, |. |/ |</i><br>
<i>|  | 0|  |  |  |</i><br>
+--+--+--+--+--+<br>
<p>
It's complicates things a bit.  I bet if we just pass through the keycode<br>
through and totally ignore the keypad (doing the remapping back there in<br>
drives/char/sysrq.c), it would make for a simpler solution.<br>
<p>
p   |\      _,,,---,,_      Kelly "STrRedWolf" Price <br>
u   /,`.-'`'    -.  ;-;;,_  <a href="http://www.FurNation.com/STriker">http://www.FurNation.com/STriker</a><br>
r  |,4-  ) )-,_..;\ (  `'-' WolfSkunks for a better Linux Kernel<br>
r '---''(_/--'  `-'_)  fL  <br>
<p>
---PATCH---<br>
diff -r -u linux-2.2.12/Documentation/Configure.help linux-2.2.12kp1/Documentation/Configure.help<br>
--- linux-2.2.12/Documentation/Configure.help	Fri Aug 27 00:06:52 1999<br>
+++ linux-2.2.12kp1/Documentation/Configure.help	Sat Sep 18 13:54:43 1999<br>
@@ -9896,6 +9896,15 @@<br>
   keys are documented in Documentation/sysrq.txt. Don't say Y unless<br>
   you really know what this hack does.<br>
 <br>
+Corrective Screwy Laptop Keyboard support<br>
+CONFIG_SYSRQ_SCREWY<br>
+  If you change loglevels when you try to magically unmount your system<br>
+  (most likely a laptop), say "Y" here.  This will recognize that you<br>
+  need to hit a Fn key (unlike F1-F12) just to activate SysRq -- which<br>
+  in turn changes half the keyboard to a keypad (which is bad).  The<br>
+  mapping used in this one is from a Compaq LTE Lite 4/25's keyboard.<br>
+  You should check Documentation/sysrq.txt for more information.<br>
+<br>
 ISDN subsystem<br>
 CONFIG_ISDN<br>
   CAUTION: the ISDN driver shipped with this kernel distribution<br>
diff -r -u linux-2.2.12/Documentation/sysrq.txt linux-2.2.12kp1/Documentation/sysrq.txt<br>
--- linux-2.2.12/Documentation/sysrq.txt	Fri Aug 27 00:06:52 1999<br>
+++ linux-2.2.12kp1/Documentation/sysrq.txt	Sat Sep 18 14:09:11 1999<br>
@@ -19,6 +19,11 @@<br>
            (older?) may not have a key labeled 'SysRQ'. The 'SysRQ' key is<br>
            also known as the 'Print Screen' key.<br>
 <br>
+	   Some keyboars, expecally laptops, require you also use a "Fn" key<br>
+	   to activate the SysRQ key.  This also has a side effect of<br>
+	   remapping half the keyboard for a keypad, which is bad.  See<br>
+	   below for some information about how to correct this.<br>
+<br>
 On SPARC - You press 'ALT-STOP-&lt;command key&gt;', I believe.<br>
 <br>
 On PowerPC - You press 'ALT-Print Screen-&lt;command key&gt;'.<br>
@@ -106,6 +111,31 @@<br>
 '#define SYSRQ_KEY 0x54' in [/usr/src/linux/]include/asm/keyboard.h to<br>
 the keycode of the key you wish to use, then recompile. Oh, and by the way,<br>
 you exit 'showkey' by not typing anything for ten seconds.<br>
+<br>
+*  I try to unmount, but I get a log level change instead on my laptop.<br>
+~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~<br>
+[Kelly Price &lt;<a href="mailto:tygris@glue.umd.edu">tygris@glue.umd.edu</a>&gt; writes]  Same here, expecially on my<br>
+Compaq LTE Lite 4/25 laptop.  So I wrote up a patch about it.  Say "Y" to<br>
+CONFIG_SYSRQ_SCREWY, which activates the hack ontop of a hack, and<br>
+accomidates for this behavor.<br>
+<br>
+/* <br>
+ * Somehow, especially with laptops, the entire right hand side where the<br>
+ * numeric keypad is overlaid onto is made into the keypad when you hit<br>
+ * SysRq (On mine it's Fn-Alt-SysRq).  Try to remount your HD and you<br>
+ * change levels instead.  GGGGRRRRR!!!!<br>
+ *<br>
+ * Origionally I wanted to remap all over the place, but that makes things<br>
+ * messy. Lets try to see if it's remapping to the numeric keypad, which has<br>
+ * a different keycode.  If it is, we can thrap it back to what's expected<br>
+ * and don't have to mess with the case statements at all.  *JOY!*  Oh, BTW,<br>
+ * it doesn't affect the normal 0-9 keys.<br>
+ * --Kelly<br>
+ */<br>
+<br>
+[Kelly] A more elegant hack would be to pass the keycode to handle_sysrq<br>
+instead of the translated key and then, depending on the laptop's layout, do<br>
+the key translation there.<br>
 <br>
 *  I have more questions, who can I ask?<br>
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~<br>
diff -r -u linux-2.2.12/arch/i386/config.in linux-2.2.12kp1/arch/i386/config.in<br>
--- linux-2.2.12/arch/i386/config.in	Fri Aug 27 00:05:42 1999<br>
+++ linux-2.2.12kp1/arch/i386/config.in	Sat Sep 18 13:56:23 1999<br>
@@ -203,5 +203,8 @@<br>
 <br>
 #bool 'Debug kmalloc/kfree' CONFIG_DEBUG_MALLOC<br>
 bool 'Magic SysRq key' CONFIG_MAGIC_SYSRQ<br>
+if [ "$CONFIG_MAGIC_SYSRQ" != "n" ]; then<br>
+  bool '  Corrective screwy laptop keyboard support' CONFIG_SYSRQ_SCREWY<br>
+fi<br>
 endmenu<br>
 <br>
diff -r -u linux-2.2.12/drivers/char/keyboard.c linux-2.2.12kp1/drivers/char/keyboard.c<br>
--- linux-2.2.12/drivers/char/keyboard.c	Fri Aug 27 00:05:51 1999<br>
+++ linux-2.2.12kp1/drivers/char/keyboard.c	Fri Sep 17 00:53:15 1999<br>
@@ -21,6 +21,7 @@<br>
  *<br>
  * 27-05-97: Added support for the Magic SysRq Key (Martin Mares)<br>
  * 30-07-98: Dead keys redone, <a href="mailto:aeb@cwi.nl">aeb@cwi.nl</a>.<br>
+ * 14-09-99: Quick hack to fix bug w/Magic SysRq Key on laptops (Kelly Price)<br>
  */<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
@@ -249,7 +250,11 @@<br>
 		return;<br>
 	} else if (sysrq_pressed) {<br>
 		if (!up_flag &amp;&amp; sysrq_enabled)<br>
+#ifdef CONFIG_SYSRQ_SCREWY	/* Do additional hacking */<br>
+			handle_sysrq( (kbd_sysrq_xlate[keycode] | ((keycode &amp; 0x7f) &lt;&lt; 16)), kbd_pt_regs, kbd, tty);<br>
+#else		<br>
 			handle_sysrq(kbd_sysrq_xlate[keycode], kbd_pt_regs, kbd, tty);<br>
+#endif<br>
 		return;<br>
 	}<br>
 #endif<br>
diff -r -u linux-2.2.12/drivers/char/sysrq.c linux-2.2.12kp1/drivers/char/sysrq.c<br>
--- linux-2.2.12/drivers/char/sysrq.c	Fri Aug 27 00:05:52 1999<br>
+++ linux-2.2.12kp1/drivers/char/sysrq.c	Sat Sep 18 14:01:06 1999<br>
@@ -6,6 +6,8 @@<br>
  *<br>
  *	(c) 1997 Martin Mares &lt;<a href="mailto:mj@atrey.karlin.mff.cuni.cz">mj@atrey.karlin.mff.cuni.cz</a>&gt;<br>
  *	based on ideas by Pavel Machek &lt;<a href="mailto:pavel@atrey.karlin.mff.cuni.cz">pavel@atrey.karlin.mff.cuni.cz</a>&gt;<br>
+ *      Screwball Laptop Mapping (c) 1999 Kelly "STrRedWolf" Price<br>
+ *                                   &lt;<a href="mailto:tygris@erols.com">tygris@erols.com</a>&gt;<br>
  */<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
@@ -57,16 +59,72 @@<br>
  * and any other keycode arrives.<br>
  */<br>
 <br>
+/* <br>
+ * Somehow, especially with laptops, the entire right hand side where the<br>
+ * numeric keypad is overlaid onto is made into the keypad when you hit<br>
+ * SysRq (On mine it's Fn-Alt-SysRq).  Try to remount your HD and you<br>
+ * change levels instead.  GGGGRRRRR!!!!  <br>
+ *<br>
+ * Origionally I wanted to remap all over the place, but that makes things<br>
+ * messy. Lets try to see if it's remapping to the numeric keypad, which has<br>
+ * a different keycode.  If it is, we can thrap it back to what's expected<br>
+ * and don't have to mess with the case statements at all.  *JOY!*  Oh, BTW,<br>
+ * it doesn't affect the normal 0-9 keys. <br>
+ * --Kelly<br>
+ */<br>
+ <br>
+<br>
 void handle_sysrq(int key, struct pt_regs *pt_regs,<br>
 		  struct kbd_struct *kbd, struct tty_struct *tty)<br>
 {<br>
 	int orig_log_level = console_loglevel;<br>
+#ifdef CONFIG_SYSRQ_SCREWY<br>
+	int keycode;<br>
+<br>
+	/* I folded the keycode in on the higher 16 bits of key, so we'll<br>
+	 * have to unmunge it here. */<br>
+	keycode=(key &amp; 0x7f0000) &gt;&gt; 16;<br>
+<br>
+	/* Place this here so we won't forget it. */<br>
+	key=key &amp; 0xffff;<br>
+	<br>
+	/* Now this is as good as a place for any to check that keycode and<br>
+	 * fix that bug. */<br>
+	switch(keycode)<br>
+	{<br>
+	case 55:<br>
+		key='0'; break;<br>
+	case 74:<br>
+		key='p'; break;<br>
+	case 75:<br>
+		key='u'; break;<br>
+	case 76:<br>
+		key='i'; break;<br>
+	case 77:<br>
+		key='o'; break;<br>
+	case 78:<br>
+		key=';'; break;<br>
+	case 79:<br>
+		key='j'; break;<br>
+	case 80:<br>
+		key='k'; break;<br>
+	case 81:<br>
+		key='l'; break;<br>
+	case 82:<br>
+		key='m'; break;<br>
+	case 83:<br>
+		key='.'; break;<br>
+	}<br>
+	<br>
+	/* And we are done! */<br>
+#endif<br>
 <br>
 	if (!key)<br>
 		return;<br>
 <br>
 	console_loglevel = 7;<br>
 	printk(KERN_INFO "SysRq: ");<br>
+	<br>
 	switch (key) {<br>
 	case 'r':					    /* R -- Reset raw mode */<br>
 		if (kbd) {<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0969.html">Jones D: "RE: PATCH: (on Alpha) emulating missing instructions"</a>
<li> <b>Previous message:</b> <a href="0967.html">Alan Cox: "Re: PATCH: (on Alpha) emulating missing instructions"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
