<!-- received="Fri Oct 15 19:36:51 1999 EET DST" -->
<!-- sent="Fri, 15 Oct 1999 18:32:50 +0200" -->
<!-- name="Jamie Lokier" -->
<!-- email="lkd@tantalophile.demon.co.uk" -->
<!-- subject="[PATCH] start of d_type changes (was: How to extend struct stat?)" -->
<!-- id="" -->
<!-- inreplyto="no.id" -->
<title>Linux-kernel mailing list archive 1999-41,: [PATCH] start of d_type changes (was: How to extend struct stat?)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] start of d_type changes (was: How to extend struct stat?)</h1>
<b>Jamie Lokier</b> (<a href="mailto:lkd@tantalophile.demon.co.uk"><i>lkd@tantalophile.demon.co.uk</i></a>)<br>
<i>Fri, 15 Oct 1999 18:32:50 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1013">[ date ]</a><a href="index.html#1013">[ thread ]</a><a href="subject.html#1013">[ subject ]</a><a href="author.html#1013">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1014.html">Kanoj Sarcar: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Previous message:</b> <a href="1012.html">Guest section DW: "Re: Question about /proc/ide"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Folks,<br>
<p>
Here is a patch which changes the internel kernel API of f_op-&gt;readdir.<br>
It is the simple and obvious change: each filesystem passes an<br>
additional "unsigned char d_type" back to the filldir callback.<br>
In the absence of useful information, they can pass DT_UNKNOWN.<br>
<p>
Surprisingly many filesystems are able to pass useful information back.<br>
So this patch does that when it's simple to code.<br>
<p>
readdir is not the only thing which uses this callback, so the changes<br>
are a bit bigger than you'd think.  nfsd, umsdos and vfat needed minor<br>
changes.  The old struct dirent is also fixed in stone for some vfat and<br>
umsdos ioctls.  Binary compatibility is preserved.<br>
<p>
No system calls are provided yet, so the information is not available to<br>
user space.  Watch this space.<br>
<p>
There is one effect on user-space: &lt;linux/dirent.h&gt; is changed.  Samba<br>
and umsdos utils may need a #define to compile.  Binary compatibility is<br>
preserved, however.<br>
<p>
I've removed the definition of `struct dirent' from &lt;linux/dirent.h&gt;<br>
because it bore no relation to _either_ the getdents or readdir<br>
interface.  (They use private structures defined in fs/readdir.c, which<br>
are different to `struct dirent'!).  Take a look to see what's there<br>
instead.<br>
<p>
I haven't tested that the code works yet.  I'm waiting to add a new<br>
syscall.  It does, however, compile cleanly.<br>
<p>
Compiles ok<br>
-----------<br>
<p>
coda, minix, fat, msdos (no changes), vfat (no changes), isofs, hfs,<br>
nfs, nfsd, umsdos, sysv, smbfs, ncpfs, hpfs, ntfs, ufs, efs, affs, romfs<br>
qnx4, udf, adfs, ext2, proc, autofs, devpts<br>
<p>
Type info (without inode lookup)<br>
--------------------------------<br>
<p>
These all compile, but are not tested.  I cannot test most of them.  The<br>
changes are fairly trivial -- some things are complex like the isofs RR<br>
change but I can test that.<br>
<p>
adfs		[not done -- maybe possible]<br>
affs		[not done -- definitely possible]<br>
autofs		[not done -- maybe possible]<br>
coda		[done]<br>
devpts		[done]<br>
efs		[not possible]<br>
ext2		[done]<br>
fat		[done]<br>
hfs		[not done -- maybe possible]<br>
hpfs		[done -- directories and attributeless files only]<br>
isofs		[done including Rock Ridge]<br>
minix		[not possible]<br>
ncpfs		[partial -- does the other place need doing too?]<br>
nfs		[not possible with NFSv2]<br>
ntfs		[not done -- scary code]<br>
proc		[done except openpromfs -- help please]<br>
qnx4		[done]<br>
romfs		[done]<br>
smbfs		[not done -- maybe possible]<br>
sysv		[not possible]<br>
udf		[done -- directories only]<br>
ufs		[done]<br>
umsdos		[done]<br>
<p>
diff -u linux-2.3/fs/adfs/dir.c.d_type linux-2.3/fs/adfs/dir.c<br>
--- linux-2.3/fs/adfs/dir.c.d_type	Sat Sep  4 04:51:38 1999<br>
+++ linux-2.3/fs/adfs/dir.c	Thu Oct 14 23:58:42 1999<br>
@@ -9,6 +9,7 @@<br>
 #include &lt;linux/adfs_fs.h&gt;<br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 static ssize_t adfs_dirread (struct file *filp, char *buf,<br>
 			     size_t siz, loff_t *ppos)<br>
@@ -322,12 +323,13 @@<br>
 <br>
 	if (filp-&gt;f_pos &lt; 2) {<br>
 		if (filp-&gt;f_pos &lt; 1) {<br>
-			if (filldir (dirent, ".", 1, 0, inode-&gt;i_ino) &lt; 0)<br>
+			if (filldir (dirent, DT_DIR, ".", 1,<br>
+				     0, inode-&gt;i_ino) &lt; 0)<br>
 				return 0;<br>
 			filp-&gt;f_pos ++;<br>
 		}<br>
-		if (filldir (dirent, "..", 2, 1,<br>
-			     adfs_inode_generate (parent_object_id, 0)) &lt; 0)<br>
+		if (filldir (dirent, DT_DIR, "..", 2,<br>
+			     1, adfs_inode_generate (parent_object_id, 0)) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos ++;<br>
 	}<br>
@@ -339,7 +341,8 @@<br>
 		if (!adfs_dir_get (sb, bh, buffers, pos, dir_object_id, &amp;ide))<br>
 			break;<br>
 <br>
-		if (filldir (dirent, ide.name, ide.name_len, filp-&gt;f_pos, ide.inode_no) &lt; 0)<br>
+		if (filldir (dirent, DT_UNKNOWN, ide.name, ide.name_len,<br>
+			     filp-&gt;f_pos, ide.inode_no) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos ++;<br>
 		pos += 26;<br>
diff -u linux-2.3/fs/affs/dir.c.d_type linux-2.3/fs/affs/dir.c<br>
--- linux-2.3/fs/affs/dir.c.d_type	Sat Sep  4 04:51:38 1999<br>
+++ linux-2.3/fs/affs/dir.c	Thu Oct 14 23:59:49 1999<br>
@@ -23,6 +23,7 @@<br>
 #include &lt;linux/string.h&gt;<br>
 #include &lt;linux/mm.h&gt;<br>
 #include &lt;linux/amigaffs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 static int affs_readdir(struct file *, void *, filldir_t);<br>
 static ssize_t affs_dir_read(struct file *, char *, size_t, loff_t *);<br>
@@ -98,14 +99,14 @@<br>
 <br>
 	if (filp-&gt;f_pos == 0) {<br>
 		filp-&gt;private_data = (void *)0;<br>
-		if (filldir(dirent,".",1,filp-&gt;f_pos,inode-&gt;i_ino) &lt; 0) {<br>
+		if (filldir(dirent,DT_DIR,".",1,filp-&gt;f_pos,inode-&gt;i_ino) &lt; 0) {<br>
 			return 0;<br>
 		}<br>
 		++filp-&gt;f_pos;<br>
 		stored++;<br>
 	}<br>
 	if (filp-&gt;f_pos == 1) {<br>
-		if (filldir(dirent,"..",2,filp-&gt;f_pos,affs_parent_ino(inode)) &lt; 0) {<br>
+		if (filldir(dirent,DT_DIR,"..",2,filp-&gt;f_pos,affs_parent_ino(inode)) &lt; 0) {<br>
 			return stored;<br>
 		}<br>
 		filp-&gt;f_pos = 2;<br>
@@ -161,7 +162,7 @@<br>
 			pr_debug("AFFS: readdir(): filldir(\"%.*s\",ino=%lu), i=%d\n",<br>
 				 namelen,name,ino,i);<br>
 			filp-&gt;private_data = (void *)ino;<br>
-			if (filldir(dirent,name,namelen,filp-&gt;f_pos,ino) &lt; 0)<br>
+			if (filldir(dirent,DT_UNKNOWN,name,namelen,filp-&gt;f_pos,ino) &lt; 0)<br>
 				goto readdir_done;<br>
 			filp-&gt;private_data = (void *)i;<br>
 			affs_brelse(fh_bh);<br>
diff -u linux-2.3/fs/autofs/dir.c.d_type linux-2.3/fs/autofs/dir.c<br>
--- linux-2.3/fs/autofs/dir.c.d_type	Sat Sep  4 04:51:38 1999<br>
+++ linux-2.3/fs/autofs/dir.c	Fri Oct 15 00:01:08 1999<br>
@@ -11,6 +11,7 @@<br>
  * ------------------------------------------------------------------------- */<br>
 <br>
 #include "autofs_i.h"<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 static int autofs_dir_readdir(struct file *filp,<br>
 			       void *dirent, filldir_t filldir)<br>
@@ -20,12 +21,12 @@<br>
 	switch((unsigned long) filp-&gt;f_pos)<br>
 	{<br>
 	case 0:<br>
-		if (filldir(dirent, ".", 1, 0, inode-&gt;i_ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, ".", 1, 0, inode-&gt;i_ino) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos++;<br>
 		/* fall through */<br>
 	case 1:<br>
-		if (filldir(dirent, "..", 2, 1, AUTOFS_ROOT_INO) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, "..", 2, 1, AUTOFS_ROOT_INO) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos++;<br>
 		/* fall through */<br>
diff -u linux-2.3/fs/autofs/root.c.d_type linux-2.3/fs/autofs/root.c<br>
--- linux-2.3/fs/autofs/root.c.d_type	Sat Sep  4 04:51:38 1999<br>
+++ linux-2.3/fs/autofs/root.c	Fri Oct 15 04:08:31 1999<br>
@@ -14,6 +14,7 @@<br>
 #include &lt;linux/stat.h&gt;<br>
 #include &lt;linux/param.h&gt;<br>
 #include "autofs_i.h"<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 static int autofs_root_readdir(struct file *,void *,filldir_t);<br>
 static struct dentry *autofs_root_lookup(struct inode *,struct dentry *);<br>
@@ -79,19 +80,19 @@<br>
 	switch(nr)<br>
 	{<br>
 	case 0:<br>
-		if (filldir(dirent, ".", 1, nr, inode-&gt;i_ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, ".", 1, nr, inode-&gt;i_ino) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos = ++nr;<br>
 		/* fall through */<br>
 	case 1:<br>
-		if (filldir(dirent, "..", 2, nr, inode-&gt;i_ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, "..", 2, nr, inode-&gt;i_ino) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos = ++nr;<br>
 		/* fall through */<br>
 	default:<br>
 		while ( onr = nr, ent = autofs_hash_enum(dirhash,&amp;nr,ent) ) {<br>
 			if ( !ent-&gt;dentry || ent-&gt;dentry-&gt;d_mounts != ent-&gt;dentry ) {<br>
-				if (filldir(dirent,ent-&gt;name,ent-&gt;len,onr,ent-&gt;ino) &lt; 0)<br>
+				if (filldir(dirent,DT_UNKNOWN,ent-&gt;name,ent-&gt;len,onr,ent-&gt;ino) &lt; 0)<br>
 					return 0;<br>
 				filp-&gt;f_pos = nr;<br>
 			}<br>
diff -u linux-2.3/fs/coda/dir.c.d_type linux-2.3/fs/coda/dir.c<br>
--- linux-2.3/fs/coda/dir.c.d_type	Sat Sep  4 04:54:35 1999<br>
+++ linux-2.3/fs/coda/dir.c	Fri Oct 15 04:35:21 1999<br>
@@ -18,6 +18,7 @@<br>
 #include &lt;asm/segment.h&gt;<br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;linux/string.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;linux/coda.h&gt;<br>
 #include &lt;linux/coda_linux.h&gt;<br>
@@ -737,12 +738,14 @@<br>
 <br>
                 /* if we don't have a null entry, copy it */<br>
                 if ( vdirent-&gt;d_fileno &amp;&amp; vdirent-&gt;d_reclen ) {<br>
-                        int namlen  = vdirent-&gt;d_namlen;<br>
-                        off_t offs  = filp-&gt;f_pos; <br>
-                        ino_t ino   = vdirent-&gt;d_fileno;<br>
-                        char *name  = vdirent-&gt;d_name;<br>
+                        int namlen = vdirent-&gt;d_namlen;<br>
+                        off_t offs = filp-&gt;f_pos; <br>
+                        ino_t ino  = vdirent-&gt;d_fileno;<br>
+                        char *name = vdirent-&gt;d_name;<br>
+			/* CDT_* types are the same as DT_* types. */<br>
+			unsigned char type = vdirent-&gt;d_type;<br>
 <br>
-			errfill = filldir(getdent,  name, namlen, <br>
+			errfill = filldir(getdent, type, name, namlen, <br>
 					  offs, ino); <br>
 CDEBUG(D_FILE, "entry %d: ino %ld, namlen %d, reclen %d, type %d, pos %d, string_offs %d, name %*s, offset %d, result: %d, errfill: %d.\n", i,vdirent-&gt;d_fileno, vdirent-&gt;d_namlen, vdirent-&gt;d_reclen, vdirent-&gt;d_type, pos,  string_offset, vdirent-&gt;d_namlen, vdirent-&gt;d_name, (u_int) offs, result, errfill);<br>
 			/* errfill means no space for filling in this round */<br>
diff -u linux-2.3/fs/devpts/root.c.d_type linux-2.3/fs/devpts/root.c<br>
--- linux-2.3/fs/devpts/root.c.d_type	Sat Sep  4 04:55:26 1999<br>
+++ linux-2.3/fs/devpts/root.c	Fri Oct 15 00:12:44 1999<br>
@@ -14,6 +14,7 @@<br>
 #include &lt;linux/stat.h&gt;<br>
 #include &lt;linux/param.h&gt;<br>
 #include &lt;linux/string.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 #include "devpts_i.h"<br>
 <br>
 static int devpts_root_readdir(struct file *,void *,filldir_t);<br>
@@ -86,12 +87,12 @@<br>
 	switch(nr)<br>
 	{<br>
 	case 0:<br>
-		if (filldir(dirent, ".", 1, nr, inode-&gt;i_ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, ".", 1, nr, inode-&gt;i_ino) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos = ++nr;<br>
 		/* fall through */<br>
 	case 1:<br>
-		if (filldir(dirent, "..", 2, nr, inode-&gt;i_ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, "..", 2, nr, inode-&gt;i_ino) &lt; 0)<br>
 			return 0;<br>
 		filp-&gt;f_pos = ++nr;<br>
 		/* fall through */<br>
@@ -100,7 +101,7 @@<br>
 			int ptynr = nr - 2;<br>
 			if ( sbi-&gt;inodes[ptynr] ) {<br>
 				genptsname(numbuf, ptynr);<br>
-				if ( filldir(dirent, numbuf, strlen(numbuf), nr, nr) &lt; 0 )<br>
+				if ( filldir(dirent, DT_CHR, numbuf, strlen(numbuf), nr, nr) &lt; 0 )<br>
 					return 0;<br>
 			}<br>
 			filp-&gt;f_pos = ++nr;<br>
diff -u linux-2.3/fs/efs/dir.c.d_type linux-2.3/fs/efs/dir.c<br>
--- linux-2.3/fs/efs/dir.c.d_type	Sat Sep  4 04:51:38 1999<br>
+++ linux-2.3/fs/efs/dir.c	Fri Oct 15 00:15:49 1999<br>
@@ -5,6 +5,7 @@<br>
  */<br>
 <br>
 #include &lt;linux/efs_fs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 static int efs_readdir(struct file *, void *, filldir_t);<br>
 <br>
@@ -111,7 +112,7 @@<br>
 				filp-&gt;f_pos = (block &lt;&lt; EFS_DIRBSIZE_BITS) | slot;<br>
 <br>
 				/* copy filename and data in dirslot */<br>
-				filldir(dirent, nameptr, namelen, filp-&gt;f_pos, inodenum);<br>
+				filldir(dirent, DT_UNKNOWN, nameptr, namelen, filp-&gt;f_pos, inodenum);<br>
 <br>
 				/* sanity check */<br>
 				if (nameptr - (char *) dirblock + namelen &gt; EFS_DIRBSIZE) {<br>
diff -u linux-2.3/fs/ext2/dir.c.d_type linux-2.3/fs/ext2/dir.c<br>
--- linux-2.3/fs/ext2/dir.c.d_type	Sat Sep  4 04:51:38 1999<br>
+++ linux-2.3/fs/ext2/dir.c	Fri Oct 15 04:18:19 1999<br>
@@ -25,6 +25,7 @@<br>
 #include &lt;linux/ext2_fs.h&gt;<br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 static ssize_t ext2_dir_read (struct file * filp, char * buf,<br>
 			      size_t count, loff_t *ppos)<br>
@@ -105,6 +106,17 @@<br>
 	return error_msg == NULL ? 1 : 0;<br>
 }<br>
 <br>
+static char ext2_file_types [EXT2_FT_MAX] = {<br>
+	DT_UNKNOWN,	/* EXT2_FT_UNKNOWN  */<br>
+	DT_REG,		/* EXT2_FT_REG_FILE */<br>
+	DT_DIR,		/* EXT2_FT_DIR      */<br>
+	DT_CHR,		/* EXT2_FT_CHRDEV   */<br>
+	DT_BLK,		/* EXT2_FT_BLKDEV   */<br>
+	DT_FIFO,	/* EXT2_FT_FIFO     */<br>
+	DT_SOCK,	/* EXT2_FT_SOCK     */<br>
+	DT_LNK,		/* EXT2_FT_SYMLINK  */<br>
+};<br>
+<br>
 static int ext2_readdir(struct file * filp,<br>
 			 void * dirent, filldir_t filldir)<br>
 {<br>
@@ -200,9 +212,13 @@<br>
 				 * during the copy operation.<br>
 				 */<br>
 				unsigned long version = inode-&gt;i_version;<br>
+				unsigned char type = DT_UNKNOWN;<br>
+<br>
+				if (de-&gt;file_type &lt; EXT2_FT_MAX)<br>
+					type = ext2_file_types [de-&gt;file_type];<br>
 <br>
-				error = filldir(dirent, de-&gt;name,<br>
-						de-&gt;name_len,<br>
+				error = filldir(dirent, type,<br>
+						de-&gt;name, de-&gt;name_len,<br>
 						filp-&gt;f_pos, le32_to_cpu(de-&gt;inode));<br>
 				if (error)<br>
 					break;<br>
diff -u linux-2.3/fs/fat/dir.c.d_type linux-2.3/fs/fat/dir.c<br>
--- linux-2.3/fs/fat/dir.c.d_type	Sat Sep  4 04:53:18 1999<br>
+++ linux-2.3/fs/fat/dir.c	Fri Oct 15 05:27:17 1999<br>
@@ -297,12 +297,13 @@<br>
 	int dotoffset = 0;<br>
 	unsigned long *furrfu = &amp;lpos;<br>
 	unsigned long dummy;<br>
+	unsigned char type;<br>
 <br>
 	cpos = filp-&gt;f_pos;<br>
 /* Fake . and .. for the root directory. */<br>
 	if (inode-&gt;i_ino == MSDOS_ROOT_INO) {<br>
 		while (cpos &lt; 2) {<br>
-			if (filldir(dirent, "..", cpos+1, cpos, MSDOS_ROOT_INO) &lt; 0)<br>
+			if (filldir(dirent, DT_DIR, "..", cpos+1, cpos, MSDOS_ROOT_INO) &lt; 0)<br>
 				return 0;<br>
 			cpos++;<br>
 			filp-&gt;f_pos++;<br>
@@ -427,6 +428,10 @@<br>
 <br>
 	i = last + dotoffset;<br>
 <br>
+	type = DT_REG;<br>
+	if ((de-&gt;attr &amp; ATTR_DIR) &amp;&amp; !IS_FREE(de-&gt;name))<br>
+		type = DT_DIR;<br>
+<br>
 	lpos = cpos - (long_slots+1)*sizeof(struct msdos_dir_entry);<br>
 	if (!memcmp(de-&gt;name,MSDOS_DOT,11))<br>
 		inum = inode-&gt;i_ino;<br>
@@ -445,7 +450,7 @@<br>
 	if (!long_slots||shortnames) {<br>
 		if (both)<br>
 			bufname[i] = '\0';<br>
-		if (filldir(dirent, bufname, i, *furrfu, inum) &lt; 0)<br>
+		if (filldir(dirent, type, bufname, i, *furrfu, inum) &lt; 0)<br>
 			goto FillFailed;<br>
 	} else {<br>
 		char longname[275];<br>
@@ -456,7 +461,8 @@<br>
 			memcpy(&amp;longname[long_len+1], bufname, i);<br>
 			long_len += i;<br>
 		}<br>
-		if (filldir(dirent, longname, long_len, *furrfu, inum) &lt; 0)<br>
+		if (filldir(dirent, type, longname, long_len,<br>
+			    *furrfu, inum) &lt; 0)<br>
 			goto FillFailed;<br>
 	}<br>
 <br>
@@ -483,13 +489,14 @@<br>
 <br>
 static int vfat_ioctl_fill(<br>
 	void * buf,<br>
+	unsigned char type,<br>
 	const char * name,<br>
 	int name_len,<br>
 	off_t offset,<br>
 	ino_t ino)<br>
 {<br>
-	struct dirent *d1 = (struct dirent *)buf;<br>
-	struct dirent *d2 = d1 + 1;<br>
+	struct getdents_dirent *d1 = (struct getdents_dirent *)buf;<br>
+	struct getdents_dirent *d2 = d1 + 1;<br>
 	int len, slen;<br>
 	int dotdir;<br>
 <br>
@@ -541,8 +548,9 @@<br>
 	 */<br>
 	switch (cmd) {<br>
 	case VFAT_IOCTL_READDIR_BOTH: {<br>
-		struct dirent *d1 = (struct dirent *)arg;<br>
-		err = verify_area(VERIFY_WRITE, d1, sizeof(struct dirent[2]));<br>
+		struct getdents_dirent *d1 = (struct getdents_dirent *)arg;<br>
+		err = verify_area(VERIFY_WRITE, d1,<br>
+				  sizeof(struct getdents_dirent[2]));<br>
 		if (err)<br>
 			return err;<br>
 		put_user(0, &amp;d1-&gt;d_reclen);<br>
@@ -550,9 +558,10 @@<br>
 				    vfat_ioctl_fill, 0, 1);<br>
 	}<br>
 	case VFAT_IOCTL_READDIR_SHORT: {<br>
-		struct dirent *d1 = (struct dirent *)arg;<br>
+		struct getdents_dirent *d1 = (struct getdents_dirent *) arg;<br>
 		put_user(0, &amp;d1-&gt;d_reclen);<br>
-		err = verify_area(VERIFY_WRITE, d1, sizeof(struct dirent[2]));<br>
+		err = verify_area(VERIFY_WRITE, d1,<br>
+				  sizeof(struct getdents_dirent[2]));<br>
 		if (err)<br>
 			return err;<br>
 		return fat_readdirx(inode,filp,(void *)arg,<br>
diff -u linux-2.3/fs/hfs/dir_cap.c.d_type linux-2.3/fs/hfs/dir_cap.c<br>
--- linux-2.3/fs/hfs/dir_cap.c.d_type	Sat Sep  4 04:51:39 1999<br>
+++ linux-2.3/fs/hfs/dir_cap.c	Fri Oct 15 00:34:59 1999<br>
@@ -24,6 +24,7 @@<br>
 #include &lt;linux/hfs_fs_sb.h&gt;<br>
 #include &lt;linux/hfs_fs_i.h&gt;<br>
 #include &lt;linux/hfs_fs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 /*================ Forward declarations ================*/<br>
 <br>
@@ -249,7 +250,7 @@<br>
 <br>
 	if (filp-&gt;f_pos == 0) {<br>
 		/* Entry 0 is for "." */<br>
-		if (filldir(dirent, DOT-&gt;Name, DOT_LEN, 0, dir-&gt;i_ino)) {<br>
+		if (filldir(dirent, DT_DIR, DOT-&gt;Name, DOT_LEN, 0, dir-&gt;i_ino)) {<br>
 			return 0;<br>
 		}<br>
 		filp-&gt;f_pos = 1;<br>
@@ -265,7 +266,7 @@<br>
 			cnid = entry-&gt;cnid;<br>
 		}<br>
 <br>
-		if (filldir(dirent, DOT_DOT-&gt;Name,<br>
+		if (filldir(dirent, DT_DIR, DOT_DOT-&gt;Name,<br>
 			    DOT_DOT_LEN, 1, ntohl(cnid))) {<br>
 			return 0;<br>
 		}<br>
@@ -292,7 +293,7 @@<br>
 				ino = ntohl(cnid) | HFS_I(dir)-&gt;file_type;<br>
 				len = hfs_namein(dir, tmp_name,<br>
 				    &amp;((struct hfs_cat_key *)brec.key)-&gt;CName);<br>
-				if (filldir(dirent, tmp_name, len,<br>
+				if (filldir(dirent, DT_UNKNOWN, tmp_name, len,<br>
 					    filp-&gt;f_pos, ino)) {<br>
 					hfs_cat_close(entry, &amp;brec);<br>
 					return 0;<br>
@@ -307,7 +308,7 @@<br>
 		if ((entry-&gt;cnid == htonl(HFS_ROOT_CNID)) &amp;&amp;<br>
 		    (type == HFS_CAP_NDIR)) {<br>
 			/* In root dir last-2 entry is for ".rootinfo" */<br>
-			if (filldir(dirent, DOT_ROOTINFO-&gt;Name,<br>
+			if (filldir(dirent, DT_UNKNOWN, DOT_ROOTINFO-&gt;Name,<br>
 				    DOT_ROOTINFO_LEN, filp-&gt;f_pos,<br>
 				    ntohl(entry-&gt;cnid) | HFS_CAP_FNDR)) {<br>
 				return 0;<br>
@@ -319,7 +320,7 @@<br>
 	if (filp-&gt;f_pos == (dir-&gt;i_size - 2)) {<br>
 		if (type == HFS_CAP_NDIR) {<br>
 			/* In normal dirs last-1 entry is for ".finderinfo" */<br>
-			if (filldir(dirent, DOT_FINDERINFO-&gt;Name,<br>
+			if (filldir(dirent, DT_UNKNOWN, DOT_FINDERINFO-&gt;Name,<br>
 				    DOT_FINDERINFO_LEN, filp-&gt;f_pos,<br>
 				    ntohl(entry-&gt;cnid) | HFS_CAP_FDIR)) {<br>
 				return 0;<br>
@@ -331,7 +332,7 @@<br>
 	if (filp-&gt;f_pos == (dir-&gt;i_size - 1)) {<br>
 		if (type == HFS_CAP_NDIR) {<br>
 			/* In normal dirs last entry is for ".resource" */<br>
-			if (filldir(dirent, DOT_RESOURCE-&gt;Name,<br>
+			if (filldir(dirent, DT_UNKNOWN, DOT_RESOURCE-&gt;Name,<br>
 				    DOT_RESOURCE_LEN, filp-&gt;f_pos,<br>
 				    ntohl(entry-&gt;cnid) | HFS_CAP_RDIR)) {<br>
 				return 0;<br>
diff -u linux-2.3/fs/hfs/dir_dbl.c.d_type linux-2.3/fs/hfs/dir_dbl.c<br>
--- linux-2.3/fs/hfs/dir_dbl.c.d_type	Sat Sep  4 04:51:39 1999<br>
+++ linux-2.3/fs/hfs/dir_dbl.c	Fri Oct 15 00:35:57 1999<br>
@@ -20,6 +20,7 @@<br>
 #include &lt;linux/hfs_fs_sb.h&gt;<br>
 #include &lt;linux/hfs_fs_i.h&gt;<br>
 #include &lt;linux/hfs_fs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 /*================ Forward declarations ================*/<br>
 <br>
@@ -207,7 +208,7 @@<br>
 <br>
 	if (filp-&gt;f_pos == 0) {<br>
 		/* Entry 0 is for "." */<br>
-		if (filldir(dirent, DOT-&gt;Name, DOT_LEN, 0, dir-&gt;i_ino)) {<br>
+		if (filldir(dirent, DT_DIR, DOT-&gt;Name, DOT_LEN, 0, dir-&gt;i_ino)) {<br>
 			return 0;<br>
 		}<br>
 		filp-&gt;f_pos = 1;<br>
@@ -215,7 +216,7 @@<br>
 <br>
 	if (filp-&gt;f_pos == 1) {<br>
 		/* Entry 1 is for ".." */<br>
-		if (filldir(dirent, DOT_DOT-&gt;Name, DOT_DOT_LEN, 1,<br>
+		if (filldir(dirent, DT_DIR, DOT_DOT-&gt;Name, DOT_DOT_LEN, 1,<br>
 			    hfs_get_hl(entry-&gt;key.ParID))) {<br>
 			return 0;<br>
 		}<br>
@@ -253,7 +254,7 @@<br>
 				    &amp;((struct hfs_cat_key *)brec.key)-&gt;CName);<br>
 			}<br>
 <br>
-			if (filldir(dirent, tmp_name, len, filp-&gt;f_pos, ino)) {<br>
+			if (filldir(dirent, DT_UNKNOWN, tmp_name, len, filp-&gt;f_pos, ino)) {<br>
 				hfs_cat_close(entry, &amp;brec);<br>
 				return 0;<br>
 			}<br>
@@ -265,7 +266,7 @@<br>
 	if (filp-&gt;f_pos == (dir-&gt;i_size - 1)) {<br>
 		if (entry-&gt;cnid == htonl(HFS_ROOT_CNID)) {<br>
 			/* In root dir last entry is for "%RootInfo" */<br>
-			if (filldir(dirent, PCNT_ROOTINFO-&gt;Name,<br>
+			if (filldir(dirent, DT_UNKNOWN, PCNT_ROOTINFO-&gt;Name,<br>
 				    PCNT_ROOTINFO_LEN, filp-&gt;f_pos,<br>
 				    ntohl(entry-&gt;cnid) | HFS_DBL_HDR)) {<br>
 				return 0;<br>
diff -u linux-2.3/fs/hfs/dir_nat.c.d_type linux-2.3/fs/hfs/dir_nat.c<br>
--- linux-2.3/fs/hfs/dir_nat.c.d_type	Sat Sep  4 04:51:39 1999<br>
+++ linux-2.3/fs/hfs/dir_nat.c	Fri Oct 15 04:21:20 1999<br>
@@ -26,6 +26,7 @@<br>
 #include &lt;linux/hfs_fs_sb.h&gt;<br>
 #include &lt;linux/hfs_fs_i.h&gt;<br>
 #include &lt;linux/hfs_fs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 /*================ Forward declarations ================*/<br>
 <br>
@@ -231,7 +232,8 @@<br>
 <br>
 	if (filp-&gt;f_pos == 0) {<br>
 		/* Entry 0 is for "." */<br>
-		if (filldir(dirent, DOT-&gt;Name, DOT_LEN, 0, dir-&gt;i_ino)) {<br>
+		if (filldir(dirent, DT_DIR, DOT-&gt;Name, DOT_LEN,<br>
+			    0, dir-&gt;i_ino)) {<br>
 			return 0;<br>
 		}<br>
 		filp-&gt;f_pos = 1;<br>
@@ -247,8 +249,8 @@<br>
 			cnid = entry-&gt;cnid;<br>
 		}<br>
 <br>
-		if (filldir(dirent, DOT_DOT-&gt;Name,<br>
-			    DOT_DOT_LEN, 1, ntohl(cnid))) {<br>
+		if (filldir(dirent, DT_DIR, DOT_DOT-&gt;Name, DOT_DOT_LEN,<br>
+			    1, ntohl(cnid))) {<br>
 			return 0;<br>
 		}<br>
 		filp-&gt;f_pos = 2;<br>
@@ -274,7 +276,7 @@<br>
 				ino = ntohl(cnid) | HFS_I(dir)-&gt;file_type;<br>
 				len = hfs_namein(dir, tmp_name,<br>
 				    &amp;((struct hfs_cat_key *)brec.key)-&gt;CName);<br>
-				if (filldir(dirent, tmp_name, len,<br>
+				if (filldir(dirent, DT_UNKNOWN, tmp_name, len,<br>
 					    filp-&gt;f_pos, ino)) {<br>
 					hfs_cat_close(entry, &amp;brec);<br>
 					return 0;<br>
@@ -288,14 +290,14 @@<br>
 	if (filp-&gt;f_pos == (dir-&gt;i_size - 2)) {<br>
 		if (type == HFS_NAT_NDIR) {<br>
 			/* In normal dirs entry 2 is for ".AppleDouble" */<br>
-			if (filldir(dirent, DOT_APPLEDOUBLE-&gt;Name,<br>
+			if (filldir(dirent, DT_DIR, DOT_APPLEDOUBLE-&gt;Name,<br>
 				    DOT_APPLEDOUBLE_LEN, filp-&gt;f_pos,<br>
 				    ntohl(entry-&gt;cnid) | HFS_NAT_HDIR)) {<br>
 				return 0;<br>
 			}<br>
 		} else if (type == HFS_NAT_HDIR) {<br>
 			/* In .AppleDouble entry 2 is for ".Parent" */<br>
-			if (filldir(dirent, DOT_PARENT-&gt;Name,<br>
+			if (filldir(dirent, DT_UNKNOWN, DOT_PARENT-&gt;Name,<br>
 				    DOT_PARENT_LEN, filp-&gt;f_pos,<br>
 				    ntohl(entry-&gt;cnid) | HFS_NAT_HDR)) {<br>
 				return 0;<br>
@@ -308,7 +310,7 @@<br>
 		/* handle ROOT/.AppleDouble/RootInfo as the last entry. */<br>
 		if ((entry-&gt;cnid == htonl(HFS_ROOT_CNID)) &amp;&amp;<br>
 		    (type == HFS_NAT_HDIR)) {<br>
-			if (filldir(dirent, ROOTINFO-&gt;Name,<br>
+			if (filldir(dirent, DT_UNKNOWN, ROOTINFO-&gt;Name,<br>
 				    ROOTINFO_LEN, filp-&gt;f_pos,<br>
 				    ntohl(entry-&gt;cnid) | HFS_NAT_HDR)) {<br>
 				return 0;<br>
diff -u linux-2.3/fs/hpfs/dir.c.d_type linux-2.3/fs/hpfs/dir.c<br>
--- linux-2.3/fs/hpfs/dir.c.d_type	Sat Sep  4 04:50:15 1999<br>
+++ linux-2.3/fs/hpfs/dir.c	Fri Oct 15 03:40:45 1999<br>
@@ -7,6 +7,7 @@<br>
  */<br>
 <br>
 #include "hpfs_fn.h"<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 int hpfs_dir_read(struct file *filp, char *name, size_t len, loff_t *loff)<br>
 {<br>
@@ -82,14 +83,14 @@<br>
 			return 0;<br>
 		}<br>
 		if (filp-&gt;f_pos == 0) {<br>
-			if (filldir(dirent, ".", 1, filp-&gt;f_pos, inode-&gt;i_ino) &lt; 0) {<br>
+			if (filldir(dirent, DT_DIR, ".", 1, filp-&gt;f_pos, inode-&gt;i_ino) &lt; 0) {<br>
 				hpfs_unlock_inode(inode);<br>
 				return 0;<br>
 			}<br>
 			filp-&gt;f_pos = -1;<br>
 		}<br>
 		if (filp-&gt;f_pos == -1) {<br>
-			if (filldir(dirent, "..", 2, filp-&gt;f_pos, inode-&gt;i_hpfs_parent_dir) &lt; 0) {<br>
+			if (filldir(dirent, DT_DIR, "..", 2, filp-&gt;f_pos, inode-&gt;i_hpfs_parent_dir) &lt; 0) {<br>
 				hpfs_unlock_inode(inode);<br>
 				return 0;<br>
 			}<br>
@@ -118,7 +119,10 @@<br>
 				goto again;<br>
 			}<br>
 			tempname = hpfs_translate_name(inode-&gt;i_sb, de-&gt;name, de-&gt;namelen, lc, de-&gt;not_8x3);<br>
-			if (filldir(dirent, tempname, de-&gt;namelen, old_pos, de-&gt;fnode) &lt; 0) {<br>
+			if (filldir(dirent, (de-&gt;directory ? DT_DIR<br>
+					     : !de-&gt;has_ea ? DT_REG<br>
+					     : DT_UNKNOWN),<br>
+				    tempname, de-&gt;namelen, old_pos, de-&gt;fnode) &lt; 0) {<br>
 				filp-&gt;f_pos = old_pos;<br>
 				if (tempname != (char *)de-&gt;name) kfree(tempname);<br>
 				hpfs_brelse4(&amp;qbh);<br>
diff -u linux-2.3/fs/isofs/dir.c.d_type linux-2.3/fs/isofs/dir.c<br>
--- linux-2.3/fs/isofs/dir.c.d_type	Sat Sep  4 04:51:39 1999<br>
+++ linux-2.3/fs/isofs/dir.c	Fri Oct 15 06:35:36 1999<br>
@@ -21,6 +21,7 @@<br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/locks.h&gt;<br>
 #include &lt;linux/config.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -139,6 +140,7 @@<br>
 	int first_de = 1;<br>
 	char *p = NULL;		/* Quiet GCC */<br>
 	struct iso_directory_record *de;<br>
+	unsigned char type;<br>
 <br>
  	if (filp-&gt;f_pos &gt;= inode-&gt;i_size)<br>
 		return 0;<br>
@@ -218,7 +220,7 @@<br>
 <br>
 		/* Handle the case of the '.' directory */<br>
 		if (de-&gt;name_len[0] == 1 &amp;&amp; de-&gt;name[0] == 0) {<br>
-			if (filldir(dirent, ".", 1, filp-&gt;f_pos, inode-&gt;i_ino) &lt; 0)<br>
+			if (filldir(dirent, DT_DIR, ".", 1, filp-&gt;f_pos, inode-&gt;i_ino) &lt; 0)<br>
 				break;<br>
 			filp-&gt;f_pos += de_len;<br>
 			continue;<br>
@@ -229,7 +231,7 @@<br>
 		/* Handle the case of the '..' directory */<br>
 		if (de-&gt;name_len[0] == 1 &amp;&amp; de-&gt;name[0] == 1) {<br>
 			inode_number = filp-&gt;f_dentry-&gt;d_parent-&gt;d_inode-&gt;i_ino;<br>
-			if (filldir(dirent, "..", 2, filp-&gt;f_pos, inode_number) &lt; 0)<br>
+			if (filldir(dirent, DT_DIR, "..", 2, filp-&gt;f_pos, inode_number) &lt; 0)<br>
 				break;<br>
 			filp-&gt;f_pos += de_len;<br>
 			continue;<br>
@@ -245,9 +247,12 @@<br>
 			}<br>
 		}<br>
 <br>
+		type = DT_DIR;<br>
+		if (!(de-&gt;flags[-high_sierra] &amp; 2))<br>
+			type = DT_REG;<br>
 		map = 1;<br>
 		if (inode-&gt;i_sb-&gt;u.isofs_sb.s_rock) {<br>
-			len = get_rock_ridge_filename(de, tmpname, inode);<br>
+			len = get_rock_ridge_filename(de, tmpname, inode, &amp;type);<br>
 			if (len != 0) {<br>
 				p = tmpname;<br>
 				map = 0;<br>
@@ -274,7 +279,7 @@<br>
 			}<br>
 		}<br>
 		if (len &gt; 0) {<br>
-			if (filldir(dirent, p, len, filp-&gt;f_pos, inode_number) &lt; 0)<br>
+			if (filldir(dirent, type, p, len, filp-&gt;f_pos, inode_number) &lt; 0)<br>
 				break;<br>
 		}<br>
 		filp-&gt;f_pos += de_len;<br>
diff -u linux-2.3/fs/isofs/namei.c.d_type linux-2.3/fs/isofs/namei.c<br>
--- linux-2.3/fs/isofs/namei.c.d_type	Mon May 10 23:14:28 1999<br>
+++ linux-2.3/fs/isofs/namei.c	Fri Oct 15 06:04:35 1999<br>
@@ -169,7 +169,7 @@<br>
 			}<br>
 		}<br>
 		if (dir-&gt;i_sb-&gt;u.isofs_sb.s_rock &amp;&amp;<br>
-		    ((i = get_rock_ridge_filename(de, page, dir)))) {<br>
+		    ((i = get_rock_ridge_filename(de, page, dir, 0)))) {<br>
 			dlen = i;<br>
 			dpnt = page;<br>
 #ifdef CONFIG_JOLIET<br>
diff -u linux-2.3/fs/isofs/rock.c.d_type linux-2.3/fs/isofs/rock.c<br>
--- linux-2.3/fs/isofs/rock.c.d_type	Sat Sep 26 01:27:13 1998<br>
+++ linux-2.3/fs/isofs/rock.c	Fri Oct 15 06:36:02 1999<br>
@@ -12,15 +12,16 @@<br>
 #include &lt;linux/string.h&gt;<br>
 #include &lt;linux/mm.h&gt;<br>
 #include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include "rock.h"<br>
 <br>
 /* These functions are designed to read the system areas of a directory record<br>
  * and extract relevant information.  There are different functions provided<br>
  * depending upon what information we need at the time.  One function fills<br>
- * out an inode structure, a second one extracts a filename, a third one<br>
- * returns a symbolic link name, and a fourth one returns the extent number<br>
- * for the file. */<br>
+ * out an inode structure, a second one extracts a filename and d_type value,<br>
+ * a third one returns a symbolic link name, and a fourth one returns the<br>
+ * extent number for the file. */<br>
 <br>
 #define SIG(A,B) ((A &lt;&lt; 8) | B)<br>
 <br>
@@ -151,7 +152,8 @@<br>
 }<br>
 <br>
 int get_rock_ridge_filename(struct iso_directory_record * de,<br>
-			    char * retname, struct inode * inode)<br>
+			    char * retname, struct inode * inode,<br>
+			    unsigned char * rettype)<br>
 {<br>
   int len;<br>
   unsigned char * chr;<br>
@@ -214,6 +216,26 @@<br>
 #endif<br>
 	if (buffer) kfree(buffer);<br>
 	return -1;<br>
+      case SIG('C','L'):<br>
+#ifdef DEBUG<br>
+	printk("RR: CL (%x)\n",inode-&gt;i_ino);<br>
+#endif<br>
+	/* Mode is set from relocated entry.  Don't look it up as that misses<br>
+	   the point of the DT_* optimisation. */<br>
+	if (rettype)<br>
+	  *rettype = DT_UNKNOWN;<br>
+	break;<br>
+      case SIG('P','X'):<br>
+	/* Merge mode with previous type byte.  It was either DT_DIR, DT_REG,<br>
+	   or set by a previous PX record (should never repeat but hey...).*/<br>
+	if (rettype) {<br>
+	  mode_t mode = isonum_733(rr-&gt;u.PX.mode);<br>
+	  if (!S_ISDIR(mode) &amp;&amp; *rettype == DT_REG)<br>
+	    *rettype = IFTODT(mode);<br>
+	  else if (*rettype != IFTODT(mode))<br>
+	    *rettype = DT_UNKNOWN;<br>
+	}<br>
+	break;<br>
       default:<br>
 	break;<br>
       }<br>
diff -u linux-2.3/fs/minix/dir.c.d_type linux-2.3/fs/minix/dir.c<br>
--- linux-2.3/fs/minix/dir.c.d_type	Sat Sep  4 04:51:39 1999<br>
+++ linux-2.3/fs/minix/dir.c	Fri Oct 15 00:51:42 1999<br>
@@ -11,6 +11,7 @@<br>
 #include &lt;linux/fs.h&gt;<br>
 #include &lt;linux/minix_fs.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -85,7 +86,7 @@<br>
 			de = (struct minix_dir_entry *) (offset + bh-&gt;b_data);<br>
 			if (de-&gt;inode) {<br>
 				int size = strnlen(de-&gt;name, info-&gt;s_namelen);<br>
-				if (filldir(dirent, de-&gt;name, size, filp-&gt;f_pos, de-&gt;inode) &lt; 0) {<br>
+				if (filldir(dirent, DT_UNKNOWN, de-&gt;name, size, filp-&gt;f_pos, de-&gt;inode) &lt; 0) {<br>
 					brelse(bh);<br>
 					return 0;<br>
 				}<br>
diff -u linux-2.3/fs/ncpfs/dir.c.d_type linux-2.3/fs/ncpfs/dir.c<br>
--- linux-2.3/fs/ncpfs/dir.c.d_type	Thu Oct 14 22:50:12 1999<br>
+++ linux-2.3/fs/ncpfs/dir.c	Fri Oct 15 01:12:07 1999<br>
@@ -21,6 +21,7 @@<br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/byteorder.h&gt;<br>
 #include &lt;linux/locks.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;linux/ncp_fs.h&gt;<br>
 <br>
@@ -392,12 +393,12 @@<br>
 <br>
 	result = 0;<br>
 	if (filp-&gt;f_pos == 0) {<br>
-		if (filldir(dirent, ".", 1, 0, inode-&gt;i_ino))<br>
+		if (filldir(dirent, DT_DIR, ".", 1, 0, inode-&gt;i_ino))<br>
 			goto finished;<br>
 		filp-&gt;f_pos = 1;<br>
 	}<br>
 	if (filp-&gt;f_pos == 1) {<br>
-		if (filldir(dirent, "..", 2, 1,<br>
+		if (filldir(dirent, DT_DIR, "..", 2, 1,<br>
 				dentry-&gt;d_parent-&gt;d_inode-&gt;i_ino))<br>
 			goto finished;<br>
 		filp-&gt;f_pos = 2;<br>
@@ -435,7 +436,7 @@<br>
 	if (!ino)<br>
 		ino = iunique(dentry-&gt;d_inode-&gt;i_sb, 2);<br>
 <br>
-	result = filldir(dirent, name, len, filp-&gt;f_pos, ino);<br>
+	result = filldir(dirent, DT_UNKNOWN, name, len, filp-&gt;f_pos, ino);<br>
 	if (!result)<br>
 		filp-&gt;f_pos += 1;<br>
 <br>
@@ -450,6 +451,7 @@<br>
 	struct inode *inode = dentry-&gt;d_inode;<br>
 	struct qstr qname;<br>
 	ino_t ino = 0;<br>
+	unsigned char type = DT_UNKNOWN;<br>
 	int result;<br>
 <br>
 	/* For getwd() we have to return the correct inode in d_ino if the<br>
@@ -490,8 +492,10 @@<br>
 			ncp_new_dentry(newdent);<br>
 		}<br>
 <br>
-		if (newdent-&gt;d_inode)<br>
+		if (newdent-&gt;d_inode) {<br>
 			ino = newdent-&gt;d_inode-&gt;i_ino;<br>
+			type = IFTODT (newdent-&gt;d_inode-&gt;i_mode);<br>
+		}<br>
 <br>
 		dput(newdent);<br>
 <br>
@@ -503,8 +507,8 @@<br>
 	if (!ino)<br>
 		ino = iunique(inode-&gt;i_sb, 2);<br>
 <br>
-	result = filldir(dirent, entry-&gt;i.entryName, entry-&gt;i.nameLen,<br>
-				filp-&gt;f_pos, ino);<br>
+	result = filldir(dirent, type, entry-&gt;i.entryName,<br>
+			 entry-&gt;i.nameLen, filp-&gt;f_pos, ino);<br>
 	if (!result)<br>
 		filp-&gt;f_pos += 1;<br>
 <br>
diff -u linux-2.3/fs/nfs/dir.c.d_type linux-2.3/fs/nfs/dir.c<br>
--- linux-2.3/fs/nfs/dir.c.d_type	Sat Sep  4 04:54:36 1999<br>
+++ linux-2.3/fs/nfs/dir.c	Fri Oct 15 01:14:24 1999<br>
@@ -30,6 +30,7 @@<br>
 #include &lt;linux/nfs_fs.h&gt;<br>
 #include &lt;linux/nfs.h&gt;<br>
 #include &lt;linux/pagemap.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/segment.h&gt;	/* for fs functions */<br>
 <br>
@@ -400,7 +401,7 @@<br>
 			continue;<br>
 <br>
 		cookie = this_cookie;<br>
-		if (filldir(dirent, name, len, cookie, fileid) &lt; 0)<br>
+		if (filldir(dirent, DT_UNKNOWN, name, len, cookie, fileid) &lt; 0)<br>
 			break;<br>
 	}<br>
 <br>
diff -u linux-2.3/fs/nfsd/nfs3xdr.c.d_type linux-2.3/fs/nfsd/nfs3xdr.c<br>
--- linux-2.3/fs/nfsd/nfs3xdr.c.d_type	Mon Apr  7 20:35:31 1997<br>
+++ linux-2.3/fs/nfsd/nfs3xdr.c	Fri Oct 15 06:54:44 1999<br>
@@ -635,7 +635,7 @@<br>
 <br>
 #define NFS3_ENTRYPLUS_BAGGAGE	((1 + 20 + 1 + NFS3_FHSIZE) &lt;&lt; 2)<br>
 int<br>
-nfs3svc_encode_entry(struct readdir_cd *cd, const char *name,<br>
+nfs3svc_encode_entry(struct readdir_cd *cd, unsigned char type, const char *name,<br>
 				int namlen, unsigned long offset, ino_t ino)<br>
 {<br>
 	u32		*p = cd-&gt;buffer;<br>
diff -u linux-2.3/fs/nfsd/nfsfh.c.d_type linux-2.3/fs/nfsd/nfsfh.c<br>
--- linux-2.3/fs/nfsd/nfsfh.c.d_type	Mon Oct 11 23:20:23 1999<br>
+++ linux-2.3/fs/nfsd/nfsfh.c	Fri Oct 15 07:03:56 1999<br>
@@ -292,8 +292,8 @@<br>
  * for the second entry (the parent inode) and the name matching<br>
  * the specified inode number.<br>
  */<br>
-static int filldir_one(void * __buf, const char * name, int len, <br>
-			off_t pos, ino_t ino)<br>
+static int filldir_one(void * __buf, unsigned char type,<br>
+			const char * name, int len, off_t pos, ino_t ino)<br>
 {<br>
 	struct nfsd_getdents_callback *buf = __buf;<br>
 	struct nfsd_dirent *dirent = buf-&gt;dirent;<br>
diff -u linux-2.3/fs/nfsd/nfsxdr.c.d_type linux-2.3/fs/nfsd/nfsxdr.c<br>
--- linux-2.3/fs/nfsd/nfsxdr.c.d_type	Wed Nov 26 22:08:38 1997<br>
+++ linux-2.3/fs/nfsd/nfsxdr.c	Fri Oct 15 06:55:15 1999<br>
@@ -423,7 +423,7 @@<br>
 }<br>
 <br>
 int<br>
-nfssvc_encode_entry(struct readdir_cd *cd, const char *name,<br>
+nfssvc_encode_entry(struct readdir_cd *cd, unsigned char type, const char *name,<br>
 					int namlen, off_t offset, ino_t ino)<br>
 {<br>
 	u32	*p = cd-&gt;buffer;<br>
diff -u linux-2.3/fs/ntfs/fs.c.d_type linux-2.3/fs/ntfs/fs.c<br>
--- linux-2.3/fs/ntfs/fs.c.d_type	Sat Sep  4 04:55:27 1999<br>
+++ linux-2.3/fs/ntfs/fs.c	Fri Oct 15 01:28:26 1999<br>
@@ -28,6 +28,7 @@<br>
 #include &lt;linux/nls.h&gt;<br>
 #include &lt;linux/locks.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 /* Forward declarations */<br>
 static struct inode_operations ntfs_dir_inode_operations;<br>
@@ -197,7 +198,7 @@<br>
 	ntfs_debug(DEBUG_OTHER, "readdir got %s,len %d\n",nf-&gt;name,nf-&gt;namelen);<br>
 	/* filldir expects an off_t rather than an loff_t.<br>
 	   Hope we don't have more than 65535 index records */<br>
-	error=nf-&gt;filldir(nf-&gt;dirent,nf-&gt;name,nf-&gt;namelen,<br>
+	error=nf-&gt;filldir(nf-&gt;dirent,DT_UNKNOWN,nf-&gt;name,nf-&gt;namelen,<br>
 			(nf-&gt;ph&lt;&lt;16)|nf-&gt;pl,inum);<br>
 	ntfs_free(nf-&gt;name);<br>
 	/* Linux filldir errors are negative, other errors positive */<br>
@@ -224,11 +225,11 @@<br>
 	if(cb.ph==0xFFFF){<br>
 		/* FIXME: Maybe we can return those with the previous call */<br>
 		switch(cb.pl){<br>
-		case 0: filldir(dirent,".",1,filp-&gt;f_pos,dir-&gt;i_ino);<br>
+		case 0: filldir(dirent,DT_DIR,".",1,filp-&gt;f_pos,dir-&gt;i_ino);<br>
 			filp-&gt;f_pos=0xFFFF0001;<br>
 			return 0;<br>
 			/* FIXME: parent directory */<br>
-		case 1: filldir(dirent,"..",2,filp-&gt;f_pos,0);<br>
+		case 1: filldir(dirent,DT_DIR,"..",2,filp-&gt;f_pos,0);<br>
 			filp-&gt;f_pos=0xFFFF0002;<br>
 			return 0;<br>
 		}<br>
diff -u linux-2.3/fs/proc/fd.c.d_type linux-2.3/fs/proc/fd.c<br>
--- linux-2.3/fs/proc/fd.c.d_type	Mon Oct 11 23:18:23 1999<br>
+++ linux-2.3/fs/proc/fd.c	Fri Oct 15 04:01:58 1999<br>
@@ -15,6 +15,7 @@<br>
 #include &lt;linux/file.h&gt;<br>
 #include &lt;linux/proc_fs.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -150,7 +151,7 @@<br>
 		ino = inode-&gt;i_ino;<br>
 		if (fd)<br>
 			ino = (ino &amp; 0xffff0000) | PROC_PID_INO;<br>
-		if (filldir(dirent, "..", fd+1, fd, ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, "..", fd+1, fd, ino) &lt; 0)<br>
 			goto out;<br>
 	}<br>
 <br>
@@ -178,7 +179,7 @@<br>
 		read_unlock(&amp;tasklist_lock);<br>
 <br>
 		ino = (pid &lt;&lt; 16) + PROC_PID_FD_DIR + fd;<br>
-		if (filldir(dirent, buf+j, NUMBUF-j, fd+2, ino) &lt; 0)<br>
+		if (filldir(dirent, DT_LNK, buf+j, NUMBUF-j, fd+2, ino) &lt; 0)<br>
 			goto out;<br>
 <br>
 		read_lock(&amp;tasklist_lock);<br>
diff -u linux-2.3/fs/proc/openpromfs.c.d_type linux-2.3/fs/proc/openpromfs.c<br>
--- linux-2.3/fs/proc/openpromfs.c.d_type	Sat Sep  4 04:55:28 1999<br>
+++ linux-2.3/fs/proc/openpromfs.c	Fri Oct 15 04:01:32 1999<br>
@@ -11,6 +11,7 @@<br>
 #include &lt;linux/fs.h&gt;<br>
 #include &lt;linux/proc_fs.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/openprom.h&gt;<br>
 #include &lt;asm/oplib.h&gt;<br>
@@ -855,12 +856,12 @@<br>
 	i = filp-&gt;f_pos;<br>
 	switch (i) {<br>
 	case 0:<br>
-		if (filldir(dirent, ".", 1, i, ino) &lt; 0) return 0;<br>
+		if (filldir(dirent, DT_DIR, ".", 1, i, ino) &lt; 0) return 0;<br>
 		i++;<br>
 		filp-&gt;f_pos++;<br>
 		/* fall thru */<br>
 	case 1:<br>
-		if (filldir(dirent, "..", 2, i, <br>
+		if (filldir(dirent, DT_DIR, "..", 2, i, <br>
 			(NODE(ino).parent == 0xffff) ? <br>
 			PROC_ROOT_INO : NODE2INO(NODE(ino).parent)) &lt; 0) <br>
 			return 0;<br>
@@ -877,7 +878,7 @@<br>
 		while (node != 0xffff) {<br>
 			if (prom_getname (nodes[node].node, buffer, 128) &lt; 0)<br>
 				return 0;<br>
-			if (filldir(dirent, buffer, strlen(buffer),<br>
+			if (filldir(dirent, DT_UNKNOWN, buffer, strlen(buffer),<br>
 				    filp-&gt;f_pos, NODE2INO(node)) &lt; 0)<br>
 				return 0;<br>
 			filp-&gt;f_pos++;<br>
@@ -885,7 +886,8 @@<br>
 		}<br>
 		j = NODEP2INO(NODE(ino).first_prop);<br>
 		if (!i) {<br>
-			if (filldir(dirent, ".node", 5, filp-&gt;f_pos, j) &lt; 0)<br>
+			if (filldir(dirent, DT_UNKNOWN, ".node", 5,<br>
+				    filp-&gt;f_pos, j) &lt; 0)<br>
 				return 0;<br>
 			filp-&gt;f_pos++;<br>
 		} else<br>
@@ -894,9 +896,11 @@<br>
 		if (ino == PROC_OPENPROM_FIRST + aliases) {<br>
 			for (j++; i &lt; aliases_nodes; i++, j++) {<br>
 				if (alias_names [i]) {<br>
-					if (filldir (dirent, alias_names [i], <br>
-						strlen (alias_names [i]), <br>
-						filp-&gt;f_pos, j) &lt; 0) return 0;<br>
+					if (filldir (dirent, DT_UNKNOWN,<br>
+						     alias_names [i], <br>
+						     strlen (alias_names [i]), <br>
+						     filp-&gt;f_pos, j) &lt; 0)<br>
+						return 0;<br>
 					filp-&gt;f_pos++;<br>
 				}<br>
 			}<br>
@@ -907,7 +911,8 @@<br>
 				j++;<br>
 				if (i) i--;<br>
 				else {<br>
-					if (filldir(dirent, p, strlen(p),<br>
+					if (filldir(dirent, DT_UNKNOWN,<br>
+						    p, strlen(p),<br>
 						    filp-&gt;f_pos, j) &lt; 0)<br>
 						return 0;<br>
 					filp-&gt;f_pos++;<br>
@@ -918,8 +923,8 @@<br>
 			if (d-&gt;node == n) {<br>
 				if (i) i--;<br>
 				else {<br>
-					if (filldir(dirent, d-&gt;name,<br>
-						    strlen(d-&gt;name),<br>
+					if (filldir(dirent, DT_UNKNOWN,<br>
+						    d-&gt;name, strlen(d-&gt;name),<br>
 						    filp-&gt;f_pos, d-&gt;inode) &lt; 0)<br>
 						return 0;<br>
 					filp-&gt;f_pos++;<br>
diff -u linux-2.3/fs/proc/root.c.d_type linux-2.3/fs/proc/root.c<br>
--- linux-2.3/fs/proc/root.c.d_type	Mon Oct  4 00:27:50 1999<br>
+++ linux-2.3/fs/proc/root.c	Fri Oct 15 04:04:43 1999<br>
@@ -14,6 +14,7 @@<br>
 #include &lt;linux/stat.h&gt;<br>
 #include &lt;linux/config.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 #include &lt;asm/bitops.h&gt;<br>
 #ifdef CONFIG_KMOD<br>
 #include &lt;linux/kmod.h&gt;<br>
@@ -944,13 +945,13 @@<br>
 	i = filp-&gt;f_pos;<br>
 	switch (i) {<br>
 		case 0:<br>
-			if (filldir(dirent, ".", 1, i, ino) &lt; 0)<br>
+			if (filldir(dirent, DT_DIR, ".", 1, i, ino) &lt; 0)<br>
 				return 0;<br>
 			i++;<br>
 			filp-&gt;f_pos++;<br>
 			/* fall through */<br>
 		case 1:<br>
-			if (filldir(dirent, "..", 2, i, de-&gt;parent-&gt;low_ino) &lt; 0)<br>
+			if (filldir(dirent, DT_DIR, "..", 2, i, de-&gt;parent-&gt;low_ino) &lt; 0)<br>
 				return 0;<br>
 			i++;<br>
 			filp-&gt;f_pos++;<br>
@@ -969,7 +970,7 @@<br>
 			}<br>
 <br>
 			do {<br>
-				if (filldir(dirent, de-&gt;name, de-&gt;namelen, filp-&gt;f_pos, ino | de-&gt;low_ino) &lt; 0)<br>
+				if (filldir(dirent, IFTODT (de-&gt;mode), de-&gt;name, de-&gt;namelen, filp-&gt;f_pos, ino | de-&gt;low_ino) &lt; 0)<br>
 					return 0;<br>
 				filp-&gt;f_pos++;<br>
 				de = de-&gt;next;<br>
@@ -1036,7 +1037,7 @@<br>
 			pid /= 10;<br>
 		} while (pid);<br>
 <br>
-		if (filldir(dirent, buf+j, PROC_NUMBUF-j, filp-&gt;f_pos, ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, buf+j, PROC_NUMBUF-j, filp-&gt;f_pos, ino) &lt; 0)<br>
 			break;<br>
 		filp-&gt;f_pos++;<br>
 	}<br>
diff -u linux-2.3/fs/qnx4/dir.c.d_type linux-2.3/fs/qnx4/dir.c<br>
--- linux-2.3/fs/qnx4/dir.c.d_type	Sat Sep  4 04:52:21 1999<br>
+++ linux-2.3/fs/qnx4/dir.c	Fri Oct 15 01:31:25 1999<br>
@@ -17,6 +17,7 @@<br>
 #include &lt;linux/fs.h&gt;<br>
 #include &lt;linux/qnx4_fs.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/segment.h&gt;<br>
 <br>
@@ -57,7 +58,7 @@<br>
 <br>
 				if ((de-&gt;di_mode) || (de-&gt;di_status == QNX4_FILE_LINK)) {<br>
 					if (de-&gt;di_status) {<br>
-						if (filldir(dirent, de-&gt;di_fname, size, filp-&gt;f_pos, de-&gt;di_first_xtnt.xtnt_blk) &lt; 0) {<br>
+						if (filldir(dirent, IFTODT (de-&gt;di_mode), de-&gt;di_fname, size, filp-&gt;f_pos, de-&gt;di_first_xtnt.xtnt_blk) &lt; 0) {<br>
 							brelse(bh);<br>
 							return 0;<br>
 						}<br>
diff -u linux-2.3/fs/readdir.c.d_type linux-2.3/fs/readdir.c<br>
--- linux-2.3/fs/readdir.c.d_type	Sat Sep  4 04:54:36 1999<br>
+++ linux-2.3/fs/readdir.c	Fri Oct 15 06:42:29 1999<br>
@@ -36,7 +36,7 @@<br>
 	int count;<br>
 };<br>
 <br>
-static int fillonedir(void * __buf, const char * name, int namlen, off_t offset, ino_t ino)<br>
+static int fillonedir(void * __buf, unsigned char type, const char * name, int namlen, off_t offset, ino_t ino)<br>
 {<br>
 	struct readdir_callback * buf = (struct readdir_callback *) __buf;<br>
 	struct old_linux_dirent * dirent;<br>
@@ -118,7 +118,7 @@<br>
 	int error;<br>
 };<br>
 <br>
-static int filldir(void * __buf, const char * name, int namlen, off_t offset, ino_t ino)<br>
+static int filldir(void * __buf, unsigned char type, const char * name, int namlen, off_t offset, ino_t ino)<br>
 {<br>
 	struct linux_dirent * dirent;<br>
 	struct getdents_callback * buf = (struct getdents_callback *) __buf;<br>
diff -u linux-2.3/fs/romfs/inode.c.d_type linux-2.3/fs/romfs/inode.c<br>
--- linux-2.3/fs/romfs/inode.c.d_type	Sat Sep  4 04:55:28 1999<br>
+++ linux-2.3/fs/romfs/inode.c	Fri Oct 15 04:45:14 1999<br>
@@ -58,6 +58,7 @@<br>
 #include &lt;linux/locks.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/smp_lock.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -258,6 +259,12 @@<br>
 	return res;<br>
 }<br>
 <br>
+static mode_t romfs_modemap[] =<br>
+{<br>
+	0, S_IFDIR+0644, S_IFREG+0644, S_IFLNK+0777,<br>
+	S_IFBLK+0600, S_IFCHR+0600, S_IFSOCK+0644, S_IFIFO+0644<br>
+};<br>
+<br>
 static int<br>
 romfs_readdir(struct file *filp, void *dirent, filldir_t filldir)<br>
 {<br>
@@ -265,6 +272,7 @@<br>
 	struct romfs_inode ri;<br>
 	unsigned long offset, maxoff;<br>
 	int j, ino, nextfh;<br>
+	unsigned char type;<br>
 	int stored = 0;<br>
 	char fsname[ROMFS_MAXFN];	/* XXX dynamic? */<br>
 <br>
@@ -302,7 +310,8 @@<br>
 		nextfh = ntohl(ri.next);<br>
 		if ((nextfh &amp; ROMFH_TYPE) == ROMFH_HRD)<br>
 			ino = ntohl(ri.spec);<br>
-		if (filldir(dirent, fsname, j, offset, ino) &lt; 0) {<br>
+		type = IFTODT (romfs_modemap [nextfh &amp; ROMFH_TYPE]);<br>
+		if (filldir(dirent, type, fsname, j, offset, ino) &lt; 0) {<br>
 			return stored;<br>
 		}<br>
 		stored++;<br>
@@ -596,12 +605,6 @@<br>
 	NULL,			/* permission */<br>
 	NULL,			/* smap */<br>
 	NULL			/* revalidate */<br>
-};<br>
-<br>
-static mode_t romfs_modemap[] =<br>
-{<br>
-	0, S_IFDIR+0644, S_IFREG+0644, S_IFLNK+0777,<br>
-	S_IFBLK+0600, S_IFCHR+0600, S_IFSOCK+0644, S_IFIFO+0644<br>
 };<br>
 <br>
 static struct inode_operations *romfs_inoops[] =<br>
diff -u linux-2.3/fs/smbfs/dir.c.d_type linux-2.3/fs/smbfs/dir.c<br>
--- linux-2.3/fs/smbfs/dir.c.d_type	Sat Sep  4 04:51:40 1999<br>
+++ linux-2.3/fs/smbfs/dir.c	Fri Oct 15 01:43:05 1999<br>
@@ -9,6 +9,7 @@<br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/errno.h&gt;<br>
 #include &lt;linux/kernel.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;linux/smb_fs.h&gt;<br>
 #include &lt;linux/smbno.h&gt;<br>
@@ -114,11 +115,11 @@<br>
 	switch ((unsigned int) filp-&gt;f_pos)<br>
 	{<br>
 	case 0:<br>
-		if (filldir(dirent, ".", 1, 0, dir-&gt;i_ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, ".", 1, 0, dir-&gt;i_ino) &lt; 0)<br>
 			goto out_free;<br>
 		filp-&gt;f_pos = 1;<br>
 	case 1:<br>
-		if (filldir(dirent, "..", 2, 1,<br>
+		if (filldir(dirent, DT_DIR, "..", 2, 1,<br>
 				dentry-&gt;d_parent-&gt;d_inode-&gt;i_ino) &lt; 0)<br>
 			goto out_free;<br>
 		filp-&gt;f_pos = 2;<br>
@@ -143,7 +144,7 @@<br>
 				entry-&gt;ino = smb_invent_inos(1);<br>
 		}<br>
 <br>
-		if (filldir(dirent, entry-&gt;name, entry-&gt;len, <br>
+		if (filldir(dirent, DT_UNKNOWN, entry-&gt;name, entry-&gt;len, <br>
 				    filp-&gt;f_pos, entry-&gt;ino) &lt; 0)<br>
 			break;<br>
 		filp-&gt;f_pos += 1;<br>
diff -u linux-2.3/fs/sysv/dir.c.d_type linux-2.3/fs/sysv/dir.c<br>
--- linux-2.3/fs/sysv/dir.c.d_type	Sat Sep  4 04:51:40 1999<br>
+++ linux-2.3/fs/sysv/dir.c	Fri Oct 15 01:44:07 1999<br>
@@ -18,6 +18,7 @@<br>
 #include &lt;linux/sysv_fs.h&gt;<br>
 #include &lt;linux/stat.h&gt;<br>
 #include &lt;linux/string.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -103,7 +104,7 @@<br>
 					       inode-&gt;i_ino, (off_t) filp-&gt;f_pos, sde.inode);<br>
 <br>
 				i = strnlen(sde.name, SYSV_NAMELEN);<br>
-				if (filldir(dirent, sde.name, i, filp-&gt;f_pos, sde.inode) &lt; 0) {<br>
+				if (filldir(dirent, DT_UNKNOWN, sde.name, i, filp-&gt;f_pos, sde.inode) &lt; 0) {<br>
 					brelse(bh);<br>
 					return 0;<br>
 				}<br>
diff -u linux-2.3/fs/udf/dir.c.d_type linux-2.3/fs/udf/dir.c<br>
--- linux-2.3/fs/udf/dir.c.d_type	Thu Sep  9 02:18:27 1999<br>
+++ linux-2.3/fs/udf/dir.c	Fri Oct 15 01:52:32 1999<br>
@@ -40,6 +40,7 @@<br>
 #include &lt;linux/mm.h&gt;<br>
 #include &lt;linux/malloc.h&gt;<br>
 #include &lt;linux/udf_fs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 #endif<br>
 <br>
 /* Prototypes for file operations */<br>
@@ -142,7 +143,7 @@<br>
 <br>
 	if ( filp-&gt;f_pos == 0 ) <br>
 	{<br>
-		if (filldir(dirent, ".", 1, filp-&gt;f_pos, dir-&gt;i_ino) &lt; 0)<br>
+		if (filldir(dirent, DT_DIR, ".", 1, filp-&gt;f_pos, dir-&gt;i_ino) &lt; 0)<br>
 			return 0;<br>
 	}<br>
  <br>
@@ -159,6 +160,7 @@<br>
 	struct FileIdentDesc cfi;<br>
 	int block, iblock;<br>
 	int nf_pos = filp-&gt;f_pos;<br>
+	unsigned char ftype;<br>
 	int flen;<br>
 	char fname[255];<br>
 	char *nameptr;<br>
@@ -249,11 +251,15 @@<br>
 				continue;<br>
 		}<br>
 <br>
+		ftype = DT_DIR;<br>
+		if ( (cfi.fileCharacteristics &amp; FILE_DIRECTORY) == 0 )<br>
+			ftype = DT_UNKNOWN;<br>
+<br>
 		iblock = udf_get_lb_pblock(dir-&gt;i_sb, lelb_to_cpu(cfi.icb.extLocation), 0);<br>
  <br>
  		if (!lfi) /* parent directory */<br>
  		{<br>
-			if (filldir(dirent, "..", 2, filp-&gt;f_pos, filp-&gt;f_dentry-&gt;d_parent-&gt;d_inode-&gt;i_ino) &lt; 0)<br>
+			if (filldir(dirent, DT_DIR, "..", 2, filp-&gt;f_pos, filp-&gt;f_dentry-&gt;d_parent-&gt;d_inode-&gt;i_ino) &lt; 0)<br>
 			{<br>
 				if (fibh.sbh != fibh.ebh)<br>
 					udf_release_data(fibh.ebh);<br>
@@ -266,7 +272,7 @@<br>
 		{<br>
 			if ((flen = udf_get_filename(nameptr, fname, lfi)))<br>
 			{<br>
-				if (filldir(dirent, fname, flen, filp-&gt;f_pos, iblock) &lt; 0)<br>
+				if (filldir(dirent, ftype, fname, flen, filp-&gt;f_pos, iblock) &lt; 0)<br>
 				{<br>
 					if (fibh.sbh != fibh.ebh)<br>
 						udf_release_data(fibh.ebh);<br>
diff -u linux-2.3/fs/ufs/dir.c.d_type linux-2.3/fs/ufs/dir.c<br>
--- linux-2.3/fs/ufs/dir.c.d_type	Sat Sep  4 04:51:40 1999<br>
+++ linux-2.3/fs/ufs/dir.c	Fri Oct 15 02:29:46 1999<br>
@@ -15,6 +15,7 @@<br>
 <br>
 #include &lt;linux/fs.h&gt;<br>
 #include &lt;linux/ufs_fs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include "swab.h"<br>
 #include "util.h"<br>
@@ -125,7 +126,8 @@<br>
 <br>
 				UFSD(("filldir(%s,%u)\n", de-&gt;d_name, SWAB32(de-&gt;d_ino)))<br>
 				UFSD(("namlen %u\n", ufs_get_de_namlen(de)))<br>
-				error = filldir(dirent, de-&gt;d_name, ufs_get_de_namlen(de),<br>
+				error = filldir(dirent, ufs_get_de_type (de),<br>
+						de-&gt;d_name, ufs_get_de_namlen(de),<br>
 						filp-&gt;f_pos, SWAB32(de-&gt;d_ino));<br>
 				if (error)<br>
 					break;<br>
diff -u linux-2.3/fs/ufs/util.h.d_type linux-2.3/fs/ufs/util.h<br>
--- linux-2.3/fs/ufs/util.h.d_type	Mon Apr 12 18:53:45 1999<br>
+++ linux-2.3/fs/ufs/util.h	Fri Oct 15 03:41:27 1999<br>
@@ -127,6 +127,11 @@<br>
 	? (de-&gt;d_u.d_namlen = SWAB16(value)) \<br>
 	: (de-&gt;d_u.d_44.d_namlen = value))<br>
 <br>
+#define ufs_get_de_type(de) \<br>
+	(((flags &amp; UFS_DE_MASK) == UFS_DE_OLD) \<br>
+	? DT_UNKNOWN \<br>
+	: de-&gt;d_u.d_44.d_type)<br>
+<br>
 #define ufs_set_de_type(de,mode) _ufs_set_de_type_(de,mode,flags,swab)<br>
 static inline void _ufs_set_de_type_(struct ufs_dir_entry * de, int mode, <br>
 	unsigned flags, unsigned swab)<br>
diff -u linux-2.3/fs/umsdos/dir.c.d_type linux-2.3/fs/umsdos/dir.c<br>
--- linux-2.3/fs/umsdos/dir.c.d_type	Sat Sep  4 04:53:20 1999<br>
+++ linux-2.3/fs/umsdos/dir.c	Fri Oct 15 02:29:21 1999<br>
@@ -16,6 +16,7 @@<br>
 #include &lt;linux/limits.h&gt;<br>
 #include &lt;linux/umsdos_fs.h&gt;<br>
 #include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -79,6 +80,7 @@<br>
  */<br>
 <br>
 static int umsdos_dir_once (	void *buf,<br>
+				unsigned char type,<br>
 				const char *name,<br>
 				int len,<br>
 				off_t offset,<br>
@@ -90,7 +92,7 @@<br>
 	if (d-&gt;count == 0) {<br>
 		PRINTK ((KERN_DEBUG "dir_once :%.*s: offset %Ld\n", <br>
 			len, name, offset));<br>
-		ret = d-&gt;filldir (d-&gt;dirbuf, name, len, offset, ino);<br>
+		ret = d-&gt;filldir (d-&gt;dirbuf, type, name, len, offset, ino);<br>
 		d-&gt;stop = ret &lt; 0;<br>
 		d-&gt;count = 1;<br>
 	}<br>
@@ -135,7 +137,7 @@<br>
 		 */<br>
 <br>
 		Printk ((KERN_WARNING "umsdos_readdir_x: pseudo_root thing UMSDOS_SPECIAL_DIRFPOS\n"));<br>
-		if (filldir (dirbuf, "DOS", 3, <br>
+		if (filldir (dirbuf, DT_DIR, "DOS", 3, <br>
 				UMSDOS_SPECIAL_DIRFPOS, UMSDOS_ROOT_INO) == 0) {<br>
 			filp-&gt;f_pos++;<br>
 		}<br>
@@ -254,7 +256,8 @@<br>
 		 */<br>
 		if (inode != pseudo_root &amp;&amp;<br>
 		    (internal_read || !(entry.flags &amp; UMSDOS_HIDDEN))) {<br>
-			if (filldir (dirbuf, entry.name, entry.name_len,<br>
+			if (filldir (dirbuf, IFTODT (entry.mode),<br>
+				     entry.name, entry.name_len,<br>
 				 cur_f_pos, inode-&gt;i_ino) &lt; 0) {<br>
 				new_filp.f_pos = cur_f_pos;<br>
 			}<br>
diff -u linux-2.3/fs/umsdos/ioctl.c.d_type linux-2.3/fs/umsdos/ioctl.c<br>
--- linux-2.3/fs/umsdos/ioctl.c.d_type	Sat Sep 26 01:30:07 1998<br>
+++ linux-2.3/fs/umsdos/ioctl.c	Fri Oct 15 03:36:47 1999<br>
@@ -14,9 +14,10 @@<br>
 #include &lt;linux/fs.h&gt;<br>
 #include &lt;linux/msdos_fs.h&gt;<br>
 #include &lt;linux/umsdos_fs.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 struct UMSDOS_DIR_ONCE {<br>
-	struct dirent *ent;<br>
+	struct getdents_dirent *ent;<br>
 	int count;<br>
 };<br>
 <br>
@@ -26,6 +27,7 @@<br>
  */<br>
 static int umsdos_ioctl_fill (<br>
 				     void *buf,<br>
+				     unsigned char type,<br>
 				     const char *name,<br>
 				     int name_len,<br>
 				     off_t offset,<br>
diff -u linux-2.3/fs/umsdos/rdir.c.d_type linux-2.3/fs/umsdos/rdir.c<br>
--- linux-2.3/fs/umsdos/rdir.c.d_type	Sat Sep  4 04:51:40 1999<br>
+++ linux-2.3/fs/umsdos/rdir.c	Fri Oct 15 03:39:31 1999<br>
@@ -15,6 +15,7 @@<br>
 #include &lt;linux/limits.h&gt;<br>
 #include &lt;linux/umsdos_fs.h&gt;<br>
 #include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/dirent.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -30,6 +31,7 @@<br>
 };<br>
 <br>
 static int rdir_filldir (	void *buf,<br>
+				unsigned char type,<br>
 				const char *name,<br>
 				int name_len,<br>
 				off_t offset,<br>
@@ -48,11 +50,11 @@<br>
 				/* Make sure the .. entry points back to the pseudo_root */<br>
 				ino = pseudo_root-&gt;i_ino;<br>
 			}<br>
-			ret = d-&gt;filldir (d-&gt;dirbuf, name, name_len, offset, ino);<br>
+			ret = d-&gt;filldir (d-&gt;dirbuf, type, name, name_len, offset, ino);<br>
 		}<br>
 	} else {<br>
 		/* Any DOS directory */<br>
-		ret = d-&gt;filldir (d-&gt;dirbuf, name, name_len, offset, ino);<br>
+		ret = d-&gt;filldir (d-&gt;dirbuf, type, name, name_len, offset, ino);<br>
 	}<br>
 	return ret;<br>
 }<br>
diff -u linux-2.3/include/linux/dirent.h.d_type linux-2.3/include/linux/dirent.h<br>
--- linux-2.3/include/linux/dirent.h.d_type	Thu Oct 14 23:31:45 1999<br>
+++ linux-2.3/include/linux/dirent.h	Fri Oct 15 06:50:26 1999<br>
@@ -1,11 +1,64 @@<br>
 #ifndef _LINUX_DIRENT_H<br>
 #define _LINUX_DIRENT_H<br>
 <br>
-struct dirent {<br>
-	long		d_ino;<br>
-	__kernel_off_t	d_off;<br>
+/* Structure returned by sys_readdir.<br>
+ */<br>
+struct readdir_dirent {<br>
+	unsigned long	d_ino;<br>
+	unsigned long	d_offset;<br>
+	unsigned short	d_namlen;<br>
+	char		d_name[256]; /* We must not include limits.h! */<br>
+};<br>
+<br>
+/* Structure returned by sys_getdents.<br>
+ */<br>
+struct getdents_dirent {<br>
+	unsigned long	d_ino;<br>
+	unsigned long	d_off;<br>
+	unsigned short	d_reclen;<br>
+	char		d_name[256]; /* We must not include limits.h! */<br>
+};<br>
+<br>
+/* Structure returned by sys_getdirentries.<br>
+ *<br>
+ * Must be identical to Glibc 2.1's struct dirent so that Glibc's<br>
+ * getdirentries can return these directly:<br>
+ *<br>
+ *	unsigned long	d_ino	(all calls)<br>
+ *	long		d_off	(non-64 bit calls (may be 64 bits anyway))<br>
+ *	long long	d_off	(64 bit calls)<br>
+ */<br>
+struct getdirentries_dirent {<br>
+	unsigned long	d_ino;<br>
+	long		d_off;<br>
+	unsigned short	d_reclen;<br>
+	unsigned char	d_type;<br>
+	char		d_name[256]; /* We must not include limits.h! */<br>
+};<br>
+struct getdirentries_dirent64 {<br>
+	unsigned long	d_ino;<br>
+	long long	d_off;<br>
 	unsigned short	d_reclen;<br>
+	unsigned char	d_type;<br>
 	char		d_name[256]; /* We must not include limits.h! */<br>
 };<br>
+<br>
+/* Type code stored in d_type.  DT_UNKNOWN when no type is available.<br>
+ * Must match Glibc values.  These are quite standard.<br>
+ */<br>
+#define DT_UNKNOWN	0<br>
+#define DT_FIFO		1<br>
+#define DT_CHR		2<br>
+#define DT_DIR		4<br>
+#define DT_BLK		6<br>
+#define DT_REG		8<br>
+#define DT_LNK		10<br>
+#define DT_SOCK		12<br>
+#define DT_WHT		14<br>
+<br>
+/* Convert to and from S_IFREG etc.<br>
+ */<br>
+#define DTTOIF(dirtype)	((dirtype) &lt;&lt; 12)<br>
+#define IFTODT(mode)	(((mode) &amp; 0170000) &gt;&gt; 12)<br>
 <br>
 #endif<br>
diff -u linux-2.3/include/linux/fs.h.d_type linux-2.3/include/linux/fs.h<br>
--- linux-2.3/include/linux/fs.h.d_type	Thu Oct 14 23:18:55 1999<br>
+++ linux-2.3/include/linux/fs.h	Fri Oct 15 00:18:24 1999<br>
@@ -583,7 +583,7 @@<br>
  * This allows the kernel to read directories into kernel space or<br>
  * to have different dirent layouts depending on the binary type.<br>
  */<br>
-typedef int (*filldir_t)(void *, const char *, int, off_t, ino_t);<br>
+typedef int (*filldir_t)(void *, unsigned char, const char *, int, off_t, ino_t);<br>
 	<br>
 struct file_operations {<br>
 	loff_t (*llseek) (struct file *, loff_t, int);<br>
diff -u linux-2.3/include/linux/iso_fs.h.d_type linux-2.3/include/linux/iso_fs.h<br>
--- linux-2.3/include/linux/iso_fs.h.d_type	Sat Sep  4 04:51:42 1999<br>
+++ linux-2.3/include/linux/iso_fs.h	Fri Oct 15 06:05:42 1999<br>
@@ -176,7 +176,7 @@<br>
 extern int iso_date(char *, int);<br>
 <br>
 extern int parse_rock_ridge_inode(struct iso_directory_record *, struct inode *);<br>
-extern int get_rock_ridge_filename(struct iso_directory_record *, char *, struct inode *);<br>
+extern int get_rock_ridge_filename(struct iso_directory_record *, char *, struct inode *, unsigned char *);<br>
 <br>
 extern char * get_rock_ridge_symlink(struct inode *);<br>
 extern int find_rock_ridge_relocation(struct iso_directory_record *, struct inode *);<br>
diff -u linux-2.3/include/linux/msdos_fs.h.d_type linux-2.3/include/linux/msdos_fs.h<br>
--- linux-2.3/include/linux/msdos_fs.h.d_type	Fri Oct 15 02:43:09 1999<br>
+++ linux-2.3/include/linux/msdos_fs.h	Fri Oct 15 02:46:09 1999<br>
@@ -85,8 +85,8 @@<br>
 /*<br>
  * ioctl commands<br>
  */<br>
-#define	VFAT_IOCTL_READDIR_BOTH		_IOR('r', 1, struct dirent [2])<br>
-#define	VFAT_IOCTL_READDIR_SHORT	_IOR('r', 2, struct dirent [2])<br>
+#define	VFAT_IOCTL_READDIR_BOTH   _IOR('r', 1, struct getdents_dirent [2])<br>
+#define	VFAT_IOCTL_READDIR_SHORT  _IOR('r', 2, struct getdents_dirent [2])<br>
 <br>
 /*<br>
  * Conversion from and to little-endian byte order. (no-op on i386/i486)<br>
diff -u linux-2.3/include/linux/nfsd/nfsd.h.d_type linux-2.3/include/linux/nfsd/nfsd.h<br>
--- linux-2.3/include/linux/nfsd/nfsd.h.d_type	Fri Oct 15 06:50:49 1999<br>
+++ linux-2.3/include/linux/nfsd/nfsd.h	Fri Oct 15 07:07:21 1999<br>
@@ -53,8 +53,8 @@<br>
 	char			eob;		/* end of buffer */<br>
 	char			dotonly;<br>
 };<br>
-typedef int		(*encode_dent_fn)(struct readdir_cd *, const char *,<br>
-						int, off_t, ino_t);<br>
+typedef int		(*encode_dent_fn)(struct readdir_cd *, unsigned char,<br>
+					  const char *, int, off_t, ino_t);<br>
 typedef int (*nfsd_dirop_t)(struct inode *, struct dentry *, int, int);<br>
 <br>
 /*<br>
diff -u linux-2.3/include/linux/nfsd/xdr.h.d_type linux-2.3/include/linux/nfsd/xdr.h<br>
--- linux-2.3/include/linux/nfsd/xdr.h.d_type	Fri Oct 15 02:50:28 1999<br>
+++ linux-2.3/include/linux/nfsd/xdr.h	Fri Oct 15 07:00:37 1999<br>
@@ -151,8 +151,8 @@<br>
 int nfssvc_encode_statfsres(struct svc_rqst *, u32 *, struct nfsd_statfsres *);<br>
 int nfssvc_encode_readdirres(struct svc_rqst *, u32 *, struct nfsd_readdirres *);<br>
 <br>
-int nfssvc_encode_entry(struct readdir_cd *, const char *name,<br>
-				int namlen, off_t offset, ino_t ino);<br>
+int nfssvc_encode_entry(struct readdir_cd *, unsigned char type,<br>
+			const char *name, int namlen, off_t offset, ino_t ino);<br>
 <br>
 int nfssvc_release_fhandle(struct svc_rqst *, u32 *, struct nfsd_fhandle *);<br>
 <br>
diff -u linux-2.3/include/linux/nfsd/xdr3.h.d_type linux-2.3/include/linux/nfsd/xdr3.h<br>
--- linux-2.3/include/linux/nfsd/xdr3.h.d_type	Mon Apr  7 20:35:32 1997<br>
+++ linux-2.3/include/linux/nfsd/xdr3.h	Fri Oct 15 07:01:15 1999<br>
@@ -262,7 +262,8 @@<br>
 				struct nfsd_fhandle *);<br>
 int nfs3svc_release_fhandle2(struct svc_rqst *, u32 *,<br>
 				struct nfsd3_fhandle2 *);<br>
-int nfs3svc_encode_entry(struct readdir_cd *, const char *name,<br>
-				int namlen, unsigned long offset, ino_t ino);<br>
+int nfs3svc_encode_entry(struct readdir_cd *, unsigned char type,<br>
+				const char *name, int namlen,<br>
+				unsigned long offset, ino_t ino);<br>
 <br>
 #endif /* LINUX_NFSD_XDR3_H */<br>
diff -u linux-2.3/include/linux/umsdos_fs.h.d_type linux-2.3/include/linux/umsdos_fs.h<br>
--- linux-2.3/include/linux/umsdos_fs.h.d_type	Thu Oct 14 23:22:16 1999<br>
+++ linux-2.3/include/linux/umsdos_fs.h	Fri Oct 15 06:50:39 1999<br>
@@ -127,7 +127,7 @@<br>
 #define UMSDOS_RENAME_DOS  _IO(0x04,220)	/* rename a file/directory in the DOS<br>
 						 * directory only */<br>
 struct umsdos_ioctl {<br>
-	struct dirent dos_dirent;<br>
+	struct getdents_dirent dos_dirent;<br>
 	struct umsdos_dirent umsdos_dirent;<br>
 	/* The following structure is used to exchange some data<br>
 	 * with utilities (umsdos_progs/util/umsdosio.c). The first<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1014.html">Kanoj Sarcar: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Previous message:</b> <a href="1012.html">Guest section DW: "Re: Question about /proc/ide"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
