<!-- received="Fri Oct 15 21:53:03 1999 EET DST" -->
<!-- sent="Fri, 15 Oct 1999 11:35:16 -0700 (PDT)" -->
<!-- name="H.J. Lu" -->
<!-- email="hjl@valinux.com" -->
<!-- subject="A patch for eepro driver" -->
<!-- id="19991015183516.1E25F3FC1@valinux.com" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: A patch for eepro driver</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>A patch for eepro driver</h1>
<b>H.J. Lu</b> (<a href="mailto:hjl@valinux.com"><i>hjl@valinux.com</i></a>)<br>
<i>Fri, 15 Oct 1999 11:35:16 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1044">[ date ]</a><a href="index.html#1044">[ thread ]</a><a href="subject.html#1044">[ subject ]</a><a href="author.html#1044">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1045.html">Martin Dalecki: "Re: PCI question"</a>
<li> <b>Previous message:</b> <a href="1043.html">Alan Cox: "Re: Fixing the VIA rhine a bit"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
Here is a patch for eepro100 in Linux 2.2.12. Without this patch,<br>
the machine will lock up when the interface is enabled if there are<br>
several devices sharing the same interrupt with eepro100 and they<br>
are registered first.<br>
<p>
Thanks.<br>
<p>
<p>
<pre>
-- 
H.J. Lu (<a href="mailto:hjl@gnu.org">hjl@gnu.org</a>)
<pre>
--
--- linux/drivers/net/eepro100.c	Wed Oct 13 12:03:37 1999
+++ linux-test/drivers/net/eepro100.c	Fri Oct 15 11:27:28 1999
@@ -823,6 +823,18 @@ speedo_open(struct device *dev)
 	dev-&gt;interrupt = 0;
 	dev-&gt;start = 1;
 
+	/*
+	 * Request the IRQ last, after we have set up all data structures.
+	 * It would be bad to get an interrupt before we're ready.
+	 *
+	 * Register ourself first before turn on the interrupt. Someone
+	 * else may share the same interrupt. H.J.
+	 */
+	if (request_irq(dev-&gt;irq, &amp;speedo_interrupt, SA_SHIRQ,
+					"Intel EtherExpress Pro 10/100 Ethernet", dev)) {
+		return -EAGAIN;
+	}
+
 	/* Start the chip's Tx process and unmask interrupts. */
 	/* Todo: verify that we must wait for previous command completion. */
 	wait_for_cmd_done(ioaddr + SCBCmd);
@@ -843,15 +855,6 @@ speedo_open(struct device *dev)
 
 	wait_for_cmd_done(ioaddr + SCBCmd);
 	outw(CU_DUMPSTATS, ioaddr + SCBCmd);
-
-	/*
-	 * Request the IRQ last, after we have set up all data structures.
-	 * It would be bad to get an interrupt before we're ready.
-	 */
-	if (request_irq(dev-&gt;irq, &amp;speedo_interrupt, SA_SHIRQ,
-					"Intel EtherExpress Pro 10/100 Ethernet", dev)) {
-		return -EAGAIN;
-	}
 
 	/* No need to wait for the command unit to accept here. */
 	if ((sp-&gt;phy[0] &amp; 0x8000) == 0)
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1045.html">Martin Dalecki: "Re: PCI question"</a>
<li> <b>Previous message:</b> <a href="1043.html">Alan Cox: "Re: Fixing the VIA rhine a bit"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
