<!-- received="Fri Oct 15 22:25:43 1999 EET DST" -->
<!-- sent="Fri, 15 Oct 1999 19:49:24 +0100" -->
<!-- name="Nick Holloway" -->
<!-- email="Nick.Holloway@alfie.demon.co.uk" -->
<!-- subject="Re: serial.c patch in 2.3.19" -->
<!-- id="199910151849.TAA22587@alfie.demon.co.uk" -->
<!-- inreplyto="serial.c patch in 2.3.19" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: serial.c patch in 2.3.19</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: serial.c patch in 2.3.19</h1>
<b>Nick Holloway</b> (<a href="mailto:Nick.Holloway@alfie.demon.co.uk"><i>Nick.Holloway@alfie.demon.co.uk</i></a>)<br>
<i>Fri, 15 Oct 1999 19:49:24 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1053">[ date ]</a><a href="index.html#1053">[ thread ]</a><a href="subject.html#1053">[ subject ]</a><a href="author.html#1053">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1054.html">Greg: "2.2.12 - MD Problems?"</a>
<li> <b>Previous message:</b> <a href="1052.html">tytso@mit.edu: "Re: RNDGETPOOL ioctl wierdness"</a>
<li> <b>Maybe in reply to:</b> <a href="0856.html">Thomas Sailer: "serial.c patch in 2.3.19"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1056.html">Theodore Y. Ts'o: "Re: serial.c patch in 2.3.19"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a> (Thomas Sailer) wrote:<br>
<i>&gt; <a href="mailto:tytso@mit.edu">tytso@mit.edu</a> wrote:</i><br>
<i>&gt; &gt; I don't see how this would be breaking systems.  Basically, this patch</i><br>
<i>&gt; &gt; causes the serial driver to not release the ioregion if the UART is</i><br>
<i>&gt; &gt; unknown.  But if the UART is unknown, the region wouldn't have been</i><br>
<i>&gt; &gt; requested by the serial driver.</i><br>
<i>&gt; </i><br>
<i>&gt; setserial /dev/ttySx uart none</i><br>
<i>&gt;   resource not released</i><br>
<i>&gt; setserial /dev/ttySx port 0</i><br>
<i>&gt;   resource still not released</i><br>
<p>
I submitted the patch originally.  Otherwise it would release the resource<br>
that wasn't held for the port I don't have.<br>
<p>
I think the problem is that when deciding if to release the port, it<br>
considers the _new_ setting of the state-&gt;type.  Thus, when you change<br>
the uart to "none", the previous allocation is not released.<br>
<p>
I think the following (untested) patch should remedy this.  My brain<br>
is having trouble thinking around this, but the check for releasing the<br>
region uses the same values used for requesting the region.<br>
<p>
--- serial.c~	Fri Oct 15 19:26:57 1999<br>
+++ serial.c	Fri Oct 15 19:36:56 1999<br>
@@ -1997,7 +1997,6 @@<br>
 	info-&gt;flags = ((state-&gt;flags &amp; ~ASYNC_INTERNAL_FLAGS) |<br>
 		       (info-&gt;flags &amp; ASYNC_INTERNAL_FLAGS));<br>
 	state-&gt;custom_divisor = new_serial.custom_divisor;<br>
-	state-&gt;type = new_serial.type;<br>
 	state-&gt;close_delay = new_serial.close_delay * HZ/100;<br>
 	state-&gt;closing_wait = new_serial.closing_wait * HZ/100;<br>
 #if (LINUX_VERSION_CODE &gt; 0x200100)<br>
@@ -2018,6 +2017,7 @@<br>
 		info-&gt;port = state-&gt;port = new_serial.port;<br>
 		info-&gt;hub6 = state-&gt;hub6 = new_serial.hub6;<br>
 	}<br>
+	state-&gt;type = new_serial.type;<br>
 	if ((state-&gt;type != PORT_UNKNOWN) &amp;&amp; state-&gt;port)<br>
 		request_region(state-&gt;port,8,"serial(set)");<br>
 <br>
<p>
<pre>
-- 
 `O O'  | <a href="mailto:Nick.Holloway@alfie.demon.co.uk">Nick.Holloway@alfie.demon.co.uk</a>
// ^ \\ | <a href="http://www.alfie.demon.co.uk/">http://www.alfie.demon.co.uk/</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1054.html">Greg: "2.2.12 - MD Problems?"</a>
<li> <b>Previous message:</b> <a href="1052.html">tytso@mit.edu: "Re: RNDGETPOOL ioctl wierdness"</a>
<li> <b>Maybe in reply to:</b> <a href="0856.html">Thomas Sailer: "serial.c patch in 2.3.19"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1056.html">Theodore Y. Ts'o: "Re: serial.c patch in 2.3.19"</a>
<!-- reply="end" -->
</ul>
</font></body>
