<!-- received="Fri Oct 15 23:47:13 1999 EET DST" -->
<!-- sent="Fri, 15 Oct 1999 22:39:03 +0200" -->
<!-- name="Kurt Garloff" -->
<!-- email="garloff@suse.de" -->
<!-- subject="APM patch for Acer TM 510 series" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: APM patch for Acer TM 510 series</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>APM patch for Acer TM 510 series</h1>
<b>Kurt Garloff</b> (<a href="mailto:garloff@suse.de"><i>garloff@suse.de</i></a>)<br>
<i>Fri, 15 Oct 1999 22:39:03 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1072">[ date ]</a><a href="index.html#1072">[ thread ]</a><a href="subject.html#1072">[ subject ]</a><a href="author.html#1072">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1073.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Previous message:</b> <a href="1071.html">Bret Indrelee: "RE: PCI question"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--Dzs2zDY0zgkG72+7<br>
Content-Type: multipart/mixed; boundary="UoPmpPX/dBe4BELn"<br>
<p>
<p>
--UoPmpPX/dBe4BELn<br>
Content-Type: text/plain; charset=iso-8859-1<br>
Content-Transfer-Encoding: quoted-printable<br>
<p>
Hi,<br>
<p>
find attached a patch to add a kernel parameter apm=3Dacertm5.<br>
<p>
It is a workaround for a bug in the Acer TravelMate 510 series APM BIOS. The<br>
info block offset is returned incorrectly, which is fixed by the apm driver,<br>
if you enable this option.<br>
<p>
Regards,<br>
--=20<br>
Kurt Garloff  &lt;<a href="mailto:garloff@suse.de">garloff@suse.de</a>&gt;                             Wuppertal, FRG<br>
PGP2 key: See mail header, key servers            Linux kernel development<br>
SuSE GmbH, N=FCrnberg, FRG               SCSI drivers: tmscsim(DC390), DC395<br>
<p>
--UoPmpPX/dBe4BELn<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="22x-acertm5-apm.diff"<br>
Content-Transfer-Encoding: quoted-printable<br>
<p>
--- linux/arch/i386/kernel/apm.c.orig	Mon Oct  4 04:21:57 1999<br>
+++ linux/arch/i386/kernel/apm.c	Tue Oct 12 10:29:42 1999<br>
@@ -90,6 +90,8 @@<br>
  *         Use CONFIG_SMP instead of __SMP__<br>
  *         Ignore BOUNCES for three seconds.<br>
  *         Stephen Rothwell<br>
+ *    1.9a: (<a href="mailto:garloff@suse.de">garloff@suse.de</a>): apm=3Dacertm5 works around Acer TravelMate=<br>
=20<br>
+ *		510 series BIOS bug.<br>
  *<br>
  * APM 1.1 Reference:<br>
  *<br>
@@ -295,6 +297,7 @@<br>
 }				apm_bios_entry;<br>
 static int			apm_enabled =3D 0;<br>
 static int			smp_hack =3D 0;<br>
+static int			acertm5 =3D 0;<br>
 #ifdef CONFIG_APM_CPU_IDLE<br>
 static int			clock_slowed =3D 0;<br>
 #endif<br>
@@ -319,7 +322,7 @@<br>
=20<br>
 static struct timer_list	apm_timer;<br>
=20<br>
-static char			driver_version[] =3D "1.9";	/* no spaces */<br>
+static char			driver_version[] =3D "1.9a";	/* no spaces */<br>
=20<br>
 #ifdef APM_DEBUG<br>
 static char *	apm_event_name[] =3D {<br>
@@ -1279,6 +1282,8 @@<br>
 			debug =3D !invert;<br>
 		if (strncmp(str, "smp-power-off", 13) =3D=3D 0)<br>
 			smp_hack =3D !invert;<br>
+		if (strncmp(str, "acertm5", 7) =3D=3D 0)<br>
+			acertm5 =3D !invert;<br>
 		str =3D strchr(str, ',');<br>
 		if (str !=3D NULL)<br>
 			str +=3D strspn(str, ", \t");<br>
@@ -1349,7 +1354,13 @@<br>
 		 __va((unsigned long)0x40 &lt;&lt; 4));<br>
 	_set_limit((char *)&amp;gdt[APM_40 &gt;&gt; 3], 4095 - (0x40 &lt;&lt; 4));<br>
=20<br>
-	apm_bios_entry.offset =3D apm_bios_info.offset;<br>
+        if (acertm5 &amp;&amp; apm_bios_info.offset &gt; 0xffff) {<br>
+		apm_bios_entry.offset =3D apm_bios_info.offset &amp; 0xffff;<br>
+		printk ("APM: Fixed APM BIOS entry offset %lx-&gt;%lx (AcerTM51x?)\n",<br>
+			apm_bios_info.offset, apm_bios_entry.offset);<br>
+	}<br>
+	else<br>
+		apm_bios_entry.offset =3D apm_bios_info.offset;<br>
 	apm_bios_entry.segment =3D APM_CS;<br>
 	set_base(gdt[APM_CS &gt;&gt; 3],<br>
 		 __va((unsigned long)apm_bios_info.cseg &lt;&lt; 4));<br>
--- linux/Documentation/kernel-parameters.txt.orig	Tue Jun  8 01:13:07 1999<br>
+++ linux/Documentation/kernel-parameters.txt	Tue Oct 12 10:25:40 1999<br>
@@ -64,7 +64,7 @@<br>
=20<br>
     AM53C974=3D		[HW,SCSI]<br>
=20<br>
-    apm=3D		[APM] Automatic Power Management.<br>
+    apm=3D		[APM] Advanced Power Management.<br>
=20<br>
     arcrimi=3D		[HW,NET]<br>
=20<br>
<p>
--UoPmpPX/dBe4BELn--<br>
<p>
--Dzs2zDY0zgkG72+7<br>
Content-Type: application/pgp-signature<br>
<p>
-----BEGIN PGP SIGNATURE-----<br>
Version: GnuPG v1.0.0e (GNU/Linux)<br>
Comment: For info see <a href="http://www.gnupg.org">http://www.gnupg.org</a><br>
<p>
iQCVAwUBOAeQ5haQN/7O/JIVAQFlOwP7BAVscn/m01DJrwtp6AVP+GHriG83Rt1L<br>
RIIXJZ0ej7qeTNa9bQVZ9S9bZKxFaIg9xNvrNCdzuxIiSF3406w6dsXMN7Ef99di<br>
RDmQb/hA0V76H2K/Mq4VVSYwwaZKZ4FT6EMktRmxjWBmFNn4nXfKaQGSlv5md5Km<br>
/vawMzmZf+w=<br>
=DJvb<br>
-----END PGP SIGNATURE-----<br>
<p>
--Dzs2zDY0zgkG72+7--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1073.html">Manfred Spraul: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>Previous message:</b> <a href="1071.html">Bret Indrelee: "RE: PCI question"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
