<!-- received="Sat Oct 16 01:27:17 1999 EET DST" -->
<!-- sent="Sat, 16 Oct 1999 00:24:33 +0200 (CEST)" -->
<!-- name="Urban Widmark" -->
<!-- email="urban@svenskatest.se" -->
<!-- subject="Re: Fixing the VIA rhine a bit" -->
<!-- id="" -->
<!-- inreplyto="E11cByF-00050C-00@the-village.bc.nu" -->
<title>Linux-kernel mailing list archive 1999-41,: Re: Fixing the VIA rhine a bit</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Fixing the VIA rhine a bit</h1>
<b>Urban Widmark</b> (<a href="mailto:urban@svenskatest.se"><i>urban@svenskatest.se</i></a>)<br>
<i>Sat, 16 Oct 1999 00:24:33 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1083">[ date ]</a><a href="index.html#1083">[ thread ]</a><a href="subject.html#1083">[ subject ]</a><a href="author.html#1083">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1084.html">Benjamin C.R. LaHaise: "Re: resize of vmalloced area possible?"</a>
<li> <b>Previous message:</b> <a href="1082.html">Kanoj Sarcar: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>In reply to:</b> <a href="1043.html">Alan Cox: "Re: Fixing the VIA rhine a bit"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 15 Oct 1999, Alan Cox wrote:<br>
<p>
<i>&gt; &gt; It still prints 8 extra "detection" lines:</i><br>
<i>&gt; &gt; via-rhine.c:v1.01 2/27/99  Written by Donald Becker</i><br>
<i>&gt; &gt;   <a href="http://cesdis.gsfc.nasa.gov/linux/drivers/via-rhine.html">http://cesdis.gsfc.nasa.gov/linux/drivers/via-rhine.html</a></i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; I believe Donald Becker expressed some thoughts on that before.</i><br>
<i>&gt; </i><br>
<i>&gt; That sounds like I didnt get the check_mem_region stuff right. Ok I need</i><br>
<i>&gt; to look at that in more detail. </i><br>
<p>
I don't see how the check_mem_region part of the if you changed gets<br>
called (around line 456). The pci_tbl sets PCI_USES_IO | PCI_USES_MEM for<br>
both listed chipsets, so the if is always true, no?<br>
<p>
On x86 VIA_USE_IO is defined by default so that hides the<br>
request_mem_region and release_mem_region as well. (No, I didn't read your<br>
patch before applying and testing ...)<br>
<p>
Not counting the:<br>
-#define ioremap vremap<br>
-#define iounmap vfree<br>
  (which makes it compile/link again, IIRC)<br>
<p>
these changes don't change much for me. Maybe they weren't supposed to<br>
since I am (apparently) using IO and not MMIO. Sorry if my reply was<br>
misleading and for the lack of detail.<br>
<p>
<p>
The version printouts come from the via_rhine_probe function, since I<br>
don't run it as a module. I called them "detection" since they are<br>
normally printed when something is detected. But for this driver it is<br>
printed no matter what the probe returns.<br>
<p>
Here are the thoughts I was thinking about above.<br>
"Hmmm, that's because the probe code in Space.c is calling the driver<br>
 eight times. It should only call the PCI drivers once, and even<br>
 (especially!) in the ISA case should give up when no more cards are<br>
 found. Probing multiple times on the ISA bus is dangerous."<br>
     <a href="http://www.uwsg.indiana.edu/hypermail/linux/kernel/9908.3/0690.html">http://www.uwsg.indiana.edu/hypermail/linux/kernel/9908.3/0690.html</a><br>
     Donald Becker  Fri, 27 Aug 1999 14:39:27 -0400 (EDT)<br>
     (searchable list archives are great :)<br>
<p>
<p>
Space.c calls via_rhine_probe once for each of the 8 defined eth<br>
interfaces. Maybe that is wrong. This patch makes it shut up. It is very<br>
likely wrong.<br>
<p>
--- via-rhine.c.orig	Fri Oct 15 23:51:22 1999<br>
+++ via-rhine.c	Fri Oct 15 23:52:06 1999<br>
@@ -498,8 +498,10 @@<br>
 #ifndef MODULE<br>
 int via_rhine_probe(struct net_device *dev)<br>
 {<br>
-	printk(KERN_INFO "%s" KERN_INFO "%s", versionA, versionB);<br>
-	return pci_etherdev_probe(dev, pci_tbl);<br>
+	int n;<br>
+	if( (n = pci_etherdev_probe(dev, pci_tbl)) == 0)<br>
+		printk(KERN_INFO "%s" KERN_INFO "%s", versionA, versionB);<br>
+	return n;<br>
 }<br>
 #endif<br>
 <br>
<p>
/Urban<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1084.html">Benjamin C.R. LaHaise: "Re: resize of vmalloced area possible?"</a>
<li> <b>Previous message:</b> <a href="1082.html">Kanoj Sarcar: "Re: [PATCH] kanoj-mm17-2.3.21 kswapd vma scanning protection"</a>
<li> <b>In reply to:</b> <a href="1043.html">Alan Cox: "Re: Fixing the VIA rhine a bit"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
