<!-- received="Sat Oct 16 13:58:00 1999 EET DST" -->
<!-- sent="Sat, 16 Oct 1999 12:51:11 +0200" -->
<!-- name="Kurt Garloff" -->
<!-- email="garloff@suse.de" -->
<!-- subject="SMP Extraversion" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: SMP Extraversion</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>SMP Extraversion</h1>
<b>Kurt Garloff</b> (<a href="mailto:garloff@suse.de"><i>garloff@suse.de</i></a>)<br>
<i>Sat, 16 Oct 1999 12:51:11 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1119">[ date ]</a><a href="index.html#1119">[ thread ]</a><a href="subject.html#1119">[ subject ]</a><a href="author.html#1119">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1120.html">Jens Benecke: "Re: rnel Oops"</a>
<li> <b>Previous message:</b> <a href="1118.html">Matti Aarnio: "Re: How to extend struct stat?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--tsOsTdHNUZQcU9Ye<br>
Content-Type: multipart/mixed; boundary="3MwIy2ne0vdjdPXF"<br>
<p>
<p>
--3MwIy2ne0vdjdPXF<br>
Content-Type: text/plain; charset=iso-8859-1<br>
Content-Transfer-Encoding: quoted-printable<br>
<p>
Hi Linus, Alan,<br>
<p>
attached is a patch which does append the string "-SMP" to the kernel<br>
version, if the kernel is compiled with CONFIG_SMP.<br>
<p>
Rationale:<br>
When changing the settings for the kernel, most modules won't break (though<br>
I'd recommend to recompile them anyway, cause that's the way they are<br>
designed).<br>
The SMP setting is special: a __SMP__ preprocessor symbol is defined and<br>
lots of critical data structures are different. Most modules will break.<br>
<p>
For slight changes, the MODVERSION mechanism is best suited.<br>
<p>
However, for UP vs. SMP, I prefer a more coarse approach: Append -SMP to the<br>
kernel release.<br>
<p>
This will have  two consequences:<br>
* The SMP modules will be stored in a different directory and won't<br>
  overwrite the UP ones. This is especially convenient for SMP kernel<br>
  hackers, that eg. use a UP kernel with DEBUG_SPINLOCK for debugging.<br>
* insmod will refuse to load non-SMP modules into an SMP kernel and vice<br>
  versa. (And while MODVERSIONS is supposed to catch most of these as well,<br>
  you'll get killed, if you disabled it or have some modules without<br>
  MODVERSIONS.)<br>
<p>
I'll suggest the patch to go into the official kernel.<br>
<p>
Patch is attached.<br>
It contains a few lines to check whether the SMP setting has been changed<br>
and rebuilds include/linux/version.h, if necessary.<br>
It has been tested on a few machines here and did not cause any trouble.<br>
<p>
Regards,<br>
--=20<br>
Kurt Garloff  &lt;<a href="mailto:garloff@suse.de">garloff@suse.de</a>&gt;                             Wuppertal, FRG<br>
PGP2 key: See mail header, key servers            Linux kernel development<br>
SuSE GmbH, N=FCrnberg, FRG               SCSI drivers: tmscsim(DC390), DC395<br>
<p>
--3MwIy2ne0vdjdPXF<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="22x-SMP-extraversion.diff"<br>
<p>
--- linux-2.2.12.SuSE.old/Makefile	Mon Oct 11 19:34:30 1999<br>
+++ linux-2.2.12.SuSE/Makefile	Mon Oct 11 19:36:48 1999<br>
@@ -60,7 +60,14 @@<br>
 <br>
 ROOT_DEV = CURRENT<br>
 <br>
-KERNELRELEASE=$(VERSION).$(PATCHLEVEL).$(SUBLEVEL)$(EXTRAVERSION)<br>
+# Test for SMP<br>
+ifdef CONFIG_SMP<br>
+SMPVERSION="-SMP"<br>
+else<br>
+SMPVERSION=<br>
+endif<br>
+<br>
+KERNELRELEASE=$(VERSION).$(PATCHLEVEL).$(SUBLEVEL)$(EXTRAVERSION)$(SMPVERSION)<br>
 <br>
 #<br>
 # INSTALL_PATH specifies where to place the updated kernel and system map<br>
@@ -297,7 +304,7 @@<br>
 <br>
 include/linux/compile.h: $(CONFIGURATION) include/linux/version.h newversion<br>
 	@echo -n \#define UTS_VERSION \"\#`cat .version` &gt; .ver<br>
-	@if [ -n "$(CONFIG_SMP)" ] ; then echo -n " SMP" &gt;&gt; .ver; fi<br>
+	@#if [ -n "$(CONFIG_SMP)" ] ; then echo -n " SMP" &gt;&gt; .ver; fi<br>
 	@if [ -f .name ]; then  echo -n \-`cat .name` &gt;&gt; .ver; fi<br>
 	@echo ' '`date`'"' &gt;&gt; .ver<br>
 	@echo \#define LINUX_COMPILE_TIME \"`date +%T`\" &gt;&gt; .ver<br>
@@ -314,7 +320,16 @@<br>
 	@echo \#define LINUX_COMPILER \"`$(CC) $(CFLAGS) -v 2&gt;&amp;1 | tail -1`\" &gt;&gt; .ver<br>
 	@mv -f .ver $@<br>
 <br>
-include/linux/version.h: ./Makefile<br>
+.kernelrelease.new:<br>
+	@echo "$(KERNELRELEASE)" &gt;./.kernelrelease.new<br>
+	<br>
+.kernelrelease: .kernelrelease.new<br>
+	@if diff ./.kernelrelease.new ./.kernelrelease &amp;&gt;/dev/null; \<br>
+		then rm ./.kernelrelease.new; \<br>
+		else mv ./.kernelrelease.new ./.kernelrelease; fi<br>
+<br>
+include/linux/version.h: ./Makefile .kernelrelease<br>
+	@echo "Creating new version.h for $(KERNELRELEASE)"<br>
 	@echo \#define UTS_RELEASE \"$(KERNELRELEASE)\" &gt; .ver<br>
 	@echo \#define LINUX_VERSION_CODE `expr $(VERSION) \\* 65536 + $(PATCHLEVEL) \\* 256 + $(SUBLEVEL)` &gt;&gt; .ver<br>
 	@echo '#define KERNEL_VERSION(a,b,c) (((a) &lt;&lt; 16) + ((b) &lt;&lt; 8) + (c))' &gt;&gt;.ver<br>
@@ -407,7 +422,7 @@<br>
 	rm -f drivers/net/hamradio/soundmodem/gentbl<br>
 	rm -f drivers/char/hfmodem/gentbl drivers/char/hfmodem/tables.h<br>
 	rm -f drivers/sound/*_boot.h drivers/sound/.*.boot<br>
-	rm -f .version .config* config.in config.old<br>
+	rm -f .version .kernelrelease .config* config.in config.old<br>
 	rm -f scripts/tkparse scripts/kconfig.tk scripts/kconfig.tmp<br>
 	rm -f scripts/cfconv config.in.tmp<br>
 	rm -f scripts/lxdialog/*.o scripts/lxdialog/lxdialog<br>
<p>
--3MwIy2ne0vdjdPXF--<br>
<p>
--tsOsTdHNUZQcU9Ye<br>
Content-Type: application/pgp-signature<br>
<p>
-----BEGIN PGP SIGNATURE-----<br>
Version: GnuPG v1.0.0e (GNU/Linux)<br>
Comment: For info see <a href="http://www.gnupg.org">http://www.gnupg.org</a><br>
<p>
iQCVAwUBOAhYnRaQN/7O/JIVAQGy7wP/cX4Me/TAOLPf1lddpRIW6FkpwGWYRtpu<br>
yAJB1GPMHU9W+2MmawXChiNmh8SiuXRpp56RJsumxBZ0bR7S1MtYO0zknSTRCdHR<br>
Ba4W/LSxoP9bdStqnWqFr7JtYfXew/ukMx5WzIapqa9Zc1Y6+TiZY6YLCrmpiRQ7<br>
FTvAeJBa2+8=<br>
=fLg8<br>
-----END PGP SIGNATURE-----<br>
<p>
--tsOsTdHNUZQcU9Ye--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1120.html">Jens Benecke: "Re: rnel Oops"</a>
<li> <b>Previous message:</b> <a href="1118.html">Matti Aarnio: "Re: How to extend struct stat?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
