<!-- received="Sat Oct 16 18:20:01 1999 EET DST" -->
<!-- sent="Sat, 16 Oct 1999 17:03:46 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] zmagic fixes" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-41,: [patch] zmagic fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] zmagic fixes</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Sat, 16 Oct 1999 17:03:46 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1140">[ date ]</a><a href="index.html#1140">[ thread ]</a><a href="subject.html#1140">[ subject ]</a><a href="author.html#1140">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1141.html">David Woodhouse: "2.3.22 locks up at boot."</a>
<li> <b>Previous message:</b> <a href="1139.html">Andrzej Krzysztofowicz: "Re: bootsect.S changes"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch fixes a bug in a do_brk. It also cleanup the code and it<br>
removes the obsolete checks for the blocksize (as now we load in anonymous<br>
memory if we can't mmap the file). I also rate-limited the printk.<br>
<p>
--- 2.3.22/fs/binfmt_aout.c	Sat Oct 16 03:34:52 1999<br>
+++ /tmp/binfmt_aout.c	Sat Oct 16 16:58:47 1999<br>
@@ -270,7 +270,6 @@<br>
 	unsigned long fd_offset;<br>
 	unsigned long rlim;<br>
 	int retval;<br>
-	static unsigned long error_time=0;<br>
 <br>
 	ex = *((struct exec *) bprm-&gt;buf);		/* exec-header */<br>
 	if ((N_MAGIC(ex) != ZMAGIC &amp;&amp; N_MAGIC(ex) != OMAGIC &amp;&amp;<br>
@@ -282,29 +281,6 @@<br>
 <br>
 	fd_offset = N_TXTOFF(ex);<br>
 <br>
-#ifdef __i386__<br>
-	if (N_MAGIC(ex) == ZMAGIC &amp;&amp; fd_offset != BLOCK_SIZE) {<br>
-		if((jiffies-error_time) &gt;5)<br>
-		{<br>
-			printk(KERN_NOTICE "N_TXTOFF != BLOCK_SIZE. See a.out.h.\n");<br>
-			error_time=jiffies;<br>
-		}<br>
-		return -ENOEXEC;<br>
-	}<br>
-<br>
-	if (N_MAGIC(ex) == ZMAGIC &amp;&amp; ex.a_text &amp;&amp;<br>
-	    bprm-&gt;dentry-&gt;d_inode-&gt;i_op &amp;&amp;<br>
-	    bprm-&gt;dentry-&gt;d_inode-&gt;i_op-&gt;get_block &amp;&amp;<br>
-	    (fd_offset &lt; bprm-&gt;dentry-&gt;d_inode-&gt;i_sb-&gt;s_blocksize)) {<br>
-		if((jiffies-error_time) &gt;5)<br>
-		{<br>
-			printk(KERN_NOTICE "N_TXTOFF &lt; BLOCK_SIZE. Please convert binary.\n");<br>
-			error_time=jiffies;<br>
-		}<br>
-		return -ENOEXEC;<br>
-	}<br>
-#endif<br>
-<br>
 	/* Check initial limits. This avoids letting people circumvent<br>
 	 * size limits imposed on them by creating programs with large<br>
 	 * arrays in the data or bss.<br>
@@ -364,26 +340,32 @@<br>
 		flush_icache_range((unsigned long) 0,<br>
 				   (unsigned long) ex.a_text+ex.a_data);<br>
 	} else {<br>
+		static unsigned long error_time, error_time2;<br>
 		if ((ex.a_text &amp; 0xfff || ex.a_data &amp; 0xfff) &amp;&amp;<br>
-		    (N_MAGIC(ex) != NMAGIC))<br>
+		    (N_MAGIC(ex) != NMAGIC) &amp;&amp; (jiffies-error_time2) &gt; 5*HZ)<br>
+		{<br>
 			printk(KERN_NOTICE "executable not page aligned\n");<br>
+			error_time2 = jiffies;<br>
+		}<br>
 <br>
 		fd = open_dentry(bprm-&gt;dentry, O_RDONLY);<br>
 		if (fd &lt; 0)<br>
 			return fd;<br>
 		file = fget(fd);<br>
 <br>
-		if ((fd_offset &amp; ~PAGE_MASK) != 0) {<br>
+		if ((fd_offset &amp; ~PAGE_MASK) != 0 &amp;&amp;<br>
+		    (jiffies-error_time) &gt; 5*HZ)<br>
+		{<br>
 			printk(KERN_WARNING <br>
 			       "fd_offset is not page aligned. Please convert program: %s\n",<br>
-			       file-&gt;f_dentry-&gt;d_name.name<br>
-			       );<br>
+			       file-&gt;f_dentry-&gt;d_name.name);<br>
+			error_time = jiffies;<br>
 		}<br>
 <br>
 		if (!file-&gt;f_op || !file-&gt;f_op-&gt;mmap || ((fd_offset &amp; ~PAGE_MASK) != 0)) {<br>
 			fput(file);<br>
 			sys_close(fd);<br>
-			do_brk(0, ex.a_text+ex.a_data);<br>
+			do_brk(N_TXTADDR(ex), ex.a_text+ex.a_data);<br>
 			read_exec(bprm-&gt;dentry, fd_offset,<br>
 				  (char *) N_TXTADDR(ex), ex.a_text+ex.a_data, 0);<br>
 			flush_icache_range((unsigned long) N_TXTADDR(ex),<br>
@@ -493,12 +475,6 @@<br>
 		goto out_putf;<br>
 	}<br>
 <br>
-	if (N_MAGIC(ex) == ZMAGIC &amp;&amp; N_TXTOFF(ex) &amp;&amp;<br>
-	    (N_TXTOFF(ex) &lt; inode-&gt;i_sb-&gt;s_blocksize)) {<br>
-		printk("N_TXTOFF &lt; BLOCK_SIZE. Please convert library\n");<br>
-		goto out_putf;<br>
-	}<br>
-<br>
 	if (N_FLAGS(ex))<br>
 		goto out_putf;<br>
 <br>
@@ -508,14 +484,17 @@<br>
 	start_addr =  ex.a_entry &amp; 0xfffff000;<br>
 <br>
 	if ((N_TXTOFF(ex) &amp; ~PAGE_MASK) != 0) {<br>
-		printk(KERN_WARNING <br>
-		       "N_TXTOFF is not page aligned. Please convert library: %s\n",<br>
-		       file-&gt;f_dentry-&gt;d_name.name<br>
-		       );<br>
-		<br>
-		do_mmap(NULL, start_addr &amp; PAGE_MASK, ex.a_text + ex.a_data + ex.a_bss,<br>
-			PROT_READ | PROT_WRITE | PROT_EXEC,<br>
-			MAP_FIXED| MAP_PRIVATE, 0);<br>
+		static unsigned long error_time;<br>
+<br>
+		if ((jiffies-error_time) &gt; 5*HZ)<br>
+		{<br>
+			printk(KERN_WARNING <br>
+			       "N_TXTOFF is not page aligned. Please convert library: %s\n",<br>
+			       file-&gt;f_dentry-&gt;d_name.name);<br>
+			error_time = jiffies;<br>
+		}<br>
+<br>
+		do_brk(start_addr, ex.a_text + ex.a_data + ex.a_bss);<br>
 		<br>
 		read_exec(file-&gt;f_dentry, N_TXTOFF(ex),<br>
 			  (char *)start_addr, ex.a_text + ex.a_data, 0);<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1141.html">David Woodhouse: "2.3.22 locks up at boot."</a>
<li> <b>Previous message:</b> <a href="1139.html">Andrzej Krzysztofowicz: "Re: bootsect.S changes"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
